/*
 * Decompiled with CFR 0.152.
 */
package eGTTIntegration;

import com.tkd.sims.servicedesk.AssetDetails;
import com.tkd.sims.servicedesk.CategoryDetails;
import com.tkd.sims.servicedesk.CustomFieldData;
import com.tkd.sims.servicedesk.CustomFieldDetails;
import com.tkd.sims.servicedesk.DepartmentDetails;
import com.tkd.sims.servicedesk.DerivedFieldDetails;
import com.tkd.sims.servicedesk.ImpactDetails;
import com.tkd.sims.servicedesk.LocationDetails;
import com.tkd.sims.servicedesk.ModifyRequestState;
import com.tkd.sims.servicedesk.NextStateDetails;
import com.tkd.sims.servicedesk.PriorityDetails;
import com.tkd.sims.servicedesk.ProjectDetails;
import com.tkd.sims.servicedesk.RecordTypeDetails;
import com.tkd.sims.servicedesk.RemoteRequest;
import com.tkd.sims.servicedesk.RequestIDDetails;
import com.tkd.sims.servicedesk.SapphireSD;
import com.tkd.sims.servicedesk.SapphireSD_Service;
import com.tkd.sims.servicedesk.ServiceDetails;
import com.tkd.sims.servicedesk.SlaComment;
import com.tkd.sims.servicedesk.SourceDetails;
import com.tkd.sims.servicedesk.StateDetails;
import com.tkd.sims.servicedesk.SubCategoryDetails;
import com.tkd.sims.servicedesk.UpdateRequest;
import com.tkd.sims.servicedesk.UrgencyDetails;
import com.tkd.sims.servicedesk.WorkGroupDetails;
import eGTTIntegration.TTIntegrationWrapper;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;

public class SapphireIMSIntegrator
extends TTIntegrationWrapper {
    private static final QName SAPPHIRESD_QNAME = new QName("http://servicedesk.sims.tkd.com/", "SapphireSD");
    public static SapphireSD_Service service = null;
    private static String ENDPOINT_URL = "";
    private static String WSDL_URL = "";
    private String username;
    private String password;
    private String schema;
    private String projectName;
    private String serviceName;
    private String locationName;
    private String category;
    private String subCategory;
    private String workGroup;
    private String departmentName;
    private String summaryFormat;
    private String descriptionFormat;
    private String strAuthKey;
    private String DefaultDescFormat;
    private final int MAX_TITLE_SIZE = 255;
    private final int MAX_DESC_SIZE = 1024;

    public SapphireIMSIntegrator(Hashtable hashtable) {
        block2: {
            this.username = "";
            this.password = "";
            this.schema = "";
            this.projectName = "";
            this.serviceName = "";
            this.locationName = "";
            this.category = "";
            this.subCategory = "";
            this.workGroup = "";
            this.departmentName = "";
            this.summaryFormat = "$prior - $ctype / $cname  - $pdesc";
            this.descriptionFormat = "";
            this.strAuthKey = "";
            this.DefaultDescFormat = " Priority :$prior  Component : $cname  Component  Type : $ctype  Layer : $layer  Problem  Description : $pdesc";
            this.MAX_TITLE_SIZE = 255;
            this.MAX_DESC_SIZE = 1024;
            try {
                this.setGlobalValues(hashtable);
            }
            catch (Throwable throwable) {
                if (!this.logEnabled) break block2;
                this.sop("ERROR: Got an exception, while setting Global Values in SapphireIMSIntegrator" + throwable.getMessage());
            }
        }
    }

    @Override
    public void updateInitParams(Hashtable hashtable) {
        this.setGlobalValues(hashtable);
    }

    public void setGlobalValues(Hashtable hashtable) {
        WSDL_URL = (String)hashtable.get("wsdl_url");
        this.username = (String)hashtable.get("user");
        this.password = (String)hashtable.get("password");
        this.schema = (String)hashtable.get("schema");
        this.projectName = (String)hashtable.get("projectName");
        this.serviceName = (String)hashtable.get("serviceName");
        this.category = (String)hashtable.get("category");
        this.subCategory = (String)hashtable.get("subCategory");
        this.workGroup = (String)hashtable.get("workGroup");
        this.departmentName = (String)hashtable.get("department");
        this.summaryFormat = (String)hashtable.get("TitleFormat");
        this.descriptionFormat = (String)hashtable.get("DescriptionFormat");
        if (WSDL_URL != null && WSDL_URL.indexOf("?") > -1) {
            ENDPOINT_URL = WSDL_URL.substring(0, WSDL_URL.indexOf("?"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createTicket(Object[] objectArray) throws IOException {
        String string = "";
        String string2 = "";
        try {
            String string3 = "";
            String string4 = "";
            Hashtable hashtable = null;
            String string5 = (String)objectArray[0];
            String string6 = (String)objectArray[2];
            String string7 = (String)objectArray[3];
            String string8 = (String)objectArray[4];
            String string9 = (String)objectArray[5];
            String string10 = (String)objectArray[6];
            String string11 = (String)objectArray[7];
            String string12 = (String)objectArray[8];
            String string13 = (String)objectArray[9];
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" Priority: ");
            stringBuffer.append(string5);
            stringBuffer.append(" Component Type: ");
            stringBuffer.append(string7);
            stringBuffer.append(" Component Name: ");
            stringBuffer.append(string8);
            stringBuffer.append(" Layer: ");
            stringBuffer.append(string9);
            stringBuffer.append(" Problem Description: ");
            stringBuffer.append(string10);
            string2 = stringBuffer.toString();
            service = new SapphireSD_Service(new URL(WSDL_URL), SAPPHIRESD_QNAME);
            RemoteRequest remoteRequest = new RemoteRequest();
            String string14 = SapphireIMSIntegrator.getAuthKey(SapphireIMSIntegrator.encode(this.username), SapphireIMSIntegrator.encode(this.password), this.schema);
            if (string14 != null && (string14.equals("") || string14.equalsIgnoreCase("Authentication failed"))) {
                if (this.logEnabled) {
                    this.sop("ERROR: Failed to create Ticket.... Authentication failed :- Given credentials(username or password or schema) are invalid.  Ticket Details-> " + string2);
                }
                String string15 = string = "";
                return string15;
            }
            int n = SapphireIMSIntegrator.getUserIDByLoginID(this.username, string14, this.schema);
            remoteRequest.setSubmitter(n);
            hashtable = this.getFormattedData(objectArray);
            if (hashtable != null && !hashtable.isEmpty()) {
                string4 = (String)hashtable.get("summary");
                string3 = (String)hashtable.get("description");
            }
            remoteRequest.setTitle(string4);
            remoteRequest.setDescription(string3);
            int n2 = SapphireIMSIntegrator.getProjectID(this.projectName, string14, this.schema);
            remoteRequest.setProjectID(n2);
            int n3 = SapphireIMSIntegrator.getServiceID(n2, this.serviceName, string14, this.schema);
            if (n2 == 0) {
                if (this.logEnabled) {
                    this.sop("ERROR: Failed to create Ticket... Given project name is invalid (" + this.projectName + ").  Ticket Details-> " + string2);
                }
                String string16 = string = "";
                return string16;
            }
            if (n3 == 0) {
                if (this.logEnabled) {
                    this.sop("ERROR: Failed to create Ticket.... Given service name is invalid (" + this.serviceName + ").  Ticket Details-> " + string2);
                }
                String string17 = string = "";
                return string17;
            }
            remoteRequest.setServiceID(n3);
            int n4 = SapphireIMSIntegrator.getCategoryID(n2, this.category, string14, this.schema);
            remoteRequest.setCategoryID(n4);
            int n5 = SapphireIMSIntegrator.getSubCategoryID(n2, n4, this.subCategory, string14, this.schema);
            remoteRequest.setSubCategoryID(n5);
            int n6 = SapphireIMSIntegrator.getDepartmentID(this.departmentName, string14, this.schema);
            remoteRequest.setDepartmentID(n6);
            int n7 = SapphireIMSIntegrator.getStateID(n2, "New", string14, this.schema);
            int n8 = SapphireIMSIntegrator.getRecordTypeID(n2, "Incident", string14, this.schema);
            remoteRequest.setRecordTypeID(n8);
            String string18 = this.getMappedUrgency(string5);
            String string19 = this.getMappedImpact(string5);
            String string20 = this.getMappedPriority(string5);
            int n9 = SapphireIMSIntegrator.getUrgencyID(n2, string18, string14, this.schema);
            remoteRequest.setUrgencyID(n9);
            int n10 = SapphireIMSIntegrator.getImpactID(n2, string19, string14, this.schema);
            remoteRequest.setImpactID(n10);
            int n11 = SapphireIMSIntegrator.getPriorityID(n2, string20, string14, this.schema);
            remoteRequest.setPriorityID(n11);
            int n12 = SapphireIMSIntegrator.getSourceID(n2, "Web", string14, this.schema);
            remoteRequest.setSourceID(n12);
            int n13 = SapphireIMSIntegrator.getWorkGroupID(n2, this.workGroup, string14, this.schema);
            remoteRequest.setWorkGroupID(n13);
            RemoteRequest remoteRequest2 = SapphireIMSIntegrator.createRequest(remoteRequest, string14, this.schema);
            if (remoteRequest2 != null) {
                String string21;
                int n14 = remoteRequest2.getProblemID();
                string = string21 = remoteRequest2.getRequestID();
                if (n14 == 0) {
                    if (this.logEnabled) {
                        this.sop("INFO: Ticket creation failed with following error message :: " + remoteRequest.getErrorMessage() + " Ticket Details->  " + string2);
                    }
                } else if (this.logEnabled) {
                    this.sop("INFO: Ticket has been created successfully... Ticket Details->  Ticket Number: " + string21 + " " + string2);
                }
            } else if (this.logEnabled) {
                this.sop("INFO: Ticket creation got failed... Ticket Details->  " + string2);
            }
            if (string != null && string.equalsIgnoreCase("AUTHENTICATION ERROR")) {
                string = "";
            }
        }
        catch (WebServiceException webServiceException) {
            if (this.logEnabled) {
                this.sop("ERROR: Ticket creation got failed... " + webServiceException.getMessage() + " Ticket Details->  " + string2);
            }
        }
        catch (Throwable throwable) {
            if (this.logEnabled) {
                this.sop("ERROR: Ticket creation got failed... Exception in createTicket() method " + throwable.getMessage() + " Ticket Details->  " + string2);
            }
        }
        finally {
            block42: {
                try {
                    service = null;
                    return string;
                }
                catch (Throwable throwable) {
                    if (!this.logEnabled) break block42;
                    this.sop("ERROR: Exception in createTicket() method");
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateTicket(String string, Object[] objectArray) throws IOException {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        Hashtable hashtable = null;
        String string5 = (String)objectArray[0];
        String string6 = (String)objectArray[2];
        String string7 = (String)objectArray[3];
        String string8 = (String)objectArray[4];
        String string9 = (String)objectArray[5];
        String string10 = (String)objectArray[6];
        String string11 = (String)objectArray[7];
        String string12 = (String)objectArray[8];
        String string13 = (String)objectArray[9];
        boolean bl = false;
        try {
            UpdateRequest updateRequest;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" Priority: ");
            stringBuffer.append(string5);
            stringBuffer.append(" Component Type: ");
            stringBuffer.append(string7);
            stringBuffer.append(" Component Name: ");
            stringBuffer.append(string8);
            stringBuffer.append(" Layer: ");
            stringBuffer.append(string9);
            stringBuffer.append(" Problem Description: ");
            stringBuffer.append(string10);
            string2 = stringBuffer.toString();
            service = new SapphireSD_Service(new URL(WSDL_URL), SAPPHIRESD_QNAME);
            hashtable = this.getFormattedData(objectArray);
            if (hashtable != null && !hashtable.isEmpty()) {
                string4 = (String)hashtable.get("summary");
                string3 = (String)hashtable.get("description");
            }
            String string14 = this.getMappedUrgency(string5);
            String string15 = this.getMappedImpact(string5);
            String string16 = this.getMappedPriority(string5);
            UpdateRequest updateRequest2 = new UpdateRequest();
            String string17 = SapphireIMSIntegrator.getAuthKey(SapphireIMSIntegrator.encode(this.username), SapphireIMSIntegrator.encode(this.password), this.schema);
            if (string17 != null && (string17.equals("") || string17.equalsIgnoreCase("Authentication failed"))) {
                if (this.logEnabled) {
                    this.sop("ERROR: Failed to update Ticket... Authentication failed :- Given credentials(username or password or schema) are invalid. Ticket Details->  Ticket Number: " + string + " " + string2);
                }
                boolean bl2 = bl = false;
                return bl2;
            }
            int n = SapphireIMSIntegrator.getUserIDByLoginID(this.username, string17, this.schema);
            int n2 = SapphireIMSIntegrator.getProjectID(this.projectName, string17, this.schema);
            int n3 = SapphireIMSIntegrator.getProblemID(n2, string, string17, this.schema);
            updateRequest2.setProblemID(n3);
            updateRequest2.setTitle(string4);
            updateRequest2.setDescription(string3);
            int n4 = SapphireIMSIntegrator.getServiceID(n2, this.serviceName, string17, this.schema);
            if (n2 == 0) {
                this.sop("ERROR: Failed to update Ticket... Given project name is invalid (" + this.projectName + "). Ticket Details->  Ticket Number: " + string + " " + string2);
                boolean bl3 = bl = false;
                return bl3;
            }
            if (n4 == 0) {
                if (this.logEnabled) {
                    this.sop("ERROR: Failed to update Ticket... Given service name is invalid (" + this.serviceName + "). Ticket Details->  Ticket Number: " + string + " " + string2);
                }
                boolean bl4 = bl = false;
                return bl4;
            }
            updateRequest2.setService(n4);
            int n5 = SapphireIMSIntegrator.getRecordTypeID(n2, "Incident", string17, this.schema);
            updateRequest2.setRecordTypeID(n5);
            int n6 = SapphireIMSIntegrator.getUrgencyID(n2, string14, string17, this.schema);
            updateRequest2.setUrgencyID(n6);
            int n7 = SapphireIMSIntegrator.getImpactID(n2, string15, string17, this.schema);
            updateRequest2.setImpactID(n7);
            int n8 = SapphireIMSIntegrator.getPriorityID(n2, string16, string17, this.schema);
            updateRequest2.setPriorityID(n8);
            int n9 = SapphireIMSIntegrator.getSourceID(n2, "Web", string17, this.schema);
            updateRequest2.setSourceID(n9);
            ArrayList<SlaComment> arrayList = new ArrayList<SlaComment>();
            boolean bl5 = false;
            List<SlaComment> list = SapphireIMSIntegrator.getSLAList(n3, string17, this.schema);
            for (int i = 0; i < list.size(); ++i) {
                bl5 = true;
                SlaComment slaComment = new SlaComment();
                slaComment.setNSlaID(list.get(i).getNSlaID());
                slaComment.setStrSlaComment("SLA Violation Comment from eG TTSystem");
                arrayList.add(slaComment);
            }
            if (bl5) {
                String string18 = SapphireIMSIntegrator.slaViolationCommentUpdate(arrayList, n3, n2, string17, this.schema);
            }
            if ((updateRequest = SapphireIMSIntegrator.updateRequestDetails(updateRequest2, string17, this.schema)) != null) {
                int n10 = updateRequest.getProblemID();
                String string19 = updateRequest.getRequestID();
                if (n10 == 0) {
                    if (this.logEnabled) {
                        this.sop("ERROR: Ticket update failed with following error message :: " + updateRequest2.getErrorMessage() + " Ticket Details->  Ticket Number: " + string + " " + string2);
                    }
                } else {
                    bl = true;
                    if (this.logEnabled) {
                        this.sop("INFO: Ticket has been updated successfully... Ticket Details->  Ticket Number: " + string19 + " " + string2);
                    }
                }
            } else if (this.logEnabled) {
                this.sop("ERROR: Ticket Updation got failed... Ticket Details->  Ticket Number: " + string + " " + string2);
            }
            if (bl && string5 != null && string5.equalsIgnoreCase("Normal")) {
                boolean bl6 = this.changeState(string, n2, string17, n3);
                if (bl6) {
                    if (this.logEnabled) {
                        this.sop("INFO: Ticket has been resolved successfully... Ticket Details->  Ticket Number: " + string + " " + string2);
                    }
                } else if (this.logEnabled) {
                    this.sop("ERROR: Failed to resolve ticket... Ticket Details->  Ticket Number: " + string + " " + string2);
                }
            }
        }
        catch (WebServiceException webServiceException) {
            if (this.logEnabled) {
                this.sop("ERROR: Ticket Updation got failed... " + webServiceException.getMessage() + " Ticket Details->  Ticket Number: " + string + " " + string2);
            }
        }
        catch (Throwable throwable) {
            if (this.logEnabled) {
                this.sop("ERROR: Ticket Updation got failed...Exception in update ticket method. " + throwable.getMessage() + " Ticket Details->  Ticket Number: " + string + " " + string2);
            }
        }
        finally {
            try {
                service = null;
                return bl;
            }
            catch (Throwable throwable) {}
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeState(String string, int n, String string2, int n2) {
        boolean bl = false;
        try {
            ModifyRequestState modifyRequestState = new ModifyRequestState();
            int n3 = SapphireIMSIntegrator.getUserIDByLoginID(this.username, string2, this.schema);
            int n4 = SapphireIMSIntegrator.getStateID(n, "resolve", string2, this.schema);
            String string3 = "0";
            modifyRequestState = SapphireIMSIntegrator.modifyState(n2, n4, "State Changed from API Call", string3, modifyRequestState, string2, this.schema);
            if (modifyRequestState.getModifyStatus().equalsIgnoreCase("Please enter the reason for violation for SLA(s)") && this.logEnabled) {
                this.sop("INFO: " + modifyRequestState.getModifyStatus() + " Ticket Number: " + string);
            }
            if (modifyRequestState.getModifyStatus().equalsIgnoreCase("SUCCESS")) {
                bl = true;
            }
            if (!modifyRequestState.getModifyStatus().equalsIgnoreCase("SUCCESS") && !modifyRequestState.getModifyStatus().equalsIgnoreCase("Please enter the reason for violation for SLA(s)") && this.logEnabled) {
                this.sop("INFO: Request state change failed with error message:" + modifyRequestState.getErrorMessage() + " Ticket Number: " + string);
            }
        }
        catch (WebServiceException webServiceException) {
            if (this.logEnabled) {
                this.sop("ERROR: Request state change failed... " + webServiceException.getMessage() + " Ticket Number: " + string);
            }
        }
        catch (Throwable throwable) {
            if (this.logEnabled) {
                this.sop("ERROR: Request state change failed... Exception in changeState method" + throwable.getMessage() + " Ticket Number: " + string);
            }
        }
        finally {
            try {
                service = null;
                return bl;
            }
            catch (Throwable throwable) {}
        }
        return bl;
    }

    private String getMappedUrgency(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("Critical")) {
                string = "High";
            } else if (string.equalsIgnoreCase("Major")) {
                string = "Medium";
            } else if (string.equalsIgnoreCase("Minor")) {
                string = "Low";
            } else if (string.equalsIgnoreCase("Normal")) {
                string = "Low";
            }
        }
        return string;
    }

    private String getMappedImpact(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("Critical")) {
                string = "High";
            } else if (string.equalsIgnoreCase("Major")) {
                string = "Medium";
            } else if (string.equalsIgnoreCase("Minor")) {
                string = "Low";
            } else if (string.equalsIgnoreCase("Normal")) {
                string = "Low";
            }
        }
        return string;
    }

    private String getMappedPriority(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("Critical")) {
                string = "P1";
            } else if (string.equalsIgnoreCase("Major")) {
                string = "P3";
            } else if (string.equalsIgnoreCase("Minor")) {
                string = "P5";
            } else if (string.equalsIgnoreCase("Normal")) {
                string = "P5";
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getFormattedData(Object[] objectArray) {
        String string = "";
        Hashtable<String, String> hashtable = null;
        String string2 = (String)objectArray[0];
        String string3 = (String)objectArray[6];
        String string4 = (String)objectArray[3];
        String string5 = (String)objectArray[4];
        String string6 = (String)objectArray[5];
        String string7 = (String)objectArray[7];
        try {
            hashtable = new Hashtable<String, String>();
            if (this.descriptionFormat != null && !this.descriptionFormat.equals("")) {
                hashtable.put("description", this.descriptionFormat);
            } else {
                hashtable.put("description", this.DefaultDescFormat);
            }
            if (this.descriptionFormat != null && !this.descriptionFormat.equals("")) {
                hashtable.put("summary", this.summaryFormat);
            } else {
                hashtable.put("summary", string3);
            }
            if (hashtable != null && !hashtable.isEmpty()) {
                Set set = hashtable.keySet();
                for (String string8 : set) {
                    string = (String)hashtable.get(string8);
                    if (string8 == null || string == null) continue;
                    if (string.indexOf("$cname") > -1) {
                        string = this.replace(string, "$cname", string5);
                    }
                    if (string.indexOf("$ctype") > -1) {
                        string = this.replace(string, "$ctype", string4);
                    }
                    if (string.indexOf("$prior") > -1) {
                        string = this.replace(string, "$prior", string2);
                    }
                    if (string.indexOf("$pdesc") > -1) {
                        string = this.replace(string, "$pdesc", string3);
                    }
                    if (string.indexOf("$layer") > -1) {
                        string = this.replace(string, "$layer", string6);
                    }
                    if (string.indexOf("$starttime") > -1) {
                        string = this.replace(string, "$starttime", string7);
                    }
                    if (string8.equalsIgnoreCase("summary")) {
                        if (string.length() > 255) {
                            string = string.substring(0, 251);
                            string = string + "...";
                        }
                    } else if (string8.equalsIgnoreCase("description") && string.length() > 1024) {
                        string = string.substring(0, 1020);
                        string = string + "...";
                    }
                    hashtable.put(string8, string);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                return hashtable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return hashtable;
    }

    private static String encode(String string) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.encode(string);
    }

    private static RemoteRequest createRequest(RemoteRequest remoteRequest, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.createRequest(remoteRequest, string, string2);
    }

    private static int getAdditionalFieldID(int n, String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getAdditionalFieldID(n, string, string2, string3);
    }

    private static String getAuthKey(String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getAuthKey(string, string2, string3);
    }

    private static int getCategoryID(int n, String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getCategoryID(n, string, string2, string3);
    }

    private static List<CategoryDetails> getCategoryList(int n, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getCategoryList(n, string, string2);
    }

    private static String getCustomFieldData(List<CustomFieldData> list, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getCustomFieldData(list, string, string2);
    }

    private static List<CustomFieldDetails> getCustomFieldsList(int n, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getCustomFieldsList(n, string, string2);
    }

    private static List<CustomFieldDetails> getCustomFieldsListCategory(int n, int n2, int n3, int n4, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getCustomFieldsListCategory(n, n2, n3, n4, string, string2);
    }

    private static List<CustomFieldDetails> getCustomFieldsListService(int n, int n2, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getCustomFieldsListService(n, n2, string, string2);
    }

    private static List<CustomFieldDetails> getCustomFieldsListState(int n, int n2, int n3, int n4, int n5, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getCustomFieldsListState(n, n2, n3, n4, n5, string, string2);
    }

    private static int getDepartmentID(String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getDepartmentID(string, string2, string3);
    }

    private static List<DepartmentDetails> getDepartmentList(String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getDepartmentList(string, string2);
    }

    private static int getDerivedField1ID(int n, String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getDerivedField1ID(n, string, string2, string3);
    }

    private static List<DerivedFieldDetails> getDerivedField1List(int n, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getDerivedField1List(n, string, string2);
    }

    private static List<DerivedFieldDetails> getDerivedField1ListSubCategory(int n, int n2, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getDerivedField1ListSubCategory(n, n2, string, string2);
    }

    private static int getDerivedField2ID(int n, String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getDerivedField2ID(n, string, string2, string3);
    }

    private static List<DerivedFieldDetails> getDerivedField2List(int n, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getDerivedField2List(n, string, string2);
    }

    private static List<DerivedFieldDetails> getDerivedField2ListSubCategory(int n, int n2, int n3, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getDerivedField2ListSubCategory(n, n2, n3, string, string2);
    }

    private static int getDerivedField3ID(int n, String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getDerivedField3ID(n, string, string2, string3);
    }

    private static List<DerivedFieldDetails> getDerivedField3List(int n, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getDerivedField3List(n, string, string2);
    }

    private static List<DerivedFieldDetails> getDerivedField3ListSubCategory(int n, int n2, int n3, int n4, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getDerivedField3ListSubCategory(n, n2, n3, n4, string, string2);
    }

    private static int getImpactID(int n, String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getImpactID(n, string, string2, string3);
    }

    private static List<ImpactDetails> getImpactList(int n, int n2, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getImpactList(n, n2, string, string2);
    }

    private static int getLocationID(String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getLocationID(string, string2, string3);
    }

    private static List<LocationDetails> getLocationList(String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getLocationList(string, string2);
    }

    private static List<NextStateDetails> getNextState(int n, int n2, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getNextState(n, n2, string, string2);
    }

    private static int getPriorityID(int n, String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getPriorityID(n, string, string2, string3);
    }

    private static List<PriorityDetails> getPriorityList(int n, int n2, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getPriorityList(n, n2, string, string2);
    }

    private static int getProblemID(int n, String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getProblemID(n, string, string2, string3);
    }

    private static int getProjectID(String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getProjectID(string, string2, string3);
    }

    private static List<ProjectDetails> getProjectList(String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getProjectList(string, string2);
    }

    private static int getRecordTypeID(int n, String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getRecordTypeID(n, string, string2, string3);
    }

    private static List<RecordTypeDetails> getRecordTypeList(int n, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getRecordTypeList(n, string, string2);
    }

    private static List<RequestIDDetails> getRequestIDList(int n, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getRequestIDList(n, string, string2);
    }

    private static List<RequestIDDetails> getRequestIDListState(int n, int n2, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getRequestIDListState(n, n2, string, string2);
    }

    private static int getServiceID(int n, String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getServiceID(n, string, string2, string3);
    }

    private static List<ServiceDetails> getServiceList(int n, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getServiceList(n, string, string2);
    }

    private static int getSourceID(int n, String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getSourceID(n, string, string2, string3);
    }

    private static List<SourceDetails> getSourceList(int n, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getSourceList(n, string, string2);
    }

    private static int getStateID(int n, String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getStateID(n, string, string2, string3);
    }

    private static List<StateDetails> getStatesList(int n, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getStatesList(n, string, string2);
    }

    private static int getSubCategoryID(int n, int n2, String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getSubCategoryID(n, n2, string, string2, string3);
    }

    private static List<SubCategoryDetails> getSubCategoryList(int n, int n2, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getSubCategoryList(n, n2, string, string2);
    }

    private static int getUrgencyID(int n, String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getUrgencyID(n, string, string2, string3);
    }

    private static List<UrgencyDetails> getUrgencyList(int n, int n2, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getUrgencyList(n, n2, string, string2);
    }

    private static List<WorkGroupDetails> getWorkGroupList(int n, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getWorkGroupList(n, string, string2);
    }

    private static int getWorkGroupID(int n, String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getWorkGroupID(n, string, string2, string3);
    }

    private static int getUserID(String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getUserID(string, string2, string3);
    }

    private static int getUserIDByColumn(String string, String string2, String string3, String string4) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getUserIDByColumn(string, string2, string3, string4);
    }

    private static int getUserIDByLoginID(String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getUserIDByLoginID(string, string2, string3);
    }

    private static List<AssetDetails> getAssetList(String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getAssetList(string, string2);
    }

    private static List<AssetDetails> getAssetListByType(String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getAssetListByType(string, string2, string3);
    }

    private static List<AssetDetails> getAllocatedAssetList(int n, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getAllocatedAssetList(n, string, string2);
    }

    private static List<AssetDetails> getAllocatedAssetListByType(int n, String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getAllocatedAssetListByType(n, string, string2, string3);
    }

    private static int getAssetID(String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getAssetID(string, string2, string3);
    }

    private static UpdateRequest updateRequestDetails(UpdateRequest updateRequest, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.updateRequestDetails(updateRequest, string, string2);
    }

    private static List<SlaComment> setSLADetails(int n, String string, String string2, String string3) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.setSLADetails(n, string, string2, string3);
    }

    private static String slaViolationCommentUpdate(List list, int n, int n2, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.slaViolationCommentUpdate(list, n, n2, string, string2);
    }

    private static List<SlaComment> getSLAList(int n, String string, String string2) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.getSLAList(n, string, string2);
    }

    private static ModifyRequestState modifyState(int n, int n2, String string, String string2, ModifyRequestState modifyRequestState, String string3, String string4) {
        SapphireSD sapphireSD = service.getSapphireSDPort();
        ((BindingProvider)sapphireSD).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
        return sapphireSD.modifyState(n, n2, string, string2, modifyRequestState, string3, string4);
    }
}

