/*
 * Decompiled with CFR 0.152.
 */
package com.representqueens.web.tags.spark;

import com.representqueens.spark.BarGraph;
import com.representqueens.spark.Encoder;
import com.representqueens.spark.LineGraph;
import com.representqueens.spark.SizeParams;
import com.representqueens.spark.util.StringConversion;
import com.representqueens.util.StringUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import javax.servlet.jsp.tagext.TagSupport;

public abstract class AbstractGraph
extends TagSupport {
    private String name;
    private String width;
    private String height;
    private String spacing;
    private String color;
    private String highColor;
    private String lastColor;
    private String background;
    private String output;

    public String getColor() {
        return this.color;
    }

    public void setColor(String string) {
        this.color = string;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String string) {
        this.height = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String string) {
        this.output = string;
    }

    public String getSpacing() {
        return this.spacing;
    }

    public void setSpacing(String string) {
        this.spacing = string;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String string) {
        this.width = string;
    }

    public String getHighColor() {
        return this.highColor;
    }

    public void setHighColor(String string) {
        this.highColor = string;
    }

    public String getLastColor() {
        return this.lastColor;
    }

    public void setLastColor(String string) {
        this.lastColor = string;
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String string) {
        this.background = string;
    }

    protected String getBarGraphData() throws IOException {
        BufferedImage bufferedImage = BarGraph.createGraph(this.getData(), this.getSizeParams(BarGraph.DEFAULT_SIZE), StringConversion.convertColor(this.color, BarGraph.DEFAULT_COLOR), StringConversion.convertColor(this.highColor, null), StringConversion.convertColor(this.lastColor, null));
        return Encoder.encode(bufferedImage, this.getOutputFormat());
    }

    protected String getLineGraphData() throws IOException {
        BufferedImage bufferedImage = LineGraph.createGraph(this.getData(), this.getSizeParams(LineGraph.DEFAULT_SIZE), StringConversion.convertColor(this.color, LineGraph.DEFAULT_COLOR));
        return Encoder.encode(bufferedImage, this.getOutputFormat());
    }

    protected SizeParams getSizeParams(SizeParams sizeParams) {
        return new SizeParams(StringConversion.convertInt(this.width, sizeParams.getWidth()), StringConversion.convertInt(this.height, sizeParams.getHeight()), StringConversion.convertInt(this.spacing, sizeParams.getSpacing()));
    }

    protected Number[] getData() {
        Object object = this.pageContext.findAttribute(this.name);
        if (object instanceof List) {
            List list = (List)object;
            return list.toArray(new Number[list.size()]);
        }
        if (object instanceof Number[]) {
            return (Number[])object;
        }
        if (object instanceof String) {
            try {
                List<Integer> list = StringUtils.toIntList((String)object);
                return list.toArray(new Number[list.size()]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Number[0];
    }

    protected Encoder.Format getOutputFormat() {
        if (!StringUtils.isEmpty(this.output) && "data".equalsIgnoreCase(this.output)) {
            return Encoder.Format.DATA;
        }
        return Encoder.Format.JAVASCRIPT;
    }
}

