/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Blob;
import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Host;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.Network;
import com.xensource.xenapi.PIF;
import com.xensource.xenapi.SR;
import com.xensource.xenapi.Task;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.VDI;
import com.xensource.xenapi.VM;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

public class Pool
extends XenAPIObject {
    protected final String ref;

    Pool(String string) {
        this.ref = string;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Pool) {
            Pool pool = (Pool)object;
            return pool.ref.equals(this.ref);
        }
        return false;
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public Record getRecord(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_record";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toPoolRecord(v);
    }

    public static Pool getByUuid(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "pool.get_by_uuid";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toPool(v);
    }

    public String getUuid(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_uuid";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getNameLabel(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_name_label";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getNameDescription(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_name_description";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Host getMaster(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_master";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toHost(v);
    }

    public SR getDefaultSR(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_default_SR";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSR(v);
    }

    public SR getSuspendImageSR(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_suspend_image_SR";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSR(v);
    }

    public SR getCrashDumpSR(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_crash_dump_SR";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSR(v);
    }

    public Map<String, String> getOtherConfig(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Boolean getHaEnabled(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_ha_enabled";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Map<String, String> getHaConfiguration(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_ha_configuration";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Set<String> getHaStatefiles(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_ha_statefiles";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfString(v);
    }

    public Long getHaHostFailuresToTolerate(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_ha_host_failures_to_tolerate";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Long getHaPlanExistsFor(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_ha_plan_exists_for";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Boolean getHaAllowOvercommit(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_ha_allow_overcommit";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Boolean getHaOvercommitted(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_ha_overcommitted";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Map<String, Blob> getBlobs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_blobs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringBlob(v);
    }

    public Set<String> getTags(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_tags";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfString(v);
    }

    public Map<String, String> getGuiConfig(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_gui_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Map<String, String> getHealthCheckConfig(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_health_check_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public String getWlbUrl(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_wlb_url";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getWlbUsername(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_wlb_username";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Boolean getWlbEnabled(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_wlb_enabled";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Boolean getWlbVerifyCert(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_wlb_verify_cert";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Boolean getRedoLogEnabled(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_redo_log_enabled";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public VDI getRedoLogVdi(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_redo_log_vdi";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVDI(v);
    }

    @Deprecated
    public String getVswitchController(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_vswitch_controller";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Map<String, String> getRestrictions(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_restrictions";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Set<VDI> getMetadataVDIs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_metadata_VDIs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVDI(v);
    }

    public String getHaClusterStack(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_ha_cluster_stack";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Set<Types.PoolAllowedOperations> getAllowedOperations(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_allowed_operations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfPoolAllowedOperations(v);
    }

    public Map<String, Types.PoolAllowedOperations> getCurrentOperations(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_current_operations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringPoolAllowedOperations(v);
    }

    public Map<String, String> getGuestAgentConfig(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_guest_agent_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Map<String, String> getCpuInfo(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_cpu_info";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Boolean getPolicyNoVendorDevice(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_policy_no_vendor_device";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Boolean getLivePatchingDisabled(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_live_patching_disabled";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Boolean getIgmpSnoopingEnabled(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_igmp_snooping_enabled";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public void setNameLabel(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "pool.set_name_label";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setNameDescription(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "pool.set_name_description";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setDefaultSR(Connection connection, SR sR) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.set_default_SR";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(sR)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setSuspendImageSR(Connection connection, SR sR) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.set_suspend_image_SR";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(sR)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setCrashDumpSR(Connection connection, SR sR) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.set_crash_dump_SR";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(sR)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setOtherConfig(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.set_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToOtherConfig(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "pool.add_to_other_config";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromOtherConfig(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "pool.remove_from_other_config";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setHaAllowOvercommit(Connection connection, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.set_ha_allow_overcommit";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setTags(Connection connection, Set<String> set) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.set_tags";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(set)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void addTags(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "pool.add_tags";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void removeTags(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "pool.remove_tags";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setGuiConfig(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.set_gui_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToGuiConfig(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "pool.add_to_gui_config";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromGuiConfig(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "pool.remove_from_gui_config";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setHealthCheckConfig(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.set_health_check_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToHealthCheckConfig(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "pool.add_to_health_check_config";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromHealthCheckConfig(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "pool.remove_from_health_check_config";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setWlbEnabled(Connection connection, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.set_wlb_enabled";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setWlbVerifyCert(Connection connection, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.set_wlb_verify_cert";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setPolicyNoVendorDevice(Connection connection, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.set_policy_no_vendor_device";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setLivePatchingDisabled(Connection connection, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.set_live_patching_disabled";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Task joinAsync(Connection connection, String string, String string2, String string3) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.JoiningHostCannotContainSharedSrs {
        String string4 = "Async.pool.join";
        String string5 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string5), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(string3)};
        Map map = connection.dispatch(string4, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static void join(Connection connection, String string, String string2, String string3) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.JoiningHostCannotContainSharedSrs {
        String string4 = "pool.join";
        String string5 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string5), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(string3)};
        Map map = connection.dispatch(string4, objectArray);
    }

    public static Task joinForceAsync(Connection connection, String string, String string2, String string3) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string4 = "Async.pool.join_force";
        String string5 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string5), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(string3)};
        Map map = connection.dispatch(string4, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static void joinForce(Connection connection, String string, String string2, String string3) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string4 = "pool.join_force";
        String string5 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string5), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(string3)};
        Map map = connection.dispatch(string4, objectArray);
    }

    public static Task ejectAsync(Connection connection, Host host) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.eject";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(host)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static void eject(Connection connection, Host host) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.eject";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(host)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static void emergencyTransitionToMaster(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.emergency_transition_to_master";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static void emergencyResetMaster(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "pool.emergency_reset_master";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public static Task recoverSlavesAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.recover_slaves";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static Set<Host> recoverSlaves(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.recover_slaves";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfHost(v);
    }

    public static Task createVLANAsync(Connection connection, String string, Network network, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VlanTagInvalid {
        String string2 = "Async.pool.create_VLAN";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(network), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static Set<PIF> createVLAN(Connection connection, String string, Network network, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VlanTagInvalid {
        String string2 = "pool.create_VLAN";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(network), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfPIF(v);
    }

    public static Task managementReconfigureAsync(Connection connection, Network network) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.HaIsEnabled, Types.PifNotPresent, Types.CannotPlugBondSlave, Types.PifIncompatiblePrimaryAddressType, Types.PifHasNoNetworkConfiguration, Types.PifHasNoV6NetworkConfiguration {
        String string = "Async.pool.management_reconfigure";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(network)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static void managementReconfigure(Connection connection, Network network) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.HaIsEnabled, Types.PifNotPresent, Types.CannotPlugBondSlave, Types.PifIncompatiblePrimaryAddressType, Types.PifHasNoNetworkConfiguration, Types.PifHasNoV6NetworkConfiguration {
        String string = "pool.management_reconfigure";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(network)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Task createVLANFromPIFAsync(Connection connection, PIF pIF, Network network, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VlanTagInvalid {
        String string = "Async.pool.create_VLAN_from_PIF";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(pIF), Marshalling.toXMLRPC(network), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static Set<PIF> createVLANFromPIF(Connection connection, PIF pIF, Network network, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.VlanTagInvalid {
        String string = "pool.create_VLAN_from_PIF";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(pIF), Marshalling.toXMLRPC(network), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfPIF(v);
    }

    public static Task enableHaAsync(Connection connection, Set<SR> set, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.enable_ha";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(set), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
        Object v = map2.get("Value");
        return Types.toTask(v);
    }

    public static void enableHa(Connection connection, Set<SR> set, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.enable_ha";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(set), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public static Task disableHaAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.disable_ha";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static void disableHa(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.disable_ha";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Task syncDatabaseAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.sync_database";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static void syncDatabase(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.sync_database";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Task designateNewMasterAsync(Connection connection, Host host) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.designate_new_master";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(host)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static void designateNewMaster(Connection connection, Host host) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.designate_new_master";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(host)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static void haPreventRestartsFor(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.ha_prevent_restarts_for";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Boolean haFailoverPlanExists(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.ha_failover_plan_exists";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public static Long haComputeMaxHostFailuresToTolerate(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.ha_compute_max_host_failures_to_tolerate";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public static Long haComputeHypotheticalMaxHostFailuresToTolerate(Connection connection, Map<VM, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.ha_compute_hypothetical_max_host_failures_to_tolerate";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
        Object v = map2.get("Value");
        return Types.toLong(v);
    }

    public static Map<VM, Map<String, String>> haComputeVmFailoverPlan(Connection connection, Set<Host> set, Set<VM> set2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.ha_compute_vm_failover_plan";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(set), Marshalling.toXMLRPC(set2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfVMMapOfStringString(v);
    }

    public Task setHaHostFailuresToTolerateAsync(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.set_ha_host_failures_to_tolerate";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void setHaHostFailuresToTolerate(Connection connection, Long l) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.set_ha_host_failures_to_tolerate";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(l)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task createNewBlobAsync(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "Async.pool.create_new_blob";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Blob createNewBlob(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "pool.create_new_blob";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toBlob(v);
    }

    public Task createNewBlobAsync(Connection connection, String string, String string2, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "Async.pool.create_new_blob";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Blob createNewBlob(Connection connection, String string, String string2, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "pool.create_new_blob";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toBlob(v);
    }

    public void enableExternalAuth(Connection connection, Map<String, String> map, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "pool.enable_external_auth";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map2 = connection.dispatch(string3, objectArray);
    }

    public void disableExternalAuth(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.disable_external_auth";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void detectNonhomogeneousExternalAuth(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.detect_nonhomogeneous_external_auth";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Task initializeWlbAsync(Connection connection, String string, String string2, String string3, String string4, String string5) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string6 = "Async.pool.initialize_wlb";
        String string7 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string7), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(string5)};
        Map map = connection.dispatch(string6, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static void initializeWlb(Connection connection, String string, String string2, String string3, String string4, String string5) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string6 = "pool.initialize_wlb";
        String string7 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string7), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(string5)};
        Map map = connection.dispatch(string6, objectArray);
    }

    public static Task deconfigureWlbAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.deconfigure_wlb";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static void deconfigureWlb(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.deconfigure_wlb";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Task sendWlbConfigurationAsync(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.send_wlb_configuration";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
        Object v = map2.get("Value");
        return Types.toTask(v);
    }

    public static void sendWlbConfiguration(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.send_wlb_configuration";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public static Task retrieveWlbConfigurationAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.retrieve_wlb_configuration";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static Map<String, String> retrieveWlbConfiguration(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.retrieve_wlb_configuration";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public static Task retrieveWlbRecommendationsAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.retrieve_wlb_recommendations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static Map<VM, Set<String>> retrieveWlbRecommendations(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.retrieve_wlb_recommendations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfVMSetOfString(v);
    }

    public static Task sendTestPostAsync(Connection connection, String string, Long l, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "Async.pool.send_test_post";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(l), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static String sendTestPost(Connection connection, String string, Long l, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "pool.send_test_post";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(l), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public static Task certificateInstallAsync(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "Async.pool.certificate_install";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static void certificateInstall(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "pool.certificate_install";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public static Task certificateUninstallAsync(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "Async.pool.certificate_uninstall";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static void certificateUninstall(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "pool.certificate_uninstall";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public static Task certificateListAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.certificate_list";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static Set<String> certificateList(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.certificate_list";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfString(v);
    }

    public static Task crlInstallAsync(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "Async.pool.crl_install";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static void crlInstall(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "pool.crl_install";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public static Task crlUninstallAsync(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "Async.pool.crl_uninstall";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static void crlUninstall(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "pool.crl_uninstall";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public static Task crlListAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.crl_list";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static Set<String> crlList(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.crl_list";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfString(v);
    }

    public static Task certificateSyncAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.certificate_sync";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static void certificateSync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.certificate_sync";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Task enableRedoLogAsync(Connection connection, SR sR) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.enable_redo_log";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(sR)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static void enableRedoLog(Connection connection, SR sR) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.enable_redo_log";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(sR)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Task disableRedoLogAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.disable_redo_log";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static void disableRedoLog(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.disable_redo_log";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
    }

    @Deprecated
    public static Task setVswitchControllerAsync(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "Async.pool.set_vswitch_controller";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    @Deprecated
    public static void setVswitchController(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "pool.set_vswitch_controller";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public String testArchiveTarget(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.test_archive_target";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
        Object v = map2.get("Value");
        return Types.toString(v);
    }

    public Task enableLocalStorageCachingAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.enable_local_storage_caching";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void enableLocalStorageCaching(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.enable_local_storage_caching";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task disableLocalStorageCachingAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.disable_local_storage_caching";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void disableLocalStorageCaching(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.disable_local_storage_caching";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task getLicenseStateAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.get_license_state";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Map<String, String> getLicenseState(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_license_state";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Task applyEditionAsync(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "Async.pool.apply_edition";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void applyEdition(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "pool.apply_edition";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public Task enableSslLegacyAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.enable_ssl_legacy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void enableSslLegacy(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.enable_ssl_legacy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task disableSslLegacyAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.disable_ssl_legacy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void disableSslLegacy(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.disable_ssl_legacy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task setIgmpSnoopingEnabledAsync(Connection connection, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.pool.set_igmp_snooping_enabled";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void setIgmpSnoopingEnabled(Connection connection, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.set_igmp_snooping_enabled";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task hasExtensionAsync(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "Async.pool.has_extension";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Boolean hasExtension(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "pool.has_extension";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Task addToGuestAgentConfigAsync(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "Async.pool.add_to_guest_agent_config";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void addToGuestAgentConfig(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "pool.add_to_guest_agent_config";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public Task removeFromGuestAgentConfigAsync(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "Async.pool.remove_from_guest_agent_config";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void removeFromGuestAgentConfig(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "pool.remove_from_guest_agent_config";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public static Set<Pool> getAll(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_all";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfPool(v);
    }

    public static Map<Pool, Record> getAllRecords(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "pool.get_all_records";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfPoolPoolRecord(v);
    }

    public static class Record
    implements Types.Record {
        public String uuid;
        public String nameLabel;
        public String nameDescription;
        public Host master;
        public SR defaultSR;
        public SR suspendImageSR;
        public SR crashDumpSR;
        public Map<String, String> otherConfig;
        public Boolean haEnabled;
        public Map<String, String> haConfiguration;
        public Set<String> haStatefiles;
        public Long haHostFailuresToTolerate;
        public Long haPlanExistsFor;
        public Boolean haAllowOvercommit;
        public Boolean haOvercommitted;
        public Map<String, Blob> blobs;
        public Set<String> tags;
        public Map<String, String> guiConfig;
        public Map<String, String> healthCheckConfig;
        public String wlbUrl;
        public String wlbUsername;
        public Boolean wlbEnabled;
        public Boolean wlbVerifyCert;
        public Boolean redoLogEnabled;
        public VDI redoLogVdi;
        public String vswitchController;
        public Map<String, String> restrictions;
        public Set<VDI> metadataVDIs;
        public String haClusterStack;
        public Set<Types.PoolAllowedOperations> allowedOperations;
        public Map<String, Types.PoolAllowedOperations> currentOperations;
        public Map<String, String> guestAgentConfig;
        public Map<String, String> cpuInfo;
        public Boolean policyNoVendorDevice;
        public Boolean livePatchingDisabled;
        public Boolean igmpSnoopingEnabled;

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            printWriter.printf("%1$20s: %2$s\n", "nameLabel", this.nameLabel);
            printWriter.printf("%1$20s: %2$s\n", "nameDescription", this.nameDescription);
            printWriter.printf("%1$20s: %2$s\n", "master", this.master);
            printWriter.printf("%1$20s: %2$s\n", "defaultSR", this.defaultSR);
            printWriter.printf("%1$20s: %2$s\n", "suspendImageSR", this.suspendImageSR);
            printWriter.printf("%1$20s: %2$s\n", "crashDumpSR", this.crashDumpSR);
            printWriter.printf("%1$20s: %2$s\n", "otherConfig", this.otherConfig);
            printWriter.printf("%1$20s: %2$s\n", "haEnabled", this.haEnabled);
            printWriter.printf("%1$20s: %2$s\n", "haConfiguration", this.haConfiguration);
            printWriter.printf("%1$20s: %2$s\n", "haStatefiles", this.haStatefiles);
            printWriter.printf("%1$20s: %2$s\n", "haHostFailuresToTolerate", this.haHostFailuresToTolerate);
            printWriter.printf("%1$20s: %2$s\n", "haPlanExistsFor", this.haPlanExistsFor);
            printWriter.printf("%1$20s: %2$s\n", "haAllowOvercommit", this.haAllowOvercommit);
            printWriter.printf("%1$20s: %2$s\n", "haOvercommitted", this.haOvercommitted);
            printWriter.printf("%1$20s: %2$s\n", "blobs", this.blobs);
            printWriter.printf("%1$20s: %2$s\n", "tags", this.tags);
            printWriter.printf("%1$20s: %2$s\n", "guiConfig", this.guiConfig);
            printWriter.printf("%1$20s: %2$s\n", "healthCheckConfig", this.healthCheckConfig);
            printWriter.printf("%1$20s: %2$s\n", "wlbUrl", this.wlbUrl);
            printWriter.printf("%1$20s: %2$s\n", "wlbUsername", this.wlbUsername);
            printWriter.printf("%1$20s: %2$s\n", "wlbEnabled", this.wlbEnabled);
            printWriter.printf("%1$20s: %2$s\n", "wlbVerifyCert", this.wlbVerifyCert);
            printWriter.printf("%1$20s: %2$s\n", "redoLogEnabled", this.redoLogEnabled);
            printWriter.printf("%1$20s: %2$s\n", "redoLogVdi", this.redoLogVdi);
            printWriter.printf("%1$20s: %2$s\n", "vswitchController", this.vswitchController);
            printWriter.printf("%1$20s: %2$s\n", "restrictions", this.restrictions);
            printWriter.printf("%1$20s: %2$s\n", "metadataVDIs", this.metadataVDIs);
            printWriter.printf("%1$20s: %2$s\n", "haClusterStack", this.haClusterStack);
            printWriter.printf("%1$20s: %2$s\n", "allowedOperations", this.allowedOperations);
            printWriter.printf("%1$20s: %2$s\n", "currentOperations", this.currentOperations);
            printWriter.printf("%1$20s: %2$s\n", "guestAgentConfig", this.guestAgentConfig);
            printWriter.printf("%1$20s: %2$s\n", "cpuInfo", this.cpuInfo);
            printWriter.printf("%1$20s: %2$s\n", "policyNoVendorDevice", this.policyNoVendorDevice);
            printWriter.printf("%1$20s: %2$s\n", "livePatchingDisabled", this.livePatchingDisabled);
            printWriter.printf("%1$20s: %2$s\n", "igmpSnoopingEnabled", this.igmpSnoopingEnabled);
            return stringWriter.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("uuid", this.uuid == null ? "" : this.uuid);
            hashMap.put("name_label", this.nameLabel == null ? "" : this.nameLabel);
            hashMap.put("name_description", this.nameDescription == null ? "" : this.nameDescription);
            hashMap.put("master", this.master == null ? new Host("OpaqueRef:NULL") : this.master);
            hashMap.put("default_SR", this.defaultSR == null ? new SR("OpaqueRef:NULL") : this.defaultSR);
            hashMap.put("suspend_image_SR", this.suspendImageSR == null ? new SR("OpaqueRef:NULL") : this.suspendImageSR);
            hashMap.put("crash_dump_SR", this.crashDumpSR == null ? new SR("OpaqueRef:NULL") : this.crashDumpSR);
            hashMap.put("other_config", this.otherConfig == null ? new HashMap() : this.otherConfig);
            hashMap.put("ha_enabled", this.haEnabled == null ? false : this.haEnabled);
            hashMap.put("ha_configuration", this.haConfiguration == null ? new HashMap() : this.haConfiguration);
            hashMap.put("ha_statefiles", this.haStatefiles == null ? new LinkedHashSet() : this.haStatefiles);
            hashMap.put("ha_host_failures_to_tolerate", this.haHostFailuresToTolerate == null ? 0L : this.haHostFailuresToTolerate);
            hashMap.put("ha_plan_exists_for", this.haPlanExistsFor == null ? 0L : this.haPlanExistsFor);
            hashMap.put("ha_allow_overcommit", this.haAllowOvercommit == null ? false : this.haAllowOvercommit);
            hashMap.put("ha_overcommitted", this.haOvercommitted == null ? false : this.haOvercommitted);
            hashMap.put("blobs", this.blobs == null ? new HashMap() : this.blobs);
            hashMap.put("tags", this.tags == null ? new LinkedHashSet() : this.tags);
            hashMap.put("gui_config", this.guiConfig == null ? new HashMap() : this.guiConfig);
            hashMap.put("health_check_config", this.healthCheckConfig == null ? new HashMap() : this.healthCheckConfig);
            hashMap.put("wlb_url", this.wlbUrl == null ? "" : this.wlbUrl);
            hashMap.put("wlb_username", this.wlbUsername == null ? "" : this.wlbUsername);
            hashMap.put("wlb_enabled", this.wlbEnabled == null ? false : this.wlbEnabled);
            hashMap.put("wlb_verify_cert", this.wlbVerifyCert == null ? false : this.wlbVerifyCert);
            hashMap.put("redo_log_enabled", this.redoLogEnabled == null ? false : this.redoLogEnabled);
            hashMap.put("redo_log_vdi", this.redoLogVdi == null ? new VDI("OpaqueRef:NULL") : this.redoLogVdi);
            hashMap.put("vswitch_controller", this.vswitchController == null ? "" : this.vswitchController);
            hashMap.put("restrictions", this.restrictions == null ? new HashMap() : this.restrictions);
            hashMap.put("metadata_VDIs", this.metadataVDIs == null ? new LinkedHashSet() : this.metadataVDIs);
            hashMap.put("ha_cluster_stack", this.haClusterStack == null ? "" : this.haClusterStack);
            hashMap.put("allowed_operations", this.allowedOperations == null ? new LinkedHashSet() : this.allowedOperations);
            hashMap.put("current_operations", this.currentOperations == null ? new HashMap() : this.currentOperations);
            hashMap.put("guest_agent_config", this.guestAgentConfig == null ? new HashMap() : this.guestAgentConfig);
            hashMap.put("cpu_info", this.cpuInfo == null ? new HashMap() : this.cpuInfo);
            hashMap.put("policy_no_vendor_device", this.policyNoVendorDevice == null ? false : this.policyNoVendorDevice);
            hashMap.put("live_patching_disabled", this.livePatchingDisabled == null ? false : this.livePatchingDisabled);
            hashMap.put("igmp_snooping_enabled", this.igmpSnoopingEnabled == null ? false : this.igmpSnoopingEnabled);
            return hashMap;
        }
    }
}

