/*
 * Decompiled with CFR 0.152.
 */
package Acme.JPM.Filters;

import Acme.JPM.Filters.ImageFilterPlus;
import Acme.JPM.Filters.RGBAllFilter;
import java.awt.image.ImageProducer;

public class Smooth
extends RGBAllFilter {
    private int n;

    public Smooth(ImageProducer producer, int n) {
        super(producer);
        this.n = n;
    }

    public Smooth(ImageProducer producer) {
        this(producer, 1);
    }

    public void filterRGBAll(int width, int height, int[][] rgbPixels) {
        int[][] newPixels = new int[height][width];
        int row = 0;
        while (row < height) {
            int col = 0;
            while (col < width) {
                int a = 0;
                int r = 0;
                int g = 0;
                int b = 0;
                int c = 0;
                int subrow = row - this.n;
                while (subrow <= row + this.n) {
                    if (subrow >= 0 && subrow < height) {
                        int subcol = col - this.n;
                        while (subcol <= col + this.n) {
                            if (subcol >= 0 && subcol < width) {
                                int rgb = rgbPixels[subrow][subcol];
                                a += rgb >> 24 & 0xFF;
                                r += rgb >> 16 & 0xFF;
                                g += rgb >> 8 & 0xFF;
                                b += rgb & 0xFF;
                                ++c;
                            }
                            ++subcol;
                        }
                    }
                    ++subrow;
                }
                newPixels[row][col] = (a /= c) << 24 | (r /= c) << 16 | (g /= c) << 8 | (b /= c);
                ++col;
            }
            ++row;
        }
        this.setPixels(width, height, newPixels);
    }

    public static void main(String[] args) {
        int n = -1;
        int argc = args.length;
        int argn = 0;
        while (argn < argc && args[argn].charAt(0) == '-') {
            if (args[argn].equals("-n") && argn + 1 < argc) {
                n = Integer.parseInt(args[++argn]);
            } else {
                Smooth.usage();
            }
            ++argn;
        }
        if (argn != argc) {
            Smooth.usage();
        }
        Smooth filter = n == -1 ? new Smooth(null) : new Smooth(null, n);
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, filter));
    }

    private static void usage() {
        System.err.println("usage: Smooth [-n N]");
        System.exit(1);
    }
}

