/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.image;

import com.objectplanet.image.Encoder;
import com.objectplanet.image.GrayScaleAlphaEncoder;
import com.objectplanet.image.GrayScaleEncoder;
import com.objectplanet.image.IndexedAlphaEncoder;
import com.objectplanet.image.IndexedEncoder;
import com.objectplanet.image.TrueColorAlphaEncoder;
import com.objectplanet.image.TrueColorEncoder;
import java.awt.Image;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PngEncoder {
    public static final int COLOR_GRAYSCALE = 0;
    public static final int COLOR_TRUECOLOR = 2;
    public static final int COLOR_INDEXED = 3;
    public static final int COLOR_GRAYSCALE_ALPHA = 4;
    public static final int COLOR_INDEXED_ALPHA = 5;
    public static final int COLOR_TRUECOLOR_ALPHA = 6;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int BEST_SPEED = 1;
    public static final int BEST_COMPRESSION = 9;
    private static final byte[] PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] END_CHUNK = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    private int colorType;
    private int compression;
    private Encoder encoder;

    public PngEncoder() {
        this(2);
    }

    public PngEncoder(int colorType) {
        this(colorType, -1);
    }

    public PngEncoder(int colorType, int compression) {
        this.compression = compression;
        this.initEncoder(colorType, compression);
    }

    private void initEncoder(int colorType, int compression) {
        this.colorType = colorType;
        switch (colorType) {
            case 3: {
                this.encoder = new IndexedEncoder(compression);
                break;
            }
            case 5: {
                this.encoder = new IndexedAlphaEncoder(compression);
                break;
            }
            case 2: {
                this.encoder = new TrueColorEncoder(compression);
                break;
            }
            case 6: {
                this.encoder = new TrueColorAlphaEncoder(compression);
                break;
            }
            case 0: {
                this.encoder = new GrayScaleEncoder(compression);
                break;
            }
            case 4: {
                this.encoder = new GrayScaleAlphaEncoder(compression);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid colorType, must be COLOR_INDEXED, COLOR_TRUECOLOR, COLOR_GRAYSCALE, COLOR_INDEXED_ALPHA, COLOR_TRUECOLOR_ALPHA or COLOR_GRAYSCALE_ALPHA");
            }
        }
    }

    public synchronized void setColorType(int colorType) {
        this.initEncoder(colorType, this.compression);
    }

    public synchronized int getColorType() {
        return this.colorType;
    }

    public synchronized void setCompression(int level) {
        this.compression = level;
        this.encoder.setCompression(level);
    }

    public static String getVersion() {
        return "2.0";
    }

    public static void main(String[] argv) {
        System.out.println("Java PngEncoder " + PngEncoder.getVersion());
        System.out.println("Copyright 2003-2006, ObjectPlanet, Inc.");
    }

    public synchronized void encode(Image image, OutputStream out) throws IOException {
        if (image == null || image.getSource() == null || out == null) {
            return;
        }
        out.write(PNG_SIGNATURE);
        this.encoder.encode(image, new DataOutputStream(out));
        out.write(END_CHUNK);
    }
}

