/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart.ext;

import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.LineChartRenderer;
import com.objectplanet.chart.ext.SplineChart;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;

public class SplineChartRenderer
extends LineChartRenderer {
    double[][] logLines;
    SplineChart chart;

    public SplineChartRenderer(SplineChart chart) {
        super(chart);
        this.chart = chart;
    }

    protected void paintArea(Graphics2D g, int index, int serie1, int serie2, Rectangle gridBounds, Rectangle dataBounds, Color color, boolean selected) {
        GeneralPath path3d;
        CubicCurve2D.Double curve;
        int sample;
        if (serie1 < 0 || serie1 >= this.samplePoints.length || serie2 < 0 || serie2 >= this.samplePoints.length) {
            return;
        }
        int seriesCount = this.getSeriesCount();
        int sampleCount = Math.min(this.getSampleCount(), Math.min(this.samplePoints[serie1].length, this.samplePoints[serie2].length));
        ChartSample[] samples1 = this.chart.getSamples(serie1);
        ChartSample[] samples2 = this.chart.getSamples(serie2);
        if (samples1 == null || samples1.length == 0 || samples2 == null || samples2.length == 0) {
            return;
        }
        if (this.display3dOn) {
            Polygon poly = new Polygon();
            poly.addPoint(gridBounds.x - this.depth3dPoint.x, gridBounds.y - this.depth3dPoint.y);
            poly.addPoint(gridBounds.x, gridBounds.y);
            poly.addPoint(gridBounds.x + gridBounds.width, gridBounds.y);
            poly.addPoint(gridBounds.x + gridBounds.width, gridBounds.y + gridBounds.height);
            poly.addPoint(gridBounds.x + gridBounds.width - this.depth3dPoint.x, gridBounds.y + gridBounds.height - this.depth3dPoint.y);
            poly.addPoint(gridBounds.x - this.depth3dPoint.x, gridBounds.y + gridBounds.height - this.depth3dPoint.y);
            g.setClip(poly);
        } else {
            g.setClip(gridBounds.x + 1, gridBounds.y, gridBounds.width - 1, gridBounds.height + 1);
        }
        dataBounds = this.chart.getDataBounds(gridBounds);
        GradientPaint paint = new GradientPaint(dataBounds.x, 0.0f, color, dataBounds.x + dataBounds.width, 0.0f, this.chart.getAreaColor2(index));
        GradientPaint paint_darker = new GradientPaint(dataBounds.x, 0.0f, SplineChartRenderer.getDarker(color), dataBounds.x + dataBounds.width, 0.0f, SplineChartRenderer.getDarker(this.chart.getAreaColor2(index)));
        int depth_x1 = this.depth3dPoint.x;
        int depth_y1 = this.depth3dPoint.y;
        int depth_x2 = this.depth3dPoint.x;
        int depth_y2 = this.depth3dPoint.y;
        if (this.chart.getLine3DLayout() == 0) {
            depth_x1 = (int)Math.round((double)this.depth3dPoint.x / (double)seriesCount);
            depth_y1 = (int)Math.round((double)this.depth3dPoint.y / (double)seriesCount);
            depth_x2 = (int)Math.round((double)this.depth3dPoint.x / (double)seriesCount);
            depth_y2 = (int)Math.round((double)this.depth3dPoint.y / (double)seriesCount);
        }
        depth_x1 = (int)((double)depth_x1 * this.chart.getLine3DDepth(serie1));
        depth_y1 = (int)((double)depth_y1 * this.chart.getLine3DDepth(serie1));
        depth_x2 = (int)((double)depth_x2 * this.chart.getLine3DDepth(serie2));
        depth_y2 = (int)((double)depth_y2 * this.chart.getLine3DDepth(serie2));
        GeneralPath gpath = new GeneralPath(1);
        int dx = this.display3dOn ? this.depth3dPoint.x : 0;
        g.setPaint(paint_darker);
        for (sample = 0; sample < sampleCount - 1; ++sample) {
            if (samples1[sample] == null || !samples1[sample].hasValue()) continue;
            curve = this.getSegmentCurve(samples1, serie1, sample, sample + 1);
            if (this.display3dOn && !this.chart.isSeriesLineOn(serie1)) {
                path3d = new GeneralPath();
                path3d.append(curve, true);
                path3d.append(this.get3DOffsetCurve(this.invertCurve(curve), serie1), true);
                g.setPaint(paint_darker);
                g.fill(path3d);
            }
            gpath.append(curve, true);
        }
        for (sample = sampleCount - 2; sample >= 0; --sample) {
            if (samples2[sample] == null || !samples1[sample].hasValue()) continue;
            curve = this.invertCurve(this.getSegmentCurve(samples2, serie2, sample, sample + 1));
            if (this.display3dOn && !this.chart.isSeriesLineOn(serie2)) {
                path3d = new GeneralPath();
                path3d.append(curve, true);
                path3d.append(this.get3DOffsetCurve(this.invertCurve(curve), serie2), true);
                g.setPaint(paint_darker);
                g.fill(path3d);
            }
            gpath.append(curve, true);
        }
        g.setPaint(paint);
        g.fill(gpath);
        if (this.display3dOn) {
            int x1 = this.getSamplePoint3DX(this.samplePoints[serie1][sampleCount - 1][0], serie1) - dx;
            int y1 = this.getSamplePoint3DY(this.samplePoints[serie1][sampleCount - 1][1], serie1);
            int x2 = this.getSamplePoint3DX(this.samplePoints[serie2][sampleCount - 1][0], serie2) - dx;
            int y2 = this.getSamplePoint3DY(this.samplePoints[serie2][sampleCount - 1][1], serie2);
            Polygon poly = new Polygon();
            poly.addPoint(x1, y1);
            poly.addPoint(x1 + depth_x1, y1 + depth_y1);
            poly.addPoint(x2 + depth_x2, y2 + depth_y2);
            poly.addPoint(x2, y2);
            g.setColor(SplineChartRenderer.getDarker(color));
            g.fillPolygon(poly);
        }
        g.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private CubicCurve2D.Double getSegmentCurve(ChartSample[] samples, int serie, int sample1, int sample2) {
        int offset_x = 0;
        int offset_y = 0;
        if (this.display3dOn) {
            int seriesCount = this.chart.getSeriesCount();
            double depth_x = this.depth3dPoint.x;
            double depth_y = this.depth3dPoint.y;
            if (this.chart.getLine3DLayout() == 0 && !this.chart.isStackedOn()) {
                depth_x /= (double)seriesCount;
                depth_y /= (double)seriesCount;
            }
            double lineDepth = this.chart.getLine3DDepth(serie);
            offset_x = (int)((1.0 - lineDepth) * depth_x * 0.5) - this.depth3dPoint.x;
            offset_y = (int)((1.0 - lineDepth) * depth_y * 0.5);
        }
        int count = this.chart.getSampleCount();
        int x1 = this.samplePoints[serie][sample1][0] + offset_x;
        int y1 = this.samplePoints[serie][sample1][1] + offset_y;
        int x2 = x1 + offset_x;
        int y2 = y1 + offset_y;
        if (serie < this.samplePoints.length && sample2 < this.samplePoints[serie].length) {
            x2 = this.samplePoints[serie][sample2][0] + offset_x;
            y2 = this.samplePoints[serie][sample2][1] + offset_y;
        }
        int prev_x = sample1 > 0 && samples[sample1 - 1] != null && samples[sample1 - 1].hasValue() ? this.samplePoints[serie][sample1 - 1][0] + offset_x : x1;
        int prev_y = sample1 > 0 && samples[sample1 - 1] != null && samples[sample1 - 1].hasValue() ? this.samplePoints[serie][sample1 - 1][1] + offset_y : y1;
        int next_x = sample1 < count - 2 && samples[sample2 + 1] != null && samples[sample2 + 1].hasValue() ? this.samplePoints[serie][sample2 + 1][0] + offset_x : x2;
        int next_y = sample1 < count - 2 && samples[sample2 + 1] != null && samples[sample2 + 1].hasValue() ? this.samplePoints[serie][sample2 + 1][1] + offset_y : y2;
        return this.getCurve(prev_x, prev_y, x1, y1, x2, y2, next_x, next_y);
    }

    protected void paintLine(Graphics g, int serie, Rectangle gridBounds, Rectangle dataBounds, Color color, boolean selected) {
        int ypos;
        int sample;
        ChartSample[] samples;
        int seriesCount = this.getSeriesCount();
        if (serie < 0 || serie >= seriesCount) {
            throw new IllegalArgumentException("Invalid series: " + serie);
        }
        if (selected) {
            // empty if block
        }
        if ((samples = this.chart.getSamples(serie)) == null || samples.length == 0) {
            return;
        }
        boolean stackedOn = this.chart.isStackedOn();
        boolean display3dOn = this.chart.is3DModeOn();
        Graphics cg = g;
        if (display3dOn) {
            Polygon poly = new Polygon();
            poly.addPoint(gridBounds.x - this.depth3dPoint.x, gridBounds.y - this.depth3dPoint.y);
            poly.addPoint(gridBounds.x, gridBounds.y);
            poly.addPoint(gridBounds.x + gridBounds.width, gridBounds.y);
            poly.addPoint(gridBounds.x + gridBounds.width, gridBounds.y + gridBounds.height);
            poly.addPoint(gridBounds.x + gridBounds.width - this.depth3dPoint.x, gridBounds.y + gridBounds.height - this.depth3dPoint.y);
            poly.addPoint(gridBounds.x - this.depth3dPoint.x, gridBounds.y + gridBounds.height - this.depth3dPoint.y);
            cg.setClip(poly);
        } else {
            cg.setClip(gridBounds.x + 1, gridBounds.y, gridBounds.width - 1, gridBounds.height + 1);
        }
        Paint paint = color;
        Paint paint_darker = SplineChartRenderer.getDarker(color);
        Paint paint_darkest = SplineChartRenderer.getDarker(SplineChartRenderer.getDarker(color));
        Color color2 = this.chart.getSampleColor2(serie);
        if (color2 != null) {
            paint = new GradientPaint(dataBounds.x, 0.0f, color, dataBounds.x + dataBounds.width, 0.0f, color2);
            paint_darker = new GradientPaint(dataBounds.x, 0.0f, SplineChartRenderer.getDarker(color), dataBounds.x + dataBounds.width, 0.0f, SplineChartRenderer.getDarker(color2));
            paint_darkest = new GradientPaint(dataBounds.x, 0.0f, SplineChartRenderer.getDarker(SplineChartRenderer.getDarker(color)), dataBounds.x + dataBounds.width, 0.0f, SplineChartRenderer.getDarker(color2));
        }
        int[] pos_x = new int[4];
        int[] pos_y = new int[4];
        boolean last_valid = false;
        int last_valid_x = 0;
        int last_valid_y = 0;
        try {
            last_valid_x = this.samplePoints[serie][0][0];
            last_valid_y = this.samplePoints[serie][0][1];
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        for (sample = 0; sample < samples.length - 1; ++sample) {
            int next_y;
            if (display3dOn) {
                ChartSample s = samples[sample];
                if (this.chart.isSampleHighlightOn(serie, sample) && s != null && s.hasValue()) {
                    try {
                        int xpos = this.getSamplePoint3DX(this.samplePoints[serie][sample][0], serie) - this.depth3dPoint.x;
                        ypos = this.getSamplePoint3DY(this.samplePoints[serie][sample][1], serie);
                        this.paintSampleHighlight(g, serie, sample, Math.round(xpos), ypos, color);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            boolean this_sample_valid = samples[sample] != null && samples[sample].hasValue();
            boolean next_sample_valid = samples[sample + 1] != null && samples[sample + 1].hasValue();
            boolean paint_line = this_sample_valid && next_sample_valid;
            paint_line |= next_sample_valid && this.chart.isConnectedLinesOn(serie);
            paint_line &= this.chart.getLineWidth(serie) > 0;
            try {
                if (paint_line && sample > 0 && sample < this.samplePoints[serie].length - 1) {
                    paint_line = this.samplePoints[serie][sample][0] != last_valid_x;
                    paint_line |= this.samplePoints[serie][sample + 1][1] != last_valid_y;
                }
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            if (this_sample_valid) {
                try {
                    last_valid_x = this.samplePoints[serie][sample][0];
                    last_valid_y = this.samplePoints[serie][sample][1];
                    last_valid = true;
                }
                catch (IndexOutOfBoundsException e) {
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            if (!(paint_line &= last_valid)) continue;
            if (this.chart.isConnectedLinesOn(serie)) {
                pos_x[0] = this.getSamplePoint3DX(last_valid_x, serie);
                pos_y[0] = this.getSamplePoint3DY(last_valid_y, serie);
            } else {
                try {
                    pos_x[0] = this.getSamplePoint3DX(this.samplePoints[serie][sample][0], serie);
                    pos_y[0] = this.getSamplePoint3DY(this.samplePoints[serie][sample][1], serie);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.samplePoints != null && serie < this.samplePoints.length && sample + 1 < this.samplePoints[serie].length) {
                pos_x[1] = this.getSamplePoint3DX(this.samplePoints[serie][sample + 1][0], serie);
                pos_y[1] = this.getSamplePoint3DY(this.samplePoints[serie][sample + 1][1], serie);
            }
            if (display3dOn) {
                pos_x[0] = pos_x[0] - this.depth3dPoint.x;
                pos_x[1] = pos_x[1] - this.depth3dPoint.x;
                pos_x[2] = pos_x[2] - this.depth3dPoint.x;
                pos_x[3] = pos_x[3] - this.depth3dPoint.x;
            }
            if (stackedOn) {
                pos_x[2] = pos_x[1];
                if (serie > 0) {
                    try {
                        pos_y[2] = this.getSamplePoint3DY(this.samplePoints[serie - 1][sample + 1][1], serie);
                    }
                    catch (Exception e) {}
                } else {
                    pos_y[2] = gridBounds.y + gridBounds.height;
                }
                if (display3dOn) {
                    pos_y[2] = pos_y[2] - this.depth3dPoint.y;
                }
                pos_x[3] = pos_x[0];
                if (serie > 0) {
                    try {
                        pos_y[3] = this.getSamplePoint3DY(this.samplePoints[serie - 1][sample][1], serie);
                    }
                    catch (Exception e) {}
                } else {
                    pos_y[3] = gridBounds.y + gridBounds.height;
                }
                if (display3dOn) {
                    pos_y[3] = pos_y[3] - this.depth3dPoint.y;
                }
            }
            if (this.chart.isSampleHighlightOn(serie)) {
                // empty if block
            }
            boolean inside_grid = false;
            int left = gridBounds.x - (display3dOn ? this.depth3dPoint.x * 2 : 0);
            int right = gridBounds.x + gridBounds.width;
            inside_grid |= pos_x[0] >= left && pos_x[0] <= right;
            inside_grid |= pos_x[1] >= left && pos_x[1] <= right;
            inside_grid |= pos_x[0] <= left && pos_x[1] >= right;
            if (!(inside_grid |= serie < this.samplePoints.length && sample < this.samplePoints[serie].length)) continue;
            int offset_y = (int)((1.0 - this.chart.getLine3DDepth(serie)) * (double)this.depth3dPoint.y * 0.5);
            int offset_x = (int)((1.0 - this.chart.getLine3DDepth(serie)) * (double)this.depth3dPoint.x * 0.5);
            int dx = display3dOn ? this.depth3dPoint.x : 0;
            int dy = display3dOn ? this.depth3dPoint.y : 0;
            int x1 = this.samplePoints[serie][sample][0] - dx + offset_x;
            int y1 = this.samplePoints[serie][sample][1] + offset_y;
            int x2 = this.samplePoints[serie][sample + 1][0] - dx + offset_x;
            int y2 = this.samplePoints[serie][sample + 1][1] + offset_y;
            int y3 = (serie > 0 ? this.samplePoints[serie - 1][sample + 1][1] : gridBounds.y + gridBounds.height - dy) + offset_y;
            int y4 = (serie > 0 ? this.samplePoints[serie - 1][sample][1] : gridBounds.y + gridBounds.height - dy) + offset_y;
            if (!this.chart.isSeriesLineOn(serie) && !selected) continue;
            int count = this.chart.getSampleCount();
            int prev_x = sample > 0 && samples[sample - 1] != null && samples[sample - 1].hasValue() ? this.getSamplePoint3DX(this.samplePoints[serie][sample - 1][0], serie) : pos_x[0] + this.depth3dPoint.x;
            int prev_y = sample > 0 && samples[sample - 1] != null && samples[sample - 1].hasValue() ? this.getSamplePoint3DY(this.samplePoints[serie][sample - 1][1], serie) : pos_y[0];
            int next_x = sample < count - 2 && samples[sample + 2] != null && samples[sample + 2].hasValue() ? this.getSamplePoint3DX(this.samplePoints[serie][sample + 2][0], serie) : pos_x[1] + this.depth3dPoint.x;
            int n = next_y = sample < count - 2 && samples[sample + 2] != null && samples[sample + 2].hasValue() ? this.getSamplePoint3DY(this.samplePoints[serie][sample + 2][1], serie) : pos_y[1];
            if (display3dOn) {
                prev_x -= this.depth3dPoint.x;
                next_x -= this.depth3dPoint.x;
            }
            boolean inverted = (double)(pos_y[0] - pos_y[1]) / (double)(pos_x[1] - pos_x[0]) > 0.69;
            GeneralPath gpath = new GeneralPath(1);
            GeneralPath gpath1 = new GeneralPath(1);
            GeneralPath gpath2 = new GeneralPath(1);
            gpath.moveTo(pos_x[0], pos_y[0]);
            CubicCurve2D.Double front_curve = this.getCurve(prev_x, prev_y, pos_x[0], pos_y[0], pos_x[1], pos_y[1], next_x, next_y);
            CubicCurve2D.Double curve1 = new CubicCurve2D.Double();
            CubicCurve2D.Double curve2 = new CubicCurve2D.Double();
            front_curve.subdivide(curve1, curve2);
            if (!selected) {
                ((Graphics2D)cg).setPaint(paint);
            } else {
                ((Graphics2D)cg).setPaint(paint_darker);
            }
            if (!display3dOn) {
                ((Graphics2D)g).setStroke(new BasicStroke(this.chart.getLineWidth(serie)));
                if (this.chart.isOutlineOn(serie)) {
                    ((Graphics2D)g).draw(front_curve);
                }
                ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
            } else {
                gpath.append(front_curve, false);
                CubicCurve2D.Double back_curve = this.get3DOffsetCurve(this.invertCurve(front_curve), serie);
                CubicCurve2D.Double i_curve1 = new CubicCurve2D.Double();
                CubicCurve2D.Double i_curve2 = new CubicCurve2D.Double();
                back_curve.subdivide(i_curve1, i_curve2);
                gpath1.append(curve1, false);
                gpath1.append(i_curve2, true);
                gpath2.append(curve2, false);
                gpath2.append(i_curve1, true);
                gpath.append(back_curve, true);
                gpath.closePath();
                if (inverted) {
                    if (!selected) {
                        ((Graphics2D)cg).setPaint(paint_darker);
                    } else {
                        ((Graphics2D)cg).setPaint(paint_darkest);
                    }
                }
                ((Graphics2D)cg).fill(gpath);
                this.chart.setAntialiasingOn(false);
                for (int i = 0; i < 100; ++i) {
                    double t = (double)i / 100.0;
                }
                this.chart.setAntialiasingOn(true);
                ((Graphics2D)g).setPaint(paint_darkest);
                if (this.chart.isOutlineOn(serie)) {
                    ((Graphics2D)cg).draw(gpath);
                }
                if (sample == 0 && this.chart.isOutlineOn(serie) && stackedOn) {
                    g.setColor(SplineChartRenderer.getDarker(color));
                    g.drawLine(x1, y1, x1, y4);
                }
                if (sample == samples.length - 2 && stackedOn) {
                    int depth_x = this.depth3dPoint.x;
                    int depth_y = this.depth3dPoint.y;
                    if (this.chart.getLine3DLayout() == 0 && !this.chart.isStackedOn()) {
                        depth_x = (int)Math.round((double)this.depth3dPoint.x / (double)seriesCount);
                        depth_y = (int)Math.round((double)this.depth3dPoint.y / (double)seriesCount);
                    }
                    depth_x = (int)((double)depth_x * this.chart.getLine3DDepth(serie));
                    depth_y = (int)((double)depth_y * this.chart.getLine3DDepth(serie));
                    GeneralPath path = new GeneralPath();
                    path.reset();
                    path.moveTo(x2, y2);
                    path.lineTo(x2 + depth_x, y2 + depth_y);
                    path.lineTo((float)x2 + (float)depth_x, y3 + depth_y);
                    path.lineTo(x2, y3);
                    path.closePath();
                    Color c = this.chart.getSampleColor2(serie) != null ? SplineChartRenderer.getDarker(this.chart.getSampleColor2(serie)) : SplineChartRenderer.getDarker(color);
                    g.setColor(c);
                    ((Graphics2D)g).fill(path);
                    if (this.chart.isOutlineOn(serie)) {
                        g.setColor(SplineChartRenderer.getDarker(c));
                        ((Graphics2D)g).draw(path);
                    }
                }
            }
            if (!stackedOn || !this.chart.isSeriesLineOn(serie)) continue;
            GeneralPath stacked_gpath = new GeneralPath(1);
            stacked_gpath.append(front_curve, false);
            if (serie > 0) {
                int s_next_y;
                if (display3dOn) {
                    pos_y[3] = pos_y[3] + this.depth3dPoint.y;
                    pos_y[2] = pos_y[2] + this.depth3dPoint.y;
                }
                ChartSample[] samples2 = this.chart.getSamples(serie - 1);
                int s_prev_x = sample > 0 && samples2[sample - 1] != null && samples2[sample - 1].hasValue() ? this.getSamplePoint3DX(this.samplePoints[serie - 1][sample - 1][0], serie - 1) : pos_x[3] + this.depth3dPoint.x;
                int s_prev_y = sample > 0 && samples2[sample - 1] != null && samples2[sample - 1].hasValue() ? this.getSamplePoint3DY(this.samplePoints[serie - 1][sample - 1][1], serie - 1) : pos_y[3];
                int s_next_x = sample < count - 2 && samples2[sample + 2] != null && samples2[sample + 2].hasValue() ? this.getSamplePoint3DX(this.samplePoints[serie - 1][sample + 2][0], serie - 1) : pos_x[2] + this.depth3dPoint.x;
                int n2 = s_next_y = sample < count - 2 && samples2[sample + 2] != null && samples2[sample + 2].hasValue() ? this.getSamplePoint3DY(this.samplePoints[serie - 1][sample + 2][1], serie - 1) : pos_y[2];
                if (display3dOn) {
                    s_prev_x -= this.depth3dPoint.x;
                    s_next_x -= this.depth3dPoint.x;
                }
                CubicCurve2D.Double stacked_curve = this.getCurve(s_prev_x, s_prev_y, pos_x[3], pos_y[3], pos_x[2], pos_y[2], s_next_x, s_next_y);
                CubicCurve2D.Double stacked_inverted = this.invertCurve(stacked_curve);
                stacked_gpath.append(stacked_inverted, true);
            } else {
                stacked_gpath.lineTo(pos_x[2], pos_y[2] + offset_y);
                stacked_gpath.lineTo(pos_x[3], pos_y[3] + offset_y);
                stacked_gpath.closePath();
            }
            ((Graphics2D)g).setPaint(paint);
            ((Graphics2D)g).fill(stacked_gpath);
            if (!this.chart.isOutlineOn(serie)) continue;
            ((Graphics2D)g).setPaint(paint_darker);
            ((Graphics2D)g).draw(front_curve);
            if (serie == 0) {
                g.drawLine(x1, y4, x2, y3);
            }
            if (sample == 0) {
                g.drawLine(x1, y1, x1, y4);
            }
            if (sample != this.chart.getSampleCount() - 2) continue;
            g.drawLine(x2, y2, x2, y3);
        }
        if (!display3dOn) {
            for (sample = 0; samples != null && sample < samples.length; ++sample) {
                ChartSample s = samples[sample];
                if (!this.chart.isSampleHighlightOn(serie, sample) && !this.chart.isSampleHighlightOn(serie) || s == null || !s.hasValue()) continue;
                try {
                    int xpos = this.getSamplePoint3DX(this.samplePoints[serie][sample][0], serie);
                    ypos = this.getSamplePoint3DY(this.samplePoints[serie][sample][1], serie);
                    if (ypos < gridBounds.y || ypos > gridBounds.y + gridBounds.height || xpos < gridBounds.x || xpos > gridBounds.x + gridBounds.width + 1) continue;
                    this.paintSampleHighlight(g, serie, sample, Math.round(xpos), ypos, color);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        g.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private void a(Graphics g, CubicCurve2D.Double curve, double t) {
        double q_x0 = curve.x1 + (curve.ctrlx1 - curve.x1) * t;
        double q_y0 = curve.y1 + (curve.ctrly1 - curve.y1) * t;
        double q_x1 = curve.ctrlx1 + (curve.ctrlx2 - curve.ctrlx1) * t;
        double q_y1 = curve.ctrly1 + (curve.ctrly2 - curve.ctrly1) * t;
        double q_x2 = curve.ctrlx2 + (curve.x2 - curve.ctrlx2) * t;
        double q_y2 = curve.ctrly2 + (curve.y2 - curve.ctrly2) * t;
        double r_x0 = q_x0 + (q_x1 - q_x0) * t;
        double r_y0 = q_y0 + (q_y1 - q_y0) * t;
        double r_x1 = q_x1 + (q_x2 - q_x1) * t;
        double r_y1 = q_y1 + (q_y2 - q_y1) * t;
        int x = (int)Math.round(r_x0 + (r_x1 - r_x0) * t);
        int y = (int)Math.round(r_y0 + (r_y1 - r_y0) * t);
        g.drawLine(x, y, x + this.depth3dPoint.x, y + this.depth3dPoint.y);
    }

    private CubicCurve2D.Double getCurve(int x0, int y0, int x1, int y1, int x2, int y2, int x3, int y3) {
        boolean inverted = (double)(y1 - y2) / (double)(x2 - x1) > 0.69;
        boolean prev_inverted = (double)(y0 - y1) / (double)(x1 - x0) > 0.69;
        boolean next_inverted = (double)(y2 - y3) / (double)(x3 - x2) > 0.69;
        double ratio = (double)this.depth3dPoint.y / (double)this.depth3dPoint.x;
        double ratio1 = (double)(y0 - y2) / (double)(x2 - x0);
        double ratio2 = (double)(y1 - y3) / (double)(x3 - x1);
        CubicCurve2D.Double curve = new CubicCurve2D.Double();
        curve.x1 = x1;
        curve.y1 = y1;
        curve.x2 = x2;
        curve.y2 = y2;
        int dist_x1 = (x2 - x1) / 3;
        int dist_y1 = -((int)(ratio1 * (double)dist_x1));
        int dist_x2 = (x2 - x1) / 3;
        int dist_y2 = -((int)(ratio2 * (double)dist_x2));
        if (this.display3dOn) {
            if (y0 <= y1 && y1 >= y2) {
                dist_y1 = 0;
            }
            if (y1 <= y2 && y2 >= y3) {
                dist_y2 = 0;
            }
            if (y0 >= y1 && y1 <= y2) {
                dist_y1 = 0;
            }
            if (y1 >= y2 && y2 <= y3) {
                dist_y2 = 0;
            }
        }
        curve.ctrlx1 = x1 + dist_x1;
        curve.ctrly1 = y1 + dist_y1;
        curve.ctrlx2 = x2 - dist_x2;
        curve.ctrly2 = y2 - dist_y2;
        return curve;
    }

    private CubicCurve2D.Double getCurve1(int x0, int y0, int x1, int y1, int x2, int y2, int x3, int y3) {
        int dist_x1;
        boolean next_inverted;
        boolean inverted = (double)(y1 - y2) / (double)(x2 - x1) > 0.69;
        boolean prev_inverted = (double)(y0 - y1) / (double)(x1 - x0) > 0.69;
        boolean bl = next_inverted = (double)(y2 - y3) / (double)(x3 - x2) > 0.69;
        if (x1 == 148 && x2 == 264) {
            System.out.println(prev_inverted + " " + inverted + " " + next_inverted);
        }
        double ratio = (double)this.depth3dPoint.y / (double)this.depth3dPoint.x;
        double ratio1 = (double)(y0 - y2) / (double)(x2 - x0);
        double ratio2 = (double)(y1 - y3) / (double)(x3 - x1);
        CubicCurve2D.Double curve = new CubicCurve2D.Double();
        curve.x1 = x1;
        curve.y1 = y1;
        curve.x2 = x2;
        curve.y2 = y2;
        int dist_x2 = dist_x1 = (x2 - x1) / 4;
        int dist_y1 = (y2 - y1) / 4;
        if (inverted ^ prev_inverted) {
            dist_y1 = this.display3dOn ? (int)(ratio * (double)(dist_x1 *= 2)) : 0;
        } else if (ratio1 != 0.0) {
            dist_x1 = (int)Math.abs((double)dist_y1 / ratio1);
        }
        int dist_y2 = (y2 - y1) / 4;
        if (inverted ^ next_inverted) {
            dist_y2 = this.display3dOn ? (int)(ratio * (double)(dist_x2 *= 2)) : 0;
        } else {
            dist_y2 = (y2 - y1) / 4;
            if (ratio2 != 0.0) {
                dist_x2 = (int)Math.abs((double)dist_y2 / ratio2);
            }
        }
        curve.ctrlx1 = x1 + dist_x1;
        curve.ctrly1 = y1 + dist_y1;
        curve.ctrlx2 = x2 - dist_x2;
        curve.ctrly2 = y2 - dist_y2;
        return curve;
    }

    private CubicCurve2D.Double invertCurve(CubicCurve2D.Double curve) {
        CubicCurve2D.Double inverted_curve = new CubicCurve2D.Double();
        inverted_curve.x1 = curve.getX2();
        inverted_curve.y1 = curve.getY2();
        inverted_curve.x2 = curve.getX1();
        inverted_curve.y2 = curve.getY1();
        inverted_curve.ctrlx1 = curve.getCtrlX2();
        inverted_curve.ctrly1 = curve.getCtrlY2();
        inverted_curve.ctrlx2 = curve.getCtrlX1();
        inverted_curve.ctrly2 = curve.getCtrlY1();
        return inverted_curve;
    }

    private CubicCurve2D.Double get3DOffsetCurve(CubicCurve2D.Double curve, int serie) {
        int seriesCount = this.getSeriesCount();
        int depth_x = this.depth3dPoint.x;
        int depth_y = this.depth3dPoint.y;
        if (this.chart.getLine3DLayout() == 0 && !this.chart.isStackedOn()) {
            depth_x = (int)Math.round((double)this.depth3dPoint.x / (double)seriesCount);
            depth_y = (int)Math.round((double)this.depth3dPoint.y / (double)seriesCount);
        }
        depth_x = (int)((double)depth_x * this.chart.getLine3DDepth(serie));
        depth_y = (int)((double)depth_y * this.chart.getLine3DDepth(serie));
        CubicCurve2D.Double curve_off = new CubicCurve2D.Double();
        curve_off.x1 = curve.getX1() + (double)depth_x;
        curve_off.y1 = curve.getY1() + (double)depth_y;
        curve_off.x2 = curve.getX2() + (double)depth_x;
        curve_off.y2 = curve.getY2() + (double)depth_y;
        curve_off.ctrlx1 = curve.getCtrlX1() + (double)depth_x;
        curve_off.ctrly1 = curve.getCtrlY1() + (double)depth_y;
        curve_off.ctrlx2 = curve.getCtrlX2() + (double)depth_x;
        curve_off.ctrly2 = curve.getCtrlY2() + (double)depth_y;
        return curve_off;
    }

    protected void paintStackedLine(Graphics2D g, ChartSample[] samples, int serie, Rectangle gridBounds, Rectangle dataBounds, Color color, boolean selected, boolean isLeftEdge) {
    }

    protected void paintSimple3DLine(Graphics2D g, ChartSample[] samples, int series, Rectangle gridBounds, Rectangle dataBounds, Color color, boolean selected) {
    }

    protected void paintStacked3DLines(Graphics2D g, int seriesCount, Rectangle gridBounds, Rectangle dataBounds) {
        for (int i = seriesCount - 1; i >= 0; --i) {
            int range = this.chart.getSeriesRange(i);
            if (this.chart.getCurrentRange(range) == this.chart.getCurrentLowerRange(range)) continue;
            this.paintLine(g, i, gridBounds, dataBounds, this.chart.getSampleColor(i), this.chart.isSelected(i, -1));
        }
    }
}

