/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Panel;

public class NonFlickerPanel
extends Panel {
    private Image offscreen;

    public NonFlickerPanel() {
    }

    public NonFlickerPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public void release() {
        if (this.offscreen != null) {
            this.offscreen.flush();
            this.offscreen = null;
            System.gc();
        }
    }

    public void invalidate() {
        super.invalidate();
        this.release();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        if (this.offscreen == null && size != null && size.width > 0 && size.height > 0) {
            try {
                this.offscreen = this.createImage(size.width, size.height);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (size != null && size.width > 0 && size.height > 0) {
            Graphics og = g;
            if (this.offscreen != null) {
                og = this.offscreen.getGraphics();
            }
            og.setClip(0, 0, size.width, size.height);
            super.paint(og);
            if (this.offscreen != null) {
                g.drawImage(this.offscreen, 0, 0, null);
                og.dispose();
            }
        }
    }
}

