/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import java.awt.Color;
import java.io.Serializable;

public class Legend
implements Serializable {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    private boolean legendOn;
    private int legendColumns;
    private int legendPosition = 1;
    private boolean legendReverseOn;
    private String[] legendLabels;
    private Color[] legendColors;
    private String[] legendImages;
    private Color[] labelColors;
    private boolean legendBoxSizeAsFont;

    public void setLegendLabels(String[] labels) {
        this.legendLabels = labels;
    }

    public String[] getLegendLabels() {
        return this.legendLabels;
    }

    public void setLegendPosition(int position) {
        if (position != this.legendPosition) {
            if (position == 2 || position == 3 || position == 0 || position == 1) {
                this.legendPosition = position;
            } else {
                throw new IllegalArgumentException("Should be TOP, BOTTOM, LEFT, or RIGHT");
            }
        }
    }

    public int getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendColumns(int columns) {
        this.legendColumns = Math.max(0, columns);
    }

    public int getLegendColumns() {
        return this.legendColumns;
    }

    public void setLegendReverseOn(boolean on) {
        if (on != this.legendReverseOn) {
            this.legendReverseOn = on;
        }
    }

    public boolean isLegendReverseOn() {
        return this.legendReverseOn;
    }

    public void setLegendOn(boolean on) {
        if (on != this.legendOn) {
            this.legendOn = on;
        }
    }

    public boolean isLegendOn() {
        return this.legendOn;
    }

    public void setLegendColors(Color[] colors) {
        this.legendColors = colors;
    }

    public Color[] getLegendColors() {
        return this.legendColors;
    }

    public void setLegendColor(int index, Color color) {
        if (this.legendColors == null) {
            this.legendColors = new Color[index + 1];
        }
        if (index >= this.legendColors.length) {
            Color[] tmp_arr = new Color[index + 1];
            System.arraycopy(this.legendColors, 0, tmp_arr, 0, this.legendColors.length);
            this.legendColors = tmp_arr;
        }
        this.legendColors[index] = color;
    }

    public Color getLegendColor(int index) {
        if (this.legendColors != null && index >= 0 && index < this.legendColors.length && this.legendColors[index] != null) {
            return this.legendColors[index];
        }
        return null;
    }

    public void setLabelColor(int index, Color color) {
        if (this.labelColors == null) {
            this.labelColors = new Color[index + 1];
        }
        if (index >= this.labelColors.length) {
            Color[] tmp_arr = new Color[index + 1];
            System.arraycopy(this.labelColors, 0, tmp_arr, 0, this.labelColors.length);
            this.labelColors = tmp_arr;
        }
        this.labelColors[index] = color;
    }

    public Color getLabelColor(int index) {
        if (this.labelColors != null && index >= 0 && index < this.labelColors.length && this.labelColors[index] != null) {
            return this.labelColors[index];
        }
        return null;
    }

    public void setLegendImage(int index, String name) {
        if (index >= 0 && index < 1000) {
            if (this.legendImages == null) {
                this.legendImages = new String[index + 1];
            }
            if (index >= this.legendImages.length) {
                String[] tmp_arr = new String[index + 1];
                System.arraycopy(this.legendImages, 0, tmp_arr, 0, this.legendImages.length);
                this.legendImages = tmp_arr;
            }
            this.legendImages[index] = name;
        }
    }

    public String getLegendImage(int index) {
        if (this.legendImages != null && index >= 0 && index < this.legendImages.length) {
            return this.legendImages[index];
        }
        return null;
    }

    public boolean isLegendBoxSizeAsFont() {
        return this.legendBoxSizeAsFont;
    }

    public void setLegendBoxSizeAsFont(boolean on) {
        this.legendBoxSizeAsFont = on;
    }
}

