/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.GenericChart;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;

public class Grid
implements Serializable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int TARGET_LINE_NO_LABEL = 0;
    public static final int TARGET_LINE_ID_LABEL = 1;
    public static final int TARGET_LINE_VALUE_LABEL = 2;
    public static final int TARGET_LINE_ID_AND_VALUE_LABEL = 3;
    GenericChart chart;
    boolean[] rangeOn;
    double[] upperRange;
    double[] lowerRange;
    double[] currentUpperRange;
    double[] currentLowerRange;
    double[] rangeInterval;
    int[] rangePosition;
    Color[] rangeColor;
    boolean[] rangeLabelsOn;
    double leftSampleAxisRange;
    double rightSampleAxisRange;
    boolean valueLinesOn;
    Color valueLinesColor;
    int maxValueLineCount;
    int maxGridLineCount;
    double[] gridLines;
    double[] defaultGridLines;
    Color defaultGridLinesColor;
    Color[] gridLineColors;
    int[] rangeDecimalCount;
    int gridAlignment;
    boolean rightToLeftScrollingOn;
    private boolean[] gridAdjustment;
    Insets graphInsets;
    Hashtable targetsLabel;
    Hashtable targetsValue;
    Hashtable targetsColor;
    Hashtable targetsStyle;
    Hashtable targetsRange;
    int targetLabelsPosition;
    private NumberFormat[] rangeFormatters;
    boolean[] rangeAdjusterOn;
    int rangeAdjusterPosition;
    int[] rangeAdjusted;
    boolean sampleScrollerOn;

    public Grid(GenericChart chart) {
        this.chart = chart;
        this.targetsLabel = new Hashtable();
        this.targetsValue = new Hashtable();
        this.targetsColor = new Hashtable();
        this.targetsStyle = new Hashtable();
        this.targetsRange = new Hashtable();
        this.targetLabelsPosition = -1;
        this.rangeOn = new boolean[1];
        this.rangeInterval = new double[1];
        this.rangePosition = new int[1];
        this.upperRange = new double[1];
        this.lowerRange = new double[1];
        this.currentUpperRange = new double[1];
        this.currentLowerRange = new double[1];
        this.rangeDecimalCount = new int[1];
        this.rangeColor = new Color[1];
        this.rangeLabelsOn = new boolean[1];
        this.rangeAdjusterOn = new boolean[1];
        this.rangeAdjusted = new int[1];
        this.gridAdjustment = new boolean[4];
        this.gridAlignment = 1;
        this.maxValueLineCount = Integer.MAX_VALUE;
        this.maxGridLineCount = 10000;
        this.leftSampleAxisRange = 0.0;
        this.rightSampleAxisRange = 100.0;
        this.valueLinesOn = false;
        this.valueLinesColor = Color.lightGray;
        this.rangeOn[0] = true;
        this.rangeDecimalCount[0] = 0;
        this.rangeLabelsOn[0] = true;
        this.rangeAdjusterOn[0] = false;
        this.sampleScrollerOn = false;
        this.upperRange[0] = 100.0;
        this.lowerRange[0] = 0.0;
        this.currentUpperRange[0] = 100.0;
        this.currentLowerRange[0] = 0.0;
        this.rangeAdjusterPosition = 1;
        this.rangePosition[0] = 0;
        this.rangeAdjusted[0] = 0;
        this.gridLines = null;
        this.defaultGridLines = null;
        this.defaultGridLinesColor = Color.lightGray;
        this.gridLineColors = null;
        this.leftSampleAxisRange = 0.0;
        this.rightSampleAxisRange = 100.0;
        this.graphInsets = new Insets(-1, -1, -1, -1);
        this.rangeFormatters = new NumberFormat[1];
    }

    public void reset() {
        this.gridAlignment = 1;
        this.maxValueLineCount = Integer.MAX_VALUE;
        this.maxGridLineCount = 10000;
        this.leftSampleAxisRange = 0.0;
        this.rightSampleAxisRange = 100.0;
        this.valueLinesOn = false;
        this.valueLinesColor = Color.lightGray;
        this.rangeOn[0] = true;
        this.rangeDecimalCount[0] = 0;
        this.rangeLabelsOn[0] = true;
        this.targetsLabel.clear();
        this.targetsValue.clear();
        this.targetsColor.clear();
        this.targetsStyle.clear();
        this.targetsRange.clear();
        this.targetLabelsPosition = -1;
        this.rangeAdjusterOn[0] = false;
        this.sampleScrollerOn = false;
        this.upperRange[0] = 100.0;
        this.lowerRange[0] = 0.0;
        this.currentUpperRange[0] = 100.0;
        this.currentLowerRange[0] = 0.0;
        this.rangeAdjusterPosition = 1;
        this.rangePosition[0] = 0;
        this.rangeAdjusted[0] = 0;
        this.gridLines = null;
        this.defaultGridLines = null;
        this.defaultGridLinesColor = Color.lightGray;
        this.gridLineColors = null;
        this.leftSampleAxisRange = 0.0;
        this.rightSampleAxisRange = 100.0;
        this.graphInsets = new Insets(-1, -1, -1, -1);
    }

    public int getRangeCount() {
        return this.rangeOn.length;
    }

    public void setRange(int index, double range) {
        index = Math.max(0, index);
        this.checkRangeIntegrity(this.rangeOn.length, index + 1);
        this.upperRange[index] = range;
        this.currentUpperRange[index] = Math.min(this.currentUpperRange[index], range);
        if (!this.rangeAdjusterOn[index]) {
            this.currentUpperRange[index] = range;
        }
    }

    public double getRange(int index) {
        return this.upperRange[Math.min(this.upperRange.length - 1, Math.max(0, index))];
    }

    public void setRelativeRange(double range) {
        this.setRelativeRangeIndex(0, range);
    }

    void setRelativeRangeIndex(int index, double range) {
        index = Math.max(0, index);
        this.checkRangeIntegrity(this.upperRange.length, index + 1);
        double max = this.chart.getHighestValue(index);
        double min = this.chart.getLowestValue(index);
        for (int i = 0; i < 10; ++i) {
            GenericChart overlay = this.chart.getOverlayChart(i);
            if (overlay == null) continue;
            max = Math.max(max, overlay.getHighestValue(index));
            min = Math.min(min, overlay.getLowestValue(index));
        }
        if (index == 0) {
            Enumeration e = this.targetsValue.elements();
            while (e.hasMoreElements()) {
                max = Math.max((Double)e.nextElement(), max);
            }
        }
        if (max > 0.0) {
            this.setRange(index, max * Math.abs(range));
        } else if (max == 0.0 && min == 0.0) {
            this.setRange(index, 100.0);
        } else {
            this.setRange(index, 0.0);
        }
    }

    public void setRelativeRange(double range, double step) {
        this.setRelativeRange(0, range, step);
    }

    public void setRelativeRange(int index, double range, double step) {
        index = Math.max(0, index);
        this.checkRangeIntegrity(this.upperRange.length, index + 1);
        double max = this.chart.getHighestValue(index);
        double min = this.chart.getLowestValue(index);
        if (index == 0) {
            Enumeration e = this.targetsValue.elements();
            while (e.hasMoreElements()) {
                max = Math.max((Double)e.nextElement(), max);
            }
        }
        if (max > 0.0) {
            step = Math.abs(step);
            double new_range = max * Math.abs(range);
            if (step % 1.0 == 0.0) {
                if (new_range % step == 0.0) {
                    this.setRange(index, new_range);
                } else {
                    this.setRange(index, new_range - new_range % step + step);
                }
            } else {
                double value;
                for (value = 0.0; value < new_range; value += step) {
                }
                this.setRange(index, value);
            }
        } else if (max == 0.0 && min == 0.0) {
            this.setRange(index, 100.0);
        } else {
            this.setRange(index, 0.0);
        }
    }

    public void setLowerRange(int index, double range) {
        index = Math.max(0, index);
        this.checkRangeIntegrity(this.lowerRange.length, index + 1);
        this.lowerRange[index] = range;
        this.currentLowerRange[index] = Math.max(this.currentLowerRange[index], range);
        if (!this.rangeAdjusterOn[index]) {
            this.currentLowerRange[index] = range;
        }
    }

    public double getLowerRange(int index) {
        return this.lowerRange[Math.min(this.lowerRange.length - 1, Math.max(0, index))];
    }

    public void setLowerRelativeRange(double range) {
        this.setLowerRelativeRangeIndex(0, range);
    }

    void setLowerRelativeRangeIndex(int index, double range) {
        index = Math.max(0, index);
        this.checkRangeIntegrity(this.lowerRange.length, index + 1);
        double min = this.chart.getLowestValue(index);
        if (index == 0) {
            Enumeration e = this.targetsValue.elements();
            while (e.hasMoreElements()) {
                min = Math.min((Double)e.nextElement(), min);
            }
        }
        if (min < 0.0) {
            this.setLowerRange(index, min * Math.abs(range));
        } else {
            this.setLowerRange(index, 0.0);
        }
    }

    public void setLowerRelativeRange(double range, double step) {
        this.setLowerRelativeRange(0, range, step);
    }

    public void setLowerRelativeRange(int index, double range, double step) {
        index = Math.max(0, index);
        this.checkRangeIntegrity(this.lowerRange.length, index + 1);
        double min = this.chart.getLowestValue(index);
        if (index == 0) {
            Enumeration e = this.targetsValue.elements();
            while (e.hasMoreElements()) {
                min = Math.min((Double)e.nextElement(), min);
            }
        }
        if (min < 0.0) {
            step = Math.abs(step);
            double new_range = min * Math.abs(range);
            if (step % 1.0 == 0.0) {
                if (new_range % step == 0.0) {
                    this.setLowerRange(index, new_range);
                } else {
                    this.setLowerRange(index, new_range - new_range % step - step);
                }
            } else {
                double value;
                for (value = 0.0; value > new_range; value -= step) {
                }
                this.setLowerRange(index, value);
            }
        } else {
            this.setLowerRange(index, 0.0);
        }
    }

    public void setCurrentRange(int range, double upper) {
        this.checkRangeIntegrity(this.currentUpperRange.length, range + 1);
        if (this.upperRange[range] > this.lowerRange[range]) {
            upper = Math.min(this.upperRange[range], upper);
            upper = Math.max(this.currentLowerRange[range], upper);
        } else {
            upper = Math.max(this.upperRange[range], upper);
            upper = Math.min(this.currentLowerRange[range], upper);
        }
        this.currentUpperRange[range] = upper;
    }

    public double getCurrentRange(int range) {
        range = Math.min(this.currentUpperRange.length - 1, Math.max(0, range));
        return this.currentUpperRange[range];
    }

    public void setCurrentLowerRange(int range, double lower) {
        range = Math.max(0, range);
        this.checkRangeIntegrity(this.currentLowerRange.length, range + 1);
        if (this.upperRange[range] > this.lowerRange[range]) {
            lower = Math.max(this.lowerRange[range], lower);
            lower = Math.min(this.currentUpperRange[range], lower);
        } else {
            lower = Math.min(this.lowerRange[range], lower);
            lower = Math.max(this.currentUpperRange[range], lower);
        }
        this.currentLowerRange[range] = lower;
    }

    public double getCurrentLowerRange(int range) {
        range = Math.min(this.currentLowerRange.length - 1, Math.max(0, range));
        return this.currentLowerRange[range];
    }

    public void setRangeInterval(int range, double interval) {
        this.checkRangeIntegrity(this.rangeInterval.length, range + 1);
        this.rangeInterval[range] = interval;
    }

    public double getRangeInterval(int range) {
        range = Math.min(this.rangeInterval.length - 1, Math.max(0, range));
        return this.rangeInterval[range];
    }

    public void setRangeOn(int index, boolean on) {
        index = Math.max(0, index);
        this.checkRangeIntegrity(this.rangeOn.length, index + 1);
        this.rangeOn[index] = on;
    }

    public boolean isRangeOn(int index) {
        if (index < this.rangeOn.length) {
            return this.rangeOn[Math.max(0, index)];
        }
        return false;
    }

    public void setRangePosition(int index, int position) {
        index = Math.max(0, index);
        this.checkRangeIntegrity(this.rangePosition.length, index + 1);
        this.rangePosition[index] = Math.min(1, Math.max(0, position));
    }

    public int getRangePosition(int index) {
        return this.rangePosition[Math.min(this.rangePosition.length - 1, Math.max(0, index))];
    }

    public void setRangeColor(int index, Color color) {
        index = Math.max(0, index);
        this.checkRangeIntegrity(this.rangeColor.length, index + 1);
        this.rangeColor[index] = color;
    }

    public Color getRangeColor(int index) {
        return this.rangeColor[index = Math.min(this.rangeColor.length - 1, Math.max(0, index))] != null ? this.rangeColor[index] : this.chart.getChartForeground();
    }

    public void setRangeDecimalCount(int index, int count) {
        index = Math.max(0, index);
        this.checkRangeIntegrity(this.rangeDecimalCount.length, index + 1);
        this.rangeDecimalCount[index] = count;
    }

    public int getRangeDecimalCount(int index) {
        int decimals = this.rangeDecimalCount[index = Math.max(0, Math.min(this.rangeDecimalCount.length - 1, index))];
        if (decimals == -1) {
            double range_delta = this.getCurrentRange(index) - this.getCurrentLowerRange(index);
            decimals = 0;
            double result = range_delta;
            while (result < 10.0) {
                result = range_delta * Math.pow(10.0, ++decimals);
            }
        }
        decimals = Math.min(decimals, 18);
        return decimals;
    }

    public void setValueLinesOn(boolean on) {
        if (on != this.valueLinesOn) {
            this.valueLinesOn = on;
        }
    }

    public boolean isValueLinesOn() {
        return this.valueLinesOn;
    }

    public void setMaxValueLineCount(int count) {
        if (count != this.maxValueLineCount) {
            this.maxValueLineCount = count > -1 ? count : Integer.MAX_VALUE;
        }
    }

    public int getMaxValueLineCount() {
        if (this.maxValueLineCount != Integer.MAX_VALUE) {
            return this.maxValueLineCount;
        }
        return -1;
    }

    public void setDefaultGridLinesOn(boolean on) {
        this.setDefaultGridLinesOn(on, -1.0, -1.0);
    }

    public void setDefaultGridLinesOn(boolean on, double start, double step) {
        block6: {
            block7: {
                this.defaultGridLines = null;
                if (!on) break block6;
                if (start <= 0.0 && step > 0.0) {
                    start = step;
                }
                if (!(step <= 0.0)) break block7;
                int sampleCount = this.chart.getSampleCount();
                int lines_number = 0;
                if (this.chart.chartType.equals("bar")) {
                    lines_number = sampleCount - 1;
                } else if (this.chart.chartType.equals("line")) {
                    lines_number = sampleCount - 2;
                }
                if (lines_number < 0) break block6;
                double grid_step = (this.rightSampleAxisRange - this.leftSampleAxisRange) / (double)(lines_number + 1);
                this.defaultGridLines = new double[lines_number];
                for (int i = 0; i < this.defaultGridLines.length; ++i) {
                    this.defaultGridLines[i] = this.leftSampleAxisRange + grid_step * (double)(i + 1);
                }
                break block6;
            }
            int lines_number = (int)Math.ceil((this.rightSampleAxisRange - start) / step);
            this.defaultGridLines = new double[lines_number];
            for (int i = 0; i < this.defaultGridLines.length; ++i) {
                this.defaultGridLines[i] = start + step * (double)i;
            }
        }
    }

    public boolean isDefaultGridLinesOn() {
        return this.defaultGridLines != null;
    }

    public void setGridLines(double[] lines) {
        this.gridLines = lines;
    }

    public double[] getGridLines() {
        return this.gridLines;
    }

    public void setGridLine(int index, double value) {
        if (index >= this.maxGridLineCount || index < 0) {
            throw new IllegalArgumentException("Illegal vertical grid line index: " + index);
        }
        if (this.gridLines == null) {
            this.gridLines = new double[index + 1];
            for (int i = 0; i < this.gridLines.length; ++i) {
                this.gridLines[i] = -2.147483648E9;
            }
        }
        if (index >= this.gridLines.length) {
            double[] tmp_arr = new double[index + 1];
            System.arraycopy(this.gridLines, 0, tmp_arr, 0, this.gridLines.length);
            for (int i = this.gridLines.length; i < tmp_arr.length - 1; ++i) {
                tmp_arr[i] = -2.147483648E9;
            }
            this.gridLines = tmp_arr;
        }
        this.gridLines[index] = value;
    }

    public double getGridLine(int index) {
        if (this.gridLines == null || index >= this.gridLines.length) {
            return -2.147483648E9;
        }
        return this.gridLines[index];
    }

    public void setSampleAxisRange(double min, double max) {
        if (min >= max) {
            throw new IllegalArgumentException("Min is more or equal than max: " + min + ", " + max);
        }
        this.leftSampleAxisRange = min;
        this.rightSampleAxisRange = max;
    }

    public void setDefaultGridLinesColor(Color color) {
        this.defaultGridLinesColor = color;
        if (this.defaultGridLinesColor == null) {
            this.defaultGridLinesColor = Color.lightGray;
        }
    }

    public void setGridLinesColor(Color color) {
        if (this.gridLines != null) {
            Color[] colors = new Color[this.gridLines.length];
            for (int i = 0; i < this.gridLines.length; ++i) {
                colors[i] = color;
            }
            this.setGridLineColors(colors);
        }
    }

    public void setGridLineColors(Color[] colors) {
        this.gridLineColors = colors;
    }

    public Color[] getGridLineColors() {
        return this.gridLineColors;
    }

    public void setGridLineColor(int index, Color color) {
        if (index >= this.maxGridLineCount || index < 0) {
            throw new IllegalArgumentException("Illegal vertical grid line index: " + index);
        }
        if (this.gridLineColors == null) {
            this.gridLineColors = new Color[index + 1];
        }
        if (index >= this.gridLineColors.length) {
            Color[] tmp_arr = new Color[index + 1];
            System.arraycopy(this.gridLineColors, 0, tmp_arr, 0, this.gridLineColors.length);
            this.gridLineColors = tmp_arr;
        }
        this.gridLineColors[index] = color;
    }

    public Color getGridLineColor(int index) {
        if (this.gridLineColors == null || index >= this.gridLineColors.length) {
            return this.getValueLinesColor();
        }
        return this.gridLineColors[index];
    }

    public void setValueLinesColor(Color color) {
        this.valueLinesColor = color;
        if (this.valueLinesColor == null) {
            this.valueLinesColor = Color.lightGray;
        }
    }

    public Color getValueLinesColor() {
        return this.valueLinesColor;
    }

    public void setRangeLabelsOn(int index, boolean on) {
        if ((index = Math.max(-1, index)) == -1) {
            for (int i = 0; i < this.rangeLabelsOn.length; ++i) {
                this.rangeLabelsOn[index] = on;
            }
        } else {
            this.checkRangeIntegrity(this.rangeLabelsOn.length, index + 1);
            this.rangeLabelsOn[index] = on;
        }
    }

    public boolean isRangeLabelsOn(int index) {
        index = Math.min(this.rangeLabelsOn.length - 1, Math.max(0, index));
        return this.rangeLabelsOn[index];
    }

    public void setTargetValueLine(String id, double value, Color color, int style, int range) {
        if (color == null) {
            this.targetsLabel.remove(id);
            this.targetsValue.remove(id);
            this.targetsColor.remove(id);
            this.targetsStyle.remove(id);
            this.targetsRange.remove(id);
        } else {
            this.targetsLabel.put(id, id);
            this.targetsValue.put(id, new Double(value));
            this.targetsColor.put(id, color);
            this.targetsStyle.put(id, new Integer(style));
            this.targetsRange.put(id, new Integer(range));
        }
    }

    String getTargetLabel(String id) {
        String label = "";
        int style = (Integer)this.targetsStyle.get(id);
        int range = (Integer)this.targetsRange.get(id);
        double value = (Double)this.targetsValue.get(id);
        String number = ((Chart)this.chart).formatRangeNumber(0, value);
        String rangeLabelPrefix = this.chart.getLabel("rangeLabelPrefix");
        String rangeLabelPostfix = this.chart.getLabel("rangeLabelPostfix");
        if (rangeLabelPrefix != null) {
            number = rangeLabelPrefix + number;
        }
        if (rangeLabelPostfix != null) {
            number = number + rangeLabelPostfix;
        }
        switch (style) {
            case 0: {
                label = "";
                break;
            }
            case 1: {
                label = id;
                break;
            }
            case 2: {
                label = number;
                break;
            }
            case 3: {
                label = this.rangePosition[range] == 0 ? id + " " + number : number + " " + id;
            }
        }
        return label;
    }

    public double getTargetValueLine(String id) {
        if (this.targetsValue.get(id) != null) {
            return (Double)this.targetsValue.get(id);
        }
        return 0.0;
    }

    public void setTargetLabelsPosition(int position) {
        this.targetLabelsPosition = Math.min(1, Math.max(-1, position));
    }

    public int getTargetLabelsPosition() {
        return this.targetLabelsPosition;
    }

    public void setRangeAdjusterOn(int adjuster, boolean on) {
        adjuster = Math.min(this.rangeAdjusterOn.length - 1, Math.max(0, adjuster));
        this.rangeAdjusterOn[adjuster] = on;
        if (!on) {
            int rangeIndex = this.rangeAdjusted[adjuster];
            if (rangeIndex == -1) {
                for (int i = 0; i < this.rangeOn.length; ++i) {
                    this.setCurrentRange(i, this.getRange(i));
                    this.setCurrentLowerRange(i, this.getLowerRange(i));
                }
            } else {
                this.setCurrentRange(rangeIndex, this.getRange(rangeIndex));
                this.setCurrentLowerRange(rangeIndex, this.getLowerRange(rangeIndex));
            }
        }
    }

    public boolean isRangeAdjusterOn(int adjuster) {
        adjuster = Math.min(this.rangeAdjusterOn.length - 1, Math.max(0, adjuster));
        return this.rangeAdjusterOn[adjuster];
    }

    public void setRangeAdjusterPosition(int position) {
        this.rangeAdjusterPosition = Math.min(1, Math.max(0, position));
    }

    public int getRangeAdjusterPosition() {
        return this.rangeAdjusterPosition;
    }

    int getAdjusterPosition(int adjuster) {
        if (this.rangeOn.length <= 2 && adjuster == 0) {
            return this.rangeAdjusterPosition;
        }
        return this.rangePosition[adjuster];
    }

    public void setRangeAdjusted(int adjuster, int range) {
        adjuster = Math.min(this.rangeAdjusterOn.length - 1, Math.max(-1, adjuster));
        this.rangeAdjusted[adjuster] = range = Math.min(this.rangeAdjusterOn.length - 1, Math.max(-1, range));
    }

    public int getRangeAdjusted(int adjuster) {
        adjuster = Math.min(this.rangeAdjusterOn.length - 1, Math.max(0, adjuster));
        return this.rangeAdjusted[adjuster];
    }

    public void setSampleScrollerOn(boolean on) {
        if (on != this.sampleScrollerOn) {
            this.sampleScrollerOn = on;
        }
    }

    public boolean isSampleScrollerOn() {
        return this.sampleScrollerOn;
    }

    public void setRightToLeftScrollingOn(boolean state) {
        this.rightToLeftScrollingOn = state;
    }

    public boolean isRightToLeftScrollingOn() {
        return this.rightToLeftScrollingOn;
    }

    public void setGridAlignment(int alignment) {
        if (alignment != this.gridAlignment) {
            if (alignment == 0 || alignment == 1) {
                this.gridAlignment = alignment;
            } else {
                throw new IllegalArgumentException("Alignment must be HORIZONTAL or VERTICAL");
            }
        }
    }

    public int getGridAlignment() {
        return this.gridAlignment;
    }

    public void setGraphInsets(int top, int left, int bottom, int right) {
        this.graphInsets.top = top;
        this.graphInsets.left = left;
        this.graphInsets.bottom = bottom;
        this.graphInsets.right = right;
    }

    public Insets getGraphInsets() {
        if (this.graphInsets != null) {
            return this.graphInsets;
        }
        return new Insets(-1, -1, -1, -1);
    }

    public void setGridAdjustmentOn(int edge, boolean on) {
        if (edge >= 0 && edge < this.gridAdjustment.length) {
            this.gridAdjustment[edge] = on;
        }
    }

    public boolean isGridAdjustmentOn(int edge) {
        if (edge >= 0 && edge < this.gridAdjustment.length) {
            return this.gridAdjustment[edge];
        }
        return false;
    }

    public void setRangeFormatter(int index, NumberFormat formatter) {
        this.checkRangeIntegrity(this.rangeOn.length, index + 1);
        this.rangeFormatters[index] = formatter;
    }

    public NumberFormat getRangeFormatter(int index) {
        if (index >= 0 && index < this.rangeFormatters.length) {
            return this.rangeFormatters[index];
        }
        return null;
    }

    public String formatRangeNumber(int index, double value) {
        int decimals;
        NumberFormat formatter = this.getRangeFormatter(index);
        int n = decimals = value != 0.0 ? this.getRangeDecimalCount(index) : 0;
        if (formatter != null) {
            formatter.setMaximumFractionDigits(decimals);
            formatter.setMinimumFractionDigits(decimals);
            StringBuffer sb = formatter.format(value, new StringBuffer(), new FieldPosition(1));
            if (sb != null) {
                return sb.toString();
            }
        }
        return null;
    }

    private void checkRangeIntegrity(int length, int newLength) {
        if (newLength > length) {
            boolean[] newRangeOn = new boolean[newLength];
            System.arraycopy(this.rangeOn, 0, newRangeOn, 0, this.rangeOn.length);
            this.rangeOn = newRangeOn;
            int[] newRangePosition = new int[newLength];
            System.arraycopy(this.rangePosition, 0, newRangePosition, 0, this.rangePosition.length);
            this.rangePosition = newRangePosition;
            if (length == 1) {
                this.rangePosition[1] = 1;
            }
            double[] newUpperRange = new double[newLength];
            System.arraycopy(this.upperRange, 0, newUpperRange, 0, this.upperRange.length);
            for (int i = this.upperRange.length; i < newUpperRange.length; ++i) {
                newUpperRange[i] = 100.0;
            }
            this.upperRange = newUpperRange;
            double[] newLowerRange = new double[newLength];
            System.arraycopy(this.lowerRange, 0, newLowerRange, 0, this.lowerRange.length);
            this.lowerRange = newLowerRange;
            double[] newCurrentUpperRange = new double[newLength];
            System.arraycopy(this.currentUpperRange, 0, newCurrentUpperRange, 0, this.currentUpperRange.length);
            for (int i = this.currentUpperRange.length; i < newCurrentUpperRange.length; ++i) {
                newCurrentUpperRange[i] = 100.0;
            }
            this.currentUpperRange = newCurrentUpperRange;
            double[] newCurrentLowerRange = new double[newLength];
            System.arraycopy(this.currentLowerRange, 0, newCurrentLowerRange, 0, this.currentLowerRange.length);
            this.currentLowerRange = newCurrentLowerRange;
            double[] newRangeInterval = new double[newLength];
            System.arraycopy(this.rangeInterval, 0, newRangeInterval, 0, this.rangeInterval.length);
            this.rangeInterval = newRangeInterval;
            int[] newRangeDecimalCount = new int[newLength];
            System.arraycopy(this.rangeDecimalCount, 0, newRangeDecimalCount, 0, this.rangeDecimalCount.length);
            this.rangeDecimalCount = newRangeDecimalCount;
            boolean[] newRangeAdjusterOn = new boolean[newLength];
            System.arraycopy(this.rangeAdjusterOn, 0, newRangeAdjusterOn, 0, this.rangeAdjusterOn.length);
            this.rangeAdjusterOn = newRangeAdjusterOn;
            int[] newRangeAdjusted = new int[newLength];
            System.arraycopy(this.rangeAdjusted, 0, newRangeAdjusted, 0, this.rangeAdjusted.length);
            for (int i = this.rangeAdjusted.length; i < newRangeAdjusted.length; ++i) {
                newRangeAdjusted[i] = i;
            }
            this.rangeAdjusted = newRangeAdjusted;
            Color[] newRangeColor = new Color[newLength];
            System.arraycopy(this.rangeColor, 0, newRangeColor, 0, this.rangeColor.length);
            this.rangeColor = newRangeColor;
            boolean[] newRangeLabelsOn = new boolean[newLength];
            System.arraycopy(this.rangeLabelsOn, 0, newRangeLabelsOn, 0, this.rangeLabelsOn.length);
            for (int i = this.rangeLabelsOn.length; i < newRangeLabelsOn.length; ++i) {
                newRangeLabelsOn[i] = true;
            }
            this.rangeLabelsOn = newRangeLabelsOn;
            NumberFormat[] newRangeFormatters = new NumberFormat[newLength];
            System.arraycopy(this.rangeFormatters, 0, newRangeFormatters, 0, this.rangeFormatters.length);
            this.rangeFormatters = newRangeFormatters;
        }
    }

    int getValuePosition(int index, double value, Rectangle gridBounds) {
        int zero_line;
        index = Math.min(this.upperRange.length - 1, Math.max(0, index));
        int positive_space = 0;
        if (this.gridAlignment == 1) {
            if (this.currentUpperRange[index] - this.currentLowerRange[index] != 0.0) {
                positive_space = (int)((double)gridBounds.height * (this.currentUpperRange[index] / (this.currentUpperRange[index] - this.currentLowerRange[index])));
            }
            zero_line = gridBounds.y + positive_space;
        } else {
            if (this.currentUpperRange[index] - this.currentLowerRange[index] != 0.0) {
                positive_space = (int)((double)gridBounds.width * (this.currentUpperRange[index] / (this.currentUpperRange[index] - this.currentLowerRange[index])));
            }
            zero_line = gridBounds.x + gridBounds.width - positive_space;
        }
        int pos = 0;
        if (this.currentUpperRange[index] - this.currentLowerRange[index] != 0.0) {
            pos = this.gridAlignment == 1 ? (int)((double)zero_line - (double)gridBounds.height * (value / (this.currentUpperRange[index] - this.currentLowerRange[index]))) : (int)((double)zero_line + (double)gridBounds.width * (value / (this.currentUpperRange[index] - this.currentLowerRange[index])));
        }
        return pos;
    }
}

