/*
 * Decompiled with CFR 0.152.
 */
package net.autotask.atws.v1_5;

import com.eg.EgDateInfo;
import com.eg.EgInstallInfo;
import com.eg.EgUtils;
import com.eg.IniFile;
import egurkha.reporter.ErUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import net.autotask.atws.v1_5.ATWS;
import net.autotask.atws.v1_5.ATWSError;
import net.autotask.atws.v1_5.ATWSResponse;
import net.autotask.atws.v1_5.ATWSSoap;
import net.autotask.atws.v1_5.Account;
import net.autotask.atws.v1_5.ArrayOfEntity;
import net.autotask.atws.v1_5.Entity;
import net.autotask.atws.v1_5.Ticket;

public class AutoTaskIntegrator {
    private static URL WSDL_LOCATION = null;
    private static QName ServiceName = null;
    private long AccountDiscoverPeriod = 900000L;
    private IniFile servicesIni = null;
    public String fileSeparator = System.getProperty("file.separator");
    private Hashtable accountMap = new Hashtable();
    private long lastQueryUpdateTime = 0L;
    private static String syncFlag = new String();
    private boolean isAccountDetailsCached = false;
    private long lastServicesIniCheckTime = 0L;
    public static long lastModifiedTime;
    private static long lastSize;
    private File servicesIniFile = null;
    private String servicesIniFileName = EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini";
    private String defaultAccount = null;
    private String ticketType = null;
    private String workType = null;
    private String queueId = null;
    private String criticalDueDate_Period = null;
    private String majorDueDate_Period = null;
    private String minorDueDate_Period = null;
    private boolean isAppendLog = false;
    private PrintWriter pw = null;
    private boolean logEnabled = false;
    private String title_Format = "";
    private String logMaxSize = "";
    private String logMaxFiles = "";

    public AutoTaskIntegrator(String string, String string2, String string3) {
        try {
            this.servicesIniFile = new File(this.servicesIniFileName);
            this.servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini", true);
            lastModifiedTime = this.lastModified();
            lastSize = this.lastSize();
            String string4 = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "AccountDiscoverPeriod");
            if (string4 != null && !string4.equals("")) {
                this.AccountDiscoverPeriod = Long.parseLong(string4);
            }
            this.defaultAccount = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "DefaultAccount");
            this.ticketType = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "TicketType");
            this.workType = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "WorkType");
            this.queueId = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "QueueId");
            this.criticalDueDate_Period = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "Critical_DueDate_Period");
            this.majorDueDate_Period = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "Major_DueDate_Period");
            this.minorDueDate_Period = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "Minor_DueDate_Period");
            this.title_Format = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "Ticket_Title_Format");
            this.logMaxSize = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "logMaxSize");
            this.logMaxFiles = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "logMaxFiles");
            String string5 = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "EnableLogging");
            if (string5 != null && string5.equalsIgnoreCase("true")) {
                this.logEnabled = true;
            }
            WSDL_LOCATION = new URL(string);
            final String string6 = string2;
            final String string7 = string3;
            Authenticator authenticator = new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(string6, string7.toCharArray());
                }
            };
            Authenticator.setDefault(authenticator);
            System.setProperty("com.sun.xml.ws.transport.http.client.HttpTransportPipe.dump", "true");
            this.initAutoTaskLog();
            this.getRecentAccountDetails();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public AutoTaskIntegrator(String string, String string2, String string3, String string4) {
        try {
            this.servicesIniFile = new File(this.servicesIniFileName);
            this.servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini", true);
            lastModifiedTime = this.lastModified();
            lastSize = this.lastSize();
            String string5 = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "AccountDiscoverPeriod");
            if (string5 != null && !string5.equals("")) {
                this.AccountDiscoverPeriod = Long.parseLong(string5);
            }
            this.defaultAccount = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "DefaultAccount");
            this.ticketType = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "TicketType");
            this.workType = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "WorkType");
            this.queueId = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "QueueId");
            this.criticalDueDate_Period = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "Critical_DueDate_Period");
            this.majorDueDate_Period = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "Major_DueDate_Period");
            this.minorDueDate_Period = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "Minor_DueDate_Period");
            this.title_Format = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "Ticket_Title_Format");
            this.logMaxSize = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "logMaxSize");
            this.logMaxFiles = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "logMaxFiles");
            String string6 = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "EnableLogging");
            if (string6 != null && string6.equalsIgnoreCase("true")) {
                this.logEnabled = true;
            }
            WSDL_LOCATION = new URL(string);
            ServiceName = new QName(string2);
            final String string7 = string3;
            final String string8 = string4;
            Authenticator authenticator = new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(string7, string8.toCharArray());
                }
            };
            Authenticator.setDefault(authenticator);
            System.setProperty("com.sun.xml.ws.transport.http.client.HttpTransportPipe.dump", "true");
            this.initAutoTaskLog();
            this.getRecentAccountDetails();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public long lastModified() {
        return this.servicesIniFile.lastModified();
    }

    public long lastSize() {
        return this.servicesIniFile.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForUpdate() {
        long l = this.lastModified();
        long l2 = this.lastSize();
        if (l == lastModifiedTime && lastSize == l2) {
            this.lastServicesIniCheckTime = System.currentTimeMillis();
            return false;
        }
        String string = syncFlag;
        synchronized (string) {
            this.lastServicesIniCheckTime = System.currentTimeMillis();
            l = this.lastModified();
            l2 = this.lastSize();
            if (l == lastModifiedTime && lastSize == l2) {
                return false;
            }
            this.servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini", true);
            String string2 = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "AccountDiscoverPeriod");
            if (string2 != null && !string2.equals("")) {
                this.AccountDiscoverPeriod = Long.parseLong(string2);
            }
            this.defaultAccount = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "DefaultAccount");
            this.ticketType = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "TicketType");
            this.workType = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "WorkType");
            this.queueId = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "QueueId");
            this.criticalDueDate_Period = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "Critical_DueDate_Period");
            this.majorDueDate_Period = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "Major_DueDate_Period");
            this.minorDueDate_Period = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "Minor_DueDate_Period");
            this.title_Format = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "Ticket_Title_Format");
            this.logMaxSize = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "logMaxSize");
            this.logMaxFiles = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "logMaxFiles");
            String string3 = this.servicesIni.getValue("AUTOTASK_TT_INTEGRATION", "EnableLogging");
            if (string3 != null && string3.equalsIgnoreCase("true")) {
                this.logEnabled = true;
            }
            return true;
        }
    }

    public String createTicket(Object[] objectArray) {
        this.getRecentAccountDetails();
        Ticket ticket = null;
        ATWSResponse aTWSResponse = null;
        int n = -1;
        String string = "-1";
        try {
            if (objectArray != null && objectArray.length > 0) {
                Object object;
                String string2 = (String)objectArray[1];
                String string3 = "";
                if (string2 == null || string2.equals("") || string2.equalsIgnoreCase("null") || string2.equalsIgnoreCase("default")) {
                    string3 = this.defaultAccount;
                } else if (this.accountMap != null && this.accountMap.containsKey(string2)) {
                    string3 = (String)this.accountMap.get(string2);
                }
                if (string3 == null || string3.equals("") || string3.equalsIgnoreCase("null")) {
                    string3 = this.defaultAccount;
                }
                if (string3 != null && string3.indexOf("$@$") > 0 && (object = EgUtils.getTokens((String)string3, (String)"$@$")) != null && ((String[])object).length == 2) {
                    string3 = object[1];
                }
                if (string3 != null && string3.length() > 0 && !string3.equalsIgnoreCase("null")) {
                    Object object2;
                    object = this.title_Format;
                    String string4 = (String)objectArray[0];
                    String string5 = (String)objectArray[2];
                    String string6 = (String)objectArray[3];
                    String string7 = (String)objectArray[4];
                    String string8 = (String)objectArray[5];
                    String string9 = (String)objectArray[6];
                    if (object != null && !((String)object).equals("")) {
                        object = this.replace((String)object, "$cname", string7);
                        object = this.replace((String)object, "$ctype", string6);
                        object = this.replace((String)object, "$prior", string4);
                        object = this.replace((String)object, "$pdesc", string9);
                        object = this.replace((String)object, "$Service", string5);
                        object = this.replace((String)object, "$layer", string8);
                    } else {
                        object = string9;
                    }
                    if (object != null && ((String)object).length() > 255) {
                        object = ((String)object).substring(0, 254);
                    }
                    ticket = new Ticket();
                    ticket.setAccountID(string3);
                    ticket.setTitle(object);
                    ticket.setDescription(string9);
                    ticket.setStatus("1");
                    ticket.setTicketType(this.ticketType);
                    if (string4 != null && string4.equalsIgnoreCase("Critical")) {
                        ticket.setPriority("4");
                        object2 = this.calculateDueDateTime(this.criticalDueDate_Period);
                        ticket.setDueDateTime(object2);
                    } else if (string4 != null && string4.equalsIgnoreCase("Major")) {
                        object2 = this.calculateDueDateTime(this.majorDueDate_Period);
                        ticket.setDueDateTime(object2);
                        ticket.setPriority("1");
                    } else if (string4 != null && string4.equalsIgnoreCase("Minor")) {
                        object2 = this.calculateDueDateTime(this.minorDueDate_Period);
                        ticket.setDueDateTime(object2);
                        ticket.setPriority("2");
                    }
                    ticket.setAllocationCodeID(this.workType);
                    ticket.setQueueID(this.queueId);
                    object2 = new ArrayList();
                    object2.add(ticket);
                    ArrayOfEntity arrayOfEntity = new ArrayOfEntity();
                    arrayOfEntity.entity = object2;
                    aTWSResponse = AutoTaskIntegrator.create(arrayOfEntity);
                    n = aTWSResponse.getReturnCode();
                    if (n == 1) {
                        List<Entity> list = aTWSResponse.getEntityResults().getEntity();
                        Ticket ticket2 = (Ticket)list.get(0);
                        if (ticket2 != null) {
                            string = (String)ticket2.getTicketNumber() + "#" + ticket2.getId();
                        }
                        this.sop("INFO : Ticket has been created successfully. Details-> Ticket Number : " + ticket2.getTicketNumber() + " Ticket ID : " + ticket2.getId() + " AccountId : " + string3 + " Priority : " + string4 + " Component Type : " + string6 + " Component name : " + string7 + " Layer : " + string8 + " Problem Description : " + string9);
                    } else {
                        List<ATWSError> list = aTWSResponse.getErrors().getATWSError();
                        ATWSError aTWSError = list.get(0);
                        this.sop("ERROR : Failed while creating ticket.." + aTWSError.getMessage() + " Details-> AccountId : " + string3 + " Priority : " + string4 + " Component Type : " + string6 + " Component name : " + string7 + " Layer : " + string8 + " Problem Description : " + string9);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private void getRecentAccountDetails() {
        long l = System.currentTimeMillis();
        if (l - this.lastQueryUpdateTime >= this.AccountDiscoverPeriod) {
            this.QueryAccountsDetails();
            this.lastQueryUpdateTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void QueryAccountsDetails() {
        this.discoverAccountsDetails();
        try {
            String string = syncFlag;
            synchronized (string) {
                String[] stringArray = this.servicesIni.getVariables("AutoTask_Account_Mapping");
                if (stringArray != null && stringArray.length > 0) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string2 = this.servicesIni.getValue("AutoTask_Account_Mapping", stringArray[i]);
                        if (string2 == null || string2.equals("") || string2.equalsIgnoreCase("null")) continue;
                        if (string2 != null && string2.indexOf(",") > -1) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                            while (stringTokenizer.hasMoreTokens()) {
                                String string3 = stringTokenizer.nextToken();
                                this.accountMap.put(string3, stringArray[i]);
                            }
                            continue;
                        }
                        this.accountMap.put(string2, stringArray[i]);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverAccountsDetails() {
        block9: {
            this.checkForUpdate();
            try {
                ATWSResponse aTWSResponse;
                List<Entity> list;
                HashSet<String> hashSet = new HashSet<String>();
                String[] stringArray = this.servicesIni.getVariables("AutoTask_Account_Mapping");
                if (stringArray != null && stringArray.length > 0) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        hashSet.add(stringArray[i]);
                    }
                }
                if ((list = (aTWSResponse = AutoTaskIntegrator.query("<queryxml><entity>Account</entity><query><field>Active<expression op=\"equals\">1</expression></field></query></queryxml>")).getEntityResults().getEntity()) != null && list.size() > 0) {
                    Iterator<Entity> iterator = list.iterator();
                    String string = syncFlag;
                    synchronized (string) {
                        while (iterator.hasNext()) {
                            Account account = (Account)iterator.next();
                            String string2 = (String)account.getAccountName();
                            String string3 = String.valueOf(account.getId());
                            String string4 = string2 + "$@$" + string3;
                            if (hashSet.contains(string4)) continue;
                            this.servicesIni.setValue("AutoTask_Account_Mapping", string4, "");
                        }
                        this.servicesIni.saveFile(true);
                    }
                    this.sop("INFO : Auto Task User Accounts has been Discovered.No of Discovered User accounts is " + list.size());
                    break block9;
                }
                this.sop("ERROR : Failed to discover Auto Task User Accounts ");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public int updateTicket(String string, Object[] objectArray) {
        this.getRecentAccountDetails();
        ATWSResponse aTWSResponse = null;
        int n = -1;
        if (objectArray != null && objectArray.length > 0 && string != null && string.length() > 0 && !string.equalsIgnoreCase("null")) {
            try {
                if (objectArray != null && objectArray.length > 0) {
                    Object object;
                    boolean bl = false;
                    String string2 = (String)objectArray[0];
                    if (string2.equalsIgnoreCase("normal")) {
                        bl = true;
                    }
                    String string3 = string;
                    if (string != null && string.indexOf("#") > 0) {
                        string3 = string.substring(0, string.indexOf("#"));
                        string = string.substring(string.indexOf("#") + 1);
                    }
                    ATWSResponse aTWSResponse2 = AutoTaskIntegrator.query(" <queryxml><entity>Ticket</entity> <query> <field>TicketNumber <expression op=\"equals\">" + string3 + "</expression></field></query> </queryxml> ");
                    ArrayOfEntity arrayOfEntity = aTWSResponse2.getEntityResults();
                    List<Entity> list = arrayOfEntity.getEntity();
                    Ticket ticket = (Ticket)list.get(0);
                    String string4 = this.title_Format;
                    String string5 = (String)objectArray[2];
                    String string6 = (String)objectArray[3];
                    String string7 = (String)objectArray[4];
                    String string8 = (String)objectArray[5];
                    String string9 = (String)objectArray[6];
                    if (string4 != null && !string4.equals("")) {
                        string4 = this.replace(string4, "$cname", string7);
                        string4 = this.replace(string4, "$ctype", string6);
                        string4 = this.replace(string4, "$prior", string2);
                        string4 = this.replace(string4, "$pdesc", string9);
                        string4 = this.replace(string4, "$Service", string5);
                        string4 = this.replace(string4, "$layer", string8);
                    } else {
                        string4 = string9;
                    }
                    if (string4 != null && string4.length() > 255) {
                        string4 = string4.substring(0, 254);
                    }
                    if (bl) {
                        ticket.setStatus("5");
                        ticket.setTitle(string4);
                        ticket.setDescription(string9);
                        ticket.setId(ticket.getId());
                    } else {
                        if (string2 != null && string2.equalsIgnoreCase("Critical")) {
                            ticket.setPriority("4");
                            object = this.calculateDueDateTime(this.criticalDueDate_Period);
                            ticket.setDueDateTime(object);
                        } else if (string2 != null && string2.equalsIgnoreCase("Major")) {
                            object = this.calculateDueDateTime(this.majorDueDate_Period);
                            ticket.setDueDateTime(object);
                            ticket.setPriority("1");
                        } else if (string2 != null && string2.equalsIgnoreCase("Minor")) {
                            object = this.calculateDueDateTime(this.minorDueDate_Period);
                            ticket.setDueDateTime(object);
                            ticket.setPriority("2");
                        }
                        ticket.setDescription(string6 + ":" + string7 + ":" + string8 + ":" + string2 + ":" + string9);
                        ticket.setTitle(string4);
                        ticket.setId(ticket.getId());
                    }
                    arrayOfEntity.getEntity().remove(0);
                    arrayOfEntity.getEntity().add(ticket);
                    aTWSResponse = AutoTaskIntegrator.update(arrayOfEntity);
                    n = aTWSResponse.getReturnCode();
                    if (n == -1) {
                        object = aTWSResponse.getErrors().getATWSError();
                        ATWSError aTWSError = (ATWSError)object.get(0);
                        this.sop("ERROR : Failed to update Ticket.." + aTWSError.getMessage() + " Details-> TicketNumber : " + string3 + " Ticket ID : " + string + " AccountID : " + ticket.getAccountID() + " Priority : " + string2 + " Component Type : " + string6 + " Component name : " + string7 + " Layer : " + string8 + " Problem Description : " + string9);
                    } else {
                        this.sop("INFO : Ticket has been updated successfully. Details-> TicketNumber : " + string3 + " Ticket ID : " + string + " AccountID : " + ticket.getAccountID() + " Priority : " + string2 + " Component Type : " + string6 + " Component name : " + string7 + " Layer : " + string8 + " Problem Description : " + string9);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    private static ATWSResponse update(ArrayOfEntity arrayOfEntity) {
        ATWS aTWS = null;
        aTWS = ServiceName != null ? new ATWS(WSDL_LOCATION, ServiceName) : new ATWS(WSDL_LOCATION);
        ATWSSoap aTWSSoap = aTWS.getATWSSoap();
        return aTWSSoap.update(arrayOfEntity);
    }

    private static ATWSResponse query(String string) {
        ATWS aTWS = null;
        aTWS = ServiceName != null ? new ATWS(WSDL_LOCATION, ServiceName) : new ATWS(WSDL_LOCATION);
        ATWSSoap aTWSSoap = aTWS.getATWSSoap();
        return aTWSSoap.query(string);
    }

    private static ATWSResponse create(ArrayOfEntity arrayOfEntity) {
        ATWS aTWS = null;
        aTWS = ServiceName != null ? new ATWS(WSDL_LOCATION, ServiceName) : new ATWS(WSDL_LOCATION);
        ATWSSoap aTWSSoap = aTWS.getATWSSoap();
        return aTWSSoap.create(arrayOfEntity);
    }

    public String calculateDueDateTime(String string) {
        String string2 = null;
        try {
            EgDateInfo egDateInfo = new EgDateInfo();
            long l = 3600000L;
            int n = string.indexOf(" ");
            String string3 = "00";
            int n2 = 0;
            String string4 = "h";
            if (n > 0) {
                n2 = Integer.parseInt(string.substring(0, n));
                string4 = string.substring(n + 1).toLowerCase();
                string4 = string4.toLowerCase();
            } else {
                n2 = Integer.parseInt(string);
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm");
            Date date = new Date(egDateInfo.egetRealDate().getTime());
            Date date2 = new Date();
            if (string4.startsWith("h")) {
                Date date3 = new Date();
                long l2 = date.getTime() + l * (long)n2;
                date2.setTime(l2);
            } else if (string4.startsWith("d")) {
                date2.setTime(date.getTime() + (long)(n2 * 24) * l);
            } else if (string4.startsWith("w")) {
                date2.setTime(date.getTime() + (long)(n2 * 168) * l);
            } else if (string4.startsWith("mo")) {
                Date date4 = egDateInfo.egetRealDate();
                String string5 = simpleDateFormat.format(date4);
                n2 = ErUtils.getTotalDays((String)string5, (long)n2) * 24;
                date2.setTime(date.getTime() + (long)n2 * l);
            }
            string2 = simpleDateFormat.format(date2);
        }
        catch (Exception exception) {
            this.sop("ERROR : Exception in calculateTime() in EgTimelineBean.java " + exception);
            exception.printStackTrace();
        }
        return string2;
    }

    public String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        while (string.indexOf(string2) > -1) {
            stringBuffer.append(string.substring(0, string.indexOf(string2)) + string3);
            string = string.substring(string.indexOf(string2) + string2.length(), string.length());
        }
        if (string.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private void initAutoTaskLog() {
        try {
            if (this.pw == null) {
                this.pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(EgInstallInfo.getInstallDir() + "/manager/logs/AutoTask_log", false), "UTF-8"), true);
            }
            this.logEnabled = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void StopAutoTaskLog() {
        try {
            this.logEnabled = false;
            if (this.pw != null) {
                this.pw.flush();
            }
            this.pw.close();
            this.pw = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sop(String string) {
        if (this.pw != null) {
            this.checkRollLog();
            String string2 = new Date().toString();
            this.pw.println(string2 + " -> " + string);
            this.pw.flush();
        }
    }

    public void checkRollLog() {
        String string = "10";
        int n = 100000;
        String string2 = this.logMaxSize;
        if (string2 == null || string2.length() == 0) {
            string2 = "2";
        }
        double d = 2097152.0;
        try {
            d = Double.parseDouble(string2);
            d = d * 1024.0 * 1024.0;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Invalid AutoTaskLogMaxRollSize entry in service file. continue with maximum size 2 MB  ");
            d = 2097152.0;
        }
        File file = new File(EgInstallInfo.getInstallDir() + "/manager/logs/AutoTask_log");
        if (file.exists() && (double)file.length() >= d) {
            int n2 = 0;
            string = this.logMaxFiles;
            if (string == null || string.trim().length() == 0) {
                string = "0";
            }
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Invalid entry in services file AutoTask_LOG_MAX_FILES Entry ... Continuing with Max file entry to 10");
                n2 = 0;
            }
            if (n2 == 0) {
                return;
            }
            int n3 = n2;
            int n4 = this.findLastFileNumber();
            n3 = n4 < n2 ? n4 : n2 - 1;
            int n5 = 0;
            for (n5 = n3; n5 > 0; --n5) {
                EgInstallInfo.fileRename((String)(EgInstallInfo.getInstallDir() + "/manager/logs/AutoTask_log." + n5), (String)(EgInstallInfo.getInstallDir() + "/manager/logs/AutoTask_log." + (n5 + 1)));
            }
            if (n5 == 0) {
                EgInstallInfo.fileRename((String)(EgInstallInfo.getInstallDir() + "/manager/logs/AutoTask_log"), (String)(EgInstallInfo.getInstallDir() + "/manager/logs/AutoTask_log.1"));
            }
            this.StopAutoTaskLog();
            if (file.exists()) {
                this.createEmptyFile(file.getAbsolutePath());
                file.delete();
            }
            this.initAutoTaskLog();
        }
        file = null;
    }

    private int findLastFileNumber() {
        int n = 0;
        int n2 = 0;
        try {
            File file = new File(EgInstallInfo.getInstallDir() + "/manager/logs");
            if (file == null || !file.exists()) {
                return 0;
            }
            File[] fileArray = file.listFiles();
            if (fileArray == null || fileArray.length <= 0) {
                return 0;
            }
            int n3 = fileArray.length;
            for (int i = 0; i < n3; ++i) {
                String string;
                if (fileArray[i].isDirectory() || !(string = fileArray[i].getName()).startsWith("AutoTask_log") || string.lastIndexOf(".") < 0) continue;
                string = string.substring(string.lastIndexOf(".") + 1);
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    fileArray[i] = null;
                    continue;
                }
                if (n < n2) {
                    n = n2;
                }
                fileArray[i] = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    private void createEmptyFile(String string) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter(new FileWriter(string));
        }
        catch (Exception exception) {
            System.err.println("Cannot open log file ");
            return;
        }
        printWriter.close();
    }

    public static void main(String[] stringArray) {
        AutoTaskIntegrator autoTaskIntegrator = new AutoTaskIntegrator("https://webservices2.autotask.net/atservices/1.5/atws.wsdl", "ppierce@eginnovationsdemo.com", "12345");
        Object[] objectArray = new Object[]{"Major", "zone1", "8", "Test", "Test", "Test", "Test", new HashSet(), "03/03/2014 23:03"};
        System.out.println("Calling create Ticket and ID is ----> " + autoTaskIntegrator.updateTicket("T20140303.0147#8723", objectArray));
    }
}

