/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.net.server;

import com.eg.ch.qos.logback.core.net.server.Client;
import com.eg.ch.qos.logback.core.net.server.ClientVisitor;
import com.eg.ch.qos.logback.core.net.server.ServerListener;
import com.eg.ch.qos.logback.core.net.server.ServerRunner;
import com.eg.ch.qos.logback.core.spi.ContextAwareBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConcurrentServerRunner<T extends Client>
extends ContextAwareBase
implements Runnable,
ServerRunner<T> {
    private final Lock clientsLock = new ReentrantLock();
    private final Collection<T> clients = new ArrayList<T>();
    private final ServerListener<T> listener;
    private final Executor executor;
    private boolean running;

    public ConcurrentServerRunner(ServerListener<T> serverListener, Executor executor) {
        this.listener = serverListener;
        this.executor = executor;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    protected void setRunning(boolean bl2) {
        this.running = bl2;
    }

    @Override
    public void stop() throws IOException {
        this.listener.close();
        this.accept(new ClientVisitor<T>(){

            @Override
            public void visit(T t2) {
                t2.close();
            }
        });
    }

    @Override
    public void accept(ClientVisitor<T> clientVisitor) {
        Collection<T> collection = this.copyClients();
        for (Client client : collection) {
            try {
                clientVisitor.visit(client);
            }
            catch (RuntimeException runtimeException) {
                this.addError(client + ": " + runtimeException);
            }
        }
    }

    private Collection<T> copyClients() {
        this.clientsLock.lock();
        try {
            ArrayList<T> arrayList;
            ArrayList<T> arrayList2 = arrayList = new ArrayList<T>(this.clients);
            return arrayList2;
        }
        finally {
            this.clientsLock.unlock();
        }
    }

    @Override
    public void run() {
        this.setRunning(true);
        try {
            this.addInfo("listening on " + this.listener);
            while (!Thread.currentThread().isInterrupted()) {
                T t2 = this.listener.acceptClient();
                if (!this.configureClient(t2)) {
                    this.addError(t2 + ": connection dropped");
                    t2.close();
                    continue;
                }
                try {
                    this.executor.execute(new ClientWrapper(this, t2));
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    this.addError(t2 + ": connection dropped");
                    t2.close();
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            this.addError("listener: " + exception);
        }
        this.setRunning(false);
        this.addInfo("shutting down");
        this.listener.close();
    }

    protected abstract boolean configureClient(T var1);

    private void addClient(T t2) {
        this.clientsLock.lock();
        try {
            this.clients.add(t2);
        }
        finally {
            this.clientsLock.unlock();
        }
    }

    private void removeClient(T t2) {
        this.clientsLock.lock();
        try {
            this.clients.remove(t2);
        }
        finally {
            this.clientsLock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClientWrapper
    implements Client {
        private final T delegate;
        final /* synthetic */ ConcurrentServerRunner this$0;

        public ClientWrapper(T t2) {
            this.this$0 = var1_1;
            this.delegate = t2;
        }

        @Override
        public void run() {
            this.this$0.addClient(this.delegate);
            try {
                this.delegate.run();
            }
            finally {
                this.this$0.removeClient(this.delegate);
            }
        }

        @Override
        public void close() {
            this.delegate.close();
        }
    }
}

