/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.utils;

import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbc2.utils.Queue;
import com.sybase.jdbc2.utils.SyncObj;

public class SyncQueue {
    public static final int NEED = 10;
    public static final int WAITING = 11;
    public static final int SATISFIED = 12;
    public static final int OWNER = 13;
    public static final int TIMEOUT = 14;
    private Queue _waitList;
    private SyncObj _owner = null;

    public SyncQueue() {
        this._waitList = new Queue();
    }

    public SyncQueue(int size, int incr) {
        this._waitList = new Queue(size, incr);
    }

    public SyncObj dump() {
        return this._owner;
    }

    protected synchronized SyncObj getOwner() {
        return this._owner;
    }

    protected void release(SyncObj obj) {
        SyncObj syncObj = obj;
        synchronized (syncObj) {
            switch (obj._state) {
                case 10: {
                    obj._state = 12;
                    break;
                }
                case 11: {
                    obj._state = 12;
                    this._waitList.removeElement(obj);
                    obj.notify();
                }
            }
        }
    }

    protected synchronized void releaseNext(SyncObj o) {
        if (o != this._owner) {
            return;
        }
        this._owner = null;
        SyncObj syncObj = o;
        synchronized (syncObj) {
            o._state = 10;
        }
        SyncObj obj = null;
        while ((obj = (SyncObj)this._waitList.popNoEx()) != null) {
            SyncObj syncObj2 = obj;
            synchronized (syncObj2) {
                if (obj._state == 11) {
                    obj._state = 13;
                    this._owner = obj;
                    obj.notify();
                    Object var4_4 = null;
                    return;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int take(long timeout, SyncObj obj) {
        if (obj == this._owner) {
            return obj._state;
        }
        SyncObj syncObj = obj;
        synchronized (syncObj) {
            if (obj._state != 10) {
                return obj._state;
            }
            SyncQueue syncQueue = this;
            synchronized (syncQueue) {
                if (this._owner == null) {
                    this._owner = obj;
                    obj._state = 13;
                    return 13;
                }
                obj._state = 11;
                this._waitList.push(obj);
            }
            try {
                obj.wait(timeout);
            }
            catch (InterruptedException ie) {
                Debug.println(this, "Interrupted: " + ie);
            }
            if (obj._state != 11) return obj._state;
            this._waitList.removeElement(obj);
            obj._state = 14;
            return obj._state;
        }
    }
}

