/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.utils;

import com.sybase.jdbc2.utils.Debug;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;

public class Queue {
    private Object[] _list = null;
    private int _head = -1;
    private int _tail = -1;
    private int _size = 0;
    private int _incr = 0;
    private int _iter = -1;

    public Queue() {
        this.init(1, 0);
    }

    public Queue(int size) {
        this.init(size, size);
    }

    public Queue(int size, int incr) {
        this.init(size, incr);
    }

    public boolean empty() {
        return this._head == -1;
    }

    private void expand() {
        int incr = this._incr == 0 ? this._size : this._incr;
        Object[] newList = new Object[this._size + incr];
        int idx = 0;
        int i = this._head;
        while (i < this._size) {
            newList[idx++] = this._list[i];
            ++i;
        }
        this._head = 0;
        int i2 = 0;
        while (i2 < this._tail) {
            newList[idx++] = this._list[i2];
            ++i2;
        }
        this._list = newList;
        this._tail = this._size;
        this._size += incr;
    }

    private void init(int size, int incr) {
        this._size = size < 1 ? 1 : size;
        this._incr = incr < 0 ? 1 : incr;
        this._list = new Object[this._size];
    }

    public Object next() throws NoSuchElementException {
        if (this._iter == -1) {
            NoSuchElementException nsee = new NoSuchElementException();
            throw nsee;
        }
        Object obj = this._list[this._iter];
        this._iter = this._iter == this._tail ? -1 : ++this._iter;
        if (this._iter == this._size) {
            this._iter = 0;
        }
        if (obj == null) {
            NoSuchElementException nsee = new NoSuchElementException();
            throw nsee;
        }
        return obj;
    }

    public synchronized Object peek() throws EmptyStackException {
        if (this._head == -1) {
            EmptyStackException ese = new EmptyStackException();
            throw ese;
        }
        return this._list[this._head];
    }

    public synchronized Object peek(int pos) throws EmptyStackException {
        if (this._head == -1 || pos < 0) {
            EmptyStackException ese = new EmptyStackException();
            throw ese;
        }
        if (this._head <= this._tail) {
            if (pos <= this._tail - this._head) {
                return this._list[pos + this._head];
            }
            EmptyStackException ese = new EmptyStackException();
            throw ese;
        }
        if (pos < this._size - this._head) {
            return this._list[pos + this._head];
        }
        if ((pos -= this._head - this._size + 1) <= this._tail) {
            return this._list[pos];
        }
        EmptyStackException ese = new EmptyStackException();
        throw ese;
    }

    public synchronized Object pop() throws EmptyStackException {
        Object obj = this.peek();
        this._list[this._head] = null;
        if (this._tail == this._head) {
            this._head = -1;
            this._tail = -1;
        } else {
            ++this._head;
            if (this._head == this._size) {
                this._head = 0;
            }
        }
        return obj;
    }

    public synchronized Object popNoEx() {
        if (this._head == -1) {
            return null;
        }
        try {
            return this.pop();
        }
        catch (EmptyStackException emptyStackException) {
            Debug.assert(this, false);
            return null;
        }
    }

    public synchronized Object push(Object obj) {
        if (this._tail == -1) {
            this._tail = 0;
            this._head = 0;
            this._list[0] = obj;
            return obj;
        }
        ++this._tail;
        if (this._tail == this._size) {
            this._tail = 0;
        }
        if (this._tail == this._head) {
            this.expand();
        }
        this._list[this._tail] = obj;
        return obj;
    }

    private void remove(int i) {
        if (i == this._tail && this._head == this._tail) {
            this._head = -1;
            this._tail = -1;
            return;
        }
        if (i > this._tail) {
            while (i < this._size - 1) {
                this._list[i] = this._list[i + 1];
                ++i;
            }
            this._list[i] = this._list[0];
            i = 0;
        }
        while (i < this._tail) {
            this._list[i] = this._list[i + 1];
            ++i;
        }
        if (this._tail == 0) {
            this._tail = this._size - 1;
            return;
        }
        --this._tail;
    }

    public synchronized boolean removeElement(Object obj) {
        int i = this.search(obj);
        if (i == -1) {
            return false;
        }
        this.remove(i);
        return true;
    }

    public void reset() throws NoSuchElementException {
        this._iter = this._head;
    }

    private int search(Object obj) {
        if (this._head == -1) {
            return -1;
        }
        int end = this._head <= this._tail ? this._tail + 1 : this._size;
        int i = this._head;
        while (i < end) {
            if (obj == this._list[i]) {
                return i;
            }
            ++i;
        }
        if (this._tail < this._head) {
            i = 0;
            while (i <= this._tail) {
                if (obj == this._list[i]) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }
}

