/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.timedio;

import com.sybase.jdbc2.jdbc.Capture;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.timedio.InStreamMgr;
import com.sybase.jdbc2.timedio.RawDbio;
import com.sybase.jdbc2.timedio.SocketDbio;
import com.sybase.jdbc2.timedio.URLDbio;
import com.sybase.jdbc2.utils.BufferInterval;
import com.sybase.jdbc2.utils.Debug;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.sql.SQLException;

public abstract class Dbio {
    public static final int NOT_WAITING = 0;
    public static final int WAITING = 1;
    protected SybProperty _info;
    protected String _host;
    protected int _port;
    protected String _proxyHost = null;
    protected int _proxyPort;
    protected IOException _lastEx;
    protected int _threadState;
    protected InStreamMgr _ioMgr;
    protected BufferInterval _bufIntv;
    protected int _bRead;
    protected InputStream _in;
    protected OutputStream _out;
    protected Capture _cap;

    protected Dbio(String host, int port, InStreamMgr ioMgr, SybProperty props) throws SQLException {
        this._info = props;
        this._host = host;
        this._port = port;
        this._ioMgr = ioMgr;
        this._bufIntv = null;
        this._threadState = 0;
        this.checkProxy();
    }

    protected void checkProxy() throws SQLException {
        String proxy = this._info.getString(17);
        if (proxy == null) {
            return;
        }
        Debug.println(this, "using JDBC gateway: " + proxy);
        int colonIndex = proxy.indexOf(58);
        if (colonIndex == -1) {
            ErrorMessage.raiseError("JZ003", proxy);
        }
        if (proxy.length() > colonIndex + 2 && proxy.charAt(colonIndex + 1) == '/' && proxy.charAt(colonIndex + 2) == '/') {
            this._proxyHost = proxy;
        } else {
            this._proxyHost = proxy.substring(0, colonIndex);
            String port = proxy.substring(colonIndex + 1);
            Debug.println(this, "proxyHost: >" + this._proxyHost + "<");
            Debug.println(this, "proxyPort: >" + port + "<");
            try {
                this._proxyPort = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                ErrorMessage.raiseError("JZ0NE", proxy, nfe.toString());
            }
        }
    }

    protected abstract void close();

    protected void closing() {
    }

    protected static Dbio connect(String host, int port, InStreamMgr ioMgr, SybProperty props) throws SQLException {
        Dbio newDbio = null;
        String proxy = props.getString(17);
        String socketFactory = props.getString(31);
        if (proxy != null && proxy.indexOf("//") > 0) {
            if (socketFactory != null) {
                ErrorMessage.raiseError("JZ0US");
            }
            Debug.println(null, "Instantiating URLDbio");
            newDbio = new URLDbio(host, port, ioMgr, props);
        } else if (socketFactory != null) {
            try {
                Debug.println(null, " Dbio.connect new SocketDbio");
                newDbio = new SocketDbio(host, port, ioMgr, props);
            }
            catch (Exception e) {
                if (e instanceof SQLException && ((SQLException)e).getSQLState().equals("JZ0NF")) {
                    throw (SQLException)e;
                }
                Debug.assert(null, false);
            }
        } else {
            Debug.println(null, "Dbio.connect - new RawDbio");
            newDbio = new RawDbio(host, port, ioMgr, props);
        }
        return newDbio;
    }

    protected void createCapture(SybProperty props) throws SQLException {
        block3: {
            Debug.println(this, "createCapture(" + props + ")");
            String traceFile = props.getString(24);
            if (traceFile == null) break block3;
            try {
                this._cap = new Capture(new FileOutputStream(traceFile));
            }
            catch (IOException ioe) {
                ErrorMessage.raiseWarning("010SP", traceFile, ioe.getMessage());
            }
            catch (SecurityException se) {
                ErrorMessage.raiseWarning("010SN", traceFile, se.getMessage());
            }
        }
    }

    protected abstract void doConnect(int var1) throws IOException;

    protected void doRead(long timeout) throws IOException {
        if (this._bufIntv == null) {
            this._ioMgr.setBuffer(timeout);
            if (this._bufIntv == null) {
                return;
            }
        }
        Debug.println(this, "Dbio start to read");
        int nbytes = 0;
        while (true) {
            try {
                nbytes = this.reallyRead(timeout);
                Debug.println(this, "read " + nbytes);
                if (nbytes > 0) {
                    break;
                }
            }
            catch (SocketException jnse) {
                if (jnse.getMessage().startsWith("Interrupted system call")) {
                    Debug.println(this, "Interrupted exception, retry...");
                    continue;
                }
                this._lastEx = jnse;
            }
            catch (ThreadDeath td) {
                Debug.println(this, "Arrg - I've been killed");
                this._lastEx = ErrorMessage.makeIOException("JZ0TD");
                this._ioMgr.reportError("JZ0T7");
                throw td;
            }
            catch (InterruptedIOException iioe) {
                Debug.println(this, "Timeout exception: " + iioe);
                this._lastEx = iioe;
            }
            catch (IOException e) {
                Debug.println(this, "Unexpected ex: " + e);
                this._ioMgr.markDead();
                Debug.assert(this, false);
            }
            if (this._lastEx != null) {
                Debug.println(this, "Read " + this._lastEx.toString());
                throw this._lastEx;
            }
            Debug.println(this, "End of read loop, no Exception?");
            if (nbytes != -1) continue;
            this._ioMgr.markDead();
        }
        if ((nbytes += this._bRead) > 0) {
            BufferInterval bi = this._bufIntv;
            this._bufIntv = null;
            Debug.println(this, "Bytes read = " + nbytes);
            this._ioMgr.moreData(bi, nbytes);
        } else {
            this._bufIntv = null;
        }
    }

    protected Capture getCapture() {
        return this._cap;
    }

    protected InputStream getInputStream() {
        return this._in;
    }

    protected OutputStream getOutputStream() {
        if (this._cap != null) {
            this._out = this._cap.getOutputStream(this._out);
            this._in = this._cap.getInputStream(this._in);
        }
        return this._out;
    }

    public String getSessionID() {
        return null;
    }

    protected abstract int reallyRead(long var1) throws IOException;

    protected void setBufferInfo(BufferInterval bi, int nHold) {
        Debug.assert(this, bi != null);
        Debug.println(this, "setBufferInfo: " + bi._buf + ", offset =  " + bi._offset + ", length = " + bi._length + ", bufsize = " + bi._buf.length + ", bytes holding = " + nHold);
        this._bufIntv = bi;
        this._bRead = nHold;
    }

    protected boolean startAsync() {
        return false;
    }

    protected void stopAsync() {
    }
}

