/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.DateObject;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.JdbcDataObject;
import com.sybase.jdbc2.jdbc.TextPointer;
import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsDataInputStream;
import com.sybase.jdbc2.tds.TdsDateTime;
import com.sybase.jdbc2.tds.TdsNumeric;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.utils.Chainable;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Calendar;

public abstract class TdsDataObject
extends TdsDataInputStream
implements JdbcDataObject,
Chainable {
    public static final int UNKNOWN = -1;
    public static final int UNINITIALIZED = -2;
    protected static byte[] _byteOrder = new byte[4];
    protected TdsProtocolContext _context;
    protected int _state;
    protected DataFormat _dataFmt;
    protected boolean _isNull;
    protected int _dataLength = -2;
    protected int _textptrlen = 0;
    protected byte[] _textptr = null;
    protected byte[] _timestamp = null;
    protected int _classIDLen;
    protected byte[] _classID;
    protected int _dbID;
    protected int _classNum;
    TdsDataObject _next = null;
    TdsDataObject _prev = null;

    static {
        String byteOrderCheck = "J";
        try {
            _byteOrder = byteOrderCheck.getBytes("Unicode");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.assert(null, false);
        }
    }

    public TdsDataObject(TdsProtocolContext context) throws IOException {
        super((Tds)context._protocol, context._inFormat);
        this._context = context;
        this.setBigEndian(context._bigEndian);
        Debug.assert(this, context._inFormat != null);
        this.initialize();
    }

    protected void badConversion(String more) throws SQLException {
        try {
            this.startRead();
        }
        catch (IOException ioe) {
            ErrorMessage.raiseError("JZ006", ioe.getMessage());
        }
        if (this._isNull) {
            return;
        }
        ErrorMessage.raiseError("JZ009", more);
    }

    protected void badConversionCombination() throws SQLException {
        try {
            this.startRead();
        }
        catch (IOException ioe) {
            ErrorMessage.raiseError("JZ006", ioe.toString());
        }
        if (this._isNull) {
            return;
        }
        ErrorMessage.raiseError("JZ0TC");
    }

    protected abstract void beginRead() throws IOException;

    public abstract void cache() throws IOException;

    public abstract void clear() throws IOException;

    protected void copyInto(TdsDataObject target) throws IOException {
        Debug.println(this, "copyInto()");
        target._state = this._state;
        target._dataFmt = this._dataFmt;
        target._isNull = this._isNull;
        target._dataLength = this._dataLength;
        target._textptrlen = this._textptrlen;
        target._classIDLen = this._classIDLen;
        target._dbID = this._dbID;
        target._classNum = this._classNum;
    }

    protected abstract TdsDataObject createCachedCopy() throws IOException, SQLException;

    protected void doRead() throws SQLException {
        try {
            this.beginRead();
        }
        catch (IOException ioe) {
            ErrorMessage.raiseError("JZ006", ioe.toString());
        }
    }

    protected void endRead() throws SQLException {
    }

    protected byte[] funkyBinaryReader() throws IOException {
        byte[] buf = null;
        int readBytes = 0;
        int padBytes = 0;
        int skipBytes = 0;
        Debug.println(this, "in funkyBinaryReader _maxFieldSize is " + this._context._maxFieldSize);
        if (this._context._maxFieldSize != 0) {
            readBytes = Math.min(this._dataLength, this._context._maxFieldSize);
            if (this._dataFmt._datatype == 37 && this._dataFmt._usertype == 3) {
                padBytes = Math.min(this._context._maxFieldSize, this._dataFmt._length) - readBytes;
            }
            skipBytes = this._dataLength - readBytes;
        } else {
            readBytes = this._dataLength;
            if (this._dataFmt._datatype == 37 && this._dataFmt._usertype == 3) {
                padBytes = this._dataFmt._length - readBytes;
            }
        }
        switch (this._dataFmt._datatype) {
            case 34: 
            case 37: 
            case 45: 
            case 225: {
                buf = new byte[readBytes + padBytes];
                this.in.read(buf, 0, readBytes);
                int i = readBytes;
                while (i < buf.length) {
                    buf[i] = 0;
                    ++i;
                }
                Debug.println(this, "slurping/skipping " + skipBytes);
                if (this._context._maxFieldSize > 0 && this._context._maxFieldSize < this._dataLength) {
                    Debug.println(this, "it's a slurp.");
                    Debug.assert(this, skipBytes == this._dataLength - this._context._maxFieldSize, "bytes to skip is not the same as the difference to read.");
                    this.in.read(new byte[skipBytes]);
                    break;
                }
                Debug.println(this, "it's a skip.");
                this.in.skip(skipBytes);
                break;
            }
            default: {
                Debug.assert(this, false);
            }
        }
        return buf;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.badConversionCombination();
        return null;
    }

    public abstract BigDecimal getBigDecimal(int var1) throws SQLException;

    public InputStream getBinaryStream() throws SQLException {
        this.badConversionCombination();
        return null;
    }

    public abstract boolean getBoolean() throws SQLException;

    public abstract byte getByte() throws SQLException;

    public byte[] getBytes() throws SQLException {
        this.badConversionCombination();
        return null;
    }

    public Reader getCharacterStream() throws SQLException {
        this.badConversionCombination();
        return null;
    }

    public DateObject getDateObject(int targetType, Calendar cal) throws SQLException {
        this.badConversionCombination();
        return null;
    }

    public abstract double getDouble() throws SQLException;

    public abstract float getFloat() throws SQLException;

    public abstract int getInt() throws SQLException;

    public abstract long getLong() throws SQLException;

    public Chainable getNext() {
        return this._next;
    }

    public abstract Object getObject() throws SQLException;

    public Chainable getPrevious() {
        return this._prev;
    }

    public abstract short getShort() throws SQLException;

    protected void getSize() throws IOException {
        Debug.println(this, "getSize for datatype " + this._dataFmt._datatype + " start datalength = " + this._dataLength);
        if (this._dataLength != -2) {
            return;
        }
        block0 : switch (this._dataFmt._datatype) {
            case 48: 
            case 50: 
            case 52: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 122: {
                this._dataLength = this._dataFmt._length;
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 47: 
            case 103: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                this._dataLength = this.readUnsignedByte();
                break;
            }
            case 34: 
            case 35: {
                this._textptrlen = this.readUnsignedByte();
                if (this._textptrlen == 0) {
                    this._dataLength = 0;
                    break;
                }
                this._textptr = new byte[this._textptrlen + 8];
                this.in.read(this._textptr, 0, this._textptrlen + 8);
            }
            case 175: 
            case 225: {
                this._dataLength = this.readInt();
                break;
            }
            case 36: {
                this._dataLength = -1;
                int serializationType = this.readUnsignedByte();
                this._classIDLen = this.readShort();
                switch (this._dataFmt._blobType) {
                    case 1: {
                        Debug.assert(this, serializationType == 1);
                        if (this._classIDLen <= 0) break block0;
                        this._classID = new byte[this._classIDLen];
                        this.read(this._classID, 0, this._classIDLen);
                        break;
                    }
                    case 3: 
                    case 4: {
                        Debug.assert(this, this._classIDLen == 0);
                        if (this._classIDLen <= 0) break block0;
                        this.skip(this._classIDLen);
                        break;
                    }
                    default: {
                        Debug.assert(this, false);
                        this.skip(this._classIDLen);
                        break;
                    }
                }
                break;
            }
            default: {
                ErrorMessage.raiseIOException("JZ0P4");
            }
        }
        Debug.println(this, "getSize(): datatype = " + this._dataFmt._datatype + ", size = " + this._dataLength);
        if (this._dataLength == 0) {
            this._isNull = true;
        }
    }

    public abstract String getString() throws SQLException;

    public TextPointer getTextPtr() throws SQLException {
        this.noTextPointer();
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.badConversionCombination();
        return null;
    }

    public void initialize() {
        Debug.println(this, "initialize()");
        this._state = 0;
        this._isNull = false;
        this._dataLength = -2;
    }

    public boolean isNull() throws SQLException {
        return this._isNull;
    }

    protected void noTextPointer() throws SQLException {
        try {
            this.startRead();
        }
        catch (IOException ioe) {
            ErrorMessage.raiseError("JZ006", ioe.getMessage());
        }
        if (this._isNull) {
            return;
        }
        ErrorMessage.raiseError("JZ0R4");
    }

    protected final TdsDateTime readDATETIMN() throws IOException, SQLException {
        switch (this._dataLength) {
            case 0: {
                return null;
            }
            case 4: {
                int dayNum = this.readUnsignedShort();
                int timeNum = this.readUnsignedShort();
                return new TdsDateTime(dayNum, timeNum, 0);
            }
            case 8: {
                int iDayNum = this.readInt();
                int iTimeNum = this.readInt();
                return new TdsDateTime(iDayNum, iTimeNum);
            }
        }
        ErrorMessage.raiseIOException("JZ0P4");
        return null;
    }

    protected final double readFLTN() throws IOException {
        switch (this._dataLength) {
            case 0: {
                return 0.0;
            }
            case 4: {
                return this.readFloat();
            }
            case 8: {
                return this.readDouble();
            }
        }
        ErrorMessage.raiseIOException("JZ0P4");
        return 0.0;
    }

    protected final long readINTN() throws IOException {
        switch (this._dataLength) {
            case 0: {
                return 0L;
            }
            case 1: {
                return this.readUnsignedByte();
            }
            case 2: {
                return this.readShort();
            }
            case 4: {
                return this.readInt();
            }
            case 8: {
                return this.readLong();
            }
        }
        ErrorMessage.raiseIOException("JZ0P4");
        return 0L;
    }

    protected final BigDecimal readMONEYN() throws IOException {
        switch (this._dataLength) {
            case 0: {
                return null;
            }
            case 4: {
                int ival = this.readInt();
                return new BigDecimal(BigInteger.valueOf(ival), 4);
            }
            case 8: {
                long lval = this.readLong();
                return new BigDecimal(BigInteger.valueOf(lval), 4);
            }
        }
        ErrorMessage.raiseIOException("JZ0P4");
        return null;
    }

    protected final BigDecimal readNUMERIC(int precision, int scale) throws IOException {
        if (this._dataLength == 0) {
            return null;
        }
        byte[] value = new byte[this._dataLength];
        this.in.read(value);
        return TdsNumeric.numericValue(value, precision, scale);
    }

    protected final String readString() throws IOException {
        if (this._dataLength == 0) {
            return null;
        }
        int readBytes = 0;
        int skipBytes = 0;
        Debug.println(this, "in readString _maxFieldSize is " + this._context._maxFieldSize);
        if (this._context._maxFieldSize != 0) {
            readBytes = Math.min(this._dataLength, this._context._maxFieldSize);
            skipBytes = this._dataLength - readBytes;
        } else {
            readBytes = this._dataLength;
        }
        byte[] buf = new byte[readBytes];
        this.in.read(buf, 0, readBytes);
        this.in.skip(skipBytes);
        return this._tds._charsetConverter.toUnicode(buf);
    }

    protected final String readUnicodeString() throws IOException {
        if (this._dataLength == 0) {
            return null;
        }
        int readBytes = 0;
        int skipBytes = 0;
        Debug.println(this, "in readString _maxFieldSize is " + this._context._maxFieldSize);
        if (this._context._maxFieldSize != 0) {
            readBytes = Math.min(this._dataLength, this._context._maxFieldSize);
            skipBytes = this._dataLength - readBytes;
        } else {
            readBytes = this._dataLength;
        }
        byte[] buf = new byte[readBytes + 2];
        this.in.read(buf, 2, readBytes);
        this.in.skip(skipBytes);
        String retVal = null;
        int offset = 2;
        if (!(buf[2] == -2 && buf[3] == -1 || buf[2] == -1 && buf[3] == -2)) {
            offset = 0;
            buf[0] = _byteOrder[0];
            buf[1] = _byteOrder[1];
        }
        try {
            retVal = new String(buf, offset, readBytes + (2 - offset), "Unicode");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.assert(this, false);
        }
        return retVal;
    }

    public void setNext(Chainable next) {
        this._next = (TdsDataObject)next;
    }

    public void setPrevious(Chainable prev) {
        this._prev = (TdsDataObject)prev;
    }

    public void startRead() throws IOException {
        Debug.println(this, "startRead from " + this._state);
        switch (this._state) {
            case 0: {
                if (this._prev != null && this._prev._state != 3) {
                    this._prev.cache();
                }
                this._state = 1;
                this.getSize();
            }
        }
    }
}

