/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.Cursor;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.Param;
import com.sybase.jdbc2.jdbc.ParamManager;
import com.sybase.jdbc2.jdbc.ProtocolContext;
import com.sybase.jdbc2.jdbc.ProtocolResultSet;
import com.sybase.jdbc2.jdbc.SybPreparedStatement;
import com.sybase.jdbc2.tds.CurCloseToken;
import com.sybase.jdbc2.tds.CurDeclare2Token;
import com.sybase.jdbc2.tds.CurDeclareToken;
import com.sybase.jdbc2.tds.CurDeleteToken;
import com.sybase.jdbc2.tds.CurFetchToken;
import com.sybase.jdbc2.tds.CurInfoToken;
import com.sybase.jdbc2.tds.CurOpenToken;
import com.sybase.jdbc2.tds.CurUpdateToken;
import com.sybase.jdbc2.tds.KeyToken;
import com.sybase.jdbc2.tds.ParamFormat2Token;
import com.sybase.jdbc2.tds.ParamFormatToken;
import com.sybase.jdbc2.tds.ParamsToken;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsParam2;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.tds.TdsResultSet;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.sql.SQLException;

public class TdsCursor
implements Cursor {
    private boolean _langCur;
    protected int _hasArgs;
    protected int _id;
    private static int _cursorNum = 0;
    protected String _name;
    protected int _state = 0;
    protected int _type = 0;
    private int _fetchSize = 1;
    protected String _table = null;
    protected String[] _columns = null;
    private Tds _tds;
    private TdsProtocolContext _tpc;
    private TdsProtocolContext _curPC;
    private SybPreparedStatement _utilStmt;

    public TdsCursor(Tds tds, ProtocolContext tpc, boolean langCur, ProtocolContext curPC) {
        this._tds = tds;
        this._tpc = (TdsProtocolContext)tpc;
        this._tpc._cursor = this;
        this._langCur = langCur;
        this._curPC = (TdsProtocolContext)curPC;
        this._curPC._cursor = this;
    }

    private void buildParamfmtToken(ParamManager params) throws IOException, SQLException {
        ParamFormatToken pft = null;
        Param[] p = params.getParams();
        Debug.assert(this, p != null && p.length > 0);
        pft = p[0] instanceof TdsParam2 ? new ParamFormat2Token(params) : new ParamFormatToken(params);
        pft.send(this._tds._out);
    }

    private void checkState() throws SQLException {
        if (this._state == 1 || this._state == 2) {
            ErrorMessage.raiseError("JZ00F");
        }
    }

    public void close(boolean dealloc) throws SQLException {
        Debug.println(this, "close() dealloc = " + dealloc);
        if (dealloc ? this._state == 0 || this._state == 3 : this._state != 1) {
            return;
        }
        this._tpc._conn.removeCursorResultSet(this._name);
        this._tds._outStreamMgr.getSendLock(this._tpc);
        try {
            block10: {
                if (!this._langCur) {
                    this._tds._outStreamMgr.beginRequest(this._tpc);
                    try {
                        CurCloseToken closeT = new CurCloseToken(this, dealloc);
                        closeT.send(this._tds._out);
                        this._tds._out.flush();
                    }
                    catch (IOException ioe) {
                        this._tds._outStreamMgr.abortRequest(this._tpc);
                        this.handleIOE(ioe);
                    }
                    if (dealloc) {
                        this._state = 3;
                        this._id = 0;
                    } else {
                        this._state = 2;
                    }
                    break block10;
                }
                this._tds.language(this._tpc, "DEALLOCATE CURSOR " + this._name, null);
                this._state = 3;
                this._utilStmt = null;
            }
            Object var3_5 = null;
            this._tds._outStreamMgr.endRequest(this._tpc);
            this._curPC.drop();
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this._tds._outStreamMgr.endRequest(this._tpc);
            this._curPC.drop();
            throw throwable;
        }
        this._tds.getDoneResult(this._tpc);
    }

    public int delete(ProtocolResultSet prs) throws SQLException {
        Debug.println(this, "delete row " + this._name);
        Debug.assert(this, this._state == 1);
        TdsResultSet trs = (TdsResultSet)prs;
        this._tds._outStreamMgr.getSendLock(this._curPC);
        try {
            if (!this._langCur) {
                this._tds._outStreamMgr.beginRequest(this._curPC);
                try {
                    CurDeleteToken deleteT = new CurDeleteToken(this, trs);
                    deleteT.send(this._tds._out);
                    KeyToken key = new KeyToken(trs);
                    key.send(this._tds._out);
                    this._tds._out.flush();
                }
                catch (IOException ioe) {
                    this._tds._outStreamMgr.abortRequest(this._curPC);
                    this.handleIOE(ioe);
                }
            } else {
                this._tds.language(this._curPC, "DELETE " + this._table + " WHERE CURRENT OF " + this._name, null);
            }
            Object var4_7 = null;
            this._tds._outStreamMgr.endRequest(this._curPC);
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this._tds._outStreamMgr.endRequest(this._curPC);
            throw throwable;
        }
        return this._tds.getDoneResult(this._curPC);
    }

    private void doCurInfo(int command) throws SQLException {
        Debug.println(this, "doCurInfo, cmd= " + command);
        this._tds._outStreamMgr.getSendLock(this._curPC);
        try {
            if (!this._langCur) {
                try {
                    this._tds._outStreamMgr.beginRequest(this._curPC);
                    CurInfoToken curInfo = new CurInfoToken(this);
                    curInfo.send(this._tds._out, command, this._fetchSize);
                    this._tds._out.flush();
                }
                catch (IOException ioe) {
                    this._tds._outStreamMgr.abortRequest(this._curPC);
                    this.handleIOE(ioe);
                }
            } else {
                Debug.assert(this, command == 1);
                this._tds.language(this._curPC, "SET CURSOR ROWS " + this._fetchSize + "FOR " + this._name, null);
            }
            Object var3_5 = null;
            this._tds._outStreamMgr.endRequest(this._curPC);
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this._tds._outStreamMgr.endRequest(this._curPC);
            throw throwable;
        }
        this._tds.getDoneResult(this._curPC);
    }

    public ProtocolResultSet fetch() throws SQLException {
        Debug.println(this, "fetch cursor " + this._name);
        Debug.assert(this, this._state == 1);
        this._tds._outStreamMgr.getSendLock(this._tpc);
        TdsResultSet prs = null;
        try {
            block8: {
                if (!this._langCur) {
                    prs = this._tpc._trs;
                    this._tds._outStreamMgr.beginRequest(this._tpc);
                    try {
                        CurFetchToken fetchT = new CurFetchToken(this, 1, 0);
                        fetchT.send(this._tds._out);
                        this._tds._out.flush();
                    }
                    catch (IOException ioe) {
                        this._tds._outStreamMgr.abortRequest(this._tpc);
                        this.handleIOE(ioe);
                    }
                    int result = this._tds.nextResult(this._tpc);
                    prs.prepareForNextFetch();
                    this._tpc._trs = prs;
                    this._tds.ungetResult(this._tpc, result);
                    break block8;
                }
                this._utilStmt.sendQuery(null, null);
                if (this._tds.getResultSetResult(this._tpc, false)) {
                    prs = (TdsResultSet)this._tds.resultSet(this._tpc);
                }
            }
            Object var3_6 = null;
            this._tds._outStreamMgr.endRequest(this._tpc);
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this._tds._outStreamMgr.endRequest(this._tpc);
            throw throwable;
        }
        return prs;
    }

    public int getConcurrency() throws SQLException {
        if (!this._langCur && this._state == 1) {
            this.doCurInfo(2);
        }
        Debug.println(this, "concurType= " + this._type);
        if ((this._type & 1) != 0) {
            return 1007;
        }
        return 1008;
    }

    public int getFetchSize() {
        return this._fetchSize;
    }

    public String getName() {
        if (this._name == null) {
            TdsCursor tdsCursor = this;
            synchronized (tdsCursor) {
                this._name = "jconnect_implicit_" + ++_cursorNum;
            }
        }
        return this._name;
    }

    public String getTable() {
        return this._table;
    }

    private void handleIOE(IOException ioe) throws SQLException {
        ErrorMessage.raiseError("JZ006", ioe.toString());
    }

    public int insert(ProtocolResultSet prs, ParamManager paramMgr, String insertClause) throws SQLException {
        Debug.println(this, "insert row: " + insertClause);
        Debug.assert(this, this._state == 1);
        TdsResultSet trs = (TdsResultSet)prs;
        this._tds._outStreamMgr.getSendLock(this._curPC);
        try {
            this._tds.language(this._curPC, insertClause, paramMgr);
            Object var6_6 = null;
            this._tds._outStreamMgr.endRequest(this._curPC);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this._tds._outStreamMgr.endRequest(this._curPC);
            throw throwable;
        }
        return this._tds.getDoneResult(this._curPC);
    }

    public boolean isLanguageCursor() {
        return this._langCur;
    }

    private void languageCursor(String query, ParamManager params) throws SQLException {
        Debug.println(this, "languageCursor() " + query);
        String curDeclare = new String("DECLARE " + this._name + " CURSOR FOR ");
        if (params != null && this._state == 0) {
            params.adjustOffsets(curDeclare.length());
        }
        if (this._state == 0 || this._state == 3) {
            this._tds.language(this._tpc, String.valueOf(curDeclare) + query, params);
            this._tds.getDoneResult(this._tpc);
        }
        if (this._fetchSize > 1) {
            this._tds.language(this._tpc, "SET CURSOR ROWS " + this._fetchSize + " FOR " + this._name, null);
            this._tds.getDoneResult(this._tpc);
        }
        this._tds.language(this._tpc, "OPEN " + this._name, null);
        this._tds.getDoneResult(this._tpc);
        if (this._utilStmt == null) {
            this._utilStmt = (SybPreparedStatement)this._tpc._conn.prepareStatement("FETCH " + this.getName(), false);
            this._utilStmt.switchContext(this._tpc);
        }
        this._utilStmt.sendQuery(null, null);
    }

    public ProtocolResultSet open(String sql, ParamManager params, boolean isRpc) throws SQLException {
        if (this._name == null) {
            Debug.println(this, "Name was null; generating one now");
            this.getName();
        }
        Debug.println(this, "Open cursor " + this._name);
        Debug.assert(this, sql != null);
        if (this._state == 1) {
            ErrorMessage.raiseError("JZ00E");
        }
        this._tds._outStreamMgr.getSendLock(this._tpc);
        this._tpc.setSponsor(this._tpc);
        if (params != null) {
            this._hasArgs = params.hasInParams() ? 1 : 0;
        }
        ProtocolResultSet prs = null;
        try {
            try {
                if (isRpc) {
                    sql = new String("EXECUTE " + sql);
                }
                if ((this._type & 8) != 0) {
                    isRpc = true;
                }
                if (!this._langCur) {
                    this.tdsCursor(sql, params, isRpc);
                } else {
                    this.languageCursor(sql, params);
                }
                if (this._tds.getResultSetResult(this._tpc, this._langCur ^ true)) {
                    prs = this._tds.resultSet(this._tpc);
                }
            }
            catch (SQLException sqle) {
                this._tds.cancel(this._tpc, false);
                throw sqle;
            }
            Object var6_6 = null;
            this._tpc.setSponsor(null);
            this._tds._outStreamMgr.endRequest(this._tpc);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this._tpc.setSponsor(null);
            this._tds._outStreamMgr.endRequest(this._tpc);
            throw throwable;
        }
        this._state = 1;
        return prs;
    }

    public void setFetchSize(int size) throws SQLException {
        if (size == 0) {
            return;
        }
        if (size < 0) {
            ErrorMessage.raiseError("JZ0BI");
        }
        int oldSize = this._fetchSize;
        this._fetchSize = size;
        Debug.println(this, "fetchSize = " + this._fetchSize);
        if (this._state == 1 && oldSize != size) {
            this.doCurInfo(1);
        }
    }

    public void setName(String name) throws SQLException {
        this.checkState();
        this._name = name;
    }

    public void setTable(String table) {
        if (table != null) {
            this._table = table;
        }
        Debug.println(this, "set table name = " + this._table);
    }

    public void setType(int type) throws SQLException {
        Debug.println(this, "setType() " + type);
        switch (type) {
            case 1: 
            case 1007: {
                this._type |= 1;
                this._type &= 0xFFFFFFFD;
                break;
            }
            case 2: 
            case 1008: {
                this._type &= 0xFFFFFFFE;
                this._type |= 2;
                break;
            }
            case 8: {
                this._type |= 8;
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0BD");
            }
        }
        Debug.println(this, "Concurrency type = " + this._type);
    }

    private void tdsCursor(String query, ParamManager params, boolean isRpc) throws SQLException {
        Debug.println(this, "tdsCursor() " + query);
        this._tds._outStreamMgr.beginRequest(this._tpc);
        try {
            if (this._state == 0 || this._state == 3) {
                this._id = 0;
                String pQuery = null;
                if (params != null) {
                    params.checkParams(this._tds, false);
                    if (!isRpc && (pQuery = params.processParamMarkers(query)) != null) {
                        query = pQuery;
                    }
                }
                CurDeclareToken declareT = null;
                boolean needCur2 = false;
                long checkLen = 65529 - this.getName().length();
                if (this._columns != null) {
                    int i = 0;
                    while (i < this._columns.length) {
                        --checkLen;
                        checkLen -= (long)this._columns[i].length();
                        ++i;
                    }
                }
                if ((long)query.length() > checkLen) {
                    needCur2 = true;
                }
                if (needCur2) {
                    if (!this._tds.isWidetableEnabled()) {
                        ErrorMessage.raiseError("JZ0PE");
                    } else {
                        declareT = new CurDeclare2Token(this, query);
                    }
                } else {
                    declareT = new CurDeclareToken(this, query);
                }
                declareT.send(this._tds._out);
                if (!isRpc && this._hasArgs == 1) {
                    this.buildParamfmtToken(params);
                }
            }
            if (this._fetchSize > 1) {
                CurInfoToken curInfo = new CurInfoToken(this);
                curInfo.send(this._tds._out, 1, this._fetchSize);
            }
            CurOpenToken openT = new CurOpenToken(this);
            openT.send(this._tds._out);
            if (this._hasArgs == 1) {
                this.buildParamfmtToken(params);
                ParamsToken pt = new ParamsToken();
                pt.send(this._tds._out);
                params.send(this._tds._out);
            }
            this._tds._out.flush();
        }
        catch (IOException ioe) {
            this._tds._outStreamMgr.abortRequest(this._tpc);
            this.handleIOE(ioe);
        }
    }

    public int update(ProtocolResultSet prs, ParamManager paramMgr, String setClause) throws SQLException {
        Debug.println(this, "update row " + this._name + ": " + setClause);
        Debug.assert(this, this._state == 1);
        boolean hasArgs = false;
        if (paramMgr != null) {
            paramMgr.checkParams(this._tds, false);
            String pSetClause = null;
            pSetClause = paramMgr.processParamMarkers(setClause);
            if (pSetClause != null) {
                setClause = pSetClause;
            }
            hasArgs = paramMgr.hasInParams();
        }
        TdsResultSet trs = (TdsResultSet)prs;
        this._tds._outStreamMgr.getSendLock(this._curPC);
        try {
            if (!this._langCur) {
                this._tds._outStreamMgr.beginRequest(this._curPC);
                try {
                    CurUpdateToken updateT = new CurUpdateToken(this, trs, setClause, hasArgs);
                    updateT.send(this._tds._out);
                    KeyToken key = new KeyToken(trs);
                    key.send(this._tds._out);
                    this._tds.sendParamStream(paramMgr, this._tds._out);
                    this._tds._out.flush();
                }
                catch (IOException ioe) {
                    this._tds._outStreamMgr.abortRequest(this._curPC);
                    this.handleIOE(ioe);
                }
            } else {
                this._tds.language(this._curPC, String.valueOf(setClause) + " WHERE CURRENT OF " + this._name, paramMgr);
            }
            Object var7_10 = null;
            this._tds._outStreamMgr.endRequest(this._curPC);
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            this._tds._outStreamMgr.endRequest(this._curPC);
            throw throwable;
        }
        return this._tds.getDoneResult(this._curPC);
    }
}

