/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions;

import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.MediaType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.VAppTemplateType;
import com.vmware.vcloud.api.rest.schema.VAppType;
import com.vmware.vcloud.api.rest.schema.extension.ImportMediaParamsType;
import com.vmware.vcloud.api.rest.schema.extension.ImportVmAsVAppParamsType;
import com.vmware.vcloud.api.rest.schema.extension.ImportVmAsVAppTemplateParamsType;
import com.vmware.vcloud.api.rest.schema.extension.ImportVmIntoExistingVAppParamsType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.extension.ResourcePoolListType;
import com.vmware.vcloud.api.rest.schema.extension.ResourcePoolType;
import com.vmware.vcloud.api.rest.schema.extension.ShieldManagerType;
import com.vmware.vcloud.api.rest.schema.extension.VMWHostReferencesType;
import com.vmware.vcloud.api.rest.schema.extension.VMWStorageProfileType;
import com.vmware.vcloud.api.rest.schema.extension.VMWStorageProfilesType;
import com.vmware.vcloud.api.rest.schema.extension.VSphereWebClientUrlType;
import com.vmware.vcloud.api.rest.schema.extension.VimObjectRefListType;
import com.vmware.vcloud.api.rest.schema.extension.VimObjectRefType;
import com.vmware.vcloud.api.rest.schema.extension.VimServerType;
import com.vmware.vcloud.api.rest.schema.extension.VmObjectRefType;
import com.vmware.vcloud.api.rest.schema.extension.VmObjectRefsListType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.Media;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.Vapp;
import com.vmware.vcloud.sdk.VappTemplate;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VMWVimServer
extends VcloudEntity<VimServerType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType vShieldManagerReference;

    VMWVimServer(VcloudClient client, VimServerType vimServerType_v1_5) {
        super(client, vimServerType_v1_5);
        this.sortLinks();
    }

    private void sortLinks() {
        if (this.getResource() != null) {
            for (LinkType link : ((VimServerType)this.getResource()).getLink()) {
                if (!link.getRel().equals("down") || !link.getType().equals("application/vnd.vmware.admin.vshieldmanager+xml")) continue;
                this.vShieldManagerReference = link;
                break;
            }
        }
    }

    public static VMWVimServer getVMWVimServerByReference(VcloudClient client, ReferenceType vmwVimServerRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + vmwVimServerRef.getHref());
        return new VMWVimServer(client, (VimServerType)VMWVimServer.getResourceByReference(client, vmwVimServerRef));
    }

    public static VMWVimServer getVMWVimServerById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new VMWVimServer(client, (VimServerType)VMWVimServer.getEntityById(client, vCloudId, "application/vnd.vmware.admin.vmwvirtualcenter+xml"));
    }

    public Task updateVMWVimServer(VimServerType vimServerType) throws VCloudException {
        ObjectFactory extensionFactory = new ObjectFactory();
        String vmwVimServerUpdateUrl = this.getReference().getHref();
        String vmwVimServerUpdateRequestXmlString = JAXBUtil.marshal(extensionFactory.createVimServer(vimServerType));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + vmwVimServerUpdateUrl);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), vmwVimServerUpdateUrl, vmwVimServerUpdateRequestXmlString, "application/vnd.vmware.admin.vmwvirtualcenter+xml", 202));
    }

    public Task forceVMWVimServerReconnect() throws VCloudException {
        String url = this.getReference().getHref() + "/action/forcevimserverreconnect";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), url, null, null, 202));
    }

    public static Task forceVMWVimServerReconnect(VcloudClient client, ReferenceType vmwVimServerRef) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.post(client, vmwVimServerRef.getHref() + "/action/forcevimserverreconnect", null, null, 202));
    }

    public Task unregisterVMWVimServer() throws VCloudException {
        String url = this.getReference().getHref() + "/action/unregister";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), url, null, null, 202));
    }

    public Task refreshVimServer() throws VCloudException {
        String url = this.getReference().getHref() + "/action/refresh";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), url, null, null, 202));
    }

    public static Task unregisterVMWVimServer(VcloudClient client, ReferenceType vmwVimServerRef) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.post(client, vmwVimServerRef.getHref() + "/action/unregister", null, null, 202));
    }

    public static HashMap<String, ResourcePoolType> getResourcePools(VcloudClient client, ReferenceType vimServerRef) throws VCloudException {
        String url = vimServerRef.getHref() + "/resourcePoolList";
        return VMWVimServer.getResourcePools(client, url);
    }

    public HashMap<String, VimObjectRefType> getNetworkVimRefsByMoref() throws VCloudException {
        String url = this.getReference().getHref() + "/networks";
        return VMWVimServer.getNetworkVimRefsByMoref(this.getVcloudClient(), url);
    }

    private static HashMap<String, VimObjectRefType> getNetworkVimRefsByMoref(VcloudClient client, String url) throws VCloudException {
        HashMap<String, VimObjectRefType> networkRefsByMoref = new HashMap<String, VimObjectRefType>();
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        VimObjectRefListType vimObjectRefListType = (VimObjectRefListType)SdkUtil.get(client, url, 200);
        for (VimObjectRefType vimObjectRef : vimObjectRefListType.getVimObjectRefs().getVimObjectRef()) {
            networkRefsByMoref.put(vimObjectRef.getMoRef(), vimObjectRef);
        }
        return networkRefsByMoref;
    }

    public static HashMap<String, VimObjectRefType> getNetworkVimRefsByMoref(VcloudClient client, ReferenceType vimServerRef) throws VCloudException {
        String url = vimServerRef.getHref() + "/networks";
        return VMWVimServer.getNetworkVimRefsByMoref(client, url);
    }

    public HashMap<String, ReferenceType> getVMWHostRefsByName() throws VCloudException {
        String url = this.getReference().getHref() + "/hostReferences";
        return VMWVimServer.getVMWHostRefsByName(this.getVcloudClient(), url);
    }

    private static HashMap<String, ReferenceType> getVMWHostRefsByName(VcloudClient client, String url) throws VCloudException {
        HashMap<String, ReferenceType> vmwHostRefs = new HashMap<String, ReferenceType>();
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        VMWHostReferencesType vmwHostReferencesType = (VMWHostReferencesType)SdkUtil.get(client, url, 200);
        for (ReferenceType vmwHostRef : vmwHostReferencesType.getHostReference()) {
            vmwHostRefs.put(vmwHostRef.getName(), vmwHostRef);
        }
        return vmwHostRefs;
    }

    public static HashMap<String, ReferenceType> getVMWHostRefsByName(VcloudClient client, ReferenceType vimServerRef) throws VCloudException {
        String url = vimServerRef.getHref() + "/hostReferences";
        return VMWVimServer.getVMWHostRefsByName(client, url);
    }

    public HashMap<String, ResourcePoolType> getResourcePools() throws VCloudException {
        String url = this.getReference().getHref() + "/resourcePoolList";
        return VMWVimServer.getResourcePools(this.getVcloudClient(), url);
    }

    private static HashMap<String, ResourcePoolType> getResourcePools(VcloudClient client, String url) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        HashMap<String, ResourcePoolType> resourcePoolsByName = new HashMap<String, ResourcePoolType>();
        ResourcePoolListType resourcePoolListType = (ResourcePoolListType)SdkUtil.get(client, url, 200);
        for (ResourcePoolType resourcePoolType : resourcePoolListType.getResourcePool()) {
            resourcePoolsByName.put(resourcePoolType.getName(), resourcePoolType);
        }
        return resourcePoolsByName;
    }

    public HashMap<String, VmObjectRefType> getVms() throws VCloudException {
        String url = this.getReference().getHref() + "/vmsList";
        return VMWVimServer.getVms(this.getVcloudClient(), url);
    }

    public HashMap<String, VmObjectRefType> getVms(int page, int pageSize) throws VCloudException {
        String url = this.getReference().getHref() + "/vmsList" + "?page=" + page + "&pageSize=" + pageSize;
        return VMWVimServer.getVms(this.getVcloudClient(), url);
    }

    public HashMap<String, VmObjectRefType> getVms(int page) throws VCloudException {
        String url = this.getReference().getHref() + "/vmsList" + "?page=" + page;
        return VMWVimServer.getVms(this.getVcloudClient(), url);
    }

    private static HashMap<String, VmObjectRefType> getVms(VcloudClient client, String url) throws VCloudException {
        HashMap<String, VmObjectRefType> vmObjectRefByName = new HashMap<String, VmObjectRefType>();
        VmObjectRefsListType vmObjectRefsListType = (VmObjectRefsListType)SdkUtil.get(client, url, 200);
        for (VmObjectRefType vmObjectRef : vmObjectRefsListType.getVmObjectRef()) {
            vmObjectRefByName.put(vmObjectRef.getName(), vmObjectRef);
        }
        return vmObjectRefByName;
    }

    public static HashMap<String, VmObjectRefType> getVms(VcloudClient client, ReferenceType vimServerRef) throws VCloudException {
        return VMWVimServer.getVms(client, vimServerRef.getHref() + "/vmsList");
    }

    public static HashMap<String, VmObjectRefType> getVms(VcloudClient client, ReferenceType vimServerRef, int page) throws VCloudException {
        return VMWVimServer.getVms(client, vimServerRef.getHref() + "/vmsList" + "?page=" + page);
    }

    public static HashMap<String, VmObjectRefType> getVms(VcloudClient client, ReferenceType vimServerRef, int page, int pageSize) throws VCloudException {
        return VMWVimServer.getVms(client, vimServerRef.getHref() + "/vmsList" + "?page=" + page + "&pageSize=" + pageSize);
    }

    public Vapp importVmAsVApp(ImportVmAsVAppParamsType importVmAsVAppParamsType) throws VCloudException {
        String url = this.getReference().getHref() + "/importVmAsVApp";
        ObjectFactory extensionFactory = new ObjectFactory();
        String requestString = JAXBUtil.marshal(extensionFactory.createImportVmAsVAppParams(importVmAsVAppParamsType));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return new Vapp(this.getVcloudClient(), (VAppType)SdkUtil.post(this.getVcloudClient(), url, requestString, "application/vnd.vmware.admin.importVmAsVAppParams+xml", 201));
    }

    public Task importVmIntoVApp(ImportVmIntoExistingVAppParamsType importVmIntoVAppParamsType) throws VCloudException {
        String url = this.getReference().getHref() + "/importVmIntoExistingVApp";
        ObjectFactory extensionFactory = new ObjectFactory();
        String requestString = JAXBUtil.marshal(extensionFactory.createImportVmIntoExistingVAppParams(importVmIntoVAppParamsType));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), url, requestString, "application/vnd.vmware.admin.importVmIntoExistingVAppParams+xml", 202));
    }

    public VappTemplate importVmAsVAppTemplate(ImportVmAsVAppTemplateParamsType importVmAsVAppTemplateParamsType) throws VCloudException {
        String url = this.getReference().getHref() + "/importVmAsVAppTemplate";
        ObjectFactory extensionFactory = new ObjectFactory();
        String requestString = JAXBUtil.marshal(extensionFactory.createImportVmAsVAppTemplateParams(importVmAsVAppTemplateParamsType));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return new VappTemplate(this.getVcloudClient(), (VAppTemplateType)SdkUtil.post(this.getVcloudClient(), url, requestString, "application/vnd.vmware.admin.importVmAsVAppTemplateParams+xml", 201));
    }

    public Media importMedia(ImportMediaParamsType importMediaParamsType) throws VCloudException {
        String url = this.getReference().getHref() + "/importMedia";
        ObjectFactory extensionFactory = new ObjectFactory();
        String requestString = JAXBUtil.marshal(extensionFactory.createImportMediaParams(importMediaParamsType));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return new Media(this.getVcloudClient(), (MediaType)SdkUtil.post(this.getVcloudClient(), url, requestString, "application/vnd.vmware.admin.importMediaParams+xml", 201));
    }

    public ShieldManagerType getvShieldManager() throws VCloudException {
        if (this.vShieldManagerReference == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
        }
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + this.vShieldManagerReference.getHref());
        return (ShieldManagerType)SdkUtil.get(this.getVcloudClient(), this.vShieldManagerReference.getHref(), 200);
    }

    public Task updatevShieldManager(ShieldManagerType shieldManager) throws VCloudException {
        if (this.vShieldManagerReference == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
        }
        ObjectFactory extensionFactory = new ObjectFactory();
        String shieldManagerUpdateUrl = this.vShieldManagerReference.getHref();
        String shieldManagerUpdateRequestXmlString = JAXBUtil.marshal(extensionFactory.createShieldManager(shieldManager));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + shieldManagerUpdateUrl);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), shieldManagerUpdateUrl, shieldManagerUpdateRequestXmlString, "application/vnd.vmware.admin.vshieldmanager+xml", 202));
    }

    public List<VMWStorageProfileType> getVMWStorageProfiles() throws VCloudException {
        return ((VMWStorageProfilesType)SdkUtil.get(this.getVcloudClient(), this.getReference().getHref() + "/storageProfiles", 200)).getVMWStorageProfile();
    }

    public Task refreshStorageProfiles() throws VCloudException {
        String url = this.getReference().getHref() + "/action/refreshStorageProfiles";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), url, null, null, 202));
    }

    public static Task refreshStorageProfiles(VcloudClient client, ReferenceType vmwVimServerRef) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.post(client, vmwVimServerRef.getHref() + "/action/refreshStorageProfiles", null, null, 202));
    }

    public String getvSphereWebClientUrl(String vimObjectType, String vimObjectMoref) throws VCloudException {
        return ((VSphereWebClientUrlType)SdkUtil.get(this.getVcloudClient(), ((VimServerType)this.getResource()).getHref() + "/" + vimObjectType + "/" + vimObjectMoref + "/vSphereWebClientUrl", 200)).getURL();
    }
}

