/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions;

import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.extension.LicensingReportSampleType;
import com.vmware.vcloud.api.rest.schema.extension.LicensingReportType;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudResource;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.HashMap;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseReport
extends VcloudResource<LicensingReportType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");

    LicenseReport(VcloudClient client, LicensingReportType licensingReportType_v1_5) {
        super(client, licensingReportType_v1_5);
    }

    public static LicenseReport getLicenseReportByReference(VcloudClient client, ReferenceType referenceType) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + referenceType.getHref());
        return new LicenseReport(client, (LicensingReportType)LicenseReport.getResourceByReference(client, referenceType));
    }

    public HashMap<XMLGregorianCalendar, LicensingReportSampleType> getSamplesByDate() {
        HashMap<XMLGregorianCalendar, LicensingReportSampleType> samples = new HashMap<XMLGregorianCalendar, LicensingReportSampleType>();
        for (LicensingReportSampleType sample : ((LicensingReportType)this.getResource()).getSample()) {
            samples.put(sample.getObservationDate(), sample);
        }
        return samples;
    }

    public XMLGregorianCalendar getReportDate() {
        return ((LicensingReportType)this.getResource()).getReportDate();
    }

    public String getProductSerialNumber() {
        return ((LicensingReportType)this.getResource()).getProductSerialNumber();
    }
}

