/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin;

import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.RightReferencesType;
import com.vmware.vcloud.api.rest.schema.RightType;
import com.vmware.vcloud.api.rest.schema.RoleType;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.admin.Role;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Right
extends VcloudEntity<RightType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");

    public Right(VcloudClient client, RightType rightType) {
        super(client, rightType);
    }

    public static Right getRightByReference(VcloudClient client, ReferenceType rightRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + rightRef.getHref());
        return new Right(client, (RightType)Right.getResourceByReference(client, rightRef));
    }

    public static Right getRightById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new Right(client, (RightType)Right.getEntityById(client, vCloudId, "application/vnd.vmware.admin.right+xml"));
    }

    public static void delete(VcloudClient client, ReferenceType rightRef) throws VCloudException {
        SdkUtil.delete(client, rightRef.getHref(), 204);
    }

    public void delete() throws VCloudException {
        SdkUtil.delete(this.getVcloudClient(), ((RightType)this.getResource()).getHref(), 204);
    }

    public Role addToRole(ReferenceType roleRef) throws VCloudException {
        Role role = Role.getRoleByReference(this.getVcloudClient(), roleRef);
        ((RoleType)role.getResource()).getRightReferences().getRightReference().add(this.getReference());
        return role.updateRole((RoleType)role.getResource());
    }

    public Role addToRole(String vCloudRoleId) throws VCloudException {
        Role role = Role.getRoleById(this.getVcloudClient(), vCloudRoleId);
        ((RoleType)role.getResource()).getRightReferences().getRightReference().add(this.getReference());
        return role.updateRole((RoleType)role.getResource());
    }

    public Role deleteFromRole(String vCloudRoleId) throws VCloudException {
        Role role = Role.getRoleById(this.getVcloudClient(), vCloudRoleId);
        List rightRefs = ((RoleType)role.getResource()).getRightReferences().getRightReference();
        for (int i = 0; i < rightRefs.size(); ++i) {
            if (!((ReferenceType)rightRefs.get(i)).getName().equals(this.getReference().getName())) continue;
            rightRefs.remove(i--);
        }
        RightReferencesType rightReferencesType = new RightReferencesType();
        rightReferencesType.getRightReference().addAll(rightRefs);
        ((RoleType)role.getResource()).setRightReferences(rightReferencesType);
        return role.updateRole((RoleType)role.getResource());
    }

    public Role deleteFromRole(ReferenceType roleRef) throws VCloudException {
        Role role = Role.getRoleByReference(this.getVcloudClient(), roleRef);
        List rightRefs = ((RoleType)role.getResource()).getRightReferences().getRightReference();
        for (int i = 0; i < rightRefs.size(); ++i) {
            if (!((ReferenceType)rightRefs.get(i)).getName().equals(this.getReference().getName())) continue;
            rightRefs.remove(i--);
        }
        RightReferencesType rightReferencesType = new RightReferencesType();
        rightReferencesType.getRightReference().addAll(rightRefs);
        ((RoleType)role.getResource()).setRightReferences(rightReferencesType);
        return role.updateRole((RoleType)role.getResource());
    }
}

