/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.AllocatedIpAddressType;
import com.vmware.vcloud.api.rest.schema.AllocatedIpAddressesType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.NetworkConfigurationType;
import com.vmware.vcloud.api.rest.schema.OrgVdcNetworkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.sdk.AllocatedIpAddress;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrgVdcNetwork
extends VcloudEntity<OrgVdcNetworkType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType vdcReference;

    OrgVdcNetwork(VcloudClient client, OrgVdcNetworkType orgVdcNetworkType) {
        super(client, orgVdcNetworkType);
        this.sortRefs();
    }

    public ReferenceType getVdcReference() throws VCloudException {
        if (this.vdcReference != null) {
            return this.vdcReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    private void sortRefs() {
        for (LinkType vdcNetworkLink : ((OrgVdcNetworkType)this.getResource()).getLink()) {
            if (!vdcNetworkLink.getRel().equals("up") || !vdcNetworkLink.getType().equals("application/vnd.vmware.vcloud.vdc+xml")) continue;
            this.vdcReference = vdcNetworkLink;
        }
    }

    public NetworkConfigurationType getConfiguration() {
        return ((OrgVdcNetworkType)this.getResource()).getConfiguration();
    }

    public static OrgVdcNetwork getOrgVdcNetworkByReference(VcloudClient client, ReferenceType orgVdcNetworkRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + orgVdcNetworkRef.getHref());
        return new OrgVdcNetwork(client, (OrgVdcNetworkType)OrgVdcNetwork.getResourceByReference(client, orgVdcNetworkRef));
    }

    public static OrgVdcNetwork getOrgVdcNetworkById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new OrgVdcNetwork(client, (OrgVdcNetworkType)OrgVdcNetwork.getEntityById(client, vCloudId, "application/vnd.vmware.vcloud.network+xml"));
    }

    public List<AllocatedIpAddress> getAllocatedAddresses() throws VCloudException {
        String allocatedAddressesHref = this.getReference().getHref() + "/allocatedAddresses";
        AllocatedIpAddressesType allocatedIpAddressesType = (AllocatedIpAddressesType)SdkUtil.get(this.getVcloudClient(), allocatedAddressesHref, 200);
        ArrayList<AllocatedIpAddress> allocatedIpAddresses = new ArrayList<AllocatedIpAddress>();
        for (AllocatedIpAddressType allocatedIpAddressType : allocatedIpAddressesType.getIpAddress()) {
            allocatedIpAddresses.add(new AllocatedIpAddress(this.getVcloudClient(), allocatedIpAddressType));
        }
        return allocatedIpAddresses;
    }
}

