/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.ChartData;
import com.objectplanet.chart.ChartRenderer;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.GenericChart;
import com.objectplanet.chart.GridRenderer;
import com.objectplanet.chart.Renderer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Chart
extends GenericChart
implements ItemSelectable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    public static final int TARGET_LINE_NO_LABEL = 0;
    public static final int TARGET_LINE_ID_LABEL = 1;
    public static final int TARGET_LINE_VALUE_LABEL = 2;
    public static final int TARGET_LINE_ID_AND_VALUE_LABEL = 3;
    public static final int INSIDE = 0;
    public static final int OUTSIDE = 1;
    public static final int BELOW = 2;
    public static final int FLOATING = 3;
    public static final int BELOW_AND_FLOATING = 4;
    public static final int POINTING = 5;
    protected ChartData chartData;
    protected int[] visibleSamples;
    private Color[] bK;
    private Color[] bR;
    private Color[] bT;
    private Color[] bD;
    private Color[] bF;
    private Color bC;
    int bG;
    int by;
    int bz;
    boolean bB;
    boolean bA;
    private boolean[] bM;
    boolean bN;
    String[] bE;
    private int[] bP;
    int[] bI;
    private NumberFormat[] bH;
    private Vector bQ;
    private ChartSample bS;
    int bO;
    int bL;
    private ChartSample bU;
    private boolean bJ;

    public Chart() {
    }

    public Chart(int n) {
        this(1, n);
    }

    public Chart(int n, int n2) {
        this.gridRenderer = new GridRenderer(this);
        this.chartData = new ChartData(n, n2);
        this.bT = new Color[n2];
        this.bD = new Color[n];
        this.bF = new Color[n];
        this.bM = new boolean[n];
        this.visibleSamples = new int[2];
        this.visibleSamples[1] = 0x7FFFFFFA;
        this.setSampleCount(n2);
        this.setSeriesCount(n);
        this.bQ = new Vector();
        this.bH = new NumberFormat[n];
        this.bI = new int[n];
        this.bP = new int[this.getSeriesCount()];
        this.bO = -1;
        this.bL = -1;
        this.setSampleColors(null);
        this.setSampleColors2(null);
        this.bM = new boolean[this.getSeriesCount()];
        this.bE = null;
        this.bB = false;
        this.legendSelection = new boolean[n > 1 ? n : n2];
    }

    public void reset() {
        super.reset();
        this.bP = new int[this.getSeriesCount()];
        this.bO = -1;
        this.bL = -1;
        this.setSampleColors(null);
        this.setSampleColors2(null);
        this.bM = new boolean[this.getSeriesCount()];
        this.setSampleLabels(null);
        this.setSeriesLabels(null);
        this.bE = null;
        this.setSeriesCount(1);
        this.setSampleCount(1);
        this.setSampleValues(0, null);
        this.bB = false;
        this.bI = new int[this.getSeriesCount()];
    }

    public ChartRenderer getRenderer() {
        return super.getRenderer();
    }

    public void setChartData(ChartData chartData) {
        this.chartData = chartData;
        this.checkDataIntegrity();
        this.autoRepaint();
    }

    public ChartData getChartData() {
        return this.chartData;
    }

    public void setSamples(int n, ChartSample[] chartSampleArray) {
        this.chartData.setSamples(n, chartSampleArray);
        this.needRender = true;
        this.needChartCalculation = true;
        if (this.isValueLabelsOn(n) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.clearAngledLabelCache();
        }
        this.F.clear();
        this.autoRepaint();
    }

    public ChartSample[] getSamples(int n) {
        return this.chartData.getSamples(n);
    }

    public void setSample(int n, int n2, ChartSample chartSample) {
        this.chartData.setSample(n, n2, chartSample);
        this.needRender = true;
        this.needChartCalculation = true;
        if (this.isValueLabelsOn(n) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.clearAngledLabelCache();
        }
        this.autoRepaint();
    }

    public ChartSample getSample(int n, int n2) {
        return this.chartData.getSample(n, n2);
    }

    public ChartSample getSample(Object object) {
        return this.chartData.getSample(object);
    }

    public void setSampleValues(int n, double[] dArray) {
        this.chartData.setSampleValues(n, dArray);
        this.needRender = true;
        this.needChartCalculation = true;
        if (this.isValueLabelsOn(n) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.clearAngledLabelCache();
        }
        this.F.clear();
        this.autoRepaint();
    }

    public double[] getSampleValues(int n) {
        return this.chartData.getSampleValues(n);
    }

    public void setSampleValue(int n, int n2, double d) {
        this.chartData.setSampleValue(n, n2, d);
        this.needRender = true;
        this.needChartCalculation = true;
        if (this.isValueLabelsOn(n) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.clearAngledLabelCache();
        }
        this.autoRepaint();
    }

    public double getSampleValue(int n, int n2) {
        return this.chartData.getSampleValue(n, n2);
    }

    public int appendSample(int n, ChartSample chartSample, boolean bl) {
        int n2 = this.chartData.appendSample(n, chartSample, bl);
        this.checkDataIntegrity();
        this.needRender = true;
        this.needChartCalculation = true;
        if (this.isValueLabelsOn(n) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.clearAngledLabelCache();
        }
        this.autoRepaint();
        return n2;
    }

    public int appendSampleValue(int n, double d, boolean bl) {
        int n2 = this.getSampleCount();
        int n3 = this.chartData.appendSampleValue(n, d, bl);
        if (n3 >= this.visibleSamples[0] + this.visibleSamples[1]) {
            this.visibleSamples[1] = n3 - this.visibleSamples[0] + 1;
        }
        if (bl && n3 >= n2) {
            this.checkDataIntegrity();
        }
        this.needRender = true;
        this.needChartCalculation = true;
        if (this.isValueLabelsOn(n) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.clearAngledLabelCache();
        }
        this.autoRepaint();
        return n3;
    }

    public int appendSampleLabel(String string, boolean bl) {
        int n = this.chartData.appendSampleLabel(string, bl);
        this.needRender = true;
        this.needChartCalculation = true;
        this.needGraphBounds = true;
        this.autoRepaint();
        return n;
    }

    public void setSampleLabels(String[] stringArray) {
        this.chartData.setSampleLabels(stringArray);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        if (this.bB && (this.getLabelAngle("sampleLabelAngle") != 0 || this.getLabelAngle("barLabelAngle") != 0)) {
            this.clearAngledLabelCache();
        }
        this.F.clear();
        this.autoRepaint();
    }

    public String[] getSampleLabels() {
        return this.chartData.getSampleLabels();
    }

    public void setSampleLabel(int n, String string) {
        String string2 = this.getSampleLabel(n);
        this.chartData.setSampleLabel(n, string);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        if (this.bB && (this.getLabelAngle("sampleLabelAngle") != 0 || this.getLabelAngle("barLabelAngle") != 0)) {
            this.clearAngledLabelCache();
        }
        if (string2 != null) {
            Long l = new Long(string2.hashCode() + this.getFont("sampleLabelFont").hashCode());
            this.F.remove(l);
            l = new Long(string2.hashCode() + this.getFont("barLabelFont").hashCode());
            this.F.remove(l);
        }
        this.autoRepaint();
    }

    public String getSampleLabel(int n) {
        return this.chartData.getSampleLabel(n);
    }

    public void setSampleLabelColor(int n, Color color) {
        if (n >= 0) {
            if (n >= this.bT.length) {
                Color[] colorArray = new Color[n + 1];
                System.arraycopy(this.bT, 0, colorArray, 0, this.bT.length);
                this.bT = colorArray;
            }
        } else {
            throw new IllegalArgumentException("Invalid sample index: " + n);
        }
        this.bT[n] = color;
        this.autoRepaint();
        if (this.getSeriesCount() == 1) {
            this.legend.setLabelColor(n, color);
        }
    }

    public Color getSampleLabelColor(int n) {
        if (this.bT != null && n >= 0 && n < this.bT.length) {
            return this.bT[n];
        }
        return null;
    }

    public void setSampleLabelSelectionColor(Color color) {
        if (color != this.bC) {
            this.bC = color;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public Color getSampleLabelSelectionColor() {
        return this.bC;
    }

    public void setSampleLabelsOn(boolean bl) {
        if (this.bB != bl) {
            this.bB = bl;
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public boolean isSampleLabelsOn() {
        return this.bB;
    }

    public void setSampleLabelStyle(int n) {
        if (n == 5 && !this.chartType.equals("pie")) {
            n = 1;
        }
        if (this.bG != n) {
            this.bG = n;
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public int getSampleLabelStyle() {
        return this.bG;
    }

    public void setSeriesLabels(String[] stringArray) {
        this.chartData.setSeriesLabels(stringArray);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public String[] getSeriesLabels() {
        return this.chartData.getSeriesLabels();
    }

    public void setSeriesLabel(int n, String string) {
        this.chartData.setSeriesLabel(n, string);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public String getSeriesLabel(int n) {
        return this.chartData.getSeriesLabel(n);
    }

    public void setSeriesLabelColor(int n, Color color) {
        try {
            if (this.bD[n] != color) {
                this.bD[n] = color;
                this.needRender = true;
                this.autoRepaint();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series index: " + n);
        }
        if (this.getSeriesCount() > 1) {
            this.legend.setLabelColor(n, color);
        }
    }

    public Color getSeriesLabelColor(int n) {
        try {
            return this.bD[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series index: " + n);
        }
    }

    public void setSeriesLabelsOn(boolean bl) {
        if (this.bA != bl) {
            this.bA = bl;
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public boolean isSeriesLabelsOn() {
        return this.bA;
    }

    public void setSeriesLabelStyle(int n) {
        if (n == 5 && !this.chartType.equals("pie")) {
            n = 1;
        }
        if (this.by != n) {
            this.by = n;
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public int getSeriesLabelStyle() {
        return this.by;
    }

    public String[] getLegendLabels() {
        String[] stringArray = this.legend.getLegendLabels();
        if (stringArray != null) {
            return stringArray;
        }
        if (this.getSeriesCount() == 1) {
            return this.getSampleLabels();
        }
        return this.getSeriesLabels();
    }

    public Color getLegendColor(int n) {
        Color[] colorArray = this.legend.getLegendColors();
        if (colorArray != null && n >= 0 && n < colorArray.length && colorArray[n] != null) {
            return colorArray[n];
        }
        return this.getSampleColor(n);
    }

    public void setLegendBoxSizeAsFont(boolean bl) {
        this.legend.setLegendBoxSizeAsFont(bl);
    }

    public boolean isLegendBoxSizeAsFont() {
        return this.legend.isLegendBoxSizeAsFont();
    }

    public int getRangeCount() {
        return this.grid.getRangeCount();
    }

    public void setRange(int n, double d) {
        this.grid.setRange(n, d);
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public double getRange(int n) {
        return this.grid.getRange(n);
    }

    public void setRelativeRange(double d) {
        this.a(0, d);
    }

    void a(int n, double d) {
        this.grid.if(n, d);
    }

    public void setRelativeRange(double d, double d2) {
        this.setRelativeRange(0, d, d2);
    }

    public void setRelativeRange(int n, double d, double d2) {
        this.grid.setRelativeRange(n, d, d2);
    }

    public void setLowerRange(int n, double d) {
        this.grid.setLowerRange(n, d);
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public double getLowerRange(int n) {
        return this.grid.getLowerRange(n);
    }

    public void setLowerRelativeRange(double d) {
        this.if(0, d);
    }

    void if(int n, double d) {
        this.grid.a(n, d);
    }

    public void setLowerRelativeRange(double d, double d2) {
        this.setLowerRelativeRange(0, d, d2);
    }

    public void setLowerRelativeRange(int n, double d, double d2) {
        this.grid.setLowerRelativeRange(n, d, d2);
    }

    public void setCurrentRange(int n, double d) {
        this.grid.setCurrentRange(n, d);
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public double getCurrentRange(int n) {
        return this.grid.getCurrentRange(n);
    }

    public void setCurrentLowerRange(int n, double d) {
        this.grid.setCurrentLowerRange(n, d);
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public double getCurrentLowerRange(int n) {
        return this.grid.getCurrentLowerRange(n);
    }

    public void setRangeInterval(int n, double d) {
        this.grid.setRangeInterval(n, d);
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public double getRangeInterval(int n) {
        return this.grid.getRangeInterval(n);
    }

    public void setRangeOn(int n, boolean bl) {
        this.grid.setRangeOn(n, bl);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public boolean isRangeOn(int n) {
        return this.grid.isRangeOn(n);
    }

    public void setRangePosition(int n, int n2) {
        this.grid.setRangePosition(n, n2);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public int getRangePosition(int n) {
        return this.grid.getRangePosition(n);
    }

    public void setRangeColor(int n, Color color) {
        Color color2 = color != null ? color : this.getChartForeground();
        this.grid.setRangeColor(n, color2);
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getRangeColor(int n) {
        return this.grid.getRangeColor(n);
    }

    public void setRangeDecimalCount(int n, int n2) {
        this.grid.setRangeDecimalCount(n, n2);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public int getRangeDecimalCount(int n) {
        return this.grid.getRangeDecimalCount(n);
    }

    public void setSeriesRange(int n, int n2) {
        if (n >= 0 && n < this.getSeriesCount()) {
            this.bI[n] = Math.max(0, n2);
        }
    }

    public int getSeriesRange(int n) {
        if (n >= 0 && n < this.getSeriesCount() && n < this.bI.length) {
            return this.bI[n] < this.getRangeCount() ? this.bI[n] : this.getRangeCount() - 1;
        }
        return 0;
    }

    public void setValueLinesOn(boolean bl) {
        this.grid.setValueLinesOn(bl);
        this.needRender = true;
        this.autoRepaint();
    }

    public boolean isValueLinesOn() {
        return this.grid.isValueLinesOn();
    }

    public void setMaxValueLineCount(int n) {
        this.grid.setMaxValueLineCount(n);
        this.needRender = true;
        this.autoRepaint();
    }

    public int getMaxValueLineCount() {
        return this.grid.getMaxValueLineCount();
    }

    public void setDefaultGridLinesOn(boolean bl) {
        this.setDefaultGridLinesOn(bl, -1.0, -1.0);
    }

    public void setDefaultGridLinesOn(boolean bl, double d, double d2) {
        this.grid.setDefaultGridLinesOn(bl, d, d2);
        this.needRender = true;
        this.autoRepaint();
    }

    public boolean isDefaultGridLinesOn() {
        return this.grid.isDefaultGridLinesOn();
    }

    public void setGridLines(double[] dArray) {
        this.grid.setGridLines(dArray);
        this.needRender = true;
        this.autoRepaint();
    }

    public double[] getGridLines() {
        return this.grid.getGridLines();
    }

    public void setGridLine(int n, double d) {
        this.grid.setGridLine(n, d);
        this.needRender = true;
        this.autoRepaint();
    }

    public double getGridLine(int n) {
        return this.grid.getGridLine(n);
    }

    public void setSampleAxisRange(double d, double d2) {
        this.grid.setSampleAxisRange(d, d2);
        this.needRender = true;
        this.autoRepaint();
    }

    public void setDefaultGridLinesColor(Color color) {
        this.grid.setDefaultGridLinesColor(color);
        this.needRender = true;
        this.autoRepaint();
    }

    public void setGridLinesColor(Color color) {
        this.grid.setGridLinesColor(color);
        this.needRender = true;
        this.autoRepaint();
    }

    public void setGridLineColors(Color[] colorArray) {
        this.grid.setGridLineColors(colorArray);
        this.needRender = true;
        this.autoRepaint();
    }

    public Color[] getGridLineColors() {
        return this.grid.getGridLineColors();
    }

    public void setGridLineColor(int n, Color color) {
        this.grid.setGridLineColor(n, color);
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getGridLineColor(int n) {
        return this.grid.getGridLineColor(n);
    }

    public void setValueLinesColor(Color color) {
        this.grid.setValueLinesColor(color);
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getValueLinesColor() {
        return this.grid.getValueLinesColor();
    }

    public void setRangeLabelsOn(int n, boolean bl) {
        this.grid.setRangeLabelsOn(n, bl);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public boolean isRangeLabelsOn(int n) {
        return this.grid.isRangeLabelsOn(n);
    }

    public void setTargetValueLine(String string, double d, Color color, int n) {
        this.setTargetValueLine(string, d, color, n, 0);
    }

    public void setTargetValueLine(String string, double d, Color color, int n, int n2) {
        this.grid.setTargetValueLine(string, d, color, n, n2);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    String new(String string) {
        return this.grid.a(string);
    }

    public double getTargetValueLine(String string) {
        return this.grid.getTargetValueLine(string);
    }

    public void setTargetLabelsPosition(int n) {
        this.grid.setTargetLabelsPosition(n);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public int getTargetLabelsPosition() {
        return this.grid.getTargetLabelsPosition();
    }

    public void setRangeAdjusterOn(int n, boolean bl) {
        this.grid.setRangeAdjusterOn(n, bl);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public boolean isRangeAdjusterOn(int n) {
        return this.grid.isRangeAdjusterOn(n);
    }

    public void setRangeAdjusterPosition(int n) {
        this.grid.setRangeAdjusterPosition(n);
    }

    public int getRangeAdjusterPosition() {
        return this.grid.getRangeAdjusterPosition();
    }

    int a(int n) {
        return this.grid.a(n);
    }

    public void setRangeAdjusted(int n, int n2) {
        this.grid.setRangeAdjusted(n, n2);
    }

    public int getRangeAdjusted(int n) {
        return this.grid.getRangeAdjusted(n);
    }

    public void setSampleScrollerOn(boolean bl) {
        this.grid.setSampleScrollerOn(bl);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public boolean isSampleScrollerOn() {
        return this.grid.isSampleScrollerOn();
    }

    public void setSeriesCount(int n) {
        if (n != this.getSeriesCount()) {
            this.chartData.setSeriesCount(n);
            this.checkDataIntegrity();
            this.needRender = true;
            this.needChartCalculation = true;
            this.needGraphBounds = true;
            this.autoRepaint();
        }
    }

    public int getSeriesCount() {
        return this.chartData.getSeriesCount();
    }

    public void setSampleCount(int n) {
        if (n != this.getSampleCount()) {
            this.chartData.setSampleCount(n);
            this.checkDataIntegrity();
            this.visibleSamples[0] = 0;
            this.visibleSamples[1] = n;
            this.needRender = true;
            this.needChartCalculation = true;
            this.needGraphBounds = true;
            this.autoRepaint();
        }
    }

    public int getSampleCount() {
        return this.chartData.getSampleCount();
    }

    public boolean isSeriesEmpty(int n) {
        if (n >= this.getSeriesCount()) {
            return true;
        }
        double[] dArray = this.getSampleValues(n);
        if (dArray == null) {
            return true;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (new Double(dArray[i]).isNaN()) continue;
            return false;
        }
        return true;
    }

    public double getMaxValue(int n) {
        return this.chartData.getMaxValue(n);
    }

    protected double getHighestValue(int n) {
        int n2;
        n = Math.min(this.getRangeCount(), Math.max(0, n));
        int n3 = this.getSeriesCount();
        double d = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.getSeriesRange(n2) != n) continue;
            d = Math.max(this.getMaxValue(n2), d);
        }
        for (n2 = 0; n2 < this.overlayCharts.size(); ++n2) {
            Chart chart;
            if (!(this.overlayCharts.elementAt(n2) instanceof Chart) || (chart = (Chart)this.overlayCharts.elementAt(n2)) == null || chart.chartType.equals("pie")) continue;
            for (int i = 0; i < chart.getSeriesCount(); ++i) {
                if (chart.getSeriesRange(i) != n) continue;
                d = Math.max(chart.getMaxValue(i), d);
            }
        }
        return d;
    }

    public double getMinValue(int n) {
        return this.chartData.getMinValue(n);
    }

    protected double getLowestValue(int n) {
        int n2;
        n = Math.min(this.getRangeCount(), Math.max(0, n));
        int n3 = this.getSeriesCount();
        double d = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.getSeriesRange(n2) != n) continue;
            d = Math.min(this.getMinValue(n2), d);
        }
        for (n2 = 0; n2 < this.overlayCharts.size(); ++n2) {
            Chart chart;
            if (!(this.overlayCharts.elementAt(n2) instanceof Chart) || (chart = (Chart)this.overlayCharts.elementAt(n2)) == null || chart.chartType.equals("pie")) continue;
            for (int i = 0; i < chart.getSeriesCount(); ++i) {
                if (chart.getSeriesRange(i) != n) continue;
                d = Math.min(chart.getMinValue(i), d);
            }
        }
        return d;
    }

    public boolean hasDataChangedSince(long l) {
        if (this.chartData != null) {
            return this.chartData.hasChangedSince(l);
        }
        return false;
    }

    public void setVisibleSamples(int n, int n2) {
        this.setVisibleSamples(n, n2, true);
    }

    public void setVisibleSamples(int n, int n2, boolean bl) {
        int n3 = this.getSampleCount();
        if (n2 < 0) {
            n2 = n3;
        }
        n = Math.max(0, n);
        n = Math.min(n3 - 1, n);
        n2 = Math.max(1, n2);
        n2 = Math.min(n3 - n, n2);
        this.visibleSamples[0] = n = Math.min(n3 - n2, n);
        this.visibleSamples[1] = n2;
        if (this.grid.try) {
            int n4 = 0;
            int n5 = this.getSeriesCount();
            block0: for (int i = 0; i < n5; ++i) {
                ChartSample[] chartSampleArray = this.getSamples(i);
                if (chartSampleArray == null) continue;
                for (int j = chartSampleArray.length - 1; j >= 0; --j) {
                    if (chartSampleArray[j] == null || !chartSampleArray[j].hasValue()) continue;
                    n4 = Math.max(n4, j);
                    continue block0;
                }
            }
            this.gridRenderer.O = (double)(n3 - n2) / (double)n3;
            this.gridRenderer.N = 0.0;
        } else if (bl) {
            this.gridRenderer.O = (double)n / (double)n3;
            this.gridRenderer.N = (double)(n3 - n2 - n) / (double)n3;
        }
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public int[] getVisibleSamples() {
        return this.visibleSamples;
    }

    protected void checkDataIntegrity() {
        int n;
        Object[] objectArray;
        int n2;
        Object[] objectArray2;
        int n3 = this.chartData.getSeriesCount();
        if (n3 != this.bD.length) {
            objectArray2 = new Color[n3];
            n2 = Math.min(n3, this.bD.length);
            System.arraycopy(this.bD, 0, objectArray2, 0, n2);
            this.bD = objectArray2;
            objectArray = new int[n3];
            System.arraycopy(this.bI, 0, objectArray, 0, Math.min(this.bI.length, objectArray.length));
            this.bI = objectArray;
            int[] nArray = new int[n3];
            System.arraycopy(this.bP, 0, nArray, 0, Math.min(this.bP.length, nArray.length));
            this.bP = nArray;
            boolean[] blArray = new boolean[n3];
            System.arraycopy(this.bM, 0, blArray, 0, Math.min(this.bM.length, blArray.length));
            this.bM = blArray;
            Color[] colorArray = new Color[n3];
            n2 = Math.min(n3, this.bF.length);
            System.arraycopy(this.bF, 0, colorArray, 0, n2);
            this.bF = colorArray;
        }
        if (this.bH.length != n3) {
            objectArray2 = new NumberFormat[n3];
            n2 = Math.min(n3, this.bH.length);
            System.arraycopy(this.bH, 0, objectArray2, 0, n2);
            this.bH = objectArray2;
        }
        if (this.legendSelection.length != (objectArray2 = this.getLegendLabels()).length) {
            boolean[] blArray = new boolean[objectArray2.length];
            System.arraycopy(this.legendSelection, 0, blArray, 0, Math.min(this.legendSelection.length, blArray.length));
            this.legendSelection = blArray;
        }
        if ((n = this.chartData.getSampleCount()) != this.bT.length) {
            objectArray = new Color[n];
            int n4 = Math.min(n, this.bT.length);
            System.arraycopy(this.bT, 0, objectArray, 0, n4);
            this.bT = (Color[])objectArray;
        }
    }

    public void setSampleDecimalCount(int n, int n2) {
        if (n == -1) {
            for (int i = 0; i < this.bP.length; ++i) {
                this.bP[i] = n2;
            }
        } else if (n >= 0 && n < this.bP.length) {
            this.bP[n] = n2;
        }
        if (this.isValueLabelsOn(n) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.clearAngledLabelCache();
        }
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public int getSampleDecimalCount(int n) {
        int n2 = 0;
        if (n >= 0 && n < this.bP.length) {
            n2 = this.bP[n];
        }
        if (n2 == -1) {
            n2 = this.grid.getRangeDecimalCount(n);
        }
        return n2;
    }

    public void setValueLabelsOn(boolean bl) {
        this.setValueLabelsOn(-1, bl);
    }

    public void setValueLabelsOn(int n, boolean bl) {
        if (n >= 0 && n < this.bM.length) {
            this.bM[n] = bl;
        } else if (n == -1) {
            for (int i = 0; i < this.bM.length; ++i) {
                this.bM[i] = bl;
            }
        }
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public boolean isValueLabelsOn() {
        return this.isValueLabelsOn(-1);
    }

    public boolean isValueLabelsOn(int n) {
        if (n >= 0 && n < this.bM.length) {
            return this.bM[n];
        }
        if (n == -1) {
            for (int i = 0; i < this.bM.length; ++i) {
                if (!this.bM[i]) continue;
                return true;
            }
        }
        return false;
    }

    public void setValueLabelColor(int n, Color color) {
        try {
            if (this.bF[n] != color) {
                this.bF[n] = color;
                this.needRender = true;
                this.autoRepaint();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series index: " + n);
        }
    }

    public Color getValueLabelColor(int n) {
        try {
            return this.bF[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series index: " + n);
        }
    }

    public void setValueLabelStyle(int n) {
        if (n == 5 && !this.chartType.equals("pie")) {
            n = 1;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                if (n == this.bz) break;
                this.bz = n;
                this.needRender = true;
                this.needGraphBounds = true;
                this.needChartCalculation = true;
                this.autoRepaint();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid valueLabelStyle: " + n);
            }
        }
    }

    public int getValueLabelStyle() {
        return this.bz;
    }

    public void displayFloatingLabel(int n, int n2) {
        this.renderer.ak = n2;
        this.renderer.ab = n;
        this.repaint();
    }

    public void set3DDepth(int n) {
        if (n >= -1 && n < Short.MAX_VALUE) {
            this.H = n;
            if (n >= 0) {
                this.depth3dPoint.x = this.H;
                this.depth3dPoint.y = -this.H;
            }
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public void setThreeDDepth(int n) {
        this.set3DDepth(n);
    }

    public int get3DDepth() {
        return this.H;
    }

    public int getThreeDDepth() {
        return this.get3DDepth();
    }

    public void setSampleColors(Color[] colorArray) {
        if (colorArray != null) {
            this.bK = colorArray;
        } else {
            this.bK = new Color[DEFAULT_SAMPLE_COLORS.length];
            System.arraycopy(DEFAULT_SAMPLE_COLORS, 0, this.bK, 0, this.bK.length);
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public Color[] getSampleColors() {
        return this.bK;
    }

    public void setSampleColor(int n, Color color) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative index");
        }
        if (n >= this.bK.length) {
            Color[] colorArray = new Color[this.bK.length + 20];
            System.arraycopy(this.bK, 0, colorArray, 0, this.bK.length);
            this.bK = colorArray;
        }
        this.bK[n] = color;
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getSampleColor(int n) {
        Color color = DEFAULT_SAMPLE_COLORS[n % DEFAULT_SAMPLE_COLORS.length];
        if (this.bK != null && this.bK.length > 0 && (color = this.bK[n % this.bK.length]) == null) {
            int n2 = Math.min(this.bK.length, DEFAULT_SAMPLE_COLORS.length);
            color = DEFAULT_SAMPLE_COLORS[n % n2];
        }
        return color;
    }

    public void setSampleColors2(Color[] colorArray) {
        this.bR = colorArray != null ? colorArray : new Color[DEFAULT_SAMPLE_COLORS.length];
        this.needRender = true;
        this.autoRepaint();
    }

    public Color[] getSampleColors2() {
        return this.bR;
    }

    public void setSampleColor2(int n, Color color) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative index");
        }
        this.bR[n % this.bR.length] = color;
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getSampleColor2(int n) {
        Color color = null;
        if (this.bR != null && this.bR.length > 0) {
            color = this.bR[n % this.bR.length];
        }
        return color;
    }

    public void setSelection(int n, int n2, boolean bl) {
        this.setSelection(n, n2, bl, false, true);
    }

    public void setSelection(int n, int n2, boolean bl, boolean bl2) {
        this.setSelection(n, n2, bl, false, bl2);
    }

    public void setSelection(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        this.chartData.a(n, n2, bl, bl2);
        this.bO = -1;
        this.bL = -1;
        for (int i = 0; i < this.legendSelection.length; ++i) {
            this.legendSelection[i] = false;
        }
        if (n2 == -1 && n == -1 && this.bS != null) {
            if (bl3) {
                this.a(this, 2, this.bS);
            }
            this.bS = null;
        } else if (n2 == -1 && n >= 0) {
            ChartSample chartSample = new ChartSample(n2);
            chartSample.setSeries(n);
            String[] stringArray = this.legend.getLegendLabels();
            if (stringArray != null && n < stringArray.length && stringArray[n] != null) {
                chartSample.setLabel(stringArray[n]);
            } else if (n >= 0 && n < this.getSeriesCount()) {
                chartSample.setLabel(this.getSeriesLabel(n));
            }
            if (bl) {
                this.bL = n;
                if ((this.bS == null || chartSample.getSeries() != this.bS.getSeries()) && bl3 && this.bS != null) {
                    this.a(this, 2, this.bS);
                }
                if (bl3) {
                    this.a(this, 1, chartSample);
                }
                this.bS = chartSample;
            } else {
                if (bl3) {
                    this.a(this, 2, chartSample);
                }
                if (chartSample == this.bS) {
                    this.bS = null;
                }
            }
        } else if (n2 >= 0 && n >= 0) {
            ChartSample chartSample = null;
            Chart chart = null;
            if (n < this.getSeriesCount() && n2 < this.getSampleCount()) {
                chartSample = this.getSample(n, n2);
                chart = this;
            }
            if (bl) {
                this.bO = n2;
                this.bL = n;
                if (bl3 && this.bS != null && chartSample != this.bS) {
                    this.a(this, 2, this.bS);
                }
                if (bl3) {
                    this.a(chart, 1, chartSample);
                }
                this.bS = chartSample;
            } else {
                if (bl3) {
                    this.a(this, 2, chartSample);
                }
                if (chartSample == this.bS) {
                    this.bS = null;
                }
            }
        }
        if (this.getSeriesCount() > 1 || this.u) {
            if (n >= 0 && n < this.legendSelection.length) {
                this.legendSelection[n] = bl;
            }
        } else if (n2 >= 0 && n2 < this.legendSelection.length) {
            this.legendSelection[n2] = bl;
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public boolean isSelected(int n, int n2) {
        return this.chartData.isSelected(n, n2);
    }

    public Object[] getSelectedObjects() {
        int n;
        int n2 = this.getSeriesCount();
        int n3 = this.getSampleCount();
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < n3; ++n) {
                if (!this.isSelected(i, n)) continue;
                ++n4;
            }
        }
        if (n4 > 0) {
            Object[] objectArray = new Object[n4];
            n = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    if (!this.isSelected(i, j) || n >= objectArray.length) continue;
                    objectArray[n++] = this.getSample(i, j);
                }
            }
            return objectArray;
        }
        return null;
    }

    public int getLastSelectedSample() {
        return this.bO;
    }

    public int getLastSelectedSeries() {
        return this.bL;
    }

    public void setRangeFormatter(int n, NumberFormat numberFormat) {
        this.grid.setRangeFormatter(n, numberFormat);
        this.needRender = true;
        this.autoRepaint();
    }

    public NumberFormat getRangeFormatter(int n) {
        return this.grid.getRangeFormatter(n);
    }

    public void setSeriesFormatter(int n, NumberFormat numberFormat) {
        if (n >= 0 && n < this.getSeriesCount()) {
            this.bH[n] = numberFormat;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public NumberFormat getSeriesFormatter(int n) {
        if (n >= 0 && n < this.getSeriesCount()) {
            return this.bH[n];
        }
        return null;
    }

    public String formatSeriesNumber(int n, double d) {
        NumberFormat numberFormat = this.getSeriesFormatter(n);
        int n2 = this.getSampleDecimalCount(n);
        if (numberFormat != null) {
            numberFormat.setMaximumFractionDigits(n2);
            numberFormat.setMinimumFractionDigits(n2);
            StringBuffer stringBuffer = numberFormat.format(d, new StringBuffer(), new FieldPosition(1));
            if (stringBuffer != null) {
                return stringBuffer.toString();
            }
            return null;
        }
        return this.formatNumber(d, n2);
    }

    public String formatRangeNumber(int n, double d) {
        String string = this.grid.formatRangeNumber(n, d);
        if (string != null) {
            return string;
        }
        int n2 = d != 0.0 ? this.getRangeDecimalCount(n) : 0;
        return this.formatNumber(d, n2);
    }

    public void setGridAdjustmentOn(int n, boolean bl) {
        this.grid.setGridAdjustmentOn(n, bl);
    }

    public boolean isGridAdjustmentOn(int n) {
        return this.grid.isGridAdjustmentOn(n);
    }

    public double getLeftScrollerFactor() {
        return this.gridRenderer.O;
    }

    public double getRightScrollerFactor() {
        return this.gridRenderer.N;
    }

    public void addItemListener(ItemListener itemListener) {
        if (itemListener != null) {
            this.bQ.addElement(itemListener);
        }
    }

    public void removeItemListener(ItemListener itemListener) {
        if (itemListener != null && this.bQ != null) {
            this.bQ.removeElement(itemListener);
        }
    }

    public Vector getListeners() {
        return this.bQ;
    }

    public static String[] getStringValues(String string, String string2) {
        int n;
        int n2;
        String[] stringArray;
        if (string2 == null) {
            string2 = ",";
        }
        if (string == null) {
            stringArray = new String[]{};
        } else if (string.indexOf(string2) == -1) {
            stringArray = new String[]{string};
        } else {
            int n3 = string.length();
            n2 = string2.length();
            n = 1;
            int n4 = 0;
            while (n4 >= 0) {
                if ((n4 = string.indexOf(string2, n4)) != -1 && n4 != n3 - n2) {
                    n4 += n2;
                    ++n;
                    continue;
                }
                if (n4 != n3 - n2) continue;
                n4 = -1;
                ++n;
            }
            stringArray = new String[n];
            int n5 = 0;
            for (int i = 0; i < n; ++i) {
                int n6;
                boolean bl = false;
                if (n5 < n3 && string.charAt(n5) == string2.charAt(0)) {
                    bl = true;
                    for (n6 = 1; n6 < n2; ++n6) {
                        if (string.charAt(n5 + n6) == string2.charAt(n6)) continue;
                        bl = false;
                    }
                }
                if (bl) {
                    stringArray[i] = "";
                    n5 += n2;
                    continue;
                }
                n6 = string.indexOf(string2, n5 + 1);
                String string3 = n6 > 0 ? string.substring(n5, n6) : string.substring(n5);
                stringArray[i] = string3 = Chart.int(string3);
                n5 = n6 + n2;
            }
        }
        String[] stringArray2 = new String[stringArray.length];
        n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray2[n2] == null) {
                stringArray2[n2] = stringArray[n];
            } else {
                String string4 = stringArray2[n2].substring(0, stringArray2[n2].length() - 1);
                stringArray2[n2] = string2.equals("\n") ? string4 + "\\n" + string2 + stringArray[n] : string4 + string2 + stringArray[n];
            }
            if (stringArray2[n2].length() != 0 && stringArray2[n2].charAt(stringArray2[n2].length() - 1) == '\\') continue;
            ++n2;
        }
        stringArray = new String[n2];
        System.arraycopy(stringArray2, 0, stringArray, 0, n2);
        return stringArray;
    }

    static String int(String string) {
        int n;
        if (string == null) {
            return null;
        }
        if (string.indexOf("\n") == -1) {
            return string.trim();
        }
        int n2 = string.length();
        for (n = 0; n < n2 && string.charAt(n) <= ' ' && string.charAt(n) != '\n'; ++n) {
        }
        while (n < n2 && string.charAt(n2 - 1) <= ' ' && string.charAt(n2 - 1) != '\n') {
            --n2;
        }
        return n > 0 || n2 < string.length() ? string.substring(n, n2) : string;
    }

    public static Hashtable getAngledLabelCache() {
        return Renderer.getAngledLabelCache();
    }

    public static int hashCode(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        char[] cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        for (int i = n3; i > 0; --i) {
            n = n * 37 + cArray[n2++];
        }
        return n;
    }

    protected String constructLabel(int n, int n2, boolean bl, int n3) {
        return this.a(n, n2, n3, bl, null);
    }

    protected String constructLabel(int n, int n2, int n3, boolean bl, String string) {
        if (string != null) {
            return this.a(n, n2, n3, bl, string);
        }
        return this.constructLabel(n, n2, bl, n3);
    }

    private String a(int n, int n2, int n3, boolean bl, String string) {
        String string2;
        if (this.getSample(n, n2) == null || !this.getSample(n, n2).hasValue()) {
            return null;
        }
        if (n < 0 || n >= this.getSeriesCount() || n2 < 0 || n2 >= this.getSampleCount()) {
            return "";
        }
        boolean bl2 = bl && this.bA && this.by == n3;
        int n4 = this.bG;
        if (this.bG == 4) {
            n4 = 3;
        }
        boolean bl3 = (this.chartType.equals("bar") && this.bN && n3 == 3 || this.bB) && n4 == n3;
        boolean bl4 = this.isValueLabelsOn(n) && this.bz == n3;
        String string3 = this.getComplexLabelSeparator();
        if (string3 == null) {
            string3 = n3 == 3 ? " : " : ":";
        }
        String string4 = "";
        if (bl2 && (string2 = this.getSeriesLabel(n)) != null) {
            string4 = string4 + string2;
            if (!string2.endsWith("\n") && bl3 && this.getSampleLabel(n2) != null) {
                string4 = string4 + string3;
            }
        }
        if (bl3 && this.getSampleLabel(n2) != null) {
            string4 = string4 + this.getSampleLabel(n2);
        }
        if (bl4) {
            String string5;
            string2 = this.getLabel("valueLabelPrefix_" + n);
            if (string2 == null) {
                string2 = this.getLabel("valueLabelPrefix");
            }
            if ((string5 = this.getLabel("valueLabelPostfix_" + n)) == null) {
                string5 = this.getLabel("valueLabelPostfix");
            }
            if (string4.length() > 0) {
                String string6 = this.formatSeriesNumber(n, this.getSampleValue(n, n2));
                string6 = string2 != null ? string2 + string6 : string6;
                String string7 = string6 = string5 != null ? string6 + string5 : string6;
                string4 = string4.endsWith("\n") || string6.startsWith("\n") ? string4 + string6 : string4 + string3 + string6;
            } else {
                string4 = this.formatSeriesNumber(n, this.getSampleValue(n, n2));
                string4 = string2 != null ? string2 + string4 : string4;
                String string8 = string4 = string5 != null ? string4 + string5 : string4;
            }
        }
        if (string != null) {
            if (!string4.equals("") && !string4.endsWith("\n")) {
                string4 = string4 + string3;
            }
            string4 = string4 + string;
        }
        return string4;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent == null) {
            return;
        }
        if (this.H > -1) {
            this.depth3dPoint.x = this.H;
            this.depth3dPoint.y = -this.H;
        }
        int n = 0;
        int n2 = 0;
        if (aWTEvent instanceof MouseEvent) {
            n = ((MouseEvent)aWTEvent).getX();
            n2 = ((MouseEvent)aWTEvent).getY();
        }
        Dimension dimension = this.getSize();
        if (aWTEvent instanceof MouseEvent) {
            this.old_cursor = this.new_cursor;
            this.new_cursor = Renderer.DEFAULT_CURSOR;
            if (this.gridRenderer != null) {
                this.gridRenderer.do(this.grid, aWTEvent);
                this.gridRenderer.if(this.grid, aWTEvent);
            }
            if (this.legendRenderer != null) {
                this.legendRenderer.handleLegendScrollers(aWTEvent);
            }
            if (this.isZoomOn() && this.dragged_label == null) {
                this.gridRenderer.a(this.grid, aWTEvent);
            }
            this.handleCustomLabels(aWTEvent);
        }
        if (this.renderer == null) {
            return;
        }
        ChartSample chartSample = this.checkSelection(new Point(n, n2));
        switch (aWTEvent.getID()) {
            case 503: 
            case 506: {
                if (chartSample == this.bU) break;
                if (chartSample == null || this.bU == null || chartSample.getIndex() != -1) {
                    this.repaint();
                } else if (chartSample.getSeries() != this.bU.getSeries()) {
                    this.repaint();
                }
                this.bU = chartSample;
            }
        }
        long l = System.currentTimeMillis();
        switch (aWTEvent.getID()) {
            case 502: {
                if (this.o && this.gridRenderer.getGraphBounds() != null) {
                    int n3;
                    GenericChart genericChart;
                    int n4;
                    for (n4 = 0; n4 < this.overlayCharts.size(); ++n4) {
                        genericChart = (GenericChart)this.overlayCharts.elementAt(n4);
                        ChartRenderer chartRenderer = (ChartRenderer)this.renderer.overlayRenderers.elementAt(n4);
                        if (chartRenderer == null || !this.isOverlayChartOn(n4) || genericChart instanceof Chart) continue;
                        ChartSample chartSample2 = chartRenderer.checkSelection(new Point(n, n2));
                        if (chartSample2 != null) {
                            int n5 = chartSample2.getSeries();
                            if (n5 <= -1) continue;
                            genericChart.setSelection(n5, chartSample2.getIndex(), true, true, true);
                            this.setSelection(-1, -1, false, true, true);
                            this.repaint();
                            this.o = true;
                            this.dragged_label = null;
                            return;
                        }
                        genericChart.setSelection(-1, -1, false, true, true);
                        this.repaint();
                    }
                    this.setSelection(-1, -1, false, true, true);
                    for (n4 = 0; n4 < this.overlayCharts.size(); ++n4) {
                        genericChart = (GenericChart)this.overlayCharts.elementAt(n4);
                        genericChart.setSelection(-1, -1, false, true, true);
                    }
                    this.repaint();
                    ChartSample chartSample3 = this.checkSelection(new Point(n, n2));
                    if (chartSample3 != null && (n3 = chartSample3.getSeries()) >= -1) {
                        try {
                            if (this.renderer.ai == null) {
                                this.setSelection(Math.max(n3, 0), chartSample3.getIndex(), true, true, true);
                            } else {
                                this.renderer.ai.setSelection(Math.max(n3, 0), chartSample3.getIndex(), true, true, true);
                            }
                            this.repaint();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
                this.o = true;
                this.dragged_label = null;
                break;
            }
            case 505: {
                this.renderer.ak = -1;
                this.renderer.ab = -1;
                this.repaint();
                break;
            }
            case 101: {
                for (int i = 0; i < this.overlayCharts.size(); ++i) {
                    GenericChart genericChart = (GenericChart)this.overlayCharts.elementAt(i);
                    if (genericChart == null || !this.isOverlayChartOn(i)) continue;
                    genericChart.needChartCalculation = true;
                }
                this.needRender = true;
                this.needGraphBounds = true;
                this.needChartCalculation = true;
                if (aWTEvent.getSource() != this) break;
                Graphics graphics = this.getGraphics();
                if (!this.bJ && graphics != null && dimension.width > 0 && dimension.height > 0) {
                    this.paint(graphics);
                    this.bJ = true;
                    this.needRender = true;
                    this.needGraphBounds = true;
                    this.needChartCalculation = true;
                    break;
                }
                if (graphics == null || dimension.width <= 0 || dimension.height <= 0) break;
                this.repaint();
            }
        }
        if (this.new_cursor != this.old_cursor) {
            this.setCursor(this.new_cursor);
        }
        super.processEvent(aWTEvent);
    }

    void a(Chart chart, int n, Object object) {
        if (this.k != null && this.k instanceof Chart) {
            ((Chart)this.k).a(chart, n, object);
        }
        if (this.bQ != null) {
            ItemEvent itemEvent = new ItemEvent(chart, 701, object, n);
            Enumeration enumeration = this.bQ.elements();
            while (enumeration.hasMoreElements()) {
                ((ItemListener)enumeration.nextElement()).itemStateChanged(itemEvent);
            }
        }
    }

    protected void calculateChartData(Rectangle rectangle, Rectangle rectangle2) {
        this.renderer.calculateChartData(rectangle, rectangle2);
    }

    protected void renderData(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        this.renderer.renderData(graphics, rectangle, rectangle2);
    }

    public Rectangle getDataBounds(Rectangle rectangle) {
        return this.gridRenderer.getDataBounds(this.grid);
    }

    protected ChartSample checkSelection(Point point) {
        return this.renderer.checkSelection(point);
    }

    protected void paintGrid(Graphics graphics, Rectangle rectangle) {
        this.gridRenderer.a(graphics, this.grid, rectangle);
    }

    public Dimension getLabelSize(String string, FontMetrics fontMetrics) {
        return this.renderer.getLabelSize(string, fontMetrics);
    }

    public static void main(String[] stringArray) {
        System.out.println("EasyCharts " + Chart.getVersion());
        System.out.println("Copyright 1998-2009, ObjectPlanet, Inc.");
    }
}

