$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Citrix.XenApp.Commands
$Global:ErrorActionPreference="SilentlyContinue"
$CONFIG_INFO_SEPARATOR = ">"
$admins = Get-XAAdministrator
Write-Host "Citrix Administrator(s) Settings"

foreach($admin in $admins)
{
	Write-Host "#Admin - start"
	$a = "Admin Name : " + $admin.AdministratorName
	Write-Host $a

	if($admin.AdministratorType -eq "Full")
	{
		Write-Host "Type : Full Administration"
	}
	if($admin.AdministratorType -eq "Custom")
	{
		Write-Host "Type : Custom"
	}
	if($admin.AdministratorType -eq "View")
	{
		Write-Host "Type : View Only"
	}

	if($admin.Enabled -eq "Enabled")
	{
		Write-Host "Admin Account : Enabled"
	}
	else
	{
		Write-Host "Admin Account : Disabled"
	}
	
	Write-Host "Farm privileges : " $admin.FarmPrivileges
	Write-Host "Folder privileges : " $admin.FolderPrivileges
	Write-Host  "#Admin - end"
}
Remove-PSSnapin Citrix.XenApp.Commands

