Param
(
    [Parameter(Mandatory=$true)] [int]$id ,
    [Parameter(Mandatory=$true)] [int]$trimToMB,
    [Parameter(Mandatory=$false)] [string]$excludedProcesses
)
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[CmdletBinding()]

[string[]] $DefaultIgnoredProcesses = @('cmd', 'dwm', 'explorer','conhost','taskhostw','winlogon','powershell', 'java' ,'js', 'vm-jsn','jsn', 'tomcat')


$ErrorActionPreference = 'SilentlyContinue'

[int]$thePid = -1
[int]$theSessionId = -1
[array]$processes = @()



$theSessionId = $id
$processes = @( Get-Process -ErrorAction SilentlyContinue | Where-Object { $_.SessionId -eq $theSessionId } )

if( ! $processes -or ! $processes.Count )
{
	Write-Host "Failed to get any processes for session $theSessionId"
	break;
}



[int]$maxWorkingSet = $trimToMB * 1MB

Add-Type -Debug:$false @'
using System;
using System.Diagnostics;
using System.Runtime.InteropServices;

namespace PInvoke.Win32
{
  
    public static class Memory
    {
        [DllImport("kernel32.dll", SetLastError=true)]
        public static extern bool SetProcessWorkingSetSizeEx( IntPtr hProcess, int min, int max , int flags );
        [DllImport("kernel32.dll", SetLastError=true)]
        public static extern bool GetProcessWorkingSetSizeEx( IntPtr hProcess, ref int min, ref int max , ref int flags );
    }
}
'@

[int]$thisMinimumWorkingSet = -1 
[int]$thisMaximumWorkingSet = -1 
[int]$thisFlags = 0
[int]$counter = 0

$Success = [System.Collections.Generic.List[string]]@()
$NoPrcsHandle = [System.Collections.Generic.List[string]]@()
$Excluded = [System.Collections.Generic.List[string]]@()

$FldToGtWrkngStInfo = [System.Collections.Generic.List[string]]@()	
$Failed = [System.Collections.Generic.List[string]]@()
	
$listOfExcludedProcesses = $excludedProcesses -split "/"
ForEach( $process in $processes )
{
	if(($DefaultIgnoredProcesses -like $($process.ProcessName)) -or (($listOfExcludedProcesses -split "/") -like $($process.ProcessName)))
	{
		$ExcludedVal = "$($Process.ProcessName)($($Process.Id))"
		if($ExcludedVal.Length -gt 0)
		{
			[void]$Excluded.add($ExcludedVal)
		}
        continue
    }
    else
    {       
        if( ! $process.Handle )
        {
			$NoPrcsHandleVal = "$($process.ProcessName)($($process.Id))"
			if($NoPrcsHandleVal.Length -gt 0)
			{
				[void]$NoPrcsHandle.add($NoPrcsHandleVal)
			}
        }
        else
        {
            ## https://msdn.microsoft.com/en-us/library/windows/desktop/ms683227(v=vs.85).aspx 
            [bool]$result = [PInvoke.Win32.Memory]::GetProcessWorkingSetSizeEx( $process.Handle, [ref]$thisMinimumWorkingSet , [ref]$thisMaximumWorkingSet , [ref]$thisFlags );$LastError = [ComponentModel.Win32Exception][Runtime.InteropServices.Marshal]::GetLastWin32Error()

            if( ! $result )
            {     
				$FldToGtWrkngStInfoVal = "{0}({1}). Error details: $($LastError.Message)" -f $process.ProcessName , $process.Id
				if($FldToGtWrkngStInfoVal.Length -gt 0)
				{
					[void]$FldToGtWrkngStInfo.add($FldToGtWrkngStInfoVal)
				}

                $thisMinimumWorkingSet = 1KB ## will be set to the minimum by the call
            }
            else
            {
                [int]$originalMaxWorkingSet = 0
                if( $maxWorkingSet -le 0 )
                {
                    $thisMaximumWorkingSet = $thisMinimumWorkingSet = -1 ## emptying the working set
                }
                else
                {
                    $originalMaxWorkingSet = $thisMaximumWorkingSet
                    $thisMaximumWorkingSet = $maxWorkingSet ## not completely emptying & can grow above this , assuming it doesn't have a hard WS limit flag set
                }
   
                ## see https://msdn.microsoft.com/en-us/library/windows/desktop/ms686237(v=vs.85).aspx
                $result = [PInvoke.Win32.Memory]::SetProcessWorkingSetSizeEx( $process.Handle , $thisMinimumWorkingSet , $thisMaximumWorkingSet , $thisFlags );$LastError = [ComponentModel.Win32Exception][Runtime.InteropServices.Marshal]::GetLastWin32Error()
				
				$prcsWithId = "{0}({1}). Error details: $($LastError.Message)"  -f $process.ProcessName , $process.Id
              
				if( ! $result )
                { 
					[void]$Failed.add($prcsWithId )
                }
                else
                {
                	$prcsWithId = "{0}({1})" -f $process.ProcessName , $process.Id
					[void]$Success.add($prcsWithId )
                }
            }
        }
    }
}


Function CnvrtLstToStr
{
 param(
        [parameter(Mandatory=$true)]$PrcsList
        )

    $PrcsStr = ""
    try
	{
        if($PrcsList -ne $null -and $PrcsList.Count -gt 0)
        {
            $PrcsArray = $PrcsList.ToArray() | Sort-Object

            if($PrcsArray -ne $null -and $PrcsArray.Count -gt 0)
            {

                $PrcsStr = ($PrcsArray -join ", ")

            }
         }
     }
     catch
     {
        $PrcsStr = ""
     }

    return $PrcsStr
}

if($Excluded -ne $null -and $Excluded.Count -gt 0)
{
	Write-Host ( "Excluded from memory trim in session $theSessionId for the list of processes in the format of ""ProcessName(PID)"" as follows: $(CnvrtLstToStr($Excluded)). ")
}
if($Success -ne $null -and $Success.Count -gt 0)
{
	Write-Host ( "Successfully trimmed the working set memory in session $theSessionId for the list of processes in the format of ""ProcessName(PID)"" as follows: $(CnvrtLstToStr($Success)).") 
}
if($NoPrcsHandle -ne $null -and $NoPrcsHandle.Count -gt 0)
{
	$NoPrcsHandleprcs = CnvrtLstToStr($NoPrcsHandle)

	$Host.UI.WriteErrorLine("No process handle in session $theSessionId for the list of processes in the format of ""ProcessName(PID)"" as follows: $NoPrcsHandleprcs. ") 
}
if($FldToGtWrkngStInfo -ne $null -and $FldToGtWrkngStInfo.Count -gt 0)
{
	$FldToGtWrkngStInfoPrcs = CnvrtLstToStr($FldToGtWrkngStInfo)
		
	$Host.UI.WriteErrorLine( "Failed to get the working set info in session $theSessionId for the list of processes in the format of ""ProcessName(PID)"" as follows: $FldToGtWrkngStInfoPrcs. ") 
}
if($Failed -ne $null -and $Failed.Count -gt 0)
{
	$FailedPrcs = CnvrtLstToStr($Failed)

	$Host.UI.WriteErrorLine("Failed to trim the working set memory in session $theSessionId for the list of processes in the format of ""ProcessName(PID)"" as follows: $FailedPrcs. ")
}



