$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$computer = $env:COMPUTERNAME
$namespace = "ROOT\citrix\VdaParameters"
$classname = "CitrixVdaParameters"

$xenapp = Get-WmiObject -Class $classname -ComputerName $computer -Namespace $namespace
if($xenapp)
{
              write-host "PropertyName","Value" -separator "^^"
              write-host "FarmName", $xenapp.FarmName -separator "^^"
              write-host "RegisteredTime", $xenapp.RegisteredTime -separator "^^"
              write-host "LicenseServerName", $xenapp.LicenseServerName -separator "^^"
              write-host "LicenseServerport", $xenapp.LicenseServerport -separator "^^"
              write-host "LicensingModel", $xenapp.LicensingModel -separator "^^"
              write-host "ProductEdition", $xenapp.ProductEdition -separator "^^"
              write-host "ProductLicenseName", $xenapp.ProductLicenseName -separator "^^"
              write-host "RegisteredDdcFqdn", $xenapp.RegisteredDdcFqdn -separator "^^"
              write-host "SiteDiscoveryMethod", $xenapp.SiteDiscoveryMethod -separator "^^"
              write-host "AgentOperationMode", $xenapp.AgentOperationMode -separator "^^"
              write-host "AssignmentType", $xenapp.AssignmentType -separator "^^"
              write-host "BrokeredSessionMode", $xenapp.BrokeredSessionMode -separator "^^"
              write-host "BrokerVersion", $xenapp.BrokerVersion -separator "^^"
              write-host "DesktopCatalogName", $xenapp.DesktopCatalogName -separator "^^"
              write-host "DesktopKind", $xenapp.DesktopKind -separator "^^"
              write-host "HasValidLicense", $xenapp.HasValidLicense -separator "^^"
              write-host "HypervisorConnectionName", $xenapp.HypervisorConnectionName -separator "^^"
              write-host "ImageOutOfDate", $xenapp.ImageOutOfDate -separator "^^"
              write-host "InHighAvailabilityMode", $xenapp.InHighAvailabilityMode -separator "^^"
              
}
