$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$argsCount = $args.length
if ($argsCount -eq 0)
{
	Write-Host "Please supply Admin Server"
	break
}

$adminServer = $args[0]
$Global:ErrorActionPreference="SilentlyContinue"
$adminConn = New-XdAdminConnection -Name $adminServer
$xenFarm = Get-XdFarm -AdminConnection $adminConn
$dgroups = Get-XdDesktopGroup 

Write-Host "Virtual Desktops"
Write-Host "---------------"
if($dgroups -ne $null)
{
	foreach ($i in $dgroups)
	{
		$vds = Get-XdVirtualDesktop -Group $i
		if($vds -ne $null)
		{
			foreach ($vd in $vds)
			{
				$vdPowerState = "-";
				if ($vd.PowerState.length -gt 0)
				{
					$vdPowerState = $vd.PowerState;
				}
				Write-Host($vd.GroupId,$vd.Name,$vd.State,$vdPowerState,$vd.MaintenanceMode,$vd.GroupName) -Separator ";"	
			}
		}	
	}
}
Write-Host "Sessions"
Write-Host "----------"
$sessions = Get-XdSession
if($sessions -ne $null)
{
	foreach ($session in $sessions)
	{
		$UserName = "Unknown";
		if ($session.UserName.length -gt 0)
		{
			$UserName = $session.UserName;
		}
		Write-Host($session.GroupId,$session.DesktopName,$UserName,$session.StartTime) -Separator ";"
	}
}


Disconnect-XdAdminConnection -AdminConnection $adminConn	