$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

#Load VMware View Snapin to powershell v2 - Starts

Set-Variable product_name "VMware View PowerCLI" -scope Private
Set-Variable view_snapin_name "VMware.View.Broker" -scope Private
$ViewSnapinLoaded = Get-PSSnapin | Where { $_.Name -eq $view_snapin_name }
if(!$ViewSnapinLoaded)
{
	# Install or Re-register View Cmdlets
	$installpath = (get-itemproperty "HKLM:\Software\VMware, Inc.\VMware VDM").ServerInstallPath
	$BuildVersion = (get-itemproperty "HKLM:\Software\VMware, Inc.\VMware VDM").BuildNumber
	$os=Get-WMIObject win32_operatingsystem | select OSArchitecture
	if ($os.OSArchitecture -like "64*")
	{
		$path="$env:windir\Microsoft.NET\Framework64\v2.0.50727\installUtil.exe"
        if(![System.IO.File]::Exists($path))
		{             
			$path="$env:windir\Microsoft.NET\Framework64\v4.0.30319\installUtil.exe"
			if(![System.IO.File]::Exists($path))
			{
     			Write-Host "Either .NET v2 or v4 frameworks are not installed"
				return
			}
		}
	}
	else
	{
		$path="$env:windir\Microsoft.NET\Framework\v2.0.50727\installUtil.exe"
		if(![System.IO.File]::Exists($path))
		{ 
			$path="$env:windir\Microsoft.NET\Framework\v4.0.30319\installUtil.exe"
			if(![System.IO.File]::Exists($path))
			{
				Write-Host "Either .NET v2 or v4 frameworks are not installed"
				return
			}
		}
	}
	set-alias installUtil $path
	$null = (installUtil ($installpath  + "\bin\PowershellServiceCmdlets.dll"))
}

Remove-Variable product_name -scope Private
Remove-Variable view_snapin_name -scope Private

#Load VMware View Snapin to powershell v2 - Ends


Add-pssnapin "VMware.View.Broker"
#$Global:ErrorActionPreference="SilentlyContinue"
$hostname = $env:computername
$hostname = "DomainMonitor." + $hostname
$LDAPPath = 'LDAP://localhost:389/OU=Servers,DC=vdi,DC=vmware,DC=int'
$LDAPEntry = New-Object DirectoryServices.DirectoryEntry $LDAPPath
$Selector = New-Object DirectoryServices.DirectorySearcher
$Selector.SearchRoot = $LDAPEntry

$LDAPPath1 = 'LDAP://localhost:389/OU=Server Groups,DC=vdi,DC=vmware,DC=int'
$LDAPEntry1 = New-Object DirectoryServices.DirectoryEntry $LDAPPath1
$Selector1 = New-Object DirectoryServices.DirectorySearcher
$Selector1.SearchRoot = $LDAPEntry1

Write-Host "Connection Brokers"
Write-Host "-------------------"
$connBrokers = Get-ConnectionBroker  | select broker_id,activation,lastBackup,ldapBackupFrequency
if($connBrokers -ne $null)
{
	foreach($connBroker in $connBrokers)
	{
		Write-Host ($connBroker.broker_id,$connBroker.activation,
		$connBroker.lastBackup,$connBroker.ldapBackupFrequency ) -Separator "#"
	}
}
else
{
	Write-Host "- #"  -nonewline;
}

$VCs = @{}
$LDAPPath2 = 'LDAP://localhost:389/OU=VirtualCenter,OU=Properties,DC=vdi,DC=vmware,DC=int'
$LDAPEntry2 = New-Object DirectoryServices.DirectoryEntry $LDAPPath2
$Selector2 = New-Object DirectoryServices.DirectorySearcher
$Selector2.SearchRoot = $LDAPEntry2
$Selector2.Filter = "(objectClass=pae-VirtualCenter)"
$VCData = $Selector2.FindAll()
foreach($VC in $VCData)
{
    $attribute = $VC.Properties
	$dn = $attribute.'distinguishedname'
    $vcurl = $attribute.'pae-vcurl'
    $dnStr = [String]$dn
    $VCs.Add($dnStr.Trim(),$vcurl)    
}
$LDAPEntry2.Close()
$VCs.Keys

<##
logic for findig the current connection server is master or replica and ignore the session monitoring data
#$vdm = Get-ItemProperty "HKLM:\SOFTWARE\VMware, Inc.\VMware VDM" 
#$isStandardVDM = $vdm.ServerInstanceType
##>
$isStandardVDM = $False
$ldapaddr = 'LDAP://localhost:389/DC=vdi,DC=vmware,DC=int'
$ldapopen = [adsi]$ldapaddr
$objectCategoryarr = $ldapopen.'objectCategory' -split ','
#$objectCategoryarr.count
if($objectCategoryarr.count -eq 4)
{
    $schemaguid = $objectCategoryarr[3]
    $schemaConfigurationaddr= 'LDAP://localhost:389/CN=Schema,CN=Configuration,'+$schemaguid
    #$schemaConfigurationaddr
    $schemaConfigurationOpen = [adsi]$schemaConfigurationaddr
    #$schemaConfigurationOpen.fSMORoleOwner
    $fsmoRoleOwnerAddr = $schemaConfigurationOpen.fSMORoleOwner -split ","
    if($fsmoRoleOwnerAddr.count -gt 2)
    {
        $masterarr= $fsmoRoleOwnerAddr[1].split('`$')
        if($masterarr.count -eq 2)
        {
            $localhost = "CN=$env:computername"
            #$localhost
            #$masterarr[0]
            $isStandardVDM = $localhost -eq $masterarr[0]
        }
    }
}
$isStandardVDM

Write-Host "Pools"
Write-Host "--------"
if($isStandardVDM -eq $True)
{
	$PoolNames = @{}
	$LDAPPath2 = 'LDAP://localhost:389/OU=Applications,DC=vdi,DC=vmware,DC=int'
	$LDAPEntry2 = New-Object DirectoryServices.DirectoryEntry $LDAPPath2
	$Selector2 = New-Object DirectoryServices.DirectorySearcher
	$Selector2.SearchRoot = $LDAPEntry2
	$Selector2.Filter = "(objectClass=pae-DesktopApplication)"
	$poolsFromAdam = $Selector2.FindAll()
	foreach($p in $poolsFromAdam)
	{
		$attribute = $p.Properties
		$cn = $attribute.'cn'
	    $server = $attribute.'pae-servers'
	    $PoolNames.Add($cn,$server[0])
	}

	foreach($p in $PoolNames.Keys)
	{
		$headroomcount = -5
		$maximumcount = -5
		$minimumcount = -5
		try
		{
			$id = $p
			$ServerPool = $PoolNames.Item($p)
			$Selector1.Filter = "(distinguishedName="+$ServerPool+ ")"
			$poolsFromAdam = $Selector1.FindAll()
			$poolAdam = $poolsFromAdam[0]
			$attribute = $poolAdam.Properties
			$displayName = $attribute.'pae-displayname'
			$Hosts  = $attribute.'pae-memberdn'
			$disabled = $attribute.'pae-disabled'
			if($disabled[0] -eq 0) { $enabled = "true"} else {$enabled = "false"}
			$Type = $attribute.'pae-serverpooltype'
			$vcDN = $attribute.'pae-vcdn'
			if($vcDN -ne $null)
			{
				$vcDNStr = [String]$vcDN
				$vcServerName = $VCs.Item($vcDNStr.Trim())
			}
			else
			{
				$vcServerName = $null
			}
			if($Type -ne $null)
			{
				if($Type -eq 8)
				{
					$poolType = "TerminalService"
					$deliveryModel = "TerminalService"
					$desktopSource = "TerminalService"
				}
				elseif($Type -eq 5)
				{
					$poolType = "ManualVCPersistent"
					$deliveryModel = "Manual"
					$desktopSource = "VC"
				}
				elseif($Type -eq 4)
				{
					$poolType = "SviNonPersistent"
					$deliveryModel = "Provisioned"
					$desktopSource = "SVI"
				}
				elseif($Type -eq 18)
				{
					$poolType = "InstantClone"
					$deliveryModel = "Provisioned"
					$desktopSource = "SVI"
				} 
				elseif($Type -eq 12)
				{
					$poolType = "DedicatedVCPersistent"
					$deliveryModel = "Dedicated"
					$desktopSource = "VC"
				}
			}
		}
		catch
		{
			$deliveryModel = $null
			$desktopSource = $null
			$vcServerName = $null
			$poolType = $null   
		}
		$headroomcount = $attribute.'pae-vmheadroomcount'
		$maximumcount = $attribute.'pae-vmmaximumcount'
		$minimumcount = $attribute.'pae-vmminimumcount'

		if($headroomcount -eq $null)
		{
			$headroomcount = -5
		}
		if($maximumcount -eq $null)
		{
			$maximumcount = -5
		}
		if($minimumcount -eq $null)
		{
			$minimumcount = -5
		}
		if($displayName -eq $null -or $displayName.length -eq 0)
		{
			$displayName = "-"
		}
				
		if($enabled -eq $null -or $enabled.length -eq 0)
		{
			$enabled = "-"
		}
		if($deliveryModel -eq $null -or $deliveryModel.length -eq 0)
		{
			$deliveryModel = "-"
		}
		if($desktopSource -eq $null -or $desktopSource.length -eq 0)
		{
			$desktopSource = "-"
		}
		if($vcServerName -eq $null -or $vcServerName.length -eq 0)
		{
			$vcServerName = "-"
		}
		if($poolType -eq $null -or $poolType.length -eq 0)
		{
			$poolType = "-"
		}
		Write-Host ($id, $displayName,$enabled, $deliveryModel, $desktopSource,$vcServerName, $poolType, $headroomcount, $maximumcount, $minimumcount) -Separator "#"
		
		$poolentitlements = Get-PoolEntitlement -pool_id $id  | select displayName
		Write-Host "poolentitlement starts ^!^" -nonewline;
		if($poolentitlements -ne $null)
		{
			foreach($poolentitlement in $poolentitlements)
			{
				Write-Host ($poolentitlement.displayName) ("^!^")  -nonewline;
			}
		}
		else
		{
			Write-Host "- ^!^"  -nonewline;
		}
		Write-Host "poolentitlement stops"
		if($desktopSource -eq "VC" -or $desktopSource -eq "SVI")
		{
			$desktops = Get-DesktopVM -pool_id $id
			Write-Host "Desktops starts ^!^" -nonewline;
			if($desktops -ne $null)
			{
				foreach($desktop in $desktops)
				{
					$Name = $desktop.Name
					
					if($Name -eq $null -or $Name.length -eq 0)
					{
						$Name = "-"
					}
					$GuestFullName = $desktop.GuestFullName
					if($GuestFullName -eq $null -or $GuestFullName.length -eq 0)
					{
						$GuestFullName = "-"
					}
					$HostName = $desktop.HostName
					if($HostName -eq $null -or $HostName.length -eq 0)
					{
						$HostName = "-"
					}
					$IPAddress = $desktop.IPAddress
					if($IPAddress -eq $null -or $IPAddress.length -eq 0)
					{
						$IPAddress = "-"
					}
					$isInPool = $desktop.isInPool
					if($isInPool -eq $null -or $isInPool.length -eq 0)
					{
						$isInPool = "-"
					}
					$machine_id = $desktop.machine_id
					if($machine_id -eq $null -or $machine_id.length -eq 0)
					{
						$machine_id = "-"
					}
					if($machine_id -ne "-")
					{
						$Selector.Filter = "(&(objectClass=pae-VM)(cn="+$machine_id+ "))"
						$dk = $Selector.FindAll()
						$attribute = $dk[0].Properties
						$Path = $attribute.'pae-vmpath'
						$ServerGroup = $attribute.'pae-memberdnof'
						
					}
					else
					{
						$Path = "-"
						$ServerGroup = "-"
					}
					if($Path -eq $null -or $Path.length -eq 0)
					{
						$Path = "-"
					}
					Write-Host ($Name,$Path, $GuestFullName, $HostName, $IPAddress, $isInPool, $id, $machine_id,$ServerGroup, "^!^") -Separator "#" -nonewline;
				}
			}
			else
			{
				Write-Host "- ^!^" -nonewline;
			}
		}
		elseif($desktopSource -eq "TerminalService")
		{
			Write-Host "Desktops starts ^!^" -nonewline;
			$servers = $Hosts.Split(";")
			if($servers)
			{
				foreach($server in $servers)
				{
					$sid = $server.Split(",")[0]
					$sid = $sid.substring(3)
					$Selector.Filter = "(&(objectClass=pae-RDSHost)(cn=" + $sid + "))"
					$desktop = $Selector.FindAll()
					if($desktop -ne $null)
					{
						$attribute = $desktop[0].Properties
						$ServerGroup = $attribute.'pae-memberdnof'
						$Name = $attribute.'pae-displayname'
						$Enabled = $attribute.'pae-disabled'
						if($Enabled -eq $null -or $Enabled.length -eq 0)
						{
							$Enabled = 0	#0 means Enabled   1 means Disabled		
						}
						$MaxConns = $attribute.'pae-optmaximumsessions'
						if($MaxConns -eq $null -or $MaxConns.length -eq 0)
						{
							$MaxConns = 150
						}
						if($Name -eq $null -or $Name.length -eq 0)
						{
							$Name = "-"
						}
						$Path = "-"
						$GuestFullName = "-"
						$IPAddress = "-"
						$isInPool = "-"
						$machine_id = $sid
						$HostName = "-"
						Write-Host ($Name,$Path, $GuestFullName, $HostName, $IPAddress, $isInPool, $id, $machine_id,$ServerGroup,$Enabled,$Status,$MaxConns, "^!^") -Separator "#" -nonewline;
					}	
				}
			}
			else
			{
				Write-Host "- ^!^" -nonewline;
			}
		}
		
		Write-Host "Desktops stops"
		Write-Host "~#~"
	}

	Write-Host "PoolsUsage"
	Write-Host "----------"

	#$localSessions = Get-LocalSession  | select userName,pool_id,startTime,DNSName,duration,state,protocol,session_id
	write-Host "localsessions starts ^!^" -nonewline;
	<# if($localSessions -ne $null)
	{
		foreach($localSession in $localSessions)
		{
			$userName = $localSession.userName
			if($userName -eq $null -or $userName.length -eq 0)
			{
				$userName = "-"
			}
			$startTime = $localSession.startTime
			if($startTime -eq $null -or $startTime.length -eq 0)
			{
				$startTime = "-"
			}
			$DNSName = $localSession.DNSName
			if($DNSName -eq $null -or $DNSName.length -eq 0)
			{
				$DNSName = "-"
			}
			$duration = $localSession.duration
			if($duration -eq $null -or $duration.length -eq 0)
			{
				$duration = "-"
			}
			$state = $localSession.state
			if($state -eq $null -or $state.length -eq 0)
			{
				$state = "-"
			}

			$protocol = $localSession.protocol
			if($protocol -eq $null -or $protocol.length -eq 0)
			{
				$protocol = "-"
			}
			$session_id = $localSession.session_id
			if($session_id -eq $null -or $session_id.length -eq 0)
			{
				$session_id = "-"
			}
			$pool_id = $session_id
			Write-Host ($userName, $pool_id,$startTime,$DNSName, $duration,$state, $protocol,$session_id,"^!^") -Separator "#" -nonewline;
		}
	}
	else
	{
		Write-Host "- ^!^" -nonewline;
	} #>
	Write-Host "localsessions stops"

	$remoteSessions = Get-RemoteSession  | select userName,pool_id,startTime,DNSName,duration,state,protocol,session_id
	Write-Host "remotesessions starts ^!^" -nonewline;
	if($remoteSessions -ne $null)
	{
		foreach($remoteSession in $remoteSessions)
		{
			$userName = $remoteSession.userName
			if($userName -eq $null -or $userName.length -eq 0)
			{
				$userName = "-"
			}
			$DNSName = $remoteSession.DNSName
			if($DNSName -eq $null -or $DNSName.length -eq 0)
			{
				$DNSName = "-"
			}
			$startTime = $remoteSession.startTime
			if($startTime -eq $null -or $startTime.length -eq 0)
			{
				$startTime = "-"
			}
			$duration = $remoteSession.duration
			if($duration -eq $null -or $duration.length -eq 0)
			{
				$duration = "-"
			}
			$state = $remoteSession.state
			if($state -eq $null -or $state.length -eq 0)
			{
				$state = "-"
			}
			$protocol = $remoteSession.protocol
			if($protocol -eq $null -or $protocol.length -eq 0)
			{
				$protocol = "-"
			}
			$session_id = $remoteSession.session_id
			if($session_id -eq $null -or $session_id.length -eq 0)
			{
				$session_id = "-"
			}
			$pool_id = $session_id
			Write-Host ($userName,$pool_id,$startTime, $DNSName, $duration, $state, $protocol, $session_id,"^!^") -Separator "#" -nonewline;
		}
	}
	else
	{
		Write-Host "- ^!^" -nonewline;
	}
	write-Host "remotesesions stops"
	Write-Host 
}

Write-Host "Domain monitor"
Write-Host "---------------"
$domains = Get-Monitor -monitor DomainMonitor -monitor_id $env:computername
if($domains -ne $null)
{
	write-host($domains.domains)
}

Write-Host 

Write-Host "VC monitor"
Write-Host "-----------"
$vcs = Get-Monitor -monitor VCMonitor
if($vcs -ne $null)
{
	foreach($vc in $vcs)
	{
		Write-Host ($vc.URL,$vc.State) -Separator "^"
	}
}
Write-Host

Write-Host "DB monitor"
Write-Host "-------------"

$db = Get-monitor -monitor DBMonitor
Write-Host ($db.Server,$db.DBName,$db.State) -Separator "#"

Write-Host

Write-Host "License"
Write-Host "---------"

$license = Get-license
$license | fl

Write-Host

Write-Host "RDS Applications"
Write-Host "------------------"
if($isStandardVDM -eq $True)
{
	$LDAPPath1 = 'LDAP://localhost:389/OU=Applications,DC=vdi,DC=vmware,DC=int'
	$LDAPEntry1 = New-Object DirectoryServices.DirectoryEntry $LDAPPath1
	$Selector1 = New-Object DirectoryServices.DirectorySearcher
	$Selector1.SearchRoot = $LDAPEntry1
	$Selector1.Filter = "(objectClass=pae-RDSApplication)"
	$RDSApps = $Selector1.FindAll()
	if($RDSApps -ne $null)
	{
		foreach($RDSApp in $RDSApps)
		{
			$attribute = $RDSApp.Properties
			$RDSAppName = $attribute.'pae-displayname'
			$Pool = $attribute.'pae-servers'
			$Disabled = $attribute.'pae-disabled'
			Write-host($RDSAppName,$Pool,$Disabled) -Separator "#"
		}
	}
}

Write-Host

Write-Host "Farm"
Write-Host "--------"
if($isStandardVDM -eq $True)
{

	$LDAPPath1 = 'LDAP://localhost:389/OU=Server Groups,DC=vdi,DC=vmware,DC=int'
	$LDAPEntry1 = New-Object DirectoryServices.DirectoryEntry $LDAPPath1
	$Selector1 = New-Object DirectoryServices.DirectorySearcher
	$Selector1.SearchRoot = $LDAPEntry1
	$Selector1.Filter = "(objectClass=pae-ServerPool)"
	$Farms = $Selector1.FindAll()
	if($Farms -ne $null)
	{
		foreach($Farm in $Farms)
		{
			$attribute = $Farm.Properties
			$ServerType = $attribute.'pae-serverpooltype'
			if($ServerType -eq 8)
			{
				$FarmName = $attribute.'pae-displayname'
				$Status = $attribute.'pae-disabled'
				Write-host($FarmName,$Status) -Separator "#"
			}
		}
	}
}

Remove-Pssnapin "VMware.View.Broker"
