$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"

# the permissions we care about (those that will allow modification of files in the target folder)
	$ModifiableRights = @('ChangePermissions', 'CreateFiles', 'FullControl', 'Modify', 'TakeOwnership', 'Write', 'WriteData')
# this is used to cast the above modifiable rights to a comparable class
	$Type = [Security.AccessControl.FileSystemRights]
                                    
$Services = get-wmiobject win32_service | select name,displayname, state,PathName, Status, StartMode

if($null -ne $Services)
{
	foreach($Service in $Services)
	{
		$PathName = $Service.PathName
		$Tokens = $PathName -Split (" -")
		if($Tokens.Count -eq 2)
		{
			$ImagePath = $Tokens[0]
			$Tokens = $ImagePath -Split (" /")
			$ImagePath = $Tokens[0]
			if($ImagePath.StartsWith('"'))
			{
				$ImagePath = $ImagePath.substring(1,$ImagePath.Length - 1)
			}
			
			if($ImagePath.EndsWith('"'))
			{
				$ImagePath = $ImagePath.substring(0,$ImagePath.Length - 1)
			}
		}
		else
		{
			$ImagePath = $PathName
		}
				
		$DisplayName = $Service.DisplayName
		$Status = $Service.Status
		$StartMode = $Service.StartMode
		try 
		{
			# use a try/catch because of the weird behavior of Get-ACL
			$DirectoryAcl = Get-Acl -Path $ImagePath -ErrorAction Stop
			
			$idntfdMdfblRights = ""

			ForEach ($Access in $DirectoryAcl.Access)
			{
				# check for the target user identities and 'Allow'
				if ( ($Access.IdentityReference -match 'NT AUTHORITY\\Authenticated Users|BUILTIN\\Users|Everyone') -and ($Access.AccessControlType -eq 'Allow') )
				{
					ForEach ($ModifiableRight in $ModifiableRights) 
					{
						# cast the right as [Security.AccessControl.FileSystemRights]
						$Right = $ModifiableRight -as $Type
						# check if any of the modifiable rights are present
						if (($Access.FileSystemRights -band $Right) -eq $Right)
						{
							if($idntfdMdfblRights -ne "")
							{
								$idntfdMdfblRights = $idntfdMdfblRights + "," + $ModifiableRight
							}
							else
							{
								$idntfdMdfblRights = $idntfdMdfblRights + $ModifiableRight
							}
						}
					}
				}						
			}
			if($idntfdMdfblRights -ne "")
			{
				Write-Host "insecureWndwsSrvc", $DisplayName, $PathName, $StartMode  -Separator ";"
			}
		}
		catch 
		{
			Write-Verbose "Error retrieving ACL for: $ImagePath"
		}
		
		$TempTrunctdPath = $PathName.substring(0, $PathName.ToLower().IndexOf(".exe"))
		
		if(($TempTrunctdPath.IndexOf(" ") -gt -1) -and (-Not ($TempTrunctdPath.startswith(""""))))
		{
			Write-Host "unqtdWndwsSrvc", $DisplayName, $PathName, $StartMode -Separator ";"
		}
	}
}


