﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$ErrorActionPreference="SilentlyContinue"
if($args.count -le 1)
{
    Write-Host "Please provide the value for ExpiringInDays and Thumbprint as arguments"
    exit
}
$ExpiringInDays = $args[0]
$ThumbPrint = $args[1]
$isCompareThumpPrint = $false
if ($ThumbPrint -ine 'none')
{
    $isCompareThumpPrint = $true
}
#$certs = get-childitem -Path cert: -recurse -ExpiringInDays $ExpiringInDays
$certs = get-childitem -Path cert: -recurse
$line = ''
foreach ($cert in $certs)
{
    if ($isCompareThumpPrint)
    {
        if ($cert.Thumbprint -ine $ThumbPrint)
        {
            continue
        }
    }
    if($cert.NotAfter -gt (get-date))
    {
        $RemainingExpiryDays = ($cert.NotAfter).subtract([DateTime]::Now).days
        if($RemainingExpiryDays -lt $ExpiringInDays)
        {
            $line = ''
            $line = $line + $cert.Subject + '#~#' + $cert.Issuer + '#~#' + $cert.Thumbprint + '#~#' +$cert.NotAfter + '#~#' + $RemainingExpiryDays + 
                    '#~#' + $cert.Version + '#~#' + $cert.PSParentPath + '#~#' + $cert.FriendlyName
            write-host $line
        }    
    }
 
}    

