﻿<#
    /*****************************************************************************
    Author            :       Prabaharan.T
    Purpose           :       used to get the site information from SPO site collections
    Created           :       31/01/2018
    Modified By       : 

#>
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue
clear

$TestInputs=$args
$domain=$TestInputs[0]
$userName=$TestInputs[1]
$password=Eg-O365Dcr -EncStr $TestInputs[2]
$proxycrdls=($TestInputs[3]).ToString().Split("#")
$proxyUsr=$proxycrdls[0]
$proxyPass=Eg-O365Dcr -EncStr $proxycrdls[1]
$proxyserverip=$TestInputs[4]
$reportingname=$TestInputs[5]
$appDetails=$TestInputs[6]
if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}

if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
$am_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'AM' -Type $encTyp
$pm_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'PM' -Type $encTyp

$CultureDateTimeFormat = (Get-Culture).DateTimeFormat
$DateFormat = $CultureDateTimeFormat.ShortDatePattern
$TimeFormat = $CultureDateTimeFormat.LongTimePattern
$DateTimeFormat = "$DateFormat $TimeFormat"
$hrfrmt=((Get-Date).ToUniversalTime()).ToString('tt').Trim()
if($hrfrmt -eq $null -or $hrfrmt -eq ''){$hrfrmt='none'}

$rptPath=$egurkhaPath+'/agent/SPO/'+$reportingname
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$fileName= $egurkhaPath+'/agent/SPO/'+$reportingname+'/sitecollections'+ $timenow +".csv"

if(!(Test-Path -Path $rptPath )){
    $null = New-Item -ItemType directory -Path $rptPath
}

if(Test-Path -Path $fileName ){
    #$null = Remove-Item $fileName
    $fileRead=Get-ChildItem -Path $rptPath |Where-Object {$_.Name -like 'sitecollections*.csv'}| Sort-Object LastWriteTime -Descending | Select Name -First 1
    foreach($file in $fileRead){
        $fileName=([String]$file.Name).Trim()
        if([System.IO.File]::Exists(($rptPath+$fileName)) -eq 'True'){
            Remove-Item $rptPath$fileName -Force
        }
    }
}

if(!(Test-Path -Path $fileName)){
    $null = New-Item $fileName    
}

Try{
    $url = 'https://'+$domain+'-admin.sharepoint.com'
    if(!$proxyserverip.Contains('none')){
        $proxyserver='http://'+$proxyserverip
        [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
        if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
            $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
            [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
            [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
        }
     }

     if($appDetails -and $appDetails -ne 'none'){
            Connect-PnPOnline -url $url -clientId $clientId -Tenant $tenantName -Thumbprint $thumbPrint
    }else{
    	$cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)    
	    Connect-SPOService -Url $url -Credential $cred 
    }
    
    if($appDetails -and $appDetails -ne 'none'){
        $null = Get-PnPTenantSite -Detailed | select Url,Status,Template,Title,Owner,WebsCount,StorageQuota,StorageUsageCurrent,ResourceUsageCurrent,ResourceUsageAverage,ResourceQuota,ResourceQuotaWarningLevel,LockState,LockIssue,LastContentModifiedDate | Export-Csv $fileName -Encoding $encTyp -NoTypeInformation -Append
    }else{
    	$null = Get-SPOSite -Limit ALL | select Url,Status,Template,Title,Owner,WebsCount,StorageQuota,StorageUsageCurrent,ResourceUsageCurrent,ResourceUsageAverage,ResourceQuota,ResourceQuotaWarningLevel,LockState,LockIssue,LastContentModifiedDate | Export-Csv $fileName -Encoding $encTyp -NoTypeInformation -Append
    }
    $spoSites= import-csv $fileName -Encoding $encTyp
    foreach($site in $spoSites){
        # Here  we exclude the groups site collections
        if($site.Template -ne 'GROUP#0'){
            $spoURL=$site.Url
            try{
                $tempdate=($site.LastContentModifiedDate).toString().trim()
                if($tempdate -ne $null -and $tempdate -ne ''){
                    $LastContentModifiedDate =Eg-ParseExact -dateStr $tempdate -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                }
                #$LastContentModifiedDate= [DateTime]::ParseExact($tempdate,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
                $LastContentModifiedDate1=(([datetime]$LastContentModifiedDate).ToString('MM/dd/yyyy HH:mm:ss tt')).toString()       
            }catch{
                $exceptionmsg=($_.Exception.Message)+($_.ScriptStackTrace) 
                Write-Error "Error Occured in SPOGetSites in date type casting -- $exceptionmsg "
                $LastContentModifiedDate1=$site.LastContentModifiedDate
            }
            Write-Host 'SpoSiteME~'$spoURL '~'$site.Status'~'$site.Template'~'$site.Title'~'$site.Owner'~'$site.WebsCount'~'$site.StorageQuota'~'$site.StorageUsageCurrent'~'$site.ResourceUsageCurrent'~'$site.ResourceUsageAverage'~'$site.ResourceQuota'~'$site.ResourceQuotaWarningLevel'~'$site.LockState'~'$site.LockIssue'~'$LastContentModifiedDate1
        }
    }
}
Catch{
    $exceptionmsg=($_.Exception.Message)+($_.ScriptStackTrace) 
    Write-Error "Error Occured in SPOSiteCollections -- $exceptionmsg "
    $fileRead=Get-ChildItem -Path $rptPath |Where-Object {$_.Name -like 'sitecollections*.csv'}| Sort-Object LastWriteTime -Descending | Select Name -First 1
    foreach($file in $fileRead){
        $fileName=([String]$file.Name).Trim()
        if([System.IO.File]::Exists(($rptPath+$fileName)) -eq 'True'){
            $null = Remove-Item $rptPath$fileName -Force
        }
    }
}
if(Test-Path -Path $fileName ){
    $null = Remove-Item $fileName
}