﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

$OpenWebPartDD = @{}
$OpenWebPartTypeCount = @{}
$OpenWebPartsCount = @{}
$CloseWebPartsCount = @{}
$SPWebApps = Get-SPWebApplication

foreach ($SPWebApp in $SPWebApps)
{
    foreach ($SPSite in $SPWebApp.Sites)
    {

    #Get all Webs
    $webs = Get-SPSite $SPSite.URL| Get-SPWeb -Limit All 
     
    #Iterate through webs
            foreach ($web in $webs) 
            {
            #Get All Pages from site's Root into $AllPages Array
            $AllPages = @($web.Files | Where-Object {$_.Name -match ".aspx"})
 
            #Search All Folders for Pages
            foreach ($folder in $web.Folders)
                {
                   #Add the pages to $AllPages Array
                   $AllPages += @($folder.Files | Where-Object {$_.Name -match ".aspx"})
                }
  
             #Iterate through all pages
             foreach($Page in $AllPages)
              {
                 $webPartManager = $web.GetLimitedWebPartManager($Page.ServerRelativeUrl, [System.Web.UI.WebControls.WebParts.PersonalizationScope]::Shared)
  
    
                 # Array to Hold all Web Parts 
               
                            foreach ($webPart in $webPartManager.WebParts)
                            {

                             $WEBAPPNAME=$SPWebApp.name
                             $SITEURL=$($web.site.Url)
                             $RELATIVEURL=$($Page.ServerRelativeUrl)
                             $TITLE=$webpart.Title
                             $ISCLOSED=$($webpart.IsClosed).ToString()
                             $TYPE=$($webpart.GetType().ToString())
                              
                             if( ($WEBAPPNAME.Length -eq 0) -or ($WEBAPPNAME -eq $null) )
                             {
                                $WEBAPPNAME="-"
                             }

                             if( ($SITEURL.Length -eq 0) -or ($SITEURL -eq $null) )
                             {
                                $SITEURL="-"
                             }

                             if( ($RELATIVEURL.Length -eq 0) -or ($RELATIVEURL -eq $null) )
                             {
                                $RELATIVEURL="-"
                             }
                              
                             if( ($TITLE.Length -eq 0) -or ($TITLE -eq $null) )
                             {
                                $TITLE="-"
                             }

                             if( ($ISCLOSED.Length -eq 0) -or ($ISCLOSED -eq $null) )
                             {
                                $ISCLOSED="-"
                             }

                             if( ($TYPE.Length -eq 0) -or ($TYPE -eq $null) )
                             {
                                $TYPE="-"
                             }

                             
                             #The below "IF" condition is to validate the OPEN WEB PARTS.

                                    if($ISCLOSED -eq "False")
                                    { 
                                       
                                       # To count the open web parts per web app
                                       # Web Application as Key and Count of open webparts as Value in HashMap, so we take the measure from "$OpenWebPartsCount" HashMap for Measure count.
                                       if($OpenWebPartsCount.ContainsKey($WEBAPPNAME))
                                       {
                                            $integer=$OpenWebPartsCount.Get_Item($WEBAPPNAME)
                                            $a = $integer -as [int]
                                            $a=$a+1
                                            $OpenWebPartsCount.Set_Item($WEBAPPNAME, $a)

                                       }
                                       else
                                       {
                                            $newOpenCount=1
                                            $OpenWebPartsCount.Add($WEBAPPNAME, $newOpenCount)

                                       }

                                       # To sort the top 10 open web parts DD based on higher number of webparts per page
                                       <#

                                       # Here the below logic to sort open web parts based upon highest number of Open webparts per page.
                                       # HashMap "$OpenWebPartDD" takes the Web Application as key and HashMap as value.
                                       # Inner HashMap takes PAGE URL as key and count of web parts per PAGE as value
                                       
                                       #>
                                        $URL=$SITEURL+$RELATIVEURL
                                       
                                            if($OpenWebPartDD.ContainsKey($WEBAPPNAME))
                                            {
                                                
                                                $hasURL=$OpenWebPartDD.Get_Item($WEBAPPNAME)

                                                if($hasURL.ContainsKey($URL))
                                                {
                                                    $integer=$hasURL.Get_Item($URL)
                                                    $b = $integer -as [int]
                                                    $b=$b+1
                                                    $hasURL.Set_Item($URL, $b)
                                                }
                                                else
                                                {
                                                    $new=1
                                                    $hasURL.Add($URL, $new)
                                                }

                                                
                                              
                                            }
                                            else
                                            {
                                                $new=1
                                                $OpenWebPartURL = @{}
                                                $OpenWebPartURL.Add($URL, $new)
                                                $OpenWebPartDD.Add($WEBAPPNAME, $OpenWebPartURL)
                                            }
                                                  
                                                  
                                           # To count the total number of web parts type per page   
                                           <#

                                           # Here the below logic to get TYPES of Open webparts per page.
                                           # HashMap "$OpenWebPartTypeCount" takes the Web Application as key and HashMap as value.
                                           # Inner HashMap takes PAGE URL as key and ArrayList as value.
                                           # ArrayList take the types of webParts as the element.
                                                # If the page that has similar webpart type we are not adding it to ArrayList.
                                                # If the page that has different webpart type we are adding it to ArrayList, so later we get the size of the Arraylist as the TYPE of WebPart TYPE.
                                            #>                                    
                                           if($OpenWebPartTypeCount.ContainsKey($WEBAPPNAME))         
                                           {
                                               
                                                $UniqueWebPartsURL=$OpenWebPartTypeCount.Get_Item($WEBAPPNAME)

                                                if($UniqueWebPartsURL.Contains($URL))
                                                {
                                                    $UniqueWebParts=$UniqueWebPartsURL.Get_Item($URL)
                                                    if(!$UniqueWebParts.Contains($TYPE))
                                                    {
                                                        $UniqueWebParts.add($TYPE)
                                                    }

                                                }
                                                else
                                                {
                                                    $newArrayList = New-Object System.Collections.ArrayList
                                                    $newArrayList.Add($TYPE)
                                                    $UniqueWebPartsURL.Add($URL, $newArrayList)
                                                }
                                                                                 
                                           }
                                           else
                                           {

                                                    
                                                $newArrayList = New-Object System.Collections.ArrayList
                                                $newArrayList.Add($TYPE)
                                                $newOpenWebPartURL = @{}
                                                $newOpenWebPartURL.Add($URL, $newArrayList)
                                                $OpenWebPartTypeCount.Add($WEBAPPNAME, $newOpenWebPartURL) 
                                           }  

                                    }
                                    else
                                    {

                                        # To count the Closed web parts per web app
                                       if($CloseWebPartsCount.ContainsKey($WEBAPPNAME))
                                       {
                                            $integer=$CloseWebPartsCount.Get_Item($WEBAPPNAME)
                                            $c = $integer -as [int]
                                            $c=$c+1
                                            $CloseWebPartsCount.Set_Item($WEBAPPNAME, $c)

                                       }
                                       else
                                       {
                                            $newCloseCount=1
                                            $CloseWebPartsCount.Add($WEBAPPNAME, $newCloseCount)

                                       }

                                         Write-Host "CLOSE WEB PART DD="$WEBAPPNAME!$SITEURL$RELATIVEURL!$TITLE!$TYPE

                                    }
                           
                             
                            }

                }
                   $web.Dispose();
             }

            $SPSite.Dispose();
        }
    }

     

    foreach ($h in $OpenWebPartsCount.GetEnumerator()) 
    {
        $keys=($h.Name).ToString()
        $values=($h.Value).ToString()
        Write-Host "OPEN WEB PART MCount="$keys!$values
    }

    foreach ($h in $CloseWebPartsCount.GetEnumerator()) 
    {
        $keys=($h.Name).ToString()
        $values=($h.Value).ToString()
        Write-Host "CLOSE WEB PART MCount="$keys!$values
    }

    foreach ($h in $OpenWebPartDD.GetEnumerator()) 
    {
        $WebAPP=($h.Name).ToString()
        $WebAPPasKEY=($h.Value)
        $TYPEcountHeader=$OpenWebPartTypeCount.Get_Item($WebAPP)
        foreach( $i in $WebAPPasKEY.GetEnumerator() | Sort-Object Value -descending| select -First 10)
        {
            $URLs=$i.Name
            $counts=$i.Value
            $webPartType=$TYPEcountHeader.Get_Item($URLs)
            Write-Host "OPEN WEB PART DD="$WebAPP!$URLs!$($webPartType.Count)!$counts
        }
        
    }


