﻿##/******************************************************************************
##Author                :   Vishnu V
##Purpose               :   Display the list of services and their status in O365
##Created               :   12/01/2018
##Modified By		    : 

$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear

$TestInputs=$args
$userName=$TestInputs[0]
$Password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUsr=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$reptnameProxy=($TestInputs[4]).ToString().Split("#")
$reportingNam=$reptnameProxy[0]
$proxyserverip=$reptnameProxy[1]
$appDetails=$TestInputs[5]
if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}
$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')
$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }


$cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
if(!$proxyserverip.Contains('none')){

    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }

if($appDetails -and $appDetails -ne 'none'){
    $null=Connect-AzureAD -CertificateThumbprint $thumbPrint -ApplicationId $clientId -TenantId $tenantName
}else{
	Connect-MsolService -Credential $cred -AzureEnvironment $azureEnvArr[0]
}

$rptArr=$reportingNam.Split("_")
$rptFoldr=($rptArr[$rptArr.Count-1]).ToLower()
if($rptFoldr -eq 'mtm'){$fldr='MTM'}
elseif($rptFoldr -eq 'sbo'){$fldr='SBO'}
elseif($rptFoldr -eq 'exo'){$fldr='EXO'}
elseif($rptFoldr -eq 'spo'){$fldr='SPO'}
else {$fldr='O365'}

$rptPath=$fldr+'/'+$reportingNam
$LicensesCnt=0
 
 #------------------------UserlogTest-----------------------------#
    Try{
        if($appDetails -and $appDetails -ne 'none'){
            $writArr = Eg-WriteFile -ComntRptPath $rptPath -FileName "O365msolUsr" -keyFileName "kO365msolUsr" -EgPath $egurkhaPath
	        Get-AzureADUser -All $True | Select-Object -Property @{Name='DisplayName';Expression={$_.DisplayName }},@{Name='UserPrincipalName';Expression={$_.UserPrincipalName}},@{Name='SignInName';Expression={$_.SignInNames -join ', '}},@{Name='Licenses';Expression={$_.AssignedLicenses.SkuId -join ', '}},@{Name='IsLicensed';Expression={$_.AssignedLicenses.Count -ne 0}},@{Name='UsageLocation';Expression={$_.UsageLocation}},@{Name='PasswordNeverExpires';Expression={$_.PasswordPolicies -contains "DisablePasswordExpiration"}},@{Name='BlockCredential';Expression={!($_.AccountEnabled)}},@{Name='LastPasswordChangeTimestamp';Expression={'-5'}},@{Name='StrongAuthenticationRequirements';Expression={'-5'}},@{Name='AccId';Expression={$_.AssignedLicenses.SkuId -join ', '}} | Export-Csv $writArr[1] -Encoding $encTyp
            $null=Protect-File  $writArr[1] -Algorithm AES -KeyAsPlainText $writArr[0] -RemoveSource
        }else{
            $writArr = Eg-WriteFile -ComntRptPath $rptPath -FileName "O365msolUsr" -keyFileName "kO365msolUsr" -EgPath $egurkhaPath
	        Get-MsolUser -All | select DisplayName,UserPrincipalName,SignInName,Licenses,IsLicensed,UsageLocation,PasswordNeverExpires,BlockCredential,LastPasswordChangeTimestamp,StrongAuthenticationRequirements| ForEach-Object {$val=$_.Licenses.AccountSkuId -join '#';$MFAstate=$_.StrongAuthenticationRequirements.State -join '#';$_ | Add-Member -MemberType NoteProperty -Name 'AccId' -Value $val -PassThru| Add-Member -MemberType NoteProperty -Name 'MFAStatus' -Value $MFAstate -PassThru}  | Export-Csv $writArr[1] -Encoding $encTyp
        	$null=Protect-File  $writArr[1] -Algorithm AES -KeyAsPlainText $writArr[0] -RemoveSource   
        }
    }Catch{Write-Host $_.Exception.Message}

    Try{
        if(!$appDetails -or $appDetails -eq 'none'){
        	$delUsrWArr = Eg-WriteFile -ComntRptPath $rptPath -FileName "O365msolDelUsr" -keyFileName "kO365msolDelUsr" -EgPath $egurkhaPath
        	Get-MsolUser -All -ReturnDeletedUsers| select UserPrincipalName,SignInName,Licenses,IsLicensed,UsageLocation | ForEach-Object {$val=$_.Licenses.AccountSkuId -join '#';$_ | Add-Member -MemberType NoteProperty -Name 'AccId' -Value $val -PassThru} |Export-Csv $delUsrWArr[1] -Encoding $encTyp
        	$null=Protect-File  $delUsrWArr[1] -Algorithm AES -KeyAsPlainText $delUsrWArr[0] -RemoveSource
	}
    }Catch{}

    Try{
        if($appDetails -and $appDetails -ne 'none'){
        	$dmUsrWArr = Eg-WriteFile -ComntRptPath $rptPath -FileName "O365msolDomUsr" -keyFileName "kO365msolDomUsr" -EgPath $egurkhaPath
            	Get-AzureADDomain | select Name |Export-Csv $dmUsrWArr[1] -Encoding $encTyp
            	$null=Protect-File  $dmUsrWArr[1] -Algorithm AES -KeyAsPlainText $dmUsrWArr[0] -RemoveSource
        }else{
	        $dmUsrWArr = Eg-WriteFile -ComntRptPath $rptPath -FileName "O365msolDomUsr" -keyFileName "kO365msolDomUsr" -EgPath $egurkhaPath
        	Get-MSOLDomain | select Name |Export-Csv $dmUsrWArr[1] -Encoding $encTyp
	        $null=Protect-File  $dmUsrWArr[1] -Algorithm AES -KeyAsPlainText $dmUsrWArr[0] -RemoveSource
	    }
    }Catch{}

 #----------------------------------------------------------------#


 #------------------------Service Provisioning-----------------------------#
  try{
        if($appDetails -and $appDetails -ne 'none'){
        	$writmsolLUsr = Eg-WriteFile -ComntRptPath $rptPath -FileName "O365PSmsolAccSku" -keyFileName "kO365PSmsolAccSku" -EgPath $egurkhaPath
            	Get-AzureADSubscribedSku | Select-Object -Property @{Name='AccountSkuId';Expression={$_.SkuPartNumber }},@{Name='SkuId';Expression={$_.SkuId}},@{Name='Status';Expression={$_.ServicePlans.ServicePlanName -join '~'}} | Export-Csv -Path $writmsolLUsr[1] -Encoding $encTyp
            	$null=Protect-File  $writmsolLUsr[1] -Algorithm AES -KeyAsPlainText $writmsolLUsr[0] -RemoveSource
        }else{
            	$writmsolLUsr = Eg-WriteFile -ComntRptPath $rptPath -FileName "O365PSmsolAccSku" -keyFileName "kO365PSmsolAccSku" -EgPath $egurkhaPath
        	Get-MsolAccountSku |Select-Object AccountSKUID,ServiceStatus| ForEach-Object {$val=$_.ServiceStatus.ServicePlan.ServiceName -join '~';$_ | Add-Member -MemberType NoteProperty -Name 'Status' -Value $val -PassThru} | Export-Csv -Path $writmsolLUsr[1] -Encoding $encTyp
        	$null=Protect-File  $writmsolLUsr[1] -Algorithm AES -KeyAsPlainText $writmsolLUsr[0] -RemoveSource
	}
    }Catch{Write-Host $_.Exception.Message}

    Try{
        $writmsolLUsr1 = Eg-WriteFile -ComntRptPath $rptPath -FileName "O365PSmsolUsr" -keyFileName "kO365PSmsolUsr" -EgPath $egurkhaPath

        if($appDetails -and $appDetails -ne 'none'){
            $sss=Get-AzureADUser -All $True 
            foreach($dmn in $sss){
            $Licenses=Get-AzureADUserLicenseDetail -ObjectId $dmn.UserPrincipalName
                foreach($dn in $Licenses){
                    $valid=$dn| Select-Object -Property @{Name='UserName';Expression={$dmn.UserPrincipalName }},@{Name='AccId';Expression={$dn.SkuPartNumber}},@{Name='ServiceName';Expression={$_.ServicePlans.ServicePlanName  -join ' '}},@{Name='ProvisioningStatus';Expression={$_.ServicePlans.ProvisioningStatus  -join ' '}}
                    if($valid -ne $null -and $valid -ne ''){
                        $valid|Export-Csv -Append -LiteralPath $writmsolLUsr1[1] -Encoding $encTyp #-Force
                    }
                }
            }
        }else{
	        $sss=Get-MsolUser -All |select UserPrincipalName,Licenses        
        	foreach($dmn in $sss){
	        $usr1=$dmn.UserPrincipalName 
			foreach($dn in $dmn.Licenses){
                		$valid=$dn| Select-Object -Property @{Name='UserName';Expression={$dmn.UserPrincipalName }},@{Name='AccId';Expression={$dn.AccountSkuId}},@{Name='ServiceName';Expression={$dn.ServiceStatus.ServicePlan.ServiceName}},@{Name='ProvisioningStatus';Expression={$dn.ServiceStatus.ProvisioningStatus}}
                		if($valid -ne $null -and $valid -ne ''){
                    			$valid|Export-Csv -Append -LiteralPath $writmsolLUsr1[1] -Encoding $encTyp #-Force
				}
                }
            }
        }
	$null=Protect-File  $writmsolLUsr1[1] -Algorithm AES -KeyAsPlainText $writmsolLUsr1[0] -RemoveSource
    }Catch{
	Write-Host $_.Exception.Message
	}
 #--------------------------------------------------------------------------#

 [System.GC]::GetTotalMemory($true) | out-null
