﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
$cqdModule=$scriptPath+"\MTMCallQlityReport.psm1"
Import-Module $egEncryPath,$egDatnKy,$cqdModule
clear

#<#
$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$mperiodAndIsTeam=$TestInputs[2].ToString().Split('#')
$mPeriodInMin=[int]$mperiodAndIsTeam[0].Trim()
$IsTeamsEnabled=$mperiodAndIsTeam[1].Trim()
#$rptTimNUPN=$mperiodAndIsTeam[2].Trim()
$tmpEdTim=$mperiodAndIsTeam[2].Trim()
if($mperiodAndIsTeam[3]-ne $null -and $mperiodAndIsTeam[3] -ne ''){$tmpFrstUpn=$mperiodAndIsTeam[3].Trim()}else{$tmpFrstUpn=''}
if($mperiodAndIsTeam[4] -ne $null -and $mperiodAndIsTeam[4] -ne ''){$tmpSecUpn=$mperiodAndIsTeam[4].Trim()}else{$tmpSecUpn=''}
#$tmpFrstUpn=$mperiodAndIsTeam[3].Trim()
#$tmpSecUpn=$mperiodAndIsTeam[4].Trim()
$rptTimNUPN=$tmpEdTim+'#'+$tmpFrstUpn+'#'+$tmpSecUpn
$rptNam=$TestInputs[3].Trim()
$prxyCrds=$TestInputs[4].ToString().Split('#')
$proxyUsr=$prxyCrds[0]
$proxyPass=Eg-O365Dcr -EncStr $prxyCrds[1]
$proxyserverip=($TestInputs[5]).ToString().trim()
$showPoorStreams=$TestInputs[6]
$showGoodStreams=$TestInputs[7]
$fetchDomains=$TestInputs[8]
#>

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

$dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
$dat2=(Get-Date).AddDays(1).ToUniversalTime()
$startDat='{0:yyyy-MM-dd}' -f $dat1
$endDat='{0:yyyy-MM-dd}' -f $dat2

$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }

$dir=$egurkhaPath +'\agent\MTM\'+$rptNam
if(!(Test-Path -Path $dir )){
    $null=New-Item -ItemType directory -Path $dir
}
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$RecADOPath=$dir+'\audioStrms'+ $timenow +".csv"
$measures='Measures.Audio Stream Count','Measures.Audio Poor Stream Count','Measures.Audio Good Stream Count','Measures.Audio Unclassified Stream Count','Measures.Audio Poor Percentage','Measures.Audio Poor Due To Jitter Count','Measures.Audio Poor Due To PacketLoss Count','Measures.Audio Poor Due To Degradation Count','Measures.Audio Poor Due To RoundTrip Count','Measures.Audio Poor Due To ConcealedRatio Count'
$Dimentions ='AllStreams.Start Time','AllStreams.End Time','AllStreams.Date','AllStreams.Hour','AllStreams.First IP Address','AllStreams.Second IP Address','AllStreams.Conference Id','AllStreams.Audio Poor Due To Jitter','AllStreams.Audio Poor Due To RoundTrip','AllStreams.Audio Poor Due To PacketLoss','AllStreams.Audio Poor Due To Degradation','AllStreams.Audio Poor Due To ConcealedRatio','AllStreams.Media Type','AllStreams.ClassifiedPoorCall','AllStreams.Is Teams','AllStreams.First UPN','AllStreams.Second UPN'
#$AudioStms=Get-CQDData -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat  -Measures $measures -OutPutType DataTable -username $username -password $password -CQDVer V3  | Where-Object { $_.'Media Type' -eq 'Audio' -and ($_.'Is Teams' -eq '1' -or $_.'Is Teams' -eq $IsTeamsEnabled)} |Sort-Object -Property 'End Time' -Descending

################################
$componentnam='Microsoft_Teams_domain'
$ps1FileName=$MyInvocation.MyCommand.Name
$isRunMainset=$false
$sprsetNam=Domains-GetSuperset -UserName $userName -Password $password -ProxyServerIP $proxyserverip -ProxyUser $proxyUsr -ProxyPassword $proxyPass

$ticks_dtlsArr= Domains-ReadFrmINI -ps1FileName $ps1FileName -RptName $rptNam -ComponentName $componentnam -EncType $encTyp
if($ticks_dtlsArr -eq $null -or $ticks_dtlsArr.Count -eq 0){
    $curTicks=(get-Date).Ticks
    Domains-WriteToINI -ps1FileName $ps1FileName -RptNam $rptNam -SfolderNam $sprsetNam -ticks $curTicks -componentNam $componentnam -encTyp $encTyp
    $isRunMainset=$true
}else{
    $curTicks=(get-Date).Ticks
    $stTicks=[long]$ticks_dtlsArr[2]
    $TimeFromTicks = [datetime]$stTicks
    $diff=((get-Date)-$TimeFromTicks)
    if($mPeriodInMin -le $diff.Minutes){
        Domains-WriteToINI -ps1FileName $ps1FileName -RptNam $rptNam -SfolderNam $sprsetNam -ticks $curTicks -componentNam $componentnam -encTyp $encTyp
        $isRunMainset=$true
    }  
}

$superSetPath='MTM/'+$sprsetNam
$superSetDir=$egurkhaPath+'/agent/MTM/'+$sprsetNam
if(!(Test-Path -Path $superSetDir )){
    New-Item -ItemType directory -Path $superSetDir
}
##################################

if($isRunMainset){
    $sAudiostrms = Eg-WriteFile -ComntRptPath $superSetPath -FileName "MTDAudioStrms" -keyFileName "kMTDAudioStrms" -EgPath $egurkhaPath
    Try{
        Get-CQDData -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat  -Measures $measures -OutPutType DataTable -username $username -password $password -CQDVer V3  | Where-Object { $_.'Media Type' -eq 'Audio' -and ($_.'Is Teams' -eq '1' -or $_.'Is Teams' -eq $IsTeamsEnabled)} |Sort-Object -Property 'End Time' | Export-Csv  $sAudiostrms[1] -Encoding $encTyp #-Descending
    }
    Catch{
        $ExcepMsg='['+(Split-Path ($_.InvocationInfo.ScriptName) -leaf)+'] Exception Occured in "getting Records" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
        Write-Host $ExcepMsg
    }
    [System.GC]::GetTotalMemory($true) | out-null
    $null=Protect-File  $sAudiostrms[1] -Algorithm AES -KeyAsPlainText $sAudiostrms[0] -RemoveSource
}

$readfiles=Eg-ReadFile -ComntRptPath $superSetPath -FileName "MTDAudioStrms" -keyFileName "kMTDAudioStrms" -EgPath $egurkhaPath
if([System.IO.File]::Exists($readfiles[1]) -eq 'True'){
    $datafile=$readfiles[1] -replace (".csv",".dat") 
    $adoStrmCSV=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
    $mtdaudioStrms= import-csv $adoStrmCSV -Encoding $encTyp
    Remove-Item $adoStrmCSV
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'MTDAudioStrms' -InputFile $readfiles[3]
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kMTDAudioStrms' -InputFile $readfiles[4]

    $AudioStms=@()
    $rptPath='MTM/'+$rptNam
    $MyDir=$egurkhaPath+'/agent/MTM/'+$rptNam
    if(!(Test-Path -Path $MyDir )){
        New-Item -ItemType directory -Path $MyDir
    }
                                                    Try{
    $mtdAudioStm = Eg-WriteFile -ComntRptPath $rptPath -FileName "MTDAudioStrms" -keyFileName "kMTDAudioStrms" -EgPath $egurkhaPath
    foreach($resStrms in $mtdaudioStrms){  
        $frstUPNDomain=([String]$resStrms.'First UPN').Trim()
        $secUPNDomain=([String]$resStrms.'Second UPN').Trim()
        if($frstUPNDomain -ne $null -and $frstUPNDomain -ne ''){$frstUPNDomain=$frstUPNDomain.Split('@')[1]}
        if($secUPNDomain -ne $null -and $secUPNDomain -ne ''){$secUPNDomain = $secUPNDomain.Split('@')[1]}
        if(($frstUPNDomain -ne $null -and $frstUPNDomain -ne '' -and $fetchDomains -match $frstUPNDomain) -or ($secUPNDomain -ne $null -and $secUPNDomain -ne '' -and $fetchDomains -match $secUPNDomain)){
            $AudioStms+=$resStrms
            $resStrms| Export-Csv $mtdAudioStm[1] -Encoding $encTyp -Append
        }
    }
    $null=Protect-File  $mtdAudioStm[1] -Algorithm AES -KeyAsPlainText $mtdAudioStm[0] -RemoveSource
    }
            Catch{
    $ExcepMsg='['+(Split-Path ($_.InvocationInfo.ScriptName) -leaf)+'] Exception Occured in "fetchdomain Records" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
    Write-Host $ExcepMsg
    }
    ###############################
    $writPath=$dir+'\MTMAudioStrms'+ $timenow +".csv"
    $iswrite=$false

    $strmsCnt=0
    $gdStmsCnt=0
    $unclsfyStrmsCnt=0
    $obj=$AudioStms| select -Last 1
    $rptEdTimNUPN=([String]$obj.'End Time').Trim()+'#'+([String]$obj.'First UPN').Trim()+'#'+([String]$obj.'Second UPN').Trim()
                                                                                                                                                                                if($showGoodStreams -eq 'none'){
    if($rptTimNUPN -ne 'none'){
        $isChkTim=$true
        foreach($strms in $AudioStms){
            if($iswrite){
                $stmStr=([String]$strms.'Audio Stream Count').Trim()
                if($stmStr -ne $null -and $stmStr -ne '' -and $stmStr -ne 'NaN'){$strmsCnt+=[int]$stmStr}
                $stmGdStr=([String]$strms.'Audio Good Stream Count').Trim()
                if($stmGdStr -ne $null -and $stmGdStr -ne '' -and $stmGdStr -ne 'NaN'){$gdStmsCnt+=[int]$stmGdStr}
                $stmUnClsStr=([String]$strms.'Audio Unclassified Stream Count').Trim()
                if($stmUnClsStr -ne $null -and $stmUnClsStr -ne '' -and $stmUnClsStr -ne 'NaN'){$unclsfyStrmsCnt+=[int]$stmUnClsStr}
                $stmPrStr=([String]$strms.'Audio Poor Stream Count').Trim()
                if($stmPrStr -ne $null -and $stmPrStr -ne '' -and $stmPrStr -ne 'NaN' -and [int]$stmPrStr -gt 0){
                    $strms| Export-Csv $writPath -Encoding $encTyp -Append 
                }
            }
            if($isChkTim){
                $chktimNam=([String]$strms.'End Time').Trim()+'#'+([String]$strms.'First UPN').Trim()+'#'+([String]$strms.'Second UPN').Trim()
                if($rptTimNUPN -eq $chktimNam){
                    $iswrite=$true;$isChkTim=$false;
                }
            }
        }
    }
    if(!$iswrite){
        foreach($strms in $AudioStms){
            $cmprTime=[DateTime][String]$strms.'End Time'
            $cmprTime=$cmprTime.ToUniversalTime()
            if($cmprTime -ne ''){
                if($dat1 -lt $cmprTime){
                    $stmStr=([String]$strms.'Audio Stream Count').Trim()
                    if($stmStr -ne $null -and $stmStr -ne '' -and $stmStr -ne 'NaN'){$strmsCnt+=[int]$stmStr}
                    $stmGdStr=([String]$strms.'Audio Good Stream Count').Trim()
                    if($stmGdStr -ne $null -and $stmGdStr -ne '' -and $stmGdStr -ne 'NaN'){$gdStmsCnt+=[int]$stmGdStr}
                    $stmUnClsStr=([String]$strms.'Audio Unclassified Stream Count').Trim()
                    if($stmUnClsStr -ne $null -and $stmUnClsStr -ne '' -and $stmUnClsStr -ne 'NaN'){$unclsfyStrmsCnt+=[int]$stmUnClsStr}
                    $stmPrStr=([String]$strms.'Audio Poor Stream Count').Trim()
                    if($stmPrStr -ne $null -and $stmPrStr -ne '' -and $stmPrStr -ne 'NaN' -and [int]$stmPrStr -gt 0){
                        $strms| Export-Csv $writPath -Encoding $encTyp -Append 
                    }
                }
            }
        }
    }
    }
                                                                                                        else{
    if($rptTimNUPN -ne 'none'){
        $isChkTim=$true
        foreach($strms in $AudioStms){
            if($iswrite){
                $strms| Export-Csv $writPath -Encoding $encTyp -Append
            }
            if($isChkTim){
                $chktimNam=([String]$strms.'End Time').Trim()+'#'+([String]$strms.'First UPN').Trim()+'#'+([String]$strms.'Second UPN').Trim()
                if($rptTimNUPN -eq $chktimNam){
                    $iswrite=$true;$isChkTim=$false;
                }
            }
        }
    }
    if(!$iswrite){
        foreach($strms in $AudioStms){
            $cmprTime=[DateTime][String]$strms.'End Time'
            $cmprTime=$cmprTime.ToUniversalTime()
            if($cmprTime -ne ''){
                if($dat1 -lt $cmprTime){
                    $strms| Export-Csv $writPath -Encoding $encTyp -Append  
                }
            }
        }
    }
    }
    $strcnt='StreamsCnt#'+$strmsCnt+'~'+$gdStmsCnt+'~'+$unclsfyStrmsCnt+'~'+$rptEdTimNUPN
    Write-Host $strcnt
    Write-Host 'LastReporting WritePath#'$writPath
}
[System.GC]::GetTotalMemory($true) | out-null