﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy
clear
 
#<#
$testargs=$args
$reportingname='EXO\'+$testargs[0]
$rptTopNDD=($testargs[1]).ToString()
$userName=$testargs[2]
$Password=Eg-O365Dcr -EncStr $testargs[3]
$proxyUsr=$testargs[4]
$proxyPass=Eg-O365Dcr -EncStr $testargs[5]
$proxyipAnRcvQta=([String]$testargs[6]).Split('#')
$appDetails=$testargs[7]
$ExcludingNames=$testargs[8]
$proxyserverip=$proxyipAnRcvQta[0]
$recoverQuotaLmt=$proxyipAnRcvQta[1]

if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}
#>

$rptPath='EXO\'+$testargs[0]
$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'


########### ARCHIVE MAILBOX - Start ######################
Function Start-SleepWithProgress {
	Param([int]$sleeptime)
	For ($i=0;$i -le $sleeptime;$i++){
		$timeleft = ($sleeptime - $i);
		Write-Progress -Activity "Sleeping" -CurrentOperation "$Timeleft More Seconds" -PercentComplete (($i/$sleeptime)*100);
		start-sleep 1
	}
	Write-Progress -Completed -Activity "Sleeping"
}

Function New-CleanO365Session {
    $Credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
    $i = 0
	while (($Credential -eq $Null) -and ($i -lt 5)){
		$script:Credential = Get-Credential -Message "Please provide your Exchange Online Credentials"
		$i++
	}
	if ($Credential -eq $null){
		Write-Error -Message "Failed to get credentials" -ErrorAction Stop
	}
    $getSession=Get-PSSession -ErrorAction SilentlyContinue
    if($getSession -ne $null -and $getSession -ne ''){
	    Disconnect-ExchangeOnline -Confirm:$false
    }
	[System.GC]::Collect()
	Start-SleepWithProgress -SleepTime 15
	$Error.Clear()
	
	# Create the session
	$sessionOption = New-PSSessionOption -SkipRevocationCheck
    if(!$proxyserverip.ToString().ToLower().Contains('none')){
        [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserverip)
	    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
	        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
            [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
            [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
	        $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType WinHttpConfig -ProxyAuthentication basic -ProxyCredential $proxyCred
	    }
    }

	# Check for an error while creating the session
	if ($Error.Count -gt 0){
		$ErrorCount++
		if ($ErrorCount -gt 3){
			$deleky=0
            try{
                if(Test-Path -path $global:writeTmpCsv){
                    $null=Protect-File  $global:writeTmpCsv -Algorithm AES -KeyAsPlainText $global:WriteTmpKey -RemoveSource
                }
            }catch{                
            }
			exit
		}
		Start-SleepWithProgress -sleeptime 60
		New-CleanO365Session
	}
	else {
		$ErrorCount = 0
	}	
	# Connect the ExchangeOnline
    if($appDetails -and $appDetails -ne 'none'){
        Connect-ExchangeOnline -CertificateThumbPrint $thumbPrint -AppID $clientId -Organization $tenantName -PSSessionOption $sessionOption -ShowBanner:$false -WarningAction SilentlyContinue
    }else{
        Connect-ExchangeOnline  -ExchangeEnvironmentName $azureEnvArr[4] -ConnectionUri $azureEnvArr[1] -Credential $Credential -PSSessionOption $sessionOption -ShowBanner:$false
    }
	
	# Set the Start time for the current session
	Set-Variable -Scope script -Name SessionStartTime -Value (Get-Date)
}
New-CleanO365Session

$isExceptionOccured=$false 
$chkCSVPath=''
Try{
    $arMailBxWritArr = Eg-WriteFile -ComntRptPath $rptPath -FileName "archivemailbox" -keyFileName "karchivemailbox" -EgPath $egurkhaPath
    $chkCSVPath=$arMailBxWritArr[1]
    Get-EXORecipient -PropertySets Archive -ResultSize Unlimited |select * |where{$_.ArchiveStatus -eq 'Active'}| Export-Csv $arMailBxWritArr[1] -Append -Encoding $encTyp
    $null=Protect-File  $arMailBxWritArr[1] -Algorithm AES -KeyAsPlainText $arMailBxWritArr[0] -RemoveSource
}Catch{
    $isExceptionOccured=$true
    $exoExcepMsg1='[EXOMbStats - Archivemailbox] Exception Occured in "Get-EXORecipient" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception+'!>'    
    Write-Host $exoExcepMsg1
}

$getSession=Get-PSSession -ErrorAction SilentlyContinue
if($getSession -ne $null -and $getSession -ne ''){
	Disconnect-ExchangeOnline -Confirm:$false
}

if(!$isExceptionOccured){
    $arMailBxReadArr=Eg-ReadFile -ComntRptPath $rptPath -FileName "archivemailbox" -keyFileName "karchivemailbox" -EgPath $egurkhaPath
    if($arMailBxReadArr -ne $null -and [System.IO.File]::Exists($arMailBxReadArr[1]) -eq 'True'){
        $unProtctAct=$arMailBxReadArr[1] -replace (".csv",".dat") 
        $arPath=Unprotect-File $unProtctAct -Algorithm AES -KeyAsPlainText $arMailBxReadArr[0]
        $archivMailboxes= import-csv $arPath -Encoding $encTyp
        Remove-Item $arPath 
    }
}
else{
    if($chkCSVPath -ne $null -and $chkCSVPath -ne ''){
        if (Test-Path $chkCSVPath -PathType leaf){
            $dirNam=(get-item $chkCSVPath).DirectoryName
            $FileName=(get-item $chkCSVPath).BaseName
            Get-ChildItem -Path $dirNam |Where-Object {$_.Name -like '*'+$FileName+'*'}|ForEach-Object{if([System.IO.File]::Exists($_.FullName) -eq 'True'){Remove-Item -Path $_.FullName}}
        }
    }
}

########### ARCHIVE MAILBOX - End ######################

Function Get-MailStatsFile{
    $readfiles1=Eg-ReadFile -ComntRptPath $reportingname -FileName "statsmailbox" -keyFileName "kstatsmailbox" -EgPath $egurkhaPath
    <#if((Get-Item $readfiles1[1]).length -le 2kb){
        Remove-Item $readfiles1[1]
        Get-MailStatsFile
    }
    else{#>
        return $readfiles1
    #}
}
[System.GC]::GetTotalMemory($true) | out-null
$readMBS=Get-MailStatsFile
if($readMBS -ne $null -and [System.IO.File]::Exists($readMBS[1]) -eq 'True'){
    $mbsFileNam=$readMBS[1] -replace (".csv",".dat") 
    Write-Host $readMBS[1]
    $csvDatas=Unprotect-File $mbsFileNam -Algorithm AES -KeyAsPlainText $readMBS[0]	
    $mbStatReports= import-csv $csvDatas -Encoding $encTyp
    Remove-Item $csvDatas
}
$mailStats=$mbStatReports | select -First 1

$arMailBxCnt=0
if($mbStatReports -ne $null -and $mbStatReports -ne '' -and $archivMailboxes -ne $null -and $archivMailboxes -ne ''){
    foreach($arMailBx in $archivMailboxes){
        $arMailBxCnt++
        if($rptTopNDD.ToLower() -eq 'all'){
            $ddstng= '~!~'+$arMailBx.PrimarySmtpAddress+'~!~~!~~!~~!~~!~~!~~!~~!~'+$arMailBx.Identity+'~!~'+$arMailBx.ArchiveState+'~!~'+$arMailBx.ArchiveStatus+'~!~'+$arMailBx.ArchiveDatabase+'~!~'+$arMailBx.ArchiveGuid
            Write-host '#ddArchivemails' $ddstng
        }else{
            if($arMailBxCnt -le [int]$rptTopNDD){
                $ddstng= '~!~'+$arMailBx.PrimarySmtpAddress+'~!~~!~~!~~!~~!~~!~~!~~!~'+$arMailBx.Identity +'~!~'+$arMailBx.ArchiveState+'~!~'+$arMailBx.ArchiveStatus+'~!~'+$arMailBx.ArchiveDatabase+'~!~'+$arMailBx.ArchiveGuid
                Write-host '#ddArchivemails' $ddstng
            } 
        } 
    }
}

#$isPreviousScript=[bool]($mailStats.PSobject.Properties.name -match "PrimarySmtpAddress")
<#
if($isPreviousScript){
    $ErrorCount=0
    $readfiles=0
    $readfiles1=0
    try{   
        $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "mailbox" -keyFileName "kmailbox" -EgPath $egurkhaPath
        $datafile=$readfiles[1] -replace (".csv",".dat") 
        $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]
        $TotMailbxcnt= import-csv $csvfile
        Remove-Item $csvfile
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'mailbox' -InputFile $readfiles[3]
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kmailbox' -InputFile $readfiles[4]
    }
    catch [System.Management.Automation.RuntimeException] {
	    $ErrorCount++	
        Write-Error -Message "File not found. The $reportingname location does not contain mailbox files."
    }
    catch{
    $ErrorCount++
        $errmsg=$_.Exception.Message
        $errstack=$_.Exception.StackTrace
        Write-Error -Message $errmsg
    }

    try{   
        $readfiles1=Get-MailStatsFile  #Eg-ReadFile -ComntRptPath $reportingname -FileName "statsmailbox" -keyFileName "kstatsmailbox" -EgPath $egurkhaPath
        $datafile1=$readfiles1[1] -replace (".csv",".dat") 
        $csvfile1=Unprotect-File $datafile1 -Algorithm AES -KeyAsPlainText $readfiles1[0]	
        $MailStatReport= import-csv $csvfile1
        Remove-Item $csvfile1
        Eg-DeleteFiles -FilePath $readfiles1[2] -Pattern 'statsmailbox' -InputFile $readfiles1[3]
        Eg-DeleteFiles -FilePath $readfiles1[2] -Pattern 'kstatsmailbox' -InputFile $readfiles1[4]
    }
    catch [System.Management.Automation.RuntimeException] {
    $ErrorCount++
        Write-Error -Message "File not found. The $reportingname location does not contain statsmailbox files."
        $MailStatReport= $null
    }
    catch{
    $ErrorCount++
        $errmsg=$_.Exception.Message
        $errstack=$_.Exception.StackTrace
        Write-Error -Message $errmsg
    }

    if( $MailStatReport -eq $null -or  $MailStatReport -eq ''){
        write-host "#TotMailbxcnt~-5"   
        write-host "#DbSndQte~-5" 
        write-host "#DbSndRecQte~-5" 
        Write-host '#MailbxOverQte~-5'
        write-host "#TotMailbxSize~-5" 
        write-host "#inactivecnt~-5" 
        write-host "#inactiveMailbxSize~-5" 
        Write-Host '#Arrcnt~-5'
        Write-Host '#Arrmailbxsize~-5'
        Write-Host '#ClutterEnabledcnt~-5'
        Write-Host '#ClutterDisabledcnt~-5'
        Write-Host '#ArchiveWarnMailscnt~-5'
        exit
    }
    Write-Host 'ReadFile:'$readfiles[3]','$readfiles1[3]

	$inactivecnt=0
	$Arrcnt=0
	$ClutterEnabledcnt=0
	$ClutterDisabledcnt=0
	$inactiveMailbxSize=0
	$SendQte=0
	$SendRecvQte=0
	$MailbxOverQte=0
	$Arrmailbxsize=0
	$TotMailbxSize=0
	$inact=0
    $ArrWarnMailcnt=0
    $ArchiveMailboxMap=@{}
    $ArchiveWarnMailboxsMap=@{}
    if($ErrorCount -eq 0){
	    $TotMailbxcnt= $TotMailbxcnt|where {$ExcludingNames -notcontains $_.DisplayName}
	    $MailStatReport=$MailStatReport|where {$ExcludingNames -notcontains $_.DisplayName}
	    $inactive=$TotMailbxcnt|Where{$_.WasInactiveMailbox -eq $true}|Select *
	    $ShrdMailboxes = $TotMailbxcnt|Where{$_.RecipientTypeDetails -eq 'SharedMailbox'}|Select *
	    $litigationhold=$TotMailbxcnt|Where{$_.LitigationHoldEnabled -eq $true}|Select *
	    $FrwdMailbx=$TotMailbxcnt|Where{$_.DeliverToMailboxAndForward -eq $true}|Select *
	    $Inplacehold=$TotMailbxcnt|Where{$_.InPlaceHolds -eq $true -and $_.InPlaceHolds -notcontains ' '}|Select *
	    foreach($Measures in $TotMailbxcnt){
		    $StatReport= $MailStatReport| Where {$_.PrimarySMTPAddress -eq $Measures.PrimarySmtpAddress }|Select PrimarySMTPAddress,IsArchiveMailbox,IsClutterEnabled,TotalItemSize,DatabaseIssueWarningQuota,DisplayName,ItemCount,DatabaseProhibitSendQuota,DatabaseProhibitSendReceiveQuota
            if($StatReport -ne $null) {
	            if($Measures.ArchiveStatus -eq 'Active'){
		            $Arrcnt++;
		            $repTot=[String]$StatReport.TotalItemSize
		            $resBytes= $repTot.Split('(')[1].Split(' ')
		            $Arrmailbxsize+=[double]$resBytes[0].Trim()
		            $ArchiveSize=[math]::round([double]$resBytes[0] /1Gb, 4)
		            $ArchiveQuota=[double]($Measures.ArchiveQuota).Split(' ')[0]
		            $ArchivewarnQuota=[double]($Measures.ArchiveWarningQuota).Split(' ')[0]
		            $ArchiveMailboxSize=[math]::round([double]$resBytes[0] /1Gb, 4)
		            $ddstng= $Measures.Name +'~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ '+ $Measures.ArchiveName +'~!~'+$Measures.ArchiveState +'~!~'+$ArchiveMailboxSize.tostring("#.##").replace(',','.') +'~!~'+$ArchiveQuota+'~!~'+$ArchivewarnQuota
		            $ArchiveMailboxMap[$ArchiveMailboxSize]=$ddstng
	                if($ArchiveMailboxSize -gt $ArchivewarnQuota){
	                $ArrWarnMailcnt++
	                $ArchiveWarnMailboxsMap[$ArchiveMailboxSize]=$ddstng           
	                }           
		        }
		        if($StatReport.IsClutterEnabled -eq $true){
		            $ClutterEnabledcnt++;
		        }
		        else{
		            $ClutterDisabledcnt++;
		        }

	            #Total MailBox Size
		        if($StatReport.TotalItemSize -ne $null){
		            $repOvrall=$StatReport.TotalItemSize
		            $restotBytes= $repOvrall.Split('(')[1].Split(' ')[0].Trim().Replace(“,”,””)
		            $TotMailbxSize+=[double]$restotBytes

	                #MailBox Over Quota
		            $DbWarn=[String]$Measures.IssueWarningQuota
    	            $DbWarnBytes= $DbWarn.Split('(')[1].Split(' ')[0].Trim().Replace(“,”,””)
                    if([double]$restotBytes -ge [double]$DbWarnBytes){
			            $MailbxOverQte++;
			            write-host " #ddOverWarning " $StatReport.DisplayName '~!~'  $Measures.UserPrincipalName '~!~' $StatReport.ItemCount '~!~'  $StatReport.totalItemSize  '~!~' $Measures.IssueWarningQuota  '~!~-~!~-'
		            }
		        }

                #MailBox Send Over Quota 
		        $SendQuota=[String]$Measures.ProhibitSendQuota
    	        $SendQuotaBytes= $SendQuota.Split('(')[1].Split(' ')[0].Trim().Replace(“,”,””)
		        if([double]$restotBytes -ge [double]$SendQuotaBytes){
			        $SendQte++;
			        write-host " #ddSendOverWarning " $StatReport.DisplayName '~!~'  $Measures.UserPrincipalName '~!~' $StatReport.ItemCount '~!~'  $StatReport.totalItemSize  '~!~-~!~' $Measures.ProhibitSendQuota '~!~-'
		        }
	
                #MailBox Send/recv Over Quota
		        $SendRecvQuota=[String]$Measures.ProhibitSendReceiveQuota
    	        $SendRecvQuotaBytes= $SendRecvQuota.Split('(')[1].Split(' ')[0].Trim().Replace(“,”,””)
		        if([double]$restotBytes -ge [double]$SendRecvQuotaBytes){
			        $SendRecvQte++;
			        write-host " #ddSendRecvOverWarning " $StatReport.DisplayName '~!~'  $Measures.UserPrincipalName '~!~' $StatReport.ItemCount '~!~'  $StatReport.totalItemSize  '~!~-~!~-~!~' $Measures.ProhibitSendReceiveQuota
		        }

                #Inactive MailBox Size

		        if($Measures.WasInactiveMailbox -eq $true){
                    $inactivecnt++
			        $inactSize=[String]$StatReport.TotalItemSize
			        $restotBytes= $inactSize.Split('(')[1].Split(' ')[0].Trim().Replace(“,”,””)
			        $inactiveMailbxSize+=[double]$restotBytes
		        }
	        }
        }

        foreach ( $in in $ArchiveMailboxMap.GetEnumerator() | sort -Property key  -Descending | select -first 10){
    	    Write-host '#ddArchivemails' $in.Value
        }

        foreach ( $in in $ArchiveWarnMailboxsMap.GetEnumerator() | sort -Property key  -Descending ){
    	    Write-host '#ddArchiveWarnMails' $in.Value
        }

	    $TotMailbxSize=[math]::round($TotMailbxSize /1Gb, 4)
	    $Arrmailbxsize=[math]::round($Arrmailbxsize /1Gb, 4)
		
	    # Top 10 Size DD
	    $ddlineMailbox= $MailStatReport| Select-Object DisplayName, @{name=”TotalItemSize_mb”;expression={[math]::Round((($_.TotalItemSize).Split(“(“)[1].Split(” “)[0].Replace(“,”,””)/1GB),4)}},PrimarySmtpAddress, ItemCount ,totalItemSize,DatabaseIssueWarningQuota,DatabaseProhibitSendQuota,DatabaseProhibitSendReceiveQuota | Sort-Object “TotalItemSize_mb” -Descending

	    For ($i=0; $i -lt 10; $i++) {
		    $ddline=$ddlineMailbox[$i]
			if($ddline -ne $null){
                $mailbx=$TotMailbxcnt | Where {$_.PrimarySMTPAddress -eq $Measures.PrimarySmtpAddress }|Select IssueWarningQuota,ProhibitSendQuota,ProhibitSendReceiveQuota
			    Write-Host  '#ddTop10Size '$ddline.DisplayName  '~!~' $ddline.ItemCount '~!~' $ddline.TotalItemSize_mb  '~!~' $mailbx.IssueWarningQuota.ToString().Split(" ")[0]  '~!~' $mailbx.ProhibitSendQuota.ToString().Split(" ")[0] '~!~' $mailbx.ProhibitSendReceiveQuota.ToString().Split(" ")[0]
			}
	    }
	
        #Inactive Measure DD
	    if($inactive -ne $null){
		    foreach($inact in $inactive){
		        $inactivecnt++
		        Write-Host '#ddinactive '$inact.DisplayName '~!~' $inact.PrimarySmtpAddress '~!~'$inact.WhenSoftDeleted
		    }
        }
    }
    #write-host "#TotMailbxcnt~" $TotMailbxcnt.Count
	write-host "#DbSndQte~" $SendQte
	write-host "#DbSndRecQte~" $SendRecvQte
	Write-host '#MailbxOverQte~'$MailbxOverQte
	write-host "#TotMailbxSize~" $TotMailbxSize.tostring("#.##").replace(',','.')
	write-host "#inactivecnt~" $inactivecnt
	write-host "#inactiveMailbxSize~" $inactiveMailbxSize.tostring("#.##").replace(',','.')
	Write-Host '#Arrcnt~' $Arrcnt
	Write-Host '#Arrmailbxsize~' $Arrmailbxsize.tostring("#.##").replace(',','.')
	Write-Host '#ClutterEnabledcnt~' $ClutterEnabledcnt
	Write-Host '#ClutterDisabledcnt~' $ClutterDisabledcnt
    Write-Host '#ArchiveWarnMailscnt~' $ArrWarnMailcnt
}
#>
#else{        
        $totMailBxSiz=0;$top10cnt=0;
        $iwarnQuotaCnt=0;$iwqCnt=0;
        $inActMBCnt=0;$iaCnt=0;
        $inactivMBSiz=0;
        $prohbtSndQuotaCnt=0;
        $prohbtSndRecvQCnt=0;
        $nearRecoverQuota=0;
        $mbStatReports|Where-Object {$_.IsDeleted -eq $false}|Sort-Object{ $_.StorageUsed -as [Long] } -Descending  | ForEach-Object{
            $totMailBxSiz+=$_.StorageUsed
            if($rptTopNDD.ToLower() -eq 'all'){
                $top10DD='#ddTop10Size '+$_.DisplayName+'~!~'+$_.ItemCount+'~!~'+[math]::Round(($_.StorageUsed/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.IssueWarningQuota/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.ProhibitSendQuota/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.'ProhibitSend/ReceiveQuota'/(1024*1024*1024)),2)
                Write-Host $top10DD
            }else{
                if($top10cnt -lt [int]$rptTopNDD){
                    $top10cnt++
                    $top10DD='#ddTop10Size '+$_.DisplayName+'~!~'+$_.ItemCount+'~!~'+[math]::Round(($_.StorageUsed/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.IssueWarningQuota/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.ProhibitSendQuota/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.'ProhibitSend/ReceiveQuota'/(1024*1024*1024)),2)
                    Write-Host $top10DD
                }
            }

            if([long]$_.StorageUsed -ge [long]$_.IssueWarningQuota){
                $iwarnQuotaCnt++
                if($rptTopNDD.ToLower() -eq 'all'){
                    $iwqDD='#ddOverWarning '+$_.DisplayName+'~!~'+$_.UserPrincipalName+'~!~'+$_.ItemCount+'~!~'+[math]::Round(($_.StorageUsed/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.IssueWarningQuota/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.ProhibitSendQuota/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.'ProhibitSend/ReceiveQuota'/(1024*1024*1024)),2)+'~!~-~!~-'
                    Write-Host $iwqDD
                }else{
                    if($iwqCnt -lt [int]$rptTopNDD){
                        $iwqCnt++
                        $iwqDD='#ddOverWarning '+$_.DisplayName+'~!~'+$_.UserPrincipalName+'~!~'+$_.ItemCount+'~!~'+[math]::Round(($_.StorageUsed/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.IssueWarningQuota/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.ProhibitSendQuota/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.'ProhibitSend/ReceiveQuota'/(1024*1024*1024)),2)+'~!~-~!~-'
                        Write-Host $iwqDD
                    }
                }
            }

            if([long]$_.StorageUsed -ge [long]$_.ProhibitSendQuota){
                $prohbtSndQuotaCnt++
            }
            if([long]$_.StorageUsed -ge [long]$_.'ProhibitSend/ReceiveQuota'){
                $prohbtSndRecvQCnt++
            }   
            [Double]$rcvQuotaPercent=0
            $rcvQuotaPercent=[math]::Round((([Double]$_.DeletedItemSize/[Double]$_.DeletedItemQuota)*100),2)
            if($rcvQuotaPercent -gt [Double]$recoverQuotaLmt){
                $nearRecoverQuota++
				if($rptTopNDD.ToLower() -eq 'all'){
                	$nearRecoverQuota_DD='#ddnearRecoverQuota '+$_.DisplayName+'~!~'+$_.UserPrincipalName+'~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~'+$_.DeletedItemCount+'~!~'+[math]::Round(($_.DeletedItemSize/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.DeletedItemQuota/(1024*1024*1024)),2)+'~!~'+$rcvQuotaPercent
                    Write-Host $nearRecoverQuota_DD				
                }else{
					if($nearRecoverQuota -le [int]$rptTopNDD){
						$nearRecoverQuota_DD='#ddnearRecoverQuota '+$_.DisplayName+'~!~'+$_.UserPrincipalName+'~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~ ~!~'+$_.DeletedItemCount+'~!~'+[math]::Round(($_.DeletedItemSize/(1024*1024*1024)),2)+'~!~'+[math]::Round(($_.DeletedItemQuota/(1024*1024*1024)),2)+'~!~'+$rcvQuotaPercent
                        Write-Host $nearRecoverQuota_DD					
                    }
				}  
            }     
        }

        $mbStatReports|Sort-Object{ $_.LastActivityDate -as [DateTime] } | ForEach-Object{
            if($_.LastActivityDate -ne $null -and $_.LastActivityDate -ne ''){
                $tDat=(Get-Date).AddDays(-30)
                $ldat=[String]($_.LastActivityDate)
                $lstActDat=[DateTime]$ldat.Trim()
                if($lstActDat -lt $tDat){
                    $inActMBCnt++
                    $inactivMBSiz+=$_.StorageUsed
                    if($rptTopNDD.ToLower() -eq 'all'){
                        if($_.IsDeleted -eq $true){
                                $inactivDD='#ddinactive '+$_.DisplayName+'~!~'+$_.UserPrincipalName+'~!~'+$_.DeletedDate
                            }else{
                                $inactivDD='#ddinactive '+$_.DisplayName+'~!~'+$_.UserPrincipalName+'~!~-'
                            }
                            Write-Host $inactivDD
                    }
                    else{
                        if($iaCnt -lt [int]$rptTopNDD){
                            $iaCnt++
                            if($_.IsDeleted -eq $true){
                                $inactivDD='#ddinactive '+$_.DisplayName+'~!~'+$_.UserPrincipalName+'~!~'+$_.DeletedDate
                            }else{
                                $inactivDD='#ddinactive '+$_.DisplayName+'~!~'+$_.UserPrincipalName+'~!~-'
                            }
                            Write-Host $inactivDD
                        }
                    }
                }
            }
        }

        $totMailBxSiz=[math]::Round(($totMailBxSiz/(1024*1024*1024)),2)
        write-host "#TotMailbxSize~"$totMailBxSiz
        Write-host '#MailbxOverQte~'$iwarnQuotaCnt
        write-host "#inactivecnt~"$inActMBCnt
        $inactivMBSiz=[math]::Round(($inactivMBSiz/(1024*1024*1024)),2)
        write-host "#inactiveMailbxSize~"$inactivMBSiz
        Write-Host '#Arrcnt~'$arMailBxCnt
	    Write-Host '#Arrmailbxsize~-5'
	    Write-Host '#ClutterEnabledcnt~-5'
	    Write-Host '#ClutterDisabledcnt~-5'
        write-host "#DbSndQte~"$prohbtSndQuotaCnt
		write-host "#DbSndRecQte~"$prohbtSndRecvQCnt
        Write-Host '#ArchiveWarnMailscnt~-5'
        Write-Host '#nearRecoverQuota~'$nearRecoverQuota
#}
[System.GC]::GetTotalMemory($true) | out-null