﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

#<#
$TestInputs=$args
$username=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUser=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$proxyserver=$TestInputs[4]
$readDat=[DateTime]$TestInputs[5]
$rptTopNDD=[int]$TestInputs[6]
$graphDetails=$TestInputs[7]
if($graphDetails -and $graphDetails -ne 'none'){
    $graphDetailsArr=($graphDetails).ToString() -Split ("~!~")
    $appId=$graphDetailsArr[0]
    $appSecret=$graphDetailsArr[1]
    $authString=$graphDetailsArr[2]
    $resource=$graphDetailsArr[3]
}
#>

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

if($proxyUser.toString().toLower().Trim() -eq 'none') { $proxyUser=$proxyUser.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserver.toString().toLower().Trim().Contains('none')) { $proxyserver=$proxyserver.toString().toLower().Trim() }
if(!$proxyserver.Contains('none')){
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUser -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUser, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

$ToReadDate=$readDat.tostring(“yyyy-MM-dd”)

Function Eg-InvokeUrl(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$Url
    )
    Process
    {
        $typePath=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
        Add-Type -Path $typePath
        $creds = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.ClientCredential" -ArgumentList $appId, $appSecret
        $authContext = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.AuthenticationContext"-ArgumentList $authString
        $context = $authContext.AcquireTokenAsync($resource, $creds).Result
        $authCode=$context.CreateAuthorizationHeader()

        $header = @{
            'Authorization'=$authCode
        }
        $queryRes = [System.Text.Encoding]::$encTyp.GetString((Invoke-WebRequest -Method Get -Headers $header -Uri $Url -UseBasicParsing).RawContentStream.ToArray())
        #$queryRes = Invoke-RestMethod -Method 'Get' -Headers $header -Uri $Url
        $queryRes=$queryRes.Replace('ï»¿','')
        $queryRes=$queryRes.Replace('(Byte)','')
        $queryRes=$queryRes.Replace(' ','')
        $resultarray = ConvertFrom-Csv -InputObject $queryRes
        $reprts=$resultarray | ConvertTo-Json 
        $jsonreprt=@()
        $jsonreprt='{ "Usage" :['+$reprts+']}'
        $reports=$jsonreprt | ConvertFrom-Json
        return $reports.Usage
    }
}

$emailActurl= "https://graph.microsoft.com/v1.0/reports/getEmailActivityUserDetail(period='D7')"
$actUsrDtls=Eg-InvokeUrl -Url $emailActurl
[System.GC]::GetTotalMemory($true) | out-null
if($actUsrDtls -ne $null -and $actUsrDtls -ne ''){
    $rptDat=$actUsrDtls | select -First 1
    $rptDat=$rptDat.ReportRefreshDate.ToString().Trim()
    if([DateTime]$rptDat -ge [DateTime]$ToReadDate){
        Write-Host 'ReadedDate for the Date#'$rptDat
        $totSent=0;$totReceiv=0;$totRead=0;$i=0
        $actUsrDtls |Where-Object{$_.IsDeleted -eq $false} |Sort-Object { $_.SendCount -as [int] } -Descending |ForEach-Object{
            $totSent+=$_.SendCount;
            $totReceiv+=$_.ReceiveCount;
            $totRead+=$_.ReadCount;
            if($i -lt $rptTopNDD){
                $top10Send='Top10Senders#'+$_.ReportRefreshDate+'~!~'+$_.UserPrincipalName+'~!~'+$_.DisplayName+'~!~'+$_.LastActivityDate+'~!~'+$_.SendCount+'~!~'+$_.ReceiveCount+'~!~'+$_.ReadCount+'~!~'+$_.AssignedProducts
                Write-Host $top10Send
                $i++
            }
        }
        $actUsrDtls |Where-Object{$_.IsDeleted -eq $false} |Sort-Object { $_.ReceiveCount -as [int] } -Descending | select -First $rptTopNDD |ForEach-Object{ 
            $top10Receivrs='Top10Receivrs#'+$_.ReportRefreshDate+'~!~'+$_.UserPrincipalName+'~!~'+$_.DisplayName+'~!~'+$_.LastActivityDate+'~!~'+$_.SendCount+'~!~'+$_.ReceiveCount+'~!~'+$_.ReadCount+'~!~'+$_.AssignedProducts
            Write-Host $top10Receivrs
        }
        $measures='Measures#'+$totSent+'~'+$totReceiv+'~'+$totRead
        Write-Host $measures  
    } 
}

[System.GC]::GetTotalMemory($true) | out-null

