$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Microsoft.Exchange.Management.PowerShell.E2010
$SRVSettings = Get-ADServerSettings
if ($SRVSettings.ViewEntireForest -eq "False")
{
	Set-ADServerSettings -ViewEntireForest $true
}


$computer = $env:computername

Write-Host "Client Access Server Rollup Details"
Write-Host "---------------------------------------"
$Exch = Get-ExchangeServer -identity $computer  | where {$_.ServerRole -ne "Edge"} 
if($Exch)
{
	# Check for exchange server admin version
	if($Exch.AdminDisplayVersion.major -eq "8")
	{
		$E2K7 = $true
	}
	if($Exch.AdminDisplayVersion.major -eq "14")
	{
		$E2K = $true
	}
	Write-Host "Server Name: " $computer
	Write-Host "Server Role: " $Exch.ServerRole
	Write-Host "Exchange Version: " $Exch.AdminDisplayVersion
	
	#Get Exchange server version
	$MsxVersion = $Exch.ExchangeVersion		
		
	$Srv = $Exch.Name
		
	if($E2K -eq $true)
	{
		$key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products\AE1D439464EB1B8488741FFA028E291C\Patches\"
	}
		
	if($E2K7 -eq $true)
	{
		$key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products\461C2B4266EDEF444B864AD6D9E5B613\Patches\"
	}
		
	$type = [Microsoft.Win32.RegistryHive]::LocalMachine
	$regKey = [Microsoft.Win32.RegistryKey]::OpenRemoteBaseKey($type, $Srv)
	$regKey = $regKey.OpenSubKey($key)
		
	if ($regKey.SubKeyCount -eq 0)
	{
		$DetailRollup+= "No Patches installed"
	}
	else
	{
		#Loop each of the subkeys (Patches) and gather the Installed date and Displayname of the Exchange patch
		$ErrorActionPreference = "SilentlyContinue"
		ForEach($sub in $regKey.GetSubKeyNames())
		{
			$SUBkey = $key + $Sub
			$SUBregKey = [Microsoft.Win32.RegistryKey]::OpenRemoteBaseKey($type, $Srv)
			$SUBregKey = $SUBregKey.OpenSubKey($SUBkey)
			ForEach($SubX in $SUBRegkey.GetValueNames())
			{
				# Display Installed date and Displayname of the Exchange patch
				IF ($Subx -eq "Installed") 
				{
					$d = $SUBRegkey.GetValue($SubX)
					$d = $d.substring(4,2) + "/" + $d.substring(6,2) + "/" + $d.substring(0,4)
				}
				IF ($Subx -eq "DisplayName") 
				{
					$cd = $SUBRegkey.GetValue($SubX)
					$DetailRollup+=  "Rollup Version:  $($d) - $($cd)"
				}
			}
		}	
		$DetailRollup+=  ""
	}
	Write-Host $DetailRollup	
}

Write-Host "Client Access Server - Autodiscover"
Write-Host "---------------------------------------"

$cas = Get-ClientAccessServer -identity $computer
if ($cas)
{	
	Write-Host "Server Name: " $cas.name
	Write-Host "AutoDiscoverServiceInternalUri: " $cas.AutoDiscoverServiceInternalUri
	Write-Host "AutoDiscoverSiteScope: " $cas.AutoDiscoverSiteScope
}


Write-Host "Client Access Server - Autodiscover Virtual Directory"
Write-Host "----------------------------------------------------------"
$AUTOVD = Get-AutodiscoverVirtualDirectory -Server $computer
if ($AUTOVD)
{
	Write-Host "Server Name: " $AUTOVD.Server
	Write-Host "Name: " $AUTOVD.name
	Write-Host "InternalURL: " $AUTOVD.InternalURL
	Write-Host "InternalAuthenticationMethods: " $AUTOVD.InternalAuthenticationMethods
	Write-Host "ExternalURL: " $AUTOVD.ExternalURL
	Write-Host "ExternalAuthenticationMethods: " $AUTOVD.ExternalAuthenticationMethods
	
}


Write-Host "Client Access Server - ActiveSync Virtual Directory"
Write-Host "--------------------------------------------------------"

$ASyncVD = Get-ActiveSyncVirtualDirectory -server $computer
if($ASyncVD)
{
	Write-Host "Server Name: " $ASyncVD.Server
	Write-Host "Name: " $ASyncVD.name
	Write-Host "InternalURL: " $ASyncVD.InternalURL
	Write-Host "InternalAuthenticationMethods: " $ASyncVD.InternalAuthenticationMethods
	Write-Host "ExternalURL: " $ASyncVD.ExternalURL
	Write-Host "ExternalAuthenticationMethods: " $ASyncVD.ExternalAuthenticationMethods
}

Write-Host "Client Access Server - ECP Virtual Directory"
Write-Host "-----------------------------------------------"

$ECPVD = Get-ECPVirtualDirectory -server $computer
if($ECPVD)
{
	Write-Host "Server Name: " $ECPVD.Server
	Write-Host "Name: " $ECPVD.name
	Write-Host "InternalURL: " $ECPVD.InternalURL
	Write-Host "InternalAuthenticationMethods: " $ECPVD.InternalAuthenticationMethods
	Write-Host "ExternalURL: " $ECPVD.ExternalURL
	Write-Host "ExternalAuthenticationMethods: " $ECPVD.ExternalAuthenticationMethods
}

Write-Host "Client Access Server - OAB Virtual Directory"
Write-Host "----------------------------------------------"

$OABVD = Get-OABVirtualDirectory -server $computer
if($OABVD)
{
	Write-Host "Server Name: " $OABVD.Server
	Write-Host "Name: " $OABVD.name
	Write-Host "InternalURL: " $OABVD.InternalURL
	Write-Host "InternalAuthenticationMethods: " $OABVD.InternalAuthenticationMethods
	Write-Host "ExternalURL: " $OABVD.ExternalURL
	Write-Host "ExternalAuthenticationMethods: " $OABVD.ExternalAuthenticationMethods
}
Write-Host "Client Access Server - OWA Virtual Directory"
Write-Host "----------------------------------------------"

$OWAVD = Get-OWAVirtualDirectory -server $computer
if($OWAVD)
{
	Write-Host "Server Name: " $OWAVD.Server
	Write-Host "Name: " $OWAVD.name
	Write-Host "InternalUrl: " $OWAVD.InternalUrl
	Write-Host "InternalAuthenticationMethods: " $OWAVD.InternalAuthenticationMethods
	Write-Host "ExternalUrl: " $OWAVD.ExternalUrl
	Write-Host "ExternalAuthenticationMethods: " $OWAVD.ExternalAuthenticationMethods
}
Write-Host "Client Access Server - WebServices Virtual Directory"
Write-Host "------------------------------------------------------"

$WEBSVD = Get-WebServicesVirtualDirectory -server $computer
if($WEBSVD)
{
	Write-Host "Server Name: " $WebSVD.server
	Write-Host "Name: " $WEBSVD.name
	Write-Host "InternalURL: " $WEBSVD.InternalURL
	Write-Host "InternalAuthenticationMethods: " $WebSVD.InternalAuthenticationMethods
	Write-Host "ExternalURL: " $WebSVD.ExternalURL
	Write-Host "ExternalAuthenticationMethods: " $WebSVD.ExternalAuthenticationMethods
}

Write-Host "Client Access Server - Powershell Virtual Directory"
Write-Host "---------------------------------------------------------"

$PWSVD = Get-PowershellVirtualDirectory -server $computer
if($PWSVD)
{
	Write-Host "Server Name : " $PWSVD.server
	Write-Host "Name: " $PWSVD.name
	Write-Host "CertificateAuthentication: " $PWSVD.CertificateAuthentication
	Write-Host "RequireSSL: " $PWSVD.RequireSSL	
	Write-Host "MetabasePath: " $PWSVD.MetabasePath
	Write-Host "Path: " $PWSVD.Path		
	Write-Host "InternalURL: " $PWSVD.InternalURL		
	Write-Host "ExternalURL: " $PWSVD.ExternalURL
}	

Write-Host "RPCClientAccess Information"
Write-Host "-------------------------------"

$RPC = Get-RPCClientAccess -server $computer
if($RPC)
{

	Write-Host "Server Name: " $RPC.server
	Write-Host "Responsibility: " $RPC.Responsibility
	Write-Host "MaximumConnections: " $RPC.MaximumConnections
	Write-Host "EncryptionRequired: " $RPC.EncryptionRequired
	Write-Host "BlockedClientVersions: " $RPC.BlockedClientVersions
}

Write-Host "POP3 settings"
Write-Host "-----------------"
$pops = Get-PopSettings -server $computer
foreach ($pop in $pops)
{
	Write-Host "Name: " $pop.Name
	Write-Host "ProtocolName: " $pop.ProtocolName
	Write-Host "MaxCommandSize: " $pop.MaxCommandSize
	Write-Host "MessageRetrievalSortOrder: " $pop.MessageRetrievalSortOrder
	Write-Host "ShowHiddenFoldersEnabled: " $pop.ShowHiddenFoldersEnabled
	Write-Host "SSLBindings: " $pop.SSLBindings
	Write-Host "InternalConnectionSettings: " $pop.InternalConnectionSettings
	Write-Host "ExternalConnectionSettings: " $pop.ExternalConnectionSettings
	Write-Host "X509CertificateName: " $pop.X509CertificateName
	Write-Host "AuthenticatedConnectionTimeout: " $pop.AuthenticatedConnectionTimeout
	Write-Host "MaxConnections: " $pop.MaxConnections
	Write-Host "MaxConnectionFromSingleIP: " $pop.MaxConnectionFromSingleIP
	Write-Host "MaxConnectionsPerUser: " $pop.MaxConnectionsPerUser
	Write-Host "ProxyTargetPort: " $pop.ProxyTargetPort
	Write-Host "OwaServerUrl: " $pop.OwaServerUrl
	Write-Host "ProtocolLogEnabled: " $pop.ProtocolLogEnabled
	Write-Host "EnforceCertificateErrors: " $pop.EnforceCertificateErrors
}	

Write-Host "IMAP settings"
Write-Host "----------------"
$pops = Get-IMAPSettings -server $env:computername
foreach ($pop in $pops)
{
	Write-Host "Name: " $pop.Name
	Write-Host "ProtocolName: " $pop.ProtocolName
	Write-Host "MaxCommandSize: " $pop.MaxCommandSize
	Write-Host "MessageRetrievalSortOrder: " $pop.MessageRetrievalSortOrder
	Write-Host "ShowHiddenFoldersEnabled: " $pop.ShowHiddenFoldersEnabled
	Write-Host "SSLBindings: " $pop.SSLBindings
	Write-Host "InternalConnectionSettings: " $pop.InternalConnectionSettings
	Write-Host "ExternalConnectionSettings: " $pop.ExternalConnectionSettings
	Write-Host "X509CertificateName: " $pop.X509CertificateName
	Write-Host "AuthenticatedConnectionTimeout: " $pop.AuthenticatedConnectionTimeout
	Write-Host "MaxConnections: " $pop.MaxConnections
	Write-Host "MaxConnectionFromSingleIP: " $pop.MaxConnectionFromSingleIP
	Write-Host "MaxConnectionsPerUser: " $pop.MaxConnectionsPerUser
	Write-Host "ProxyTargetPort: " $pop.ProxyTargetPort
	Write-Host "OwaServerUrl: " $pop.OwaServerUrl
	Write-Host "ProtocolLogEnabled: " $pop.ProtocolLogEnabled
	Write-Host "EnforceCertificateErrors: " $pop.EnforceCertificateErrors
}	

Write-Host "Client Access Server - Exchange Certificates"
Write-Host "------------------------------------------------"
$certs = Get-ExchangeCertificate -Server $computer
if($certs)
{
	foreach($cert in $certs)
	{
		$certthumb = $cert.Thumbprint
		$CertDom = $cert.CertificateDomains
		$certserv = $cert.services
		$certAR = $cert.AccessRules
		$certPK = $cert.HasPrivatekey
		$certSSigned = $cert.IsSelfSigned
		$certIss = $cert.Issuer
		$certNA = $cert.NotAfter
		$certNB = $cert.NotBefore
		$certPKS = $cert.PublicKeySize
		$certRoot = $cert.RootCAType
		$certSN = $cert.SerialNumber
		$certstatus = $cert.status
		$certsubj = $cert.subject
		Write-Host "AccessRules: " $($certAR)
		Write-Host "Certificate Domains: " $($CertDom)
		Write-Host "HasPrivateKey: " $($certPK)	
		Write-Host "IsSelfSigned: " $($certSSigned)
		Write-Host "Issuer: " $($certIss)		
		Write-Host "NotAfter: " $($certNA)
		Write-Host "NotBefore: " $($certNB)
		Write-Host "PublicKeySize: " $($certPKS)
		Write-Host "RootCAType: " $($certRoot)
		Write-Host "SerialNumber: " $($certSN)
		Write-Host "Services: " $($certserv)
		Write-Host "Status: " $($certstatus)
		Write-Host "Subject: " $($certsubj)
		Write-Host "ThumbPrint: " $($certthumb)
	}	
}

Remove-PSSnapin Microsoft.Exchange.Management.PowerShell.E2010

	
	