#This File is in Unicode format.  Do not edit in an ASCII editor.
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

#region help text

<#
.SYNOPSIS
			
			To get the Site links enumuration information of Active Directory
.DESCRIPTION

			This Script is used to collect the Site links enumuration information of Active Directory
			Measure are:
			1.Transport type,
			2.Replication cost,
			3.Replication interval,
			4.Sites included
.INPUTS
			CONST_TEST_HDR and delimiter
.OUTPUTS
			Collect the Measures of Site links enumuration information in following format
            <siteLinkName><Delimiter><replCost><Delimiter><replInterval>
            <Delimiter><sitesIncluded><Delimiter><distinguishedName>


#>

$ErrorActionPreference = 'SilentlyContinue'
$global:isErrorOccured = $False

$global:CONST_TEST_HDR = $args[0]
$global:CONST_TEST_END = $args[1]
$global:delimiter = $args[2]



import-module ActiveDirectory

Clear-Host

#To get the Site links enumuration information of Active Directory

Function getADSiteLinkInfo
{
		
	$Forest = Get-ADForest -Current LocalComputer | select RootDomain,PartitionsContainer
	$rootDomain = $Forest.RootDomain
	$ConfigurationPart = ($Forest.PartitionsContainer -Replace "CN=Partitions,","")
	$siteLinks = Get-ADObject -Server $rootDomain -Filter { objectClass -eq "siteLink" } -SearchBase $ConfigurationPart -Properties name, cost, replInterval, siteList | Sort-Object replInterval
	foreach ($link in $siteLinks)
	{
		$siteLinkName = $link.name
		$distinguishedName = $link.DistinguishedName
		$replCost = $link.cost
		$replInterval = $link.replInterval
		$sitesIncluded = ""
		$siteCount = 0
		foreach ($linkList in $link.siteList)
		{
			$siteNameObj = Get-ADObject -Identity $linkList -Properties Name
			$siteName = $siteNameObj.Name
			if ($siteCount -eq 0)
			{
				$sitesIncluded = $siteName
			}
			else
			{
				$sitesIncluded = $sitesIncluded + "," + $siteName
			}
			$siteCount = $siteCount + 1
		}
		Write-Host($siteLinkName,$replCost,$replInterval,$sitesIncluded,$distinguishedName) -Separator $global:delimiter
	}								

}

#Main Region Starts

try
{

   	Write-Host $global:CONST_TEST_HDR
	Write-Host "-------------------------"
       
    getADSiteLinkInfo
}
catch [Exception]
{
	$global:isErrorOccured = $True
	Write-Verbose "Catch block executed and following Exception is occured : " $_.Exception.GetType().FullName, $_.Exception.Message
}

If($global:isErrorOccured -eq $False)
{
	Write-Host $global:CONST_TEST_END
}
#Main Region Ends


