$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Citrix.XenApp.Commands
$Global:ErrorActionPreference="SilentlyContinue"
$CONFIG_INFO_SEPARATOR = ">"
$servers = Get-XAServer
foreach($server in $servers)
{
	Write-Host "#Server - start"
	Write-Host "#Server details - start"
	Write-Host "Name  : " $server.ServerName
	Write-Host "IP Address : " $server.IPAddresses
	Write-Host "Product Name : " $server.CitrixProductName
	Write-Host "Product code : -"
	$servicePack = "-"
	if ($server.CitrixServicePack -ne 0)
	{
		$servicePack  = $server.CitrixServicePack
	}
	Write-Host "Server Pack : " $servicePack 
	Write-Host "Version : " $server.CitrixVersion
	Write-Host "Feature Realease : -"
	Write-Host "XML Port : -"
	Write-Host "Installed on : " $server.CitrixInstallDate
	Write-Host "#Server details - end"
	Write-Host  "#Hot fixes - start"
	$hotfixes = Get-XAServerHotfix -ServerName $server.ServerName
	if($hotfixes -ne $null)
	{
		foreach($hotfix in $hotfixes)
		{
			Write-Host "Hotfix Name : " $hotfix.HotfixName
			Write-Host "Installed By : " $hotfix.InstalledBy
			Write-Host "Hotfix Installed on : " $hotfix.InstalledOn
		}
	}	
	Write-Host "#Hot fixes - end"
	Write-Host "#Server - end"
	Write-Host

}
Remove-PSSnapin Citrix.XenApp.Commands

