@echo off
SETLOCAL
setlocal EnableDelayedExpansion

cd apm\NodeJS\default
set SETUP_LOG=..\..\..\..\agent\logs\node-monitor-setup.log
set STATUS_LOG=..\..\..\..\agent\logs\node-monitor-status.log
set INSTALL_LOG=..\..\..\..\agent\logs\node-monitor-install.log
del %INSTALL_LOG%

FOR /F "skip=1 tokens=1-6" %%A IN ('WMIC Path Win32_LocalTime Get Day^,Hour^,Minute^,Month^,Second^,Year /Format:table') DO (
    if "%%B" NEQ "" (
        SET /A FDATE=%%F*10000+%%D*100+%%A
    )
)

echo The eG Node Monitor files has been extracted successfully. > %SETUP_LOG%
echo To monitoring Node.JS application, please follow the steps indicated in documentation. >> %SETUP_LOG%

node -v && (
  call :Display "INFO" "The Availability of Node.js:- Available"
  node -v >> %INSTALL_LOG%
) || (
  call :Display "Error" "The Availability of Node.js:- Not able to find globally installed Node.js"
  call :printStatus "2"
  exit
)

call npm -v && (
  call :Display "INFO" "The Availability of NPM    :- Available
  call npm -v >> %INSTALL_LOG%
) || (
  call :Display "Error" "The Availability of NPM    :- Not able to find globally installed NPM"
  call :printStatus "3"
  exit
)

call node .\scripts\node_module_availability_checker.js --no-logs > ..\..\..\..\agent\logs\tmp.txt
set /p moduleInstalled=<..\..\..\..\agent\logs\tmp.txt
call :Display "INFO" "Native Addon Availability Status: %moduleInstalled%"
del ..\..\..\..\agent\logs\tmp.txt
set COMPILER_AVAIL=NO
set moduleInstalledNew=NA

if %moduleInstalled% NEQ PASS (
  call :Display "WARN" "Some native node modules is not compatible with this system, so going to rebuild the node-modules"

  gcc --version && (
    call :Display "INFO" "The Availability of GCC    :- Available
    gcc --version >> %INSTALL_LOG%
	set COMPILER_AVAIL=YES
  ) || (
    call :Display "WARN" "The Availability of GCC    :- Not Found"
  )

  call python3 --version && (
    call :Display "INFO" "The Availability of Python :- Available
    call python3 --version >> %INSTALL_LOG%
	set COMPILER_AVAIL=YES
  ) || (
    call python --version && (
      call :Display "INFO" "The Availability of Python :- Available
      call python --version >> %INSTALL_LOG%
	  set COMPILER_AVAIL=YES
    ) || (
      call :Display "WARN" "The Availability of Python :- Not Found"
    )
  )

  if !COMPILER_AVAIL!==NO (
    call :Display "WARN" "Some native addon complier is not available, so can't rebuild the node-modules"
  ) else (
    call :Display "WARN" "Rebuild is starting...!"
    echo "Rebuild Log Starts---------------------->" >> %INSTALL_LOG%
    call node ./scripts/script_runner.js --cmd="npm rebuild" --log-path=%INSTALL_LOG%
    echo "Rebuild Log ends------------------------>" >> %INSTALL_LOG%
    call :Display "INFO" "npm rebuild completed"

    call node .\scripts\node_module_availability_checker.js --no-logs > ..\..\..\..\agent\logs\tmp1.txt
    set /p moduleInstalledNew=<..\..\..\..\agent\logs\tmp1.txt
    call :Display "INFO" "Module Installed Status after recompile: !moduleInstalledNew!"
	del ..\..\..\..\agent\logs\tmp1.txt

    if !moduleInstalledNew! NEQ PASS (
      call :Display "WARN" "Rebuild is failed, so going try to reach NPM repo to install node-modules"

      Ping www.npmjs.org -n 1 -w 1000
      if errorlevel 1 (
        call :Display "WARN" "NPM repo is not reachable...!"
	  ) else (
        call :Display "INFO" "NPM repo is reachable, so going to install node modules"
        echo "Going to install" >>%INSTALL_LOG%
        call node ./scripts/script_runner.js --cmd="npm install --production --no-audit --progress=false --prefer-offline" --log-path=%INSTALL_LOG%
		call :Display "INFO" "Install is completed"
      )
    )
  ) 
)

call :Display "INFO" "Going to check whether all node modules is available or not"
call node .\scripts\node_module_availability_checker.js --log-path=%INSTALL_LOG% --status-path=%STATUS_LOG%
ENDLOCAL
exit

:Display
  echo %FDATE:~6,2%-%FDATE:~4,2%-%FDATE:~0,4% %TIME:~0,2%:%TIME:~3,2%:%TIME:~6,2% - %~1 - %~2 %~3
  echo %FDATE:~6,2%-%FDATE:~4,2%-%FDATE:~0,4% %TIME:~0,2%:%TIME:~3,2%:%TIME:~6,2% - %~1 - %~2 %~3>> %INSTALL_LOG%
exit /B 0

:printStatus
  (
    FOR /f "usebackqdelims=" %%a IN ("%STATUS_LOG%") DO (
      FOR /f "tokens=1*delims==" %%g IN ("%%a") DO (
        IF /i "%%g"=="INSTALL_STATUS" (ECHO(%%g=%~1
        ) ELSE (ECHO(%%a)
      )
    )
  )>temp.txt
  :: temp.txt now contains a modified version.
  MOVE /y temp.txt "%STATUS_LOG%"
  echo "INSTALL_STATUS=%~1"
exit /B 0