$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
#Add-PSSnapin "Microsoft.SystemCenter.VirtualMachineManager"

#$$snapinModule = Get-PSSnapin -Registered -Name "Microsoft.SystemCenter.VirtualMachineManager" -ErrorAction SilentlyContinue
#$snapinFile = $snapinModule.ModuleName
#Import-Module -name $snapinFile 

$SCVMHosts = Get-SCVMHost -VMMServer localhost
if ($SCVMHosts -ne $null)
{
	Write-Host ("CAPTION: HostCluster","VMHostGroup","ComputerName","FullyQualifiedDomainName","IPAddresses","OperatingSystem","VirtualizationPlatform","IsServerOSVMs") -Separator "#~#"
	foreach ($SCVMHost in $SCVMHosts)
	{
        $ServerOSCount = 0
        $DesktopOSCount = 0
        $IsServerOSVMs = $false;
        $VMs = $SCVMHost.VMs
		if ($VMs -ne $null)
		{
			foreach ($VM in $VMs)
			{
                $VMOperatingSystem = $VM.OperatingSystem
                if ($VMOperatingSystem -ne $null)
                {
                    if ($VMOperatingSystem -imatch("Windows 11") -or $VMOperatingSystem -imatch("Windows 10") -or $VMOperatingSystem -imatch("Windows 8") -or $VMOperatingSystem -imatch("Windows 7"))
                    {
                         $DesktopOSCount = $DesktopOSCount + 1
                    } 
                    elseif ($VMOperatingSystem -match("2022") -or $VMOperatingSystem -match("2019") -or $VMOperatingSystem -match("2016") -or $VMOperatingSystem -match("2012") -or $VMOperatingSystem -match("2008"))
                    {
                         $ServerOSCount = $ServerOSCount + 1
                    }
			    }
            }
		}

        if ($ServerOSCount -gt $DesktopOSCount)
        {
            $IsServerOSVMs = $true
        }

		$SCVMHostNetworkAdapters = Get-SCVMHostNetworkAdapter -VMHost $SCVMHost
		$IPAddresses = ""
		if ($SCVMHostNetworkAdapters -ne $null)
		{
			foreach ($SCVMHostNetworkAdapter in $SCVMHostNetworkAdapters)
			{
				$IPAddress = $SCVMHostNetworkAdapter.IPAddresses
				if ($IPAddress -ne $null)
				{
					foreach ($IPAddr in $IPAddress)
					{
						if ($IPAddresses.length -eq 0)
						{
							$IPAddresses = $IPAddr.IPAddressToString
						}
						else
						{
							$IPAddresses = $IPAddresses + "," + $IPAddr.IPAddressToString
						}
					}
				}
			}
		}
		Write-Host ($SCVMHost.HostCluster,$SCVMHost.VMHostGroup,$SCVMHost.ComputerName,$SCVMHost.FullyQualifiedDomainName,$IPAddresses,$SCVMHost.OperatingSystem,$SCVMHost.VirtualizationPlatform,$IsServerOSVMs) -Separator "#~#"
	}
}

#Remove-PSSnapin "Microsoft.SystemCenter.VirtualMachineManager"
