param(
    [int] $SessionID = 0,
    [string] $UserName="",
    [string] $SessionState = "Disconnected", # Either Active or Disconnected
    [switch] $IdleTime,
    [int] $IdleTimeInMinutes=15,
    [string] $PriorityToChange = "BelowNormal", # Should be one of the following Normal/Idle/RealTime/High/BelowNormal/AboveNormal
    [string] $ProcessesToIgnore="",
	[string]$revertPrrtyFrUsrsInRgstry = "false"
    )

$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Set-StrictMode -Version 1
[string[]] $DefaultIgnoredProcesses = @('cmd', 'dwm', 'explorer','conhost','taskhostw','winlogon','powershell', 'java' ,'js', 'vm-jsn','jsn', 'tomcat','wfshell','ctxgfx')
$global:PrePriorityIDWise = @{}

function DeleteRegistryKey
{
    param(
        [parameter(Mandatory=$true)]$SessionID
         )
    Remove-Item -Path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation\$SessionID" -Recurse
}

function DeleteRegistryKeys
{
    Remove-Item -Path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\*" -Recurse
}

#revert the process pririty for already changed sessions when session id comes to active from idle or disconnected state
function RevertPrrtyFrUsrsInRgstry
{
    [boolean] $keyFound = Test-Path -path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation"
    if($keyFound)
    {
        $inFile = "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation\"
        $allPath = Get-ChildItem -path ($inFile -replace ([char] 0xa0), '?') | Select Name,Property
       
        foreach ($crntPath in $allPath)
        {
            $pathName = $crntPath.Name      
            $sessionId = $pathName.Substring($pathName.LastIndexOf("\")+1)		
		
            $processes = (Get-ItemProperty -Path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation\$sessionId\").CurrentPriorities | ConvertFrom-Csv
       
            foreach ($process in $processes)
            {
				if($process.ProcessName -eq "wfshell")
				{
					continue
				}
                $priorityToChange =  "$($process.PriorityClass)"
                $curntPriority = ""
                try
                { 
                    $curntPriority = (Get-Process -Id ($process.Id) -ErrorAction SilentlyContinue).PriorityClass
                    (Get-Process -Id ($process.Id) -ErrorAction SilentlyContinue).PriorityClass = $priorityToChange 
          
                    Write-host "Successfully reverted the priority for the process $($process.ProcessName) with pid $($process.Id) from $($curntPriority) to $($priorityToChange) in the session $SessionID. "
                }
                catch
                {
                    $Host.UI.WriteErrorLine("Failed to revert the priority for the process $($process.ProcessName) with pid $($process.Id) from $($curntPriority) to $($priorityToChange) in the session $SessionID. ")
                }
               
            }
        }
		DeleteRegistryKeys       
    }
}

function CreateRegistryKeys
{
    [Boolean] $keyFound = $false
    [boolean] $keyFound = Test-Path -path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation"
    if($keyFound -eq $False)
    {
        New-Item -Path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent" -Name "Automation" -ErrorAction SilentlyContinue | Out-Null
    }
}

#Export the process details to registry
function ExportProcessPriorityState 
{
    param(
        [parameter(Mandatory=$true)]$SessionID,
        [parameter(Mandatory=$true)]$UserName,
        [parameter(Mandatory=$true)]$ProcessList
    )

    $sessionPriority = $ProcessList | Select-Object -Property SessionID,ProcessName,Id,PriorityClass

    For($incr = 0; $incr -lt $sessionPriority.Length; $incr++ )
	{
        $CurntPrcsID = $sessionPriority[$incr].Id
        $sessionPriority[$incr].PriorityClass = $global:PrePriorityIDWise.$CurntPrcsID
	}

    New-Item -Path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation" -Name "$SessionID" -ErrorAction SilentlyContinue | Out-Null
    New-ItemProperty -Path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation\$SessionID" -PropertyType String -Name UserName -Value $UserName | Out-Null
    New-ItemProperty -Path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation\$SessionID" -PropertyType MultiString -Name CurrentPriorities -Value ($sessionPriority | ConvertTo-Csv) -Force | Out-Null
}

#Find whether session key already available or not in registry
function TestRegistryValue
{
    param (
        [parameter(Mandatory=$true)][ValidateNotNullOrEmpty()]$Path,
       [parameter(Mandatory=$true)][ValidateNotNullOrEmpty()]$Value
    )
    try
    {
        Get-ItemProperty -Path $Path -Name $Value -ErrorAction Stop | Out-Null
        return $True
    }
    catch
    {
        return $False
    }
    
}

#change the process priority for session Id which is went to idle or disconnected state
Function ChangePrrtyForUsers
{   
	[string] $PreviousUserName = $null
	[string] $PreviousExportDateStr = $null
	[int] $PreviousWfShellPID = -1
	$PriorityIDWise = @{}

	$Realtime = [System.Collections.Generic.List[string]]@()
	$High = [System.Collections.Generic.List[string]]@()
	$Above_normal = [System.Collections.Generic.List[string]]@()
	$Normal = [System.Collections.Generic.List[string]]@()
	$Low = [System.Collections.Generic.List[string]]@()

	$Failed = [System.Collections.Generic.List[string]]@()
	$Excluded = [System.Collections.Generic.List[string]]@()

	if($SessionID -gt 0)
	{
		# Create the Automation key as it is not available by default
		CreateRegistryKeys
		
		# Find the session id if we exported his processes before in the registry
		$KeyExists = TestRegistryValue -Path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation\$SessionID" -value CurrentPriorities 
		
		# If the session id is found, collect all the attributes from the regisry like username, export date and its previous process priorities
		if($KeyExists -eq $True)
		{
			$PreviousPriorities = (Get-ItemProperty -Path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation\$SessionID\").CurrentPriorities | ConvertFrom-Csv
			$PreviousUserName = (Get-ItemProperty -Path "HKLM:\SOFTWARE\eGurkha\eGurkha Agent\Automation\$SessionID\").UserName
			
			# Find the previous wfshell process ID
			[int] $PreviousWfShellPID = @($PreviousPriorities | Where-Object {$_.SessionID -eq $SessionID -and $_.ProcessName -eq "wfshell"} -ErrorAction SilentlyContinue)[0].ID

			foreach ($process in $PreviousPriorities)
			{  
				$PriorityIDWise.add($process.Id,$process.PriorityClass)
			}
		}
		
		# If the session id is found in the registry but the given username and the username in the registry are different. Could be the 
		# session id is reused by the OS.
		if($KeyExists -and ($PreviousUserName -ne $null -and $UserName -ne $PreviousUserName))
		{
			DeleteRegistryKey -SessionID $SessionID
		}
		
		# Find all the processes that are running currently for the given session ID
		[array]$RunningProcesses = @(Get-Process | Where-Object {$_.SessionID -eq $SessionID} -ErrorAction SilentlyContinue)

		# Find the current wfshell process ID
		[int] $CurrentWfShellPID = @($RunningProcesses | Where-Object {$_.SessionID -eq $SessionID -and $_.ProcessName -eq "wfshell"} -ErrorAction SilentlyContinue)[0].ID

		if (($SessionState -eq "Active") -or ($SessionState -eq "Disconnected"))
		{
			if($IdleTimeInMinutes -ge 1)
			{
				If ($KeyExists -eq $False)
				{
					$prirtyChngdPrcsLst = [System.Collections.ArrayList]@()
                    $global:PrePriorityIDWise.clear()
					foreach ($process in $RunningProcesses)
					{						
						if($process.ProcessName -eq "wfshell")
						{
							$global:PrePriorityIDWise.add($process.Id,$process.PriorityClass)                                
							[void]$prirtyChngdPrcsLst.add($process)
						}
						
						# Ignore processes if available in DefaultIgnoredProcesses or ProcessesToIgnore parameter				
						if(($DefaultIgnoredProcesses -like $($process.ProcessName)) -or (($ProcessesToIgnore -split "/") -like $($process.ProcessName)))
						{
							$excldPrc = "$($process.ProcessName) ($($process.Id))"

							[void]$Excluded.Add($excldPrc)	
						}
						else
						{
							$CurrentPriority = "$($process.PriorityClass)"
							try
							{
								if($CurrentPriority -ne "BelowNormal")
								{
    							    $global:PrePriorityIDWise.add($process.Id,$process.PriorityClass)                                
								    $process.PriorityClass = "$($PriorityToChange)" 				
								    [void]$prirtyChngdPrcsLst.add($process)	
                                
                                    $stmnt = "$($process.ProcessName)($($process.Id))";
								    if($CurrentPriority -eq "Normal")
								    {
									    [void]$Normal.add($stmnt);
								    }
								    elseif($CurrentPriority -eq "High")
								    {
									    [void]$High.add($stmnt);
								    }
								    elseif($CurrentPriority -eq "AboveNormal")
								    {
									    [void]$Above_normal.add($stmnt);
								    }
								    elseif($CurrentPriority -eq "Idle")
								    {
									    [void]$Low.add($stmnt);
								    }
								    elseif($CurrentPriority -eq "RealTime")
								    {
									    [void]$Realtime.add($stmnt);
								    }	
                                }						
							                                
                            }
							catch
							{									
								[void]$Failed.add( "$($process.ProcessName)($($process.Id))");	
							}
                        }						
					}

					if($Excluded -ne $null -and $Excluded.Count -gt 0)
                    {							
						Write-host ("Excluded from reduce priority in session $SessionID for the list of processes in the format of ""ProcessName(PID)"" as follows: $(CnvrtLstToStr($Excluded)). ")
					}
                    if($Realtime -ne $null -and $Realtime.Count -gt 0)
                    {					
					    Write-host "Successfully reduced the priority from Realtime to $($PriorityToChange) in session $SessionID for the list of processes in the format of ""ProcessName(PID)"" as follows: $(CnvrtLstToStr($Realtime)). ";				
                    }
                    if($High -ne $null -and $High.Count -gt 0)
                    {						
	                    Write-host "Successfully reduced the priority from High to $($PriorityToChange) in session $SessionID for the list of processes in the format of ""ProcessName(PID)"" as follows: $(CnvrtLstToStr($High)). ";
					}
					if($Above_normal -ne $null -and $Above_normal.Count -gt 0)
                    {						 
						Write-host "Successfully reduced the priority from Above normal to $($PriorityToChange) in session $SessionID for the list of processes in the format of ""ProcessName(PID)"" as follows: $(CnvrtLstToStr($Above_normal)). ";
					}
					if($Normal -ne $null -and $Normal.Count -gt 0)
                    {						 
						Write-host "Successfully reduced the priority from Normal to $($PriorityToChange) in session $SessionID for the list of processes in the format of ""ProcessName(PID)"" as follows: $(CnvrtLstToStr($Normal)). ";
					}
					if($Low -ne $null -and $Low.Count -gt 0)
                    {						 
						Write-host "Successfully reduced the priority from Low to $($PriorityToChange) in session $SessionID for the list of processes in the format of ""ProcessName(PID)"" as follows: $(CnvrtLstToStr($Low)). ";
					}
					
					if($Failed -ne $null -and $Failed.Count -gt 0)
                    {
						$FailedPrcss = CnvrtLstToStr($Failed)
						$Host.UI.WriteErrorLine( "Failed to reduce the priority to $($PriorityToChange) in session $SessionID for the list of processes in the format of ""ProcessName(PID)"" as follows: $FailedPrcss. ")
					}

					ExportProcessPriorityState -SessionID $SessionID -ProcessList $prirtyChngdPrcsLst -UserName $UserName
				}
			}
			elseif($IdleTimeInMinutes -eq 0)
			{		
				If($KeyExists -eq $True)
				{	    
					# It is possible that the SessionID and Username can be same after you logged off directly from idle.
					# In this case i had seen you before and recorded you in the automation. 
					# We are comparing the wfshell.exe process id so verify whether i had seen you before

					if($CurrentWfShellPID -eq $PreviousWfShellPID)
					{
						foreach ($process in $PreviousPriorities)
						{
							if($process.ProcessName -eq "wfshell")
							{
								continue
							}
							
							$processId = $process.Id
							$prevPriortity = $PriorityIDWise.$processId
                            $curntPriority = ""
							try
							{
                                 $curntPriority = (Get-Process -Id ($process.Id) -ErrorAction SilentlyContinue).PriorityClass
                                 (Get-Process -Id ($process.Id) -ErrorAction SilentlyContinue).PriorityClass = $prevPriortity 
								 Write-host "Successfully reverted the priority for the process $($process.ProcessName) with pid $($process.Id) running in session $SessionID from $($curntPriority) to $($prevPriortity). "
							}
							catch
							{
								$Host.UI.WriteErrorLine("Failed to revert the priority for the process $($process.ProcessName) with pid $($process.Id) running in session $SessionID from $($curntPriority) to $($prevPriortity). ")
							}
						}
						DeleteRegistryKey -SessionID $SessionID
					}
					# Now delete the session id from the Automation key as he has recovered from idle session to active
				}
			}   
		}
    }

}

Function CnvrtLstToStr
{
 param(
        [parameter(Mandatory=$true)]$PrcsList
        )

    $PrcsStr = ""
    try
	{
        if($PrcsList -ne $null -and $PrcsList.Count -gt 0)
        {
            $PrcsArray = $PrcsList.ToArray() | Sort-Object

            if($PrcsArray -ne $null -and $PrcsArray.Count -gt 0)
            {

                $PrcsStr = ($PrcsArray -join ", ")

            }
         }
     }
     catch
     {
        $PrcsStr = ""
     }

    return $PrcsStr
}

#code start here
Function ExecuteScript
{
    if($revertPrrtyFrUsrsInRgstry -eq "true")
    {
	    RevertPrrtyFrUsrsInRgstry
    }
    else
    {
        ChangePrrtyForUsers
    }	
}

ExecuteScript