$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

if($args.count -ne 7)

{

    Write-Host "IGelActions.ps1 <igelserver> <igelport> <username> <password> <Action> <Thinclientname> <eGInstallDir>"

    break

}

 

if (-not ([System.Management.Automation.PSTypeName]'ServerCertificateValidationCallback').Type)

{

$certCallback = @"

    using System;

    using System.Net;

    using System.Net.Security;

    using System.Security.Cryptography.X509Certificates;

    public class ServerCertificateValidationCallback

    {

        public static void Ignore()

        {

            if(ServicePointManager.ServerCertificateValidationCallback ==null)

            {

                ServicePointManager.ServerCertificateValidationCallback +=

                    delegate

                    (

                        Object obj,

                        X509Certificate certificate,

                        X509Chain chain,

                        SslPolicyErrors errors

                    )

                    {

                        return true;

                    };

            }

        }

    }

"@

    Add-Type $certCallback

}

 

function Create-RestBody {

    Param

    (

        [Parameter(Mandatory=$false,HelpMessage='ID of the device')] [string]$ID,

        [Parameter(Mandatory=$false,HelpMessage='objectType')] [string]$objectType

    )

 

        $JSONObject = New-Object -TypeName PSObject

        if ($ID)         { $JSONObject | add-member -name id -value $ID -MemberType NoteProperty           }

        if ($ObjectType) { $JSONObject | add-member -name type -value $objectType -MemberType NoteProperty }

        "[$($JSONObject | ConvertTo-Json)]"

}

 

[ServerCertificateValidationCallback]::Ignore()

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12

 

$igelserver = $args[0]

$igelport = $args[1]

$username = $args[2]

$password = $args[3]

$action = $args[4]

$tcname = $args[5]

$DirPath = $args[6]

$DirPath = $DirPath + "\\lib\\OE.exe"

& $DirPath $password | Tee-Object -Variable pwd | Out-Null

$pair = "$($username):$($pwd)"

$encodedCreds = [System.Convert]::ToBase64String([System.Text.Encoding]::ASCII.GetBytes($pair))

$basicAuthValue = "Basic $encodedCreds"

$Headers = @{

    Authorization = $basicAuthValue

}

 

#Perfmon authentication

try

{

    $result = Invoke-WebRequest -Method Post -Uri "https://$($igelserver):$($igelport)/umsapi/v3/login" -Headers $Headers -UseBasicParsing -SessionVariable session

}

catch

{

    Write-Host "An error occurred when logging on to IGel Management server $_"

    break

}

 

Write-Host "Successfully Logged In"

$global:cookie = $session

 

Write-host "Fetching the thinclient details"

try

{

    $thinclients = Invoke-RestMethod -Method Get -Uri "https://$($igelserver):$($igelport)/umsapi/v3/thinclients" -Headers $Headers  -UseBasicParsing -WebSession $global:cookie -ContentType "application/json"

}

catch

{

    Write-Host "An error occurred $_"

    break

}

 

$selectedDevice = $null

 

if ($thinclients -ne $null)

{

    foreach($thinclient in $thinclients)

    {  

        if($thinclient.name -like $tcname)

        {

            $selectedDevice = $thinclient

            Write-Host "The given thinclient $($tcname) is available in the given ums server"

        }

    }

}

$logout = $false

if($selectedDevice -eq $null)

{

    write-host "The given thinclient $($tcname) is not available in the ums server"

    $logout = $true

}

 

if($logout -eq $false)

{

    $PostBody = Create-RestBody -ID $selectedDevice.id -ObjectType $selectedDevice.objectType

    $tcId = $SelectedDevice.id

 

    switch ($action)

    {

        "Wakeup"

        {

            try {

                $commandResult = Invoke-WebRequest -Uri "https://$($igelserver):$($igelport)/umsapi/v3/thinclients/?command=wakeup" -headers $Headers  -UseBasicParsing -WebSession $global:cookie -method POST -Body $PostBody -ContentType "application/json"   

            }

            catch {

 

            }

        }

        "Reboot"

        {

            try {

                $commandResult = Invoke-WebRequest -Uri "https://$($igelserver):$($igelport)/umsapi/v3/thinclients/?command=reboot" -headers $Headers  -UseBasicParsing -WebSession $global:cookie -method POST -Body $PostBody -ContentType "application/json"

            }

            catch {

 

            }

        }

        "Shutdown"

        {

            try {

                $commandResult = Invoke-WebRequest -Uri "https://$($igelserver):$($igelport)/umsapi/v3/thinclients/?command=shutdown" -headers $Headers  -UseBasicParsing -WebSession $global:cookie -method POST -Body $PostBody -ContentType "application/json"   

            }

            catch {

               

            }

            

        }

        "Update"

        {

            try {

                $commandResult = Invoke-WebRequest -Uri "https://$($igelserver):$($igelport)/umsapi/v3/thinclients/?command=settings2tc" -headers $Headers  -UseBasicParsing -WebSession $global:cookie -method POST -Body $PostBody -ContentType "application/json"

            }

            catch {

               

            }

        }    

        "Details"

        {

            try {

                $commandResult = Invoke-WebRequest -Uri "https://$($igelserver):$($igelport)/umsapi/v3/thinclients/$($tcId)?facets=details" -headers $Headers  -UseBasicParsing -WebSession $global:cookie -method GET   

            }

            catch {

               

            }

        }

        "Asset"

        {

            try {

                $commandResult = Invoke-WebRequest -Uri "https://$($igelserver):$($igelport)/umsapi/v3/assetinfo/thinclients/$($tcId)" -headers $Headers -WebSession $global:cookie -method GET   

            }

            catch {

               

            }

        }

        "Profile"

        {

            $commandResult = New-Object System.Collections.Arraylist

            $deviceProfiles = Invoke-WebRequest -Uri "https://$($igelserver):$($igelport)/umsapi/v3/thinclients/$($tcId)/assignments/profiles" -headers $Headers  -UseBasicParsing -WebSession $global:cookie -method GET

            $allProfiles    = Invoke-WebRequest -Uri "https://$($igelserver):$($igelport)/umsapi/v3/profiles" -headers $headers -WebSession $global:cookie -method GET

            foreach ( $deviceProfileId in $(($deviceProfiles.content | ConvertFrom-Json).assignee.id))

            {

                foreach ($profileId in $($allProfiles.Content | ConvertFrom-Json))

                {

                    if ($profileId.id -eq $deviceProfileId)

                    {

                        $commandResult += $profileId.name

                    }

                }

            }

        }

    }

 

    if ([bool]($commandResult.PSobject.Properties.name -match "Content"))

    {

        if ($commandResult.Content -like "*CommandExecList*")

        {

            Write-Output "$(($commandResult.Content | ConvertFrom-Json).commandExecList | Select "message","state" | fl * | Out-String)"

        }

        else

        {

            Write-Output "$(($commandResult.Content | ConvertFrom-Json) |Out-String)"

        }

    }

    else

    {

        Write-Output "$($commandResult | Out-String)"

    }

}

 

try

{

    $result = Invoke-WebRequest -Method Post -Uri "https://$($igelserver):$($igelport)/umsapi/v3/logout" -Headers $Headers  -UseBasicParsing -WebSession $global:cookie

    write-host "Logout successfully"

}

catch

{

    Write-Host "Error: Logout has failed with error. The Message is $_"

    break

}