$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$ErrorActionPreference = "Stop"
Try
{
              Add-PsSnapin Citrix.Broker.Admin.*
}
catch
{
              write-host "Unable to load the snapin"
              exit 1
}

$machineName = $args[0]
$mode = $args[1]
Try
{
    $TargetMachine = Get-BrokerMachine -dnsname $machineName
}
Catch
{
              Write-host "Unable to determine desktop status - possibly insufficient administrative privileges"
              exit 1
}

if($mode -eq "enable")
{
              $isMaintenance = $true
}
else
{
              $isMaintenance = $false
}

$DesktopGroup = Get-BrokerDesktopGroup -Uid $TargetMachine.DesktopGroupUid
if($DesktopGroup -ne $null -and $DesktopGroup.InMaintenanceMode -eq "True")
{
	Write-Host "$machineName belongs to a $($DesktopGroup.PublishedName) delivery group is in Maintenance mode."
	Write-Host "So this operation can not be performed."
	exit 1
}
             
If ($TargetMachine -ne $null)
{
              $TargetMachine | Set-BrokerMachine -InMaintenanceMode $isMaintenance
              if($isMaintenance)
              {
                             Write-Host "$machineName is in Maintenance Mode"
              }
              else
              {
                             Write-Host "$machineName is no longer in Maintenance Mode"
              }
}
else
{
              Write-host "Could not find desktop $machineName"
              exit 1
}
