$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$keys = '','\Wow6432Node'
if($keys){

	Write-Host "Display Name", "Display Version", "PS ChildName","Install Date","Publisher","Uninstall String","Bits" -Separator "#"

	foreach ($key in $keys)
	{
	    try
	    {
		$regkey = "hklm:\SOFTWARE$key\Microsoft\Windows\CurrentVersion\Uninstall\"
		$AllSubKey= Get-ChildItem $regkey | ForEach {Get-ItemProperty $_.PSPath}
		If ($AllSubKey  -eq $null)
		{
		    Write-Host "Not able to enumerate the softwares from the machine"
		    Continue
		}
		$Bits = $(if ($key -eq '\Wow6432Node') {'64 Bits'} else {'32 Bits'})
		
		ForEach ($SubKey in $AllSubKey)
		{
		    Write-Host ($SubKey.DisplayName,$SubKey.DisplayVersion,$SubKey.PSChildName,$SubKey.InstallDate,$SubKey.Publisher,$SubKey.UninstallString,$Bits) -Separator "#"
		}
	    }
	    catch
	    {
		continue
	    }
	}
} else {
	Write-Host "Not able to enumerate the softwares from the machine"
}