$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

import-module grouppolicy

function HasNoSettings{
    $cExtNodes = $xmldata.DocumentElement.SelectNodes($cQueryString, $XmlNameSpaceMgr)
  
    foreach ($cExtNode in $cExtNodes){
        If ($cExtNode.HasChildNodes){
            Return $false
        }
    }
    
    $uExtNodes = $xmldata.DocumentElement.SelectNodes($uQueryString, $XmlNameSpaceMgr)
    
    foreach ($uExtNode in $uExtNodes){
       If ($uExtNode.HasChildNodes){
            Return $false
        }
    }
    
    Return $true
}

function configNamespace{
    $script:xmlNameSpaceMgr = New-Object System.Xml.XmlNamespaceManager($xmldata.NameTable)

    $xmlNameSpaceMgr.AddNamespace("", $xmlnsGpSettings)
    $xmlNameSpaceMgr.AddNamespace("gp", $xmlnsGpSettings)
    $xmlNameSpaceMgr.AddNamespace("xsi", $xmlnsSchemaInstance)
    $xmlNameSpaceMgr.AddNamespace("xsd", $xmlnsSchema)
}

$noSettingsGPOs = @()

$xmlnsGpSettings = "http://www.microsoft.com/GroupPolicy/Settings"
$xmlnsSchemaInstance = "http://www.w3.org/2001/XMLSchema-instance"
$xmlnsSchema = "http://www.w3.org/2001/XMLSchema"

$cQueryString = "gp:Computer/gp:ExtensionData/gp:Extension"
$uQueryString = "gp:User/gp:ExtensionData/gp:Extension"

Get-GPO -All | ForEach { $gpo = $_ ; $_ | Get-GPOReport -ReportType xml | ForEach { $xmldata = [xml]$_ ; configNamespace ; If(HasNoSettings){$noSettingsGPOs+= $gpo} }}

If ($noSettingsGPOs.Count -eq 0) {
    "0 GPO's Without Settings Were Found"
}
Else{
    #write-host $noSettingsGPOs.count" GPO's were found without settings:"
	write-host "Display_Name;ID;Creation_Time;Modification_Time;GPO_Status;Description"
    foreach($noSettingsGPO in $noSettingsGPOs)
    {
        write-host "$($noSettingsGPO.DisplayName);$($noSettingsGPO.ID);$($noSettingsGPO.CreationTime);$($noSettingsGPO.ModificationTime);$($noSettingsGPO.GPOStatus);$($noSettingsGPO.Description)"
    }
    
}
