[CmdletBinding()]
Param([int] $sessionid) 
Add-PSSnapin Citrix.Broker.* 
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}
try {

    Get-BrokerSession -uid $sessionid | stop-brokersession -EA stop
    "Stopped/Log off the session successfully."
}
catch {
    "The selected session is not available."
} 
Remove-pssnapin Citrix.Broker.*