$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$ErrorActionPreference = "Stop"
$currentDomain = $env:USERDOMAIN.ToUpper()
$serviceAccounts = @{} 
try {
   $serviceList = @( gwmi -Class Win32_Service -Property Name,StartName,SystemName -ErrorAction Stop ) 
   } catch {
    "Failed to retrieve data from $env:computername"    
}
foreach($service in $serviceList)
{
    $account = $service.StartName
    if($account -ne $null)
    {
        if($account.toUpper().StartsWith( $currentDomain ))
        {
            $occurance = "`"$($service.Name)`" service on $($service.SystemName)"
            if ( $script:serviceAccounts.Contains( $account ) )
            {
                $script:serviceAccounts.Item($account) += $occurance
            }
            else
            {
                $script:serviceAccounts.Add( $account, @( $occurance ) ) 
            }
        }    
    }
}

$accountTable = @()
foreach( $serviceAccount in $serviceAccounts.Keys ) {
    foreach( $occurance in $serviceAccounts.item($serviceAccount)  )
    {
        $row = new-object psobject
        Add-Member -InputObject $row -MemberType NoteProperty -Name "Account" -Value $serviceAccount
        Add-Member -InputObject $row -MemberType NoteProperty -Name "Usage" -Value $occurance
        $accountTable  += $row
    }
}

Write-Host "Service account report for $currentDomain"
Write-Host "Discovered $($serviceAccounts.count) service accounts"
if($($serviceAccounts.count) -gt 0)
{
    Write-Host "Discovered service accounts"
    $accountTable | Sort Account
}   
