$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Param([string] $dgGroups) 
$dgs = $dgGroups -split "," 
Add-PSSnapin Citrix.Broker.* 
Function GetMaintenanceVMs
{
    param([string] $dgGroupName)
    $VMs = @()
    try
    {
        Write-Host "Machines In Maintenance Mode:"
        if($dgGroups -like "*none*")
        {
            $VMs = Get-BrokerMachine -InMaintenanceMode $true
        }
        else {
            $VMs = Get-BrokerMachine -DesktopGroupName $dgGroupName -InMaintenanceMode $true
        }
    }
    catch
    {
    } 
    If ($VMs)
    {
        ForEach ($vm in $VMs) {
            write-host "Maintenane mode is enabled on the machine '$($vm.MachineName) in the delivery group '$($vm.DesktopGroupName)'"
          }
    }
    else {
        Write-host "There are no machines in maintenace mode"
    }
} 
foreach($dg in $dgs)
{
    GetMaintenanceVMs -dgGroupName $dg
}
Remove-pssnapin Citrix.Broker.*

 