$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Param([Switch]$Security)
try
{
    import-module ActiveDirectory -ErrorAction SilentlyContinue
    $rootDSE = [adsi]"LDAP://RootDSE"
    $DCDNShostname = $rootDSE.dnsHostName
    If ($Security)
    {
        # Retrieve all security groups where the member attribute is empty.
        $Groups = Get-ADGroup -Server $($DCDNShostname) -LDAPFilter "(&(groupType:1.2.840.113556.1.4.803:=2147483648)(!(member=*)))" | Select distinguishedName, sAMAccountName, SID
    }
    else
    {
        # Retrieve all groups where the member attribute is empty.
        $Groups = Get-ADGroup -Server $($DCDNShostname) -LDAPFilter "(!(member=*))" | Select distinguishedName, sAMAccountName, SID
    }

    # Enumerate these groups. Check if any users or computers has them designated as their
    # "primary" group. This will be users or computers where the primaryGroupID attribute
    # equals the primaryGroupToken attribute of the group.

    $Count = 0
    ForEach ($Group In $Groups)
    {
        # Retrieve the primaryGroupToken (the RID) of the group.
        # This is an operational (constructed) attribute, so it is easier to parse the SID.
        $SID = [String]$Group.SID
        $RID = $SID.Split("-")[-1]
        # Check if there are any users or computers where the primaryGroupID attribute
        # equals the primaryGroupToken of this group.
        $PrimaryMembers = Get-ADObject -Server $($DCDNShostname) -LDAPFilter "(primaryGroupID=$RID)"
        If (-Not $PrimaryMembers)
        {
            # This is a group with no members.
            $DN = $Group.distinguishedName
            $NTName = $Group.sAMAccountName
            # Output the group DN and sAMAccountName.
            "$DN ($NTName)"
        }
        # Count the number of empty groups.
        $Count = $Count + 1
    }
    "Total number of empty groups: $Count"
}
catch
{
    Write-Host ("{0}" -f $_.exception.message)
} 