$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Citrix.*
$PublishedApps = Get-BrokerApplication | Where-Object {$_.AssociatedUserNames -like "S-1-5-21*"}
if($PublishedApps)
{
    write-Host "Application with broken SID"
    Write-host "--------------------------------"
    Write-host 
    Foreach($app in $PublishedApps)
    {
        Write-Host $app.Name "is broken with user SID."
    }
}
else
{
    Write-Host "There are 0 broken SIDs in the all published resources"
} 
