﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
Import-Module $egEncryPath -WarningAction SilentlyContinue
clear

$TestInputs=$args
$plainValue=$TestInputs[0]

if($plainValue){
    $keyFile=$egurkhaPath+'\Webhooks\config\kloc.dat'
    if([System.IO.File]::Exists($keyFile)){
        $key=Get-Content -Path $keyFile

        $encryptedBytes = Protect-Value -PlainValue $plainValue -Key $key
        $encryptedText = [Convert]::ToBase64String($encryptedBytes)
        Write-Host $encryptedText
    }else{
        Write-Host 'Encryption key file is not found at - '$keyFile
    }
}else{
    Write-Host 'Invalid input - '$plainValue
}